/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import org.jcrontab.data.Process;
import org.jcrontab.data.ProcessFactory;
import org.jcrontab.data.ProcessSource;
import org.jcrontab.log.Log;

public class ProcessDAO {
    private static ProcessDAO instance;
    private static ProcessSource dao;

    private ProcessDAO() {
        if (dao == null) {
            try {
                ProcessFactory.getInstance();
                dao = ProcessFactory.getDAO();
            }
            catch (Exception e) {
                Log.error(e.toString(), e);
            }
        }
    }

    public static synchronized ProcessDAO getInstance() {
        if (instance == null) {
            instance = new ProcessDAO();
        }
        return instance;
    }

    public Process[] findAll() throws Exception {
        return dao.findAll();
    }

    public Process find(Process ps) throws Exception {
        return dao.find(ps);
    }

    public void store(Process[] list) throws Exception {
        dao.store(list);
    }

    public void store(Process bean) throws Exception {
        Process[] ps = new Process[]{bean};
        this.store(ps);
    }

    public void remove(Process bean) throws Exception {
        Process[] ps = new Process[]{bean};
        this.remove(ps);
    }

    public void remove(Process[] list) throws Exception {
        dao.remove(list);
    }

    static {
        dao = null;
    }
}

