/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jcrontab.CronTask;
import org.jcrontab.Crontab;
import org.jcrontab.data.DataNotFoundException;
import org.jcrontab.data.Process;
import org.jcrontab.data.ProcessSource;
import org.jcrontab.log.Log;

public class ProcessSQLSource
implements ProcessSource {
    private static Object dbDriver = null;
    private static ProcessSQLSource instance;
    public static String queryAllProcess;
    public static String querySearching;
    public static String queryAllTasks;
    public static String storeProcess;
    public static String storeTask;
    public static String storeRelation;
    public static String removeProcess;
    public static String removeTask;
    public static String removeRelation;
    public static String nextSequence;

    protected ProcessSQLSource() {
    }

    public ProcessSource getInstance() {
        if (instance == null) {
            instance = new ProcessSQLSource();
        }
        return instance;
    }

    public Process find(Process ps) throws Exception {
        Process[] processes = this.findAll();
        for (int i = 0; i < processes.length; ++i) {
            if (!processes[i].equals(ps)) continue;
            return processes[i];
        }
        throw new DataNotFoundException("Unable to find :" + ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process[] findAll() throws Exception {
        Vector<Process> list = new Vector<Process>();
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        Process[] processList = null;
        try {
            conn = this.getConnection();
            st = conn.createStatement();
            rs = st.executeQuery(queryAllProcess);
            if (rs != null) {
                while (rs.next()) {
                    int id = rs.getInt("id");
                    String name = rs.getString("name");
                    boolean isconcurrent = rs.getBoolean("isconcurrent");
                    boolean isfaulttolerant = rs.getBoolean("isfaulttolerant");
                    boolean isrunning = rs.getBoolean("isrunning");
                    Date lastrun = rs.getDate("lastrun");
                    Process process = new Process();
                    process.setId(id);
                    process.setIsConcurrent(isconcurrent);
                    process.setIsFaultTolerant(isfaulttolerant);
                    process.setIsRunning(isrunning);
                    process.setLastRun(lastrun);
                    list.add(process);
                }
            } else {
                throw new DataNotFoundException("No Processes available");
            }
            rs.close();
            processList = Process.toArray(list.toArray());
            Crontab crontab = Crontab.getInstance();
            for (int i = 0; i < processList.length; ++i) {
                pstmt = conn.prepareStatement(queryAllTasks);
                pstmt.setInt(1, processList[i].getId());
                rs = pstmt.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        int id = rs.getInt("id");
                        String name = rs.getString("task");
                        String method = rs.getString("method");
                        String parameters = rs.getString("parameters");
                        int order = rs.getInt("precedence");
                        String[] extraInfo = parameters.split(" ");
                        CronTask task = new CronTask();
                        task.setParams(crontab, id, name, method, extraInfo);
                        task.setOrder(order);
                        processList[i].addTask(task);
                    }
                } else {
                    throw new DataNotFoundException("No Task available for proces: " + processList[i]);
                }
                rs.close();
            }
        }
        finally {
            try {
                st.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e2) {}
        }
        return processList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Process[] process) throws Exception {
        Connection conn = null;
        Statement ps = null;
        try {
            int i;
            conn = this.getConnection();
            ps = conn.prepareStatement(removeProcess);
            for (i = 0; i < process.length; ++i) {
                ps.setInt(1, process[i].getId());
                ps.executeUpdate();
            }
            ps = conn.prepareStatement(removeTask);
            for (i = 0; i < process.length; ++i) {
                ps.setInt(1, process[i].getId());
                ps.executeUpdate();
            }
            ps = conn.prepareStatement(removeRelation);
            for (i = 0; i < process.length; ++i) {
                ps.setInt(1, process[i].getId());
                ps.executeUpdate();
            }
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e2) {}
        }
    }

    public void store(Process[] process) throws Exception {
        throw new Exception("Unsuported opeartion");
    }

    protected Connection getConnection() throws SQLException {
        Crontab crontab = Crontab.getInstance();
        String dbUser = crontab.getProperty("org.jcrontab.data.GenericSQLSource.username");
        String dbPwd = crontab.getProperty("org.jcrontab.data.GenericSQLSource.password");
        String dbUrl = crontab.getProperty("org.jcrontab.data.GenericSQLSource.url");
        if (dbDriver == null) {
            dbDriver = this.loadDatabaseDriver(crontab.getProperty("org.jcrontab.data.GenericSQLSource.dbDataSource"));
        }
        if (dbDriver instanceof DataSource) {
            if (dbUser != null && dbPwd != null) {
                return ((DataSource)dbDriver).getConnection(dbUser, dbPwd);
            }
            return ((DataSource)dbDriver).getConnection();
        }
        return DriverManager.getConnection(dbUrl, dbUser, dbPwd);
    }

    protected Object loadDatabaseDriver(String srcName) throws SQLException {
        String dbDataSource = srcName;
        Crontab crontab = Crontab.getInstance();
        if (dbDataSource == null) {
            String dbDriver = crontab.getProperty("org.jcrontab.data.GenericSQLSource.driver");
            Log.info("Loading dbDriver: " + dbDriver);
            try {
                return Class.forName(dbDriver).newInstance();
            }
            catch (Exception ie) {
                Log.error("Error loading " + dbDriver, ie);
                return DriverManager.getDriver(crontab.getProperty("org.jcrontab.data.GenericSQLSource.url"));
            }
        }
        try {
            DataSource dataSource = null;
            Log.info("Loading dataSource: " + dbDataSource);
            InitialContext ctx = null;
            ctx = new InitialContext();
            try {
                dataSource = (DataSource)ctx.lookup(dbDataSource);
            }
            catch (NameNotFoundException nnfe) {
                Log.info(nnfe.getExplanation());
                Log.info("Checking Tomcat Context");
                Context tomcatCtx = (Context)ctx.lookup("java:comp/env");
                dataSource = (DataSource)tomcatCtx.lookup(dbDataSource);
            }
            Log.debug("DataSource loaded. ");
            return dataSource;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e instanceof NamingException) {
                msg = ((NamingException)e).getExplanation();
            }
            Log.debug(msg);
            Log.info(msg + " will try to use dbDriver...");
            return this.loadDatabaseDriver(null);
        }
    }

    private void addId(Process process, Connection conn) throws Exception {
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery(nextSequence);
        if (rs != null) {
            while (rs.next()) {
                int id = rs.getInt("id");
                process.setId(id + 1);
            }
        }
    }

    static {
        queryAllProcess = "SELECT id, name, isconcurrent,  isfaulttolerant,  isrunning, lastrunt  FROM process";
        querySearching = "SELECT id, name, isconcurrent,  isfaulttolerant,  isrunning,  lastrunt  FROM process  where id = ? ";
        queryAllTasks = "SELECT t.id, t.task, t.method, t.parameters  tip.precedence FROM task t, tasksinprocess tip where  t.id = tip.taskid and  tip.processid = ? order by precedence ";
        storeProcess = "INSERT into process(id, name, isconcurrent,  isfaulttolerant,  isrunning, lastrunt) VALUES (?, ?, ?, ?, ?, ?)";
        storeTask = "INSERT into task(id, task, method, parameters)  VALUES (?, ?, ?, ? )";
        storeRelation = "INSERT into tasksinprocess(processid,  taskid) VALUES (?, ?) ";
        removeProcess = "DELETE FROM process WHERE  id = ? ";
        removeTask = "DELETE FROM task t, tasksinprocess tip  where t.id = tip.taskid and  tip.processid = ? ";
        removeRelation = "DELETE FROM tasksinprocess where processid = ? ";
        nextSequence = "SELECT MAX(id) id FROM PROCESS";
    }
}

