/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLParser
extends DefaultHandler {
    private Vector list = new Vector();
    private CrontabEntryBean ceb = null;
    private CharArrayWriter contents = new CharArrayWriter();
    private String formatDate = "dd/MM/yy";
    private CrontabParser cp = new CrontabParser();

    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        this.contents.reset();
        if (localName.equals("crontabentry")) {
            this.ceb = new CrontabEntryBean();
            this.ceb.setId(Integer.parseInt(attr.getValue("id")));
            this.list.addElement(this.ceb);
        }
        if ((localName.equals("enddate") || localName.equals("startdate")) && attr.getValue("format") != null && attr.getValue("format") != "") {
            this.formatDate = attr.getValue("format");
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Date date;
        SimpleDateFormat sdf;
        ParsePosition parsePosition;
        if (localName.equals("seconds")) {
            String seconds = this.contents.toString();
            this.ceb.setSeconds(this.contents.toString());
        }
        if (localName.equals("minutes")) {
            this.ceb.setMinutes(this.contents.toString());
        }
        if (localName.equals("hours")) {
            this.ceb.setHours(this.contents.toString());
        }
        if (localName.equals("daysofweek")) {
            this.ceb.setDaysOfWeek(this.contents.toString());
        }
        if (localName.equals("months")) {
            this.ceb.setMonths(this.contents.toString());
        }
        if (localName.equals("daysofmonth")) {
            this.ceb.setDaysOfMonth(this.contents.toString());
        }
        if (localName.equals("years")) {
            this.ceb.setYears(this.contents.toString());
        }
        if (localName.equals("class")) {
            this.ceb.setClassName(this.contents.toString());
        }
        if (localName.equals("method")) {
            this.ceb.setMethodName(this.contents.toString());
        }
        if (localName.equals("startdate")) {
            parsePosition = new ParsePosition(0);
            sdf = new SimpleDateFormat(this.formatDate);
            date = sdf.parse(this.contents.toString(), parsePosition);
            this.ceb.setStartDate(date);
        }
        if (localName.equals("enddate")) {
            parsePosition = new ParsePosition(0);
            sdf = new SimpleDateFormat(this.formatDate);
            date = sdf.parse(this.contents.toString(), parsePosition);
            this.ceb.setEndDate(date);
        }
        if (localName.equals("parameters")) {
            String[] result = this.contents.toString().split("\\s");
            this.ceb.setExtraInfo(result);
        }
        if (localName.equals("description")) {
            this.ceb.setDescription(this.contents.toString());
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    private Vector getList() {
        return this.list;
    }

    public CrontabEntryBean[] unMarshall(String xmlFile) throws Exception {
        return this.unMarshall(new InputSource(new FileInputStream(xmlFile)));
    }

    public CrontabEntryBean[] unMarshall(InputSource is) throws Exception {
        XMLReader xr = XMLReaderFactory.createXMLReader();
        XMLParser parser = new XMLParser();
        xr.setContentHandler(parser);
        xr.parse(is);
        Vector items = parser.getList();
        CrontabEntryBean[] cebs = new CrontabEntryBean[items.size()];
        for (int i = 0; i < cebs.length; ++i) {
            cebs[i] = this.cp.completeTheMarshalling((CrontabEntryBean)items.get(i));
        }
        return cebs;
    }

    public String marshall(CrontabEntryBean[] cebs) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<!DOCTYPE crontab SYSTEM \"crontab.dtd\">\n");
        sb.append("<crontab>\n");
        for (int i = 0; i < cebs.length; ++i) {
            sb.append(cebs[i].toXML());
        }
        sb.append("</crontab>\n");
        return sb.toString();
    }
}

