/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.jcrontab.Crontab;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabParser;
import org.jcrontab.data.DataNotFoundException;
import org.jcrontab.data.DataSource;
import org.jcrontab.data.XMLParser;

public class XMLSource
implements DataSource {
    private CrontabParser cp = new CrontabParser();
    private static XMLSource instance;
    private CrontabEntryBean[] cachedBeans = null;
    protected long lastModified;
    private String crontab_xml_file = "crontab.xml";
    private XMLParser xmlParser = new XMLParser();

    protected XMLSource() {
        if (Crontab.getInstance().getProperty("org.jcrontab.data.file") == null) {
            Crontab.getInstance().setProperty("org.jcrontab.data.file", this.crontab_xml_file);
        } else {
            this.crontab_xml_file = Crontab.getInstance().getProperty("org.jcrontab.data.file");
        }
        if (System.getProperty("org.xml.sax.driver") == null) {
            String parser = "org.apache.xerces.parsers.SAXParser";
            if (Crontab.getInstance().getProperty("org.xml.sax.driver") != null) {
                System.setProperty("org.xml.sax.driver", Crontab.getInstance().getProperty("org.xml.sax.driver"));
            } else {
                System.setProperty("org.xml.sax.driver", parser);
            }
        }
    }

    public synchronized DataSource getInstance() {
        if (instance == null) {
            instance = new XMLSource();
        }
        return instance;
    }

    public synchronized CrontabEntryBean find(CrontabEntryBean ceb) throws Exception {
        CrontabEntryBean[] cebra = this.xmlParser.unMarshall(this.crontab_xml_file);
        for (int i = 0; i < cebra.length; ++i) {
            if (!cebra[i].equals(ceb)) continue;
            return cebra[i];
        }
        throw new DataNotFoundException("Unable to find " + ceb);
    }

    public synchronized CrontabEntryBean[] findAll() throws Exception {
        return this.xmlParser.unMarshall(this.crontab_xml_file);
    }

    public synchronized void remove(CrontabEntryBean[] ceb) throws Exception {
        CrontabEntryBean[] thelist = this.findAll();
        CrontabEntryBean[] result = new CrontabEntryBean[thelist.length - ceb.length];
        for (int i = 0; i < thelist.length; ++i) {
            for (int y = 0; y < ceb.length; ++y) {
                if (thelist[i] == null || !thelist[i].equals(ceb[y])) continue;
                thelist[i] = null;
            }
        }
        int resultCounter = 0;
        for (int i = 0; i < thelist.length; ++i) {
            if (thelist[i] == null) continue;
            result[resultCounter] = thelist[i];
            ++resultCounter;
        }
        this.storeAll(result);
    }

    public synchronized void storeAll(CrontabEntryBean[] list) throws Exception {
        for (int i = 0; i < list.length; ++i) {
            list[i].setId(i);
        }
        String result = this.xmlParser.marshall(list);
        File fl = new File(this.crontab_xml_file);
        PrintStream out = new PrintStream(new FileOutputStream(fl));
        out.print(result);
    }

    public synchronized void store(CrontabEntryBean[] beans) throws Exception {
        CrontabEntryBean[] cebra = this.findAll();
        CrontabEntryBean[] results = new CrontabEntryBean[cebra.length + beans.length];
        int i = 0;
        for (int y = 0; y < cebra.length; ++y) {
            results[i] = cebra[y];
            ++i;
        }
        for (int j = 0; j < beans.length; ++j) {
            results[i] = beans[j];
            ++i;
        }
        this.storeAll(results);
    }
}

