/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.data.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jcrontab.Crontab;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabEntryDAO;
import org.jcrontab.data.CrontabParser;
import org.jcrontab.data.DataNotFoundException;

public class DAOTest
extends TestCase {
    private CrontabParser cp = new CrontabParser();
    private static Crontab crontab = null;
    private CrontabEntryBean[] ceb = new CrontabEntryBean[3];

    public DAOTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.ceb[0] = this.cp.marshall("* * * * * org.jcrontab.tests.test testing");
        this.ceb[0].setYears("*");
        this.ceb[0].setSeconds("0");
        this.ceb[0].setBusinessDays(true);
        this.ceb[0].setId(0);
        this.ceb[1] = this.cp.marshall("* * * * * org.jcrontab.tests.test testing 2");
        this.ceb[1].setYears("*");
        this.ceb[1].setSeconds("0");
        this.ceb[1].setBusinessDays(true);
        this.ceb[1].setId(1);
        this.ceb[2] = this.cp.marshall("* * * * * org.jcrontab.tests.test testing 3");
        this.ceb[2].setYears("*");
        this.ceb[2].setSeconds("0");
        this.ceb[2].setBusinessDays(true);
        this.ceb[2].setId(2);
    }

    public static Test suite() {
        return new TestSuite(DAOTest.class);
    }

    public static void main(String[] args) throws Exception {
        Crontab crontab = Crontab.getInstance();
        crontab.getInstance().init();
        TestRunner.run((Test)DAOTest.suite());
        System.exit(0);
    }

    public void testAdd() throws Exception {
        CrontabEntryDAO.getInstance().store(this.ceb);
    }

    public void testFind0() throws Exception {
        CrontabEntryBean ceb2 = CrontabEntryDAO.getInstance().find(this.ceb[0]);
        DAOTest.assertEquals((Object)this.ceb[0], (Object)ceb2);
    }

    public void testFind1() throws Exception {
        CrontabEntryBean ceb2 = CrontabEntryDAO.getInstance().find(this.ceb[1]);
        DAOTest.assertEquals((Object)this.ceb[1], (Object)ceb2);
    }

    public void testFind2() throws Exception {
        CrontabEntryBean ceb2 = CrontabEntryDAO.getInstance().find(this.ceb[2]);
        DAOTest.assertEquals((Object)this.ceb[2], (Object)ceb2);
    }

    public void testFindAll() throws Exception {
        CrontabEntryBean[] ceb2 = CrontabEntryDAO.getInstance().findAll();
        DAOTest.assertEquals((int)ceb2.length, (int)3);
    }

    public void testRemove() throws Exception {
        CrontabEntryDAO.getInstance().remove(this.ceb);
        try {
            CrontabEntryBean[] ceb3 = CrontabEntryDAO.getInstance().findAll();
        }
        catch (DataNotFoundException dnfe) {
            DAOTest.assertEquals((String)dnfe.toString(), (String)"org.jcrontab.data.DataNotFoundException: No CrontabEntries available");
        }
    }

    public void testRemove1() throws Exception {
        CrontabEntryBean[] ceb2 = new CrontabEntryBean[]{this.ceb[2]};
        CrontabEntryDAO.getInstance().remove(ceb2);
        CrontabEntryBean[] ceb3 = CrontabEntryDAO.getInstance().findAll();
        DAOTest.assertEquals((int)ceb3.length, (int)2);
    }

    public void testRemove2() throws Exception {
        CrontabEntryBean[] ceb2 = new CrontabEntryBean[]{this.ceb[0], this.ceb[1]};
        CrontabEntryDAO.getInstance().remove(ceb2);
        try {
            CrontabEntryBean[] ceb3 = CrontabEntryDAO.getInstance().findAll();
        }
        catch (DataNotFoundException dnfe) {
            DAOTest.assertEquals((String)dnfe.toString(), (String)"org.jcrontab.data.DataNotFoundException: No CrontabEntries available");
        }
    }
}

