/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.jcrontab.Crontab;
import org.jcrontab.gui.BottomController;
import org.jcrontab.gui.ConfigAction;
import org.jcrontab.gui.DataModifiedEvent;
import org.jcrontab.gui.Event;
import org.jcrontab.gui.JcrontabGUI;
import org.jcrontab.gui.Listener;
import org.jcrontab.gui.PropertiesTableModel;
import org.jcrontab.log.Log;

public class ConfigTab
extends JPanel
implements Listener {
    private int width = 0;
    private JTextField text = null;
    private JButton button = null;
    private PropertiesTableModel tableModel;
    private JScrollPane scrollPane = null;
    private JTable table = null;
    private Object[] data = null;
    private DefaultComboBoxModel combomodel = null;
    private JComboBox comboBox = null;

    public ConfigTab() {
        this.setLayout(null);
        Component propertiesContainer = this.getPropertiesContainer();
        Component actionableContainer = this.getActionableContainer();
        this.add(actionableContainer);
        this.add(propertiesContainer);
        JcrontabGUI.getInstance().addListener(this);
        Insets insets = this.getInsets();
        Dimension actionableSize = actionableContainer.getSize();
        Dimension propertiesSize = propertiesContainer.getSize();
        actionableContainer.setBounds(5 + insets.left, 5 + insets.top, actionableSize.width + 5, actionableSize.height + 5);
        propertiesContainer.setBounds(5 + insets.left, 5 + insets.top + actionableSize.height + 5, propertiesSize.width + 5, propertiesSize.height + 5);
    }

    public Component getPropertiesContainer() {
        this.tableModel = new PropertiesTableModel();
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new MouseHandler());
        this.table.getModel().addTableModelListener(this.tableModel);
        JcrontabGUI.getInstance().addListener(this.tableModel);
        this.scrollPane = new JScrollPane(this.table);
        return this.scrollPane;
    }

    public Component getActionableContainer() {
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(null);
        this.combomodel = new DefaultComboBoxModel();
        this.refresh();
        this.comboBox = new JComboBox(this.combomodel);
        actionPanel.add(this.comboBox);
        this.text = new JTextField(32);
        actionPanel.add(this.text);
        this.button = new JButton("Add");
        this.button.addActionListener(new ConfigAction());
        actionPanel.add(this.button);
        Insets insets = actionPanel.getInsets();
        Dimension comboBoxSize = this.comboBox.getPreferredSize();
        Dimension textSize = this.text.getPreferredSize();
        Dimension buttonSize = this.button.getPreferredSize();
        this.comboBox.setBounds(5 + insets.left, 5 + insets.top, comboBoxSize.width + 5, comboBoxSize.height);
        this.text.setBounds(5 + insets.left + comboBoxSize.width + 5, 5 + insets.top, textSize.width + 5, textSize.height + 5);
        this.button.setBounds(5 + insets.left + comboBoxSize.width + 5 + textSize.width + 5, 5 + insets.top, buttonSize.width + 10, buttonSize.height);
        this.width = 5 + insets.left + comboBoxSize.width + 5 + textSize.width + 5 + buttonSize.width + 10;
        Dimension dim = new Dimension(this.width, textSize.height + 10);
        actionPanel.setSize(dim);
        Dimension dim2 = new Dimension(this.width, this.width / 2);
        this.table.setPreferredScrollableViewportSize(dim2);
        this.scrollPane.setSize(dim2);
        return actionPanel;
    }

    private void refresh() {
        String[] allTheProperties = Crontab.getInstance().getAllThePropertiesNames();
        String[] usedProperties = new String[this.tableModel.getRowCount()];
        Enumeration keys = this.tableModel.propertyNames();
        int y = 0;
        while (keys.hasMoreElements()) {
            usedProperties[y] = (String)keys.nextElement();
            ++y;
        }
        String[] result = new String[allTheProperties.length - usedProperties.length + 1];
        int resultIndex = 0;
        boolean token = false;
        for (int i = 0; i < allTheProperties.length; ++i) {
            for (int z = 0; z < usedProperties.length; ++z) {
                if (allTheProperties[i].equals(usedProperties[z])) {
                    token = false;
                    break;
                }
                token = true;
            }
            if (!token) continue;
            result[resultIndex] = allTheProperties[i];
            ++resultIndex;
        }
        this.data = result;
        this.combomodel.removeAllElements();
        for (int j = 0; j < this.data.length; ++j) {
            this.combomodel.addElement(this.data[j]);
        }
    }

    public void processEvent(Event event) {
        DataModifiedEvent dmEvent;
        String command;
        if (event instanceof DataModifiedEvent && (command = (dmEvent = (DataModifiedEvent)event).getCommand()) == "CONFIG") {
            try {
                this.refresh();
            }
            catch (Exception e) {
                BottomController.getInstance().setError(e.toString());
                e.printStackTrace();
                Log.error("Error", e);
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        int editingRow = 0;
        JTable table = null;

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Remove");
            menuItem.addMouseListener(new PopUpHandler());
            popup.add(menuItem);
            this.table = (JTable)e.getSource();
            this.editingRow = this.table.getSelectedRow();
            if (this.editingRow != -1) {
                int mask = 15;
                int mods = e.getModifiers() & mask;
                if (mods == 0) {
                    if (e.getClickCount() >= 2) {
                        // empty if block
                    }
                } else {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        private class PopUpHandler
        extends MouseAdapter {
            private PopUpHandler() {
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public synchronized void maybeShowPopup(MouseEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                String text = menuItem.getText();
                if (text.equals("Remove")) {
                    try {
                        ConfigTab.this.tableModel.remove(MouseHandler.this.editingRow);
                    }
                    catch (Exception ex) {
                        BottomController.getInstance().setError(ex.toString());
                        Log.error("Error", ex);
                    }
                }
            }
        }
    }
}

