/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import org.jcrontab.gui.DateChooser;

public class DateButton
extends JButton {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy");
    private static final DateChooser DATE_CHOOSER = new DateChooser((Frame)null, "Select Date");
    private Date date;

    protected void fireActionPerformed(ActionEvent e) {
        Date newDate = DATE_CHOOSER.select(this.date);
        if (newDate == null) {
            return;
        }
        this.setDate(newDate);
    }

    public DateButton(Date date) {
        super(DATE_FORMAT.format(date));
        this.date = date;
    }

    public DateButton() {
        this(new Date());
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        Date old = this.date;
        this.date = date;
        this.setText(DATE_FORMAT.format(date));
        this.firePropertyChange("date", old, date);
    }
}

