/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DateChooser
extends JDialog
implements ItemListener,
MouseListener,
FocusListener,
KeyListener,
ActionListener {
    private static final String[] MONTHS = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] DAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final Color WEEK_DAYS_FOREGROUND = Color.black;
    private static final Color DAYS_FOREGROUND = Color.blue;
    private static final Color SELECTED_DAY_FOREGROUND = Color.white;
    private static final Color SELECTED_DAY_BACKGROUND = Color.blue;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final Border FOCUSED_BORDER = BorderFactory.createLineBorder(Color.yellow, 1);
    private static final int FIRST_YEAR = 1900;
    private static final int LAST_YEAR = 2100;
    private GregorianCalendar calendar;
    private JLabel[][] days;
    private FocusablePanel daysGrid;
    private JComboBox month;
    private JComboBox year;
    private JButton ok;
    private JButton cancel;
    private int offset;
    private int lastDay;
    private JLabel day;
    private boolean okClicked;

    private void construct() {
        int i;
        this.calendar = new GregorianCalendar();
        this.month = new JComboBox<String>(MONTHS);
        this.month.addItemListener(this);
        this.year = new JComboBox();
        for (i = 1900; i <= 2100; ++i) {
            this.year.addItem(Integer.toString(i));
        }
        this.year.addItemListener(this);
        this.days = new JLabel[7][7];
        for (i = 0; i < 7; ++i) {
            this.days[0][i] = new JLabel(DAYS[i], 4);
            this.days[0][i].setForeground(WEEK_DAYS_FOREGROUND);
        }
        for (i = 1; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.days[i][j] = new JLabel(" ", 4);
                this.days[i][j].setForeground(DAYS_FOREGROUND);
                this.days[i][j].setBackground(SELECTED_DAY_BACKGROUND);
                this.days[i][j].setBorder(EMPTY_BORDER);
                this.days[i][j].addMouseListener(this);
            }
        }
        this.ok = new JButton("Ok");
        this.ok.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        JPanel monthYear = new JPanel();
        monthYear.add(this.month);
        monthYear.add(this.year);
        this.daysGrid = new FocusablePanel(new GridLayout(7, 7, 5, 0));
        this.daysGrid.addFocusListener(this);
        this.daysGrid.addKeyListener(this);
        for (int i2 = 0; i2 < 7; ++i2) {
            for (int j = 0; j < 7; ++j) {
                this.daysGrid.add(this.days[i2][j]);
            }
        }
        this.daysGrid.setBackground(Color.white);
        this.daysGrid.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel daysPanel = new JPanel();
        daysPanel.add(this.daysGrid);
        JPanel buttons = new JPanel();
        buttons.add(this.ok);
        buttons.add(this.cancel);
        Container dialog = this.getContentPane();
        dialog.add("North", monthYear);
        dialog.add("Center", daysPanel);
        dialog.add("South", buttons);
        this.pack();
        this.setResizable(false);
    }

    private int getSelectedDay() {
        if (this.day == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.day.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void setSelected(JLabel newDay) {
        if (this.day != null) {
            this.day.setForeground(DAYS_FOREGROUND);
            this.day.setOpaque(false);
            this.day.setBorder(EMPTY_BORDER);
        }
        this.day = newDay;
        this.day.setForeground(SELECTED_DAY_FOREGROUND);
        this.day.setOpaque(true);
        if (this.daysGrid.hasFocus()) {
            this.day.setBorder(FOCUSED_BORDER);
        }
    }

    private void setSelected(int newDay) {
        this.setSelected(this.days[(newDay + this.offset - 1) / 7 + 1][(newDay + this.offset - 1) % 7]);
    }

    private void update() {
        int i;
        int iday = this.getSelectedDay();
        for (i = 0; i < 7; ++i) {
            this.days[1][i].setText(" ");
            this.days[5][i].setText(" ");
            this.days[6][i].setText(" ");
        }
        this.calendar.set(5, 1);
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        this.offset = this.calendar.get(7) - 1;
        this.lastDay = this.calendar.getActualMaximum(5);
        for (i = 0; i < this.lastDay; ++i) {
            this.days[(i + this.offset) / 7 + 1][(i + this.offset) % 7].setText(String.valueOf(i + 1));
        }
        if (iday != -1) {
            if (iday > this.lastDay) {
                iday = this.lastDay;
            }
            this.setSelected(iday);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.okClicked = true;
        }
        this.hide();
    }

    public void focusGained(FocusEvent e) {
        this.setSelected(this.day);
    }

    public void focusLost(FocusEvent e) {
        this.setSelected(this.day);
    }

    public void itemStateChanged(ItemEvent e) {
        this.update();
    }

    public void keyPressed(KeyEvent e) {
        int iday = this.getSelectedDay();
        switch (e.getKeyCode()) {
            case 37: {
                if (iday <= 1) break;
                this.setSelected(iday - 1);
                break;
            }
            case 39: {
                if (iday >= this.lastDay) break;
                this.setSelected(iday + 1);
                break;
            }
            case 38: {
                if (iday <= 7) break;
                this.setSelected(iday - 7);
                break;
            }
            case 40: {
                if (iday > this.lastDay - 7) break;
                this.setSelected(iday + 7);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        JLabel day = (JLabel)e.getSource();
        if (!day.getText().equals(" ")) {
            this.setSelected(day);
        }
        this.daysGrid.requestFocus();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public DateChooser(Dialog owner, String title) {
        super(owner, title, true);
        this.construct();
    }

    public DateChooser(Dialog owner) {
        super(owner, true);
        this.construct();
    }

    public DateChooser(Frame owner, String title) {
        super(owner, title, true);
        this.construct();
    }

    public DateChooser(Frame owner) {
        super(owner, true);
        this.construct();
    }

    public Date select(Date date) {
        this.calendar.setTime(date);
        int _day = this.calendar.get(5);
        int _month = this.calendar.get(2);
        int _year = this.calendar.get(1);
        this.year.setSelectedIndex(_year - 1900);
        this.month.setSelectedIndex(_month - 0);
        this.setSelected(_day);
        this.okClicked = false;
        this.show();
        if (!this.okClicked) {
            return null;
        }
        this.calendar.set(5, this.getSelectedDay());
        this.calendar.set(2, this.month.getSelectedIndex() + 0);
        this.calendar.set(1, this.year.getSelectedIndex() + 1900);
        return this.calendar.getTime();
    }

    public Date select() {
        return this.select(new Date());
    }

    private static class FocusablePanel
    extends JPanel {
        public FocusablePanel(LayoutManager layout) {
            super(layout);
        }

        public boolean isFocusTraversable() {
            return true;
        }
    }
}

