/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jcrontab.Crontab;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.gui.BottomController;
import org.jcrontab.gui.Event;
import org.jcrontab.gui.ExtendedTaskDialog;
import org.jcrontab.gui.Listener;
import org.jcrontab.gui.MenuController;
import org.jcrontab.gui.SimpleTaskDialog;
import org.jcrontab.gui.TabController;
import org.jcrontab.gui.TaskDialog;
import org.jcrontab.log.Log;

public final class JcrontabGUI
extends JFrame {
    private static JcrontabGUI instance = null;
    private static JTabbedPane tabbedPane = null;
    private static String config = null;
    private static Map listeners = Collections.synchronizedMap(new HashMap());

    private JcrontabGUI() {
        super("Jcrontab Editor");
    }

    public static JcrontabGUI getInstance() {
        if (instance == null) {
            instance = new JcrontabGUI();
        }
        return instance;
    }

    public Properties getConfig() {
        return Crontab.getInstance().getConfig();
    }

    public void setConfig(String file) throws Exception {
        BottomController.getInstance().setRightText(file);
        config = file;
        Crontab crontab = Crontab.getInstance();
        crontab.setConfig(config);
        crontab.loadConfig();
    }

    public void storeProperty(String name, String value) {
        Crontab.getInstance().storeProperty(name, value);
    }

    public void removeProperty(String name) {
        Crontab.getInstance().removeProperty(name);
    }

    public JMenuBar createMenuBar() {
        MenuController menucontroller = new MenuController();
        return menucontroller.createMenuBar();
    }

    public JPanel createTabbedPanel(int width, int height) {
        TabController tabController = new TabController(width, height);
        tabbedPane = tabController.getTAbbedPanel();
        return tabController.getPanel();
    }

    public JPanel createBottomPanel() {
        BottomController botController = BottomController.getInstance();
        return botController.getPanel();
    }

    private void createAndShowGUI() {
        Dimension screen = this.getToolkit().getScreenSize();
        instance.setUndecorated(true);
        instance.getRootPane().setWindowDecorationStyle(1);
        instance.setJMenuBar(this.createMenuBar());
        instance.setContentPane(new JPanel(new BorderLayout()));
        instance.getContentPane().add((Component)this.createTabbedPanel(screen.width, screen.height), "Center");
        instance.getContentPane().add((Component)this.createBottomPanel(), "South");
        instance.setDefaultCloseOperation(2);
        instance.setSize(screen.width, screen.height);
        BottomController.getInstance().setRightText(config);
        instance.setVisible(true);
    }

    public int getSelectedPane() {
        return tabbedPane.getSelectedIndex();
    }

    public void setSelectedPane(int selected) {
        tabbedPane.setSelectedIndex(selected);
    }

    public void addListener(Object listener) {
        listeners.put(listener, listener);
        Log.debug("Added new Listener");
    }

    public void notify(Event event) {
        Log.debug("Processing new Event " + event.getCommand());
        for (Listener listener : listeners.values()) {
            listener.processEvent(event);
        }
    }

    public TaskDialog buildTaskDialog(CrontabEntryBean bean, boolean isUpdate, int position) {
        String dao = this.getConfig().getProperty("org.jcrontab.data.datasource").toString();
        if (bean == null && !isUpdate) {
            bean = new CrontabEntryBean();
        }
        JDialog taskdialog = dao.equals("org.jcrontab.data.FileSource") ? new SimpleTaskDialog(bean, isUpdate, position) : new ExtendedTaskDialog(bean, isUpdate, position);
        return taskdialog;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            if (args[0].equals("-f")) {
                JcrontabGUI.getInstance().setConfig(args[1]);
            } else {
                System.out.println("Usage: java JcrontabGUI -f thefilewiththe.properties");
                System.exit(0);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JcrontabGUI gui = JcrontabGUI.getInstance();
                gui.createAndShowGUI();
            }
        });
    }
}

