/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.gui;

import java.util.Enumeration;
import java.util.Properties;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jcrontab.gui.BottomController;
import org.jcrontab.gui.DataModifiedEvent;
import org.jcrontab.gui.Event;
import org.jcrontab.gui.JcrontabGUI;
import org.jcrontab.gui.Listener;
import org.jcrontab.log.Log;

class PropertiesTableModel
extends AbstractTableModel
implements TableModelListener,
Listener {
    static Properties props = null;
    private Object[][] data = null;
    String[] columnNames = new String[]{"Name", "Value"};

    public PropertiesTableModel() {
        this.refresh();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public String getName() {
        return "PropertiesTableModel";
    }

    public Enumeration propertyNames() {
        return JcrontabGUI.getInstance().getConfig().propertyNames();
    }

    public void remove(int row) {
        this.fireTableRowsDeleted(row, row);
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0 && e.getColumn() != -1) {
            int row = e.getLastRow();
            int col = e.getColumn();
            TableModel model = (TableModel)e.getSource();
            String value = (String)model.getValueAt(row, 1);
            String name = (String)model.getValueAt(row, 0);
            JcrontabGUI.getInstance().storeProperty(name, value);
            DataModifiedEvent modifiedEvent = new DataModifiedEvent("CONFIG", this);
            JcrontabGUI.getInstance().notify(modifiedEvent);
        } else if (e.getType() == -1 && e.getColumn() == -1 && e.getLastRow() == e.getFirstRow()) {
            int row = e.getLastRow();
            String key = (String)this.getValueAt(row, 0);
            JcrontabGUI.getInstance().removeProperty(key);
            DataModifiedEvent modifiedEvent = new DataModifiedEvent("CONFIG", this);
            JcrontabGUI.getInstance().notify(modifiedEvent);
        }
    }

    private void refresh() {
        try {
            props = JcrontabGUI.getInstance().getConfig();
            this.data = null;
            int size = props.size();
            Enumeration<?> keys = props.propertyNames();
            this.data = new Object[size][2];
            int i = 0;
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.data[i][0] = key;
                this.data[i][1] = props.getProperty(key);
                ++i;
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            BottomController.getInstance().setError(ex.toString());
            Log.error("Error", ex);
        }
    }

    public void processEvent(Event event) {
        if (event instanceof DataModifiedEvent) {
            DataModifiedEvent dmEvent = (DataModifiedEvent)event;
            String command = dmEvent.getCommand();
            Log.debug("Processing the Event for the command " + event.getCommand());
            if (command == "ALL" || command == "CONFIG") {
                this.refresh();
            }
        }
    }
}

