/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.gui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabEntryDAO;
import org.jcrontab.data.CrontabParser;
import org.jcrontab.gui.BottomController;
import org.jcrontab.gui.DataModifiedEvent;
import org.jcrontab.gui.JcrontabGUI;
import org.jcrontab.gui.TaskDialog;
import org.jcrontab.log.Log;

class SimpleTaskDialog
extends JDialog
implements TaskDialog {
    private JTextField minute;
    private JTextField hour;
    private JTextField dayOfMonth;
    private JTextField month;
    private JTextField dayOfWeek;
    private JTextField task;
    private JTextField method;
    private JTextField parameters;
    private JLabel label;
    private JButton ok;
    private JButton cancel;
    private boolean isUpdate = false;
    private boolean isExtended = true;
    private CrontabEntryBean ceb;
    private int id;
    private int position;
    private JPanel panel;

    public SimpleTaskDialog(CrontabEntryBean ceb2, boolean update, int position) {
        if (update) {
            this.id = ceb2.getId();
        }
        this.ceb = ceb2;
        this.isUpdate = update;
        this.panel = new JPanel(new GridLayout(9, 2, 0, 6));
        this.panel.setBorder(new EmptyBorder(12, 12, 6, 12));
        this.addFields();
        this.getContentPane().add("Center", this.panel);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.setBorder(new EmptyBorder(6, 12, 12, 12));
        this.panel.add(Box.createGlue());
        this.ok = new JButton("Ok");
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        this.panel.add(this.ok);
        this.panel.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionHandler());
        this.panel.add(this.cancel);
        this.panel.add(Box.createGlue());
        this.getContentPane().add("South", this.panel);
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.setVisible(true);
        this.toFront();
    }

    public void addFields() {
        this.label = new JLabel("Minutes", 4);
        this.label.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.panel.add(this.label);
        this.minute = new JTextField(this.ceb.getMinutes());
        this.panel.add(this.minute);
        this.label = new JLabel("Hours", 4);
        this.label.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.panel.add(this.label);
        this.hour = new JTextField(this.ceb.getHours());
        this.panel.add(this.hour);
        this.label = new JLabel("Days Of Month", 4);
        this.label.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.panel.add(this.label);
        this.dayOfMonth = new JTextField(this.ceb.getDaysOfMonth());
        this.panel.add(this.dayOfMonth);
        this.label = new JLabel("Months", 4);
        this.label.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.panel.add(this.label);
        this.month = new JTextField(this.ceb.getMonths());
        this.panel.add(this.month);
        this.label = new JLabel("Days Of Week", 4);
        this.label.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.panel.add(this.label);
        this.dayOfWeek = new JTextField(this.ceb.getDaysOfWeek());
        this.panel.add(this.dayOfWeek);
        this.label = new JLabel("Class Name", 4);
        this.label.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.panel.add(this.label);
        this.task = new JTextField(this.ceb.getClassName());
        this.panel.add(this.task);
        this.label = new JLabel("Method name", 4);
        this.label.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.panel.add(this.label);
        this.method = new JTextField(this.ceb.getMethodName());
        this.panel.add(this.method);
        this.label = new JLabel("Parameters", 4);
        this.label.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.panel.add(this.label);
        String params = new String();
        if (this.ceb.getExtraInfo() != null) {
            for (int i = 0; i < this.ceb.getExtraInfo().length; ++i) {
                params = params + this.ceb.getExtraInfo()[i] + " ";
            }
        }
        this.parameters = new JTextField(params);
        this.panel.add(this.parameters);
    }

    public void ok() {
        CrontabEntryBean ceb3 = new CrontabEntryBean();
        try {
            ceb3.setMinutes(this.minute.getText());
            ceb3.setHours(this.hour.getText());
            ceb3.setDaysOfMonth(this.dayOfMonth.getText());
            ceb3.setMonths(this.month.getText());
            ceb3.setDaysOfWeek(this.dayOfWeek.getText());
            if (this.task.getText().indexOf("#") > 0) {
                StringTokenizer tokenize = new StringTokenizer(this.task.getText(), "#");
                String className = tokenize.nextToken();
                String methodName = tokenize.nextToken();
                ceb3.setClassName(className);
                ceb3.setMethodName(methodName);
            } else {
                ceb3.setClassName(this.task.getText());
                ceb3.setMethodName(this.method.getText());
            }
            if (this.parameters.getText() != null) {
                StringTokenizer tokenizer = new StringTokenizer(this.parameters.getText());
                int numTokens = tokenizer.countTokens();
                String token = tokenizer.nextToken();
                boolean bextraInfo = true;
                int i = 0;
                String[] extraInfo = new String[numTokens];
                extraInfo[i] = token;
                while (tokenizer.hasMoreElements()) {
                    extraInfo[++i] = tokenizer.nextToken();
                }
                this.ceb.setBExtraInfo(bextraInfo);
                this.ceb.setExtraInfo(extraInfo);
            }
            CrontabParser parser = new CrontabParser();
            ceb3 = parser.completeTheMarshalling(ceb3);
            if (this.isUpdate) {
                CrontabEntryBean[] cebList = new CrontabEntryBean[1];
                this.ceb.setId(this.id);
                cebList[0] = ceb3;
                CrontabEntryDAO.getInstance().remove(cebList);
            }
            CrontabEntryDAO.getInstance().store(ceb3);
            this.ceb = ceb3;
            DataModifiedEvent event = new DataModifiedEvent("DATA", this);
            JcrontabGUI.getInstance().notify(event);
        }
        catch (Exception ex) {
            BottomController.getInstance().setError(ex.toString());
            Log.error("Error", ex);
        }
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public CrontabEntryBean getCrontabEntryBean() {
        return this.ceb;
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == SimpleTaskDialog.this.ok) {
                SimpleTaskDialog.this.ok();
            } else {
                SimpleTaskDialog.this.cancel();
            }
        }
    }
}

