/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabEntryDAO;
import org.jcrontab.gui.BottomController;
import org.jcrontab.gui.DataModifiedEvent;
import org.jcrontab.gui.JcrontabGUI;
import org.jcrontab.gui.TaskDialog;
import org.jcrontab.gui.TasksTableModel;
import org.jcrontab.log.Log;

public class TasksTab
extends JPanel {
    private int width = 600;
    String sourceName = null;
    TasksTableModel tableModel = null;
    JTable table = null;

    public TasksTab() {
        this.setLayout(null);
        Component tasksContainer = this.getTasksContainer();
        this.add(tasksContainer);
    }

    public Component getTasksContainer() {
        JScrollPane scrollPane = null;
        try {
            this.tableModel = new TasksTableModel();
            JcrontabGUI.getInstance().addListener(this.tableModel);
            this.table = new JTable(this.tableModel);
            this.table.addMouseListener(new MouseHandler());
            Dimension dim = new Dimension(this.width, this.width / 2);
            this.table.setPreferredScrollableViewportSize(dim);
            scrollPane = new JScrollPane(this.table);
            scrollPane.setSize(dim);
        }
        catch (Exception e) {
            e.printStackTrace();
            BottomController.getInstance().setError(e.toString());
            Log.error("Error", e);
            scrollPane = new JScrollPane();
        }
        return scrollPane;
    }

    private class MouseHandler
    extends MouseAdapter {
        int editingRow = 0;
        JTable table = null;

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Add");
            menuItem.setName("add");
            menuItem.addMouseListener(new PopUpHandler());
            popup.add(menuItem);
            menuItem = new JMenuItem("Remove");
            menuItem.setName("remove");
            menuItem.addMouseListener(new PopUpHandler());
            popup.add(menuItem);
            menuItem = new JMenuItem("Copy");
            menuItem.setName("copy");
            menuItem.addMouseListener(new PopUpHandler());
            popup.add(menuItem);
            this.table = (JTable)e.getSource();
            this.editingRow = this.table.getSelectedRow();
            if (this.editingRow != -1) {
                int mask = 15;
                int mods = e.getModifiers() & mask;
                if (mods == 0) {
                    if (e.getClickCount() >= 2) {
                        CrontabEntryBean ceb = (CrontabEntryBean)this.table.getValueAt(this.editingRow, 0);
                        TaskDialog dialog = JcrontabGUI.getInstance().buildTaskDialog(ceb, true, this.editingRow);
                        CrontabEntryBean ceb2 = dialog.getCrontabEntryBean();
                        TasksTab.this.tableModel.setValueAt(ceb2, this.editingRow, 0);
                    }
                } else {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        private class PopUpHandler
        extends MouseAdapter {
            private PopUpHandler() {
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void maybeShowPopup(MouseEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                String text = menuItem.getName();
                if (text.equals("add")) {
                    CrontabEntryBean ceb = new CrontabEntryBean();
                    JcrontabGUI.getInstance().buildTaskDialog(ceb, false, MouseHandler.this.editingRow);
                } else if (text.equals("remove")) {
                    try {
                        CrontabEntryBean ceb = (CrontabEntryBean)MouseHandler.this.table.getValueAt(MouseHandler.this.editingRow, 0);
                        CrontabEntryBean[] cebs = new CrontabEntryBean[]{ceb};
                        CrontabEntryDAO.getInstance().remove(cebs);
                        DataModifiedEvent event = new DataModifiedEvent("DATA", this);
                        JcrontabGUI.getInstance().notify(event);
                    }
                    catch (Exception ex) {
                        BottomController.getInstance().setError(ex.toString());
                        Log.error("Error", ex);
                    }
                } else if (text.equals("copy")) {
                    CrontabEntryBean ceb = (CrontabEntryBean)MouseHandler.this.table.getValueAt(MouseHandler.this.editingRow, 0);
                    CrontabEntryBean cebCopy = new CrontabEntryBean(ceb);
                    JcrontabGUI.getInstance().buildTaskDialog(ceb, false, MouseHandler.this.editingRow);
                }
            }
        }
    }
}

