/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.gui;

import javax.swing.table.AbstractTableModel;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.DataNotFoundException;
import org.jcrontab.data.DataSourceProxy;
import org.jcrontab.gui.BottomController;
import org.jcrontab.gui.DataModifiedEvent;
import org.jcrontab.gui.Event;
import org.jcrontab.gui.JcrontabGUI;
import org.jcrontab.gui.Listener;
import org.jcrontab.log.Log;

class TasksTableModel
extends AbstractTableModel
implements Listener {
    Object[] data = null;
    String[] columnNames = new String[]{"Name"};

    public TasksTableModel() throws Exception {
        this.refresh();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        return this.data[row];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void setValueAt(Object value, int row, int col) {
        this.data[row] = value;
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int row) {
        return false;
    }

    public String getName() {
        return "AbstractTableModel";
    }

    public void add(Object obj) {
        Object[] result = new Object[this.data.length + 1];
        for (int i = 0; i < this.data.length; ++i) {
            result[i] = this.data[i];
        }
        result[this.data.length] = obj;
        this.data = result;
        this.fireTableDataChanged();
    }

    public void refresh() throws Exception {
        try {
            this.data = new DataSourceProxy(JcrontabGUI.getInstance().getConfig().getProperty("org.jcrontab.data.datasource")).getDataSource().findAll();
        }
        catch (Exception ex) {
            if (ex instanceof DataNotFoundException) {
                CrontabEntryBean bean = new CrontabEntryBean();
                this.data = new CrontabEntryBean[0];
            }
            throw ex;
        }
        this.fireTableDataChanged();
    }

    public void processEvent(Event event) {
        DataModifiedEvent dmEvent;
        String command;
        if (event instanceof DataModifiedEvent && ((command = (dmEvent = (DataModifiedEvent)event).getCommand()) == "ALL" || command == "DATA")) {
            try {
                this.refresh();
            }
            catch (Exception e) {
                BottomController.getInstance().setError(e.toString());
                e.printStackTrace();
                Log.error("Error", e);
            }
        }
    }
}

