/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.log;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.jcrontab.Crontab;
import org.jcrontab.data.DefaultFiles;
import org.jcrontab.log.Logger;

public class Log4JLogger
implements Logger {
    private static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger((String)"jcrontab");

    protected InputStream createPropertiesStream(String name) throws IOException {
        try {
            InputStream stream = this.getClass().getResourceAsStream(name);
            if (stream == null) {
                stream = new FileInputStream(name);
            }
            return stream;
        }
        catch (FileNotFoundException fnfe) {
            try {
                DefaultFiles.createLog4jFile();
                return new FileInputStream(name);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException("Error creating/reading default file");
            }
        }
    }

    public void init() {
        String log4JProperties = Crontab.getInstance().getProperty("org.jcrontab.log.log4J.Properties");
        Properties props = new Properties();
        try {
            InputStream input = this.createPropertiesStream(log4JProperties);
            props.load(input);
            PropertyConfigurator.configure((Properties)props);
        }
        catch (Exception e) {
            System.out.println("Unable to load :" + log4JProperties + e);
        }
    }

    public void info(String message) {
        log.info((Object)message);
    }

    public void error(String message, Throwable t) {
        log.error((Object)message, t);
    }

    public void debug(String message) {
        log.debug((Object)message);
    }
}

