/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jcrontab.Crontab;
import org.jcrontab.data.CalendarBuilder;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabEntryDAO;
import org.jcrontab.data.CrontabParser;

public class SimpleTest
extends TestCase {
    private CrontabParser cp = new CrontabParser();
    private static Crontab crontab = null;
    private CrontabEntryBean[] ceb = new CrontabEntryBean[3];

    public SimpleTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        crontab = Crontab.getInstance();
        crontab.getInstance().init();
        this.ceb[0] = this.cp.marshall("* * * * * org.jcrontab.tests.test testing");
        this.ceb[0].setYears("*");
        this.ceb[0].setSeconds("0");
        this.ceb[0].setBusinessDays(true);
        this.ceb[0].setId(0);
        this.ceb[1] = this.cp.marshall("* * * * * org.jcrontab.tests.test testing 2");
        this.ceb[1].setYears("*");
        this.ceb[1].setSeconds("0");
        this.ceb[1].setBusinessDays(true);
        this.ceb[1].setId(1);
        this.ceb[2] = this.cp.marshall("* * * * * org.jcrontab.tests.test testing 3");
        this.ceb[2].setYears("*");
        this.ceb[2].setSeconds("0");
        this.ceb[2].setBusinessDays(true);
        this.ceb[2].setId(2);
    }

    public static Test suite() {
        return new TestSuite(SimpleTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SimpleTest.suite());
        System.exit(0);
    }

    public void testDAOAdd() throws Exception {
        CrontabEntryDAO.getInstance().store(this.ceb);
    }

    public void testDAOFindAll() throws Exception {
        CrontabEntryBean[] listOfBeans = CrontabEntryDAO.getInstance().findAll();
        SimpleTest.assertEquals((int)listOfBeans.length, (int)3);
    }

    public void testNextBeanToExecute() throws Exception {
        CrontabEntryBean[] listOfBeans = CrontabEntryDAO.getInstance().findAll();
        CalendarBuilder calb = new CalendarBuilder();
        CrontabEntryBean nextb = calb.getNextCrontabEntry(listOfBeans);
        System.out.println("this is the next Bean \n" + nextb.toXML());
    }

    public void testCrontabParser() throws Exception {
        CrontabParser cp = new CrontabParser();
        CrontabEntryBean ceb = cp.marshall("* * * * * org.jcrontab.tests.TaskTest");
        System.out.println("this is the bean resulting from  * * * * * org.jcrontab.tests.TaskTest \n" + ceb.toXML());
    }
}

