/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Vector;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabEntryDAO;
import org.jcrontab.data.CrontabParser;
import org.jcrontab.data.DataNotFoundException;
import org.jcrontab.log.Log;

public class CrontabServletXML
extends HttpServlet {
    public static final String xsl = "view.xsl";

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        int event = Integer.parseInt(request.getParameter("event"));
        switch (event) {
            case 0: {
                this.store(request, response);
                break;
            }
            case 1: {
                this.remove(request, response);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.show(request, response);
    }

    public void remove(HttpServletRequest request, HttpServletResponse response) {
        Vector<String> errors = new Vector<String>();
        if (request.getParameterValues("remove") == null) {
            errors.add("Must select smth to delete");
            request.setAttribute("error", errors);
            this.show(request, response);
        } else {
            String[] idToDelete = request.getParameterValues("remove");
            CrontabEntryBean[] result = new CrontabEntryBean[idToDelete.length];
            for (int i = 0; i < idToDelete.length; ++i) {
                CrontabEntryBean resulti = new CrontabEntryBean();
                resulti.setId(Integer.parseInt(idToDelete[i]));
                try {
                    result[i] = CrontabEntryDAO.getInstance().find(resulti);
                    continue;
                }
                catch (Exception e) {
                    Log.error(e.toString(), e);
                }
            }
            try {
                CrontabEntryDAO.getInstance().remove(result);
            }
            catch (Exception e) {
                errors.add(e.toString());
                request.setAttribute("error", errors);
                Log.error(e.toString(), e);
            }
            this.show(request, response);
        }
    }

    public void store(HttpServletRequest request, HttpServletResponse response) {
        Vector<String> errors = new Vector<String>();
        String Classname = request.getParameter("Classname").trim();
        if (Classname.length() > 0) {
            String Minutes = request.getParameter("Minutes").trim();
            String Hours = request.getParameter("Hours").trim();
            String Daysofmonth = request.getParameter("Daysofmonth").trim();
            String Month = request.getParameter("Month").trim();
            String Daysofweek = request.getParameter("Daysofweek").trim();
            String Extrainfo = request.getParameter("Extrainfo").trim();
            StringBuffer sb = new StringBuffer();
            sb.append(Minutes);
            sb.append(" ");
            sb.append(Hours);
            sb.append(" ");
            sb.append(Daysofmonth);
            sb.append(" ");
            sb.append(Month);
            sb.append(" ");
            sb.append(Daysofweek);
            sb.append(" ");
            sb.append(Classname);
            sb.append(" ");
            sb.append(Extrainfo);
            try {
                CrontabParser cbp = new CrontabParser();
                CrontabEntryBean cb = cbp.marshall(sb.toString());
                CrontabEntryDAO.getInstance().store(cb);
                this.show(request, response);
            }
            catch (Exception e) {
                errors.add(e.toString());
                Log.error(e.toString(), e);
            }
            request.setAttribute("error", errors);
            this.show(request, response);
        } else {
            errors.add("Must write some class name");
            request.setAttribute("error", errors);
            this.show(request, response);
        }
    }

    public void show(HttpServletRequest request, HttpServletResponse response) {
        try {
            PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
            CrontabEntryBean[] listOfBeans = null;
            try {
                listOfBeans = CrontabEntryDAO.getInstance().findAll();
            }
            catch (Exception e) {
                if (e instanceof DataNotFoundException) {
                    listOfBeans = new CrontabEntryBean[1];
                    CrontabParser cbp = new CrontabParser();
                    listOfBeans[0] = cbp.marshall("* * * * * org.jcrontab.tests.Example put your own");
                }
                Log.error(e.toString(), e);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(CrontabServletXML.printHeader());
            sb.append(CrontabServletXML.processErrors(request));
            sb.append("<crontabentries>");
            for (int i = 0; i < listOfBeans.length; ++i) {
                sb.append(listOfBeans[i].toXML());
            }
            sb.append("</crontabentries>");
            sb.append(CrontabServletXML.printFooter());
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource xmlsource = new StreamSource(new StringReader(sb.toString()));
            File xslFile = new File(this.getServletContext().getRealPath("/") + xsl);
            FileInputStream fileInputStream = new FileInputStream(xslFile);
            InputStreamReader xslReader = new InputStreamReader(fileInputStream);
            StreamSource xslSource = new StreamSource(xslReader);
            Transformer transformer = tFactory.newTransformer(xslSource);
            transformer.transform(xmlsource, new StreamResult(out));
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String printHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"view.xsl\" ?> \n");
        sb.append("<page xml:base=\"\"> \n");
        return sb.toString();
    }

    public static String printFooter() {
        return "</page>";
    }

    public static String processErrors(HttpServletRequest request) {
        if (request.getAttribute("error") != null) {
            Vector errorV = (Vector)request.getAttribute("error");
            String[] errorList = new String[errorV.size()];
            for (int i = 0; i < errorV.size(); ++i) {
                errorList[i] = (String)errorV.get(i);
            }
            StringBuffer sbi = new StringBuffer();
            for (int i = 0; i < errorList.length; ++i) {
                sbi.append("<error><text>");
                sbi.append(errorList[i]);
                sbi.append("</text></error>\n");
            }
            return sbi.toString();
        }
        return " ";
    }
}

