/*
 * Decompiled with CFR 0.152.
 */
package org.jcrontab.web;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.jcrontab.Crontab;
import org.jcrontab.log.Log;

public class loadCrontabServlet
extends HttpServlet {
    private Crontab crontab = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            System.out.print("Working?...");
            this.process();
            System.out.println("OK");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected InputStream createPropertiesStream(String name) throws IOException {
        return new FileInputStream(name);
    }

    public void process() {
        String propz = "jcrontab.properties";
        String props = this.getServletConfig().getInitParameter("PROPERTIES_FILE");
        if (props == null) {
            props = propz;
        }
        Properties propObj = new Properties();
        try {
            InputStream input = this.createPropertiesStream(props);
            propObj.load(input);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        ServletConfig c = this.getServletConfig();
        Enumeration keys = c.getInitParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            propObj.setProperty(key, c.getInitParameter(key));
        }
        this.crontab = Crontab.getInstance();
        try {
            this.ShutdownHook();
            this.crontab.init(propObj);
        }
        catch (Exception e) {
            Log.error(e.toString(), e);
        }
    }

    public void ShutdownHook() throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                loadCrontabServlet.this.doStop();
            }
        });
    }

    public void destroy() {
        this.doStop();
    }

    public void doStop() {
        Log.info("Shutting down...");
        this.crontab.uninit(100);
        Log.info("Stoped");
    }
}

