/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.toolkit.atom.ExportExcelAtomService;
import com.tydic.newretail.toolkit.atom.QueryExportMappingAtomService;
import com.tydic.newretail.toolkit.bo.ExportExcelReqBO;
import com.tydic.newretail.toolkit.bo.ExportExcelRspBO;
import com.tydic.newretail.toolkit.bo.ExportMappingBO;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import com.tydic.newretail.toolkit.util.TkNewOssFileUtils;
import com.tydic.newretail.toolkit.util.TkOssConfig;
import com.tydic.newretail.toolkit.util.TkPropertiesUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ExportExcelAtomServiceImpl
implements ExportExcelAtomService {
    private static final Logger logger = LoggerFactory.getLogger(ExportExcelAtomServiceImpl.class);
    private static Pattern pattern = Pattern.compile("^//d+(//.//d+)?$");
    private QueryExportMappingAtomService queryExportMappingAtomService;

    public void setQueryExportMappingAtomService(QueryExportMappingAtomService queryExportMappingAtomService) {
        this.queryExportMappingAtomService = queryExportMappingAtomService;
    }

    @Override
    public ExportExcelRspBO exportExcel(ExportExcelReqBO reqBO) {
        ExportExcelRspBO result = new ExportExcelRspBO();
        long start = System.currentTimeMillis();
        try {
            if (StringUtils.isEmpty((CharSequence)reqBO.getTableName())) {
                logger.error("\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u8868\u540d\u3010tableName\u3011\u4e3a\u7a7a");
                throw new BusinessException("0001", "\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u8868\u540d\u3010tableName\u3011\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getFileName())) {
                logger.error("\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u6587\u4ef6\u540d\u3010FileName\u3011\u4e3a\u7a7a");
                throw new BusinessException("0001", "\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u6587\u4ef6\u540d\u3010FileName\u3011\u4e3a\u7a7a");
            }
            List datas = reqBO.getDatas();
            ExportMappingBO exportQryBO = new ExportMappingBO();
            exportQryBO.setTableName(reqBO.getTableName());
            exportQryBO.setDefaultFlag("1");
            List<ExportMappingBO> exmappList = this.queryExportMappingAtomService.listExportMapByTable(exportQryBO);
            if (CollectionUtils.isEmpty(exmappList)) {
                logger.error("\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u672a\u914d\u7f6e\u8868" + reqBO.getTableName() + "\u7684\u6620\u5c04\u5173\u7cfb");
                throw new BusinessException("9999", "\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u672a\u914d\u7f6e\u8868" + reqBO.getTableName() + "\u7684\u6620\u5c04\u5173\u7cfb");
            }
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList<String> keys = new ArrayList<String>();
            if (CollectionUtils.isEmpty((Collection)reqBO.getHeadParams())) {
                for (ExportMappingBO exportMappingBO : exmappList) {
                    headers.add(exportMappingBO.getHeadName());
                    keys.add(exportMappingBO.getObjName());
                }
            } else {
                for (ExportMappingBO exportMappingBO : exmappList) {
                    if (!reqBO.getHeadParams().contains(exportMappingBO.getObjName())) continue;
                    headers.add(exportMappingBO.getHeadName());
                    keys.add(exportMappingBO.getObjName());
                    reqBO.getHeadParams().remove(exportMappingBO.getObjName());
                }
            }
            File file = this.createTempFile();
            long first = System.currentTimeMillis();
            logger.info("\u5bfc\u51fa-\u751f\u6210\u4e34\u65f6\u6587\u4ef6\u7528\u65f6" + (first - start) + "\u6beb\u79d2");
            FileOutputStream out = new FileOutputStream(file);
            this.writeExcelFile(datas, headers, keys, out);
            long second = System.currentTimeMillis();
            logger.info("\u5bfc\u51fa-\u5199\u8868\u7528\u65f6" + (second - first) + "\u6beb\u79d2");
            TkOssConfig ossConfig = new TkOssConfig();
            ossConfig.setAccessKeyId(TkPropertiesUtils.getProperty("OSS_ACCESSKEY").trim());
            ossConfig.setAccessKeySecret(TkPropertiesUtils.getProperty("OSS_ACCESSKEY_SECRET").trim());
            ossConfig.setAccessUrl(TkPropertiesUtils.getProperty("OSS_ACCESS_URL").trim());
            ossConfig.setBucketName(TkPropertiesUtils.getProperty("OSS_BUCKETNAME").trim());
            ossConfig.setEndpoint(TkPropertiesUtils.getProperty("OSS_ENDPOINT").trim());
            String path = TkPropertiesUtils.getProperty("OSS_DEFAULT_FILEPATH").trim();
            TkNewOssFileUtils.uploadFileToPath(file, path, ossConfig);
            long three = System.currentTimeMillis();
            logger.info("\u5bfc\u51fa-\u4e0a\u4f20\u6587\u4ef6\u7528\u65f6" + (three - second) + "\u6beb\u79d2");
            String fileName = file.getName();
            String filePath = path + fileName;
            result.setFilePath(filePath);
            result.setRespCode("0000");
            result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519", (Throwable)e);
            throw new BusinessException("9999", e.getMessage());
        }
        long end = System.currentTimeMillis();
        logger.info("\u5bfc\u51fa-\u603b\u7528\u65f6" + (end - start) + "\u6beb\u79d2");
        return result;
    }

    @Override
    public ExportExcelReqBO queryTableMapping(ExportExcelReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getTableName())) {
            logger.error("\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u8868\u540d\u3010tableName\u3011\u4e3a\u7a7a");
            throw new BusinessException("0001", "\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u8868\u540d\u3010tableName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getFileName())) {
            logger.error("\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u6587\u4ef6\u540d\u3010FileName\u3011\u4e3a\u7a7a");
            throw new BusinessException("0001", "\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u6587\u4ef6\u540d\u3010FileName\u3011\u4e3a\u7a7a");
        }
        ExportMappingBO exportQryBO = new ExportMappingBO();
        exportQryBO.setTableName(reqBO.getTableName());
        exportQryBO.setDefaultFlag("1");
        List<ExportMappingBO> exmappList = this.queryExportMappingAtomService.listExportMapByTable(exportQryBO);
        if (CollectionUtils.isEmpty(exmappList)) {
            logger.error("\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u672a\u914d\u7f6e\u8868" + reqBO.getTableName() + "\u7684\u6620\u5c04\u5173\u7cfb");
            throw new BusinessException("9999", "\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u672a\u914d\u7f6e\u8868" + reqBO.getTableName() + "\u7684\u6620\u5c04\u5173\u7cfb");
        }
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)reqBO.getHeadParams())) {
            for (ExportMappingBO exportMappingBO : exmappList) {
                headers.add(exportMappingBO.getHeadName());
                keys.add(exportMappingBO.getObjName());
            }
        } else {
            for (ExportMappingBO exportMappingBO : exmappList) {
                if (!reqBO.getHeadParams().contains(exportMappingBO.getObjName())) continue;
                headers.add(exportMappingBO.getHeadName());
                keys.add(exportMappingBO.getObjName());
                reqBO.getHeadParams().remove(exportMappingBO.getObjName());
            }
        }
        reqBO.setHeadParams(keys);
        reqBO.setHeadNames(headers);
        return reqBO;
    }

    @Override
    public List<ExportMappingBO> queryTableMappingList(ExportExcelReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getTableName())) {
            logger.error("\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u8868\u540d\u3010tableName\u3011\u4e3a\u7a7a");
            throw new BusinessException("0001", "\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u8868\u540d\u3010tableName\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getFileName())) {
            logger.error("\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u6587\u4ef6\u540d\u3010FileName\u3011\u4e3a\u7a7a");
            throw new BusinessException("0001", "\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u5165\u53c2\u6587\u4ef6\u540d\u3010FileName\u3011\u4e3a\u7a7a");
        }
        ExportMappingBO exportQryBO = new ExportMappingBO();
        exportQryBO.setTableName(reqBO.getTableName());
        exportQryBO.setDefaultFlag("1");
        List<ExportMappingBO> exmappList = this.queryExportMappingAtomService.listExportMapByTable(exportQryBO);
        if (CollectionUtils.isEmpty(exmappList)) {
            logger.error("\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u672a\u914d\u7f6e\u8868" + reqBO.getTableName() + "\u7684\u6620\u5c04\u5173\u7cfb");
            throw new BusinessException("9999", "\u5bfc\u51fa\u8868\u683c\u539f\u5b50\u670d\u52a1\u51fa\u9519\uff1a\u672a\u914d\u7f6e\u8868" + reqBO.getTableName() + "\u7684\u6620\u5c04\u5173\u7cfb");
        }
        return exmappList;
    }

    private File createTempFile() throws Exception {
        File file = null;
        try {
            String path = System.getProperty("java.io.tmpdir");
            String tempExcelFileName = path + File.separator + UUID.randomUUID() + ".xlsx";
            file = new File(tempExcelFileName);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new Exception("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", e);
        }
        return file;
    }

    private void writeExcelFile(List<?> datas, List<String> headers, List<String> keys, OutputStream out) throws Exception {
        int index = 1;
        int limit = 10000;
        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        CellStyle titleStyle = this.setExcelTitleStyle(workbook);
        CellStyle bodyStyle = this.setExcelBodyStyle(workbook, titleStyle);
        int totalRows = 0;
        int sheetNum = 1;
        int rowIndex = 0;
        SXSSFSheet sheet = workbook.createSheet("Sheet" + sheetNum);
        if (headers.size() > 0) {
            Row row = sheet.createRow(rowIndex++);
            row.setHeightInPoints(15.0f);
            for (int j = 0; j < headers.size(); ++j) {
                Cell cell = row.createCell(j);
                XSSFRichTextString text = new XSSFRichTextString(headers.get(j));
                cell.setCellValue((RichTextString)text);
                cell.setCellStyle(titleStyle);
            }
        }
        ArrayList totalNumList = new ArrayList();
        while (datas != null && datas.size() > 0) {
            if ((totalRows += datas.size()) % 500000 == 0) {
                sheet = workbook.createSheet("Sheet" + ++sheetNum);
                rowIndex = 0;
                if (headers.size() > 0) {
                    Row row = sheet.createRow(rowIndex++);
                    row.setHeightInPoints(15.0f);
                    for (int j = 0; j < headers.size(); ++j) {
                        Cell cell = row.createCell(j);
                        XSSFRichTextString text = new XSSFRichTextString(headers.get(j));
                        cell.setCellValue((RichTextString)text);
                        cell.setCellStyle(titleStyle);
                    }
                }
            }
            this.ExportExcelTOStream(headers, keys, datas, workbook, titleStyle, bodyStyle, (Sheet)sheet, rowIndex);
            rowIndex += datas.size();
            if (datas.size() != limit) break;
            ++index;
        }
        workbook.write(out);
        if (out != null) {
            out.close();
        }
        if (workbook != null) {
            workbook.dispose();
        }
    }

    private CellStyle setExcelTitleStyle(SXSSFWorkbook workbook) {
        CellStyle titleStyle = workbook.createCellStyle();
        Font titleFont = workbook.createFont();
        titleFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        titleFont.setFontHeightInPoints((short)12);
        titleStyle.setFont(titleFont);
        return titleStyle;
    }

    private CellStyle setExcelBodyStyle(SXSSFWorkbook workbook, CellStyle titleStyle) {
        CellStyle bodyStyle = workbook.createCellStyle();
        bodyStyle.cloneStyleFrom(titleStyle);
        Font bodyFont = workbook.createFont();
        bodyFont.setFontName("\u5b8b\u4f53");
        bodyFont.setColor(IndexedColors.BLACK.index);
        bodyFont.setFontHeightInPoints((short)12);
        bodyStyle.setFont(bodyFont);
        return bodyStyle;
    }

    private void ExportExcelTOStream(List<String> headers, List<String> keys, List<?> datasets, SXSSFWorkbook workbook, CellStyle titleStyle, CellStyle bodyStyle, Sheet sheet, int index) throws Exception {
        block15: {
            try {
                Row row = null;
                if (datasets == null) break block15;
                Iterator<?> it = datasets.iterator();
                while (it.hasNext()) {
                    row = sheet.createRow(index);
                    row.setHeightInPoints(15.0f);
                    Object t = it.next();
                    ArrayList<Field> fieldList = new ArrayList<Field>();
                    Map map = new HashMap();
                    boolean mapFlag = false;
                    if (t instanceof Map) {
                        mapFlag = true;
                        map = (Map)t;
                    } else {
                        for (Class<?> tempClass = t.getClass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
                            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
                        }
                    }
                    for (int j = 0; j < keys.size(); ++j) {
                        Cell cell = row.createCell(j);
                        cell.setCellStyle(bodyStyle);
                        Object value = null;
                        if (mapFlag) {
                            for (Object key : map.keySet()) {
                                if (key == null || !((String)key).equals(keys.get(j))) continue;
                                value = map.get(key);
                                break;
                            }
                        } else {
                            Object key;
                            Field field = null;
                            key = fieldList.iterator();
                            while (key.hasNext()) {
                                Field f = (Field)key.next();
                                String fieldName = f.getName();
                                if (fieldName != null && fieldName.equals(keys.get(j))) {
                                    field = f;
                                    break;
                                }
                                if (!"respDesc".equals(keys.get(j))) continue;
                                field = RspBaseBO.class.getDeclaredField("respDesc");
                                break;
                            }
                            if (field == null) continue;
                            field.setAccessible(true);
                            value = field.get(t);
                        }
                        String textValue = null;
                        if (value instanceof Date) {
                            Date date = (Date)value;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            textValue = sdf.format(date);
                        } else {
                            String string = textValue = value == null ? "" : value.toString();
                        }
                        if (textValue == null) continue;
                        Matcher matcher = pattern.matcher(textValue);
                        if (matcher.matches()) {
                            cell.setCellValue(Double.parseDouble(textValue));
                            continue;
                        }
                        cell.setCellValue(textValue);
                    }
                    ++index;
                }
            }
            catch (Exception e) {
                logger.error("\u5199excel\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw new BusinessException("8806", "\u5199excel\u6587\u4ef6\u5931\u8d25\uff0c" + e.getMessage());
            }
        }
    }
}

