/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.toolkit.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class TkCreateThreadUtils {
    private static LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue(1);

    public static ExecutorService createSimpleThreadPool(Runnable run, String threadName, int corePoolSize, int maxPoolSize) {
        return TkCreateThreadUtils.createSimpleThreadPoolPub(run, threadName, corePoolSize, maxPoolSize, null);
    }

    public static ExecutorService createSimpleThreadPoolWithQueue(Runnable run, String threadName, int corePoolSize, int maxPoolSize, LinkedBlockingQueue<Runnable> queue) {
        return TkCreateThreadUtils.createSimpleThreadPoolPub(run, threadName, corePoolSize, maxPoolSize, queue);
    }

    public static ExecutorService createSimpleThreadPoolPub(Runnable run, String threadName, int corePoolSize, int maxPoolSize, LinkedBlockingQueue<Runnable> queue) {
        if (null == queue) {
            queue = linkedBlockingQueue;
        }
        if (StringUtils.isBlank((CharSequence)threadName)) {
            threadName = "default-pool";
        }
        queue.add(run);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat(threadName + "-%d").build();
        ThreadPoolExecutor singleThreadPool = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 0L, TimeUnit.MILLISECONDS, queue, namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());
        return singleThreadPool;
    }
}

