/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.imes.config;

import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.imes.config.IdxStrategyConfig;
import com.tydic.nicc.imes.config.eums.IdxStrategyType;
import java.util.Date;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="nicc-im-data2es.config.idx-strategy")
public class AutoIndexStrategyProperties {
    private Boolean enable = true;
    private List<IdxStrategyConfig> configs;

    public String getRealIndexName(String idxName, Date date) {
        if (this.configs != null) {
            for (IdxStrategyConfig config : this.configs) {
                if (!idxName.equals(config.getIdxName())) continue;
                String realIdxName = "";
                if (IdxStrategyType.day.name().equals(config.getStrategy())) {
                    Date nextDay = DateTimeUtil.DateAdd((Date)date, (int)5, (int)1);
                    String day = DateTimeUtil.getTimeShortString((Date)nextDay, (String)config.getFormat());
                    realIdxName = config.getIdxName() + config.getSplit() + day;
                } else if (IdxStrategyType.month.name().equals(config.getStrategy())) {
                    Date nextMonth = DateTimeUtil.DateAdd((Date)date, (int)2, (int)1);
                    String month = DateTimeUtil.getTimeShortString((Date)nextMonth, (String)config.getFormat());
                    realIdxName = config.getIdxName() + config.getSplit() + month;
                }
                return realIdxName;
            }
        }
        return "";
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public List<IdxStrategyConfig> getConfigs() {
        return this.configs;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setConfigs(List<IdxStrategyConfig> configs) {
        this.configs = configs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoIndexStrategyProperties)) {
            return false;
        }
        AutoIndexStrategyProperties other = (AutoIndexStrategyProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        List<IdxStrategyConfig> this$configs = this.getConfigs();
        List<IdxStrategyConfig> other$configs = other.getConfigs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoIndexStrategyProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        List<IdxStrategyConfig> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    public String toString() {
        return "AutoIndexStrategyProperties(enable=" + this.getEnable() + ", configs=" + this.getConfigs() + ")";
    }
}

