/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.imes.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.bo.rocketmq.SessionIndexContext;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.eums.CommonEsMethodName;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.imes.api.ChatUserSessionIndexApi;
import com.tydic.nicc.imes.api.bo.ChatSessionIndexDocument;
import com.tydic.nicc.imes.api.bo.ChatSessionIndexQueryReqBO;
import com.tydic.nicc.imes.api.es.EsRsp;
import com.tydic.nicc.imes.api.es.QueryCondition;
import com.tydic.nicc.imes.config.NiccImData2ESProperties;
import com.tydic.nicc.imes.utils.EsDocumentHelper;
import com.tydic.nicc.user.api.UserOptionService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
public class ChatUserSessionIndexServiceImpl
implements ChatUserSessionIndexApi {
    private static final Logger log = LoggerFactory.getLogger(ChatUserSessionIndexServiceImpl.class);
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserOptionService userOptionService;
    @Resource
    private NiccImData2ESProperties niccImData2ESProperties;
    @Resource
    private EsDocumentHelper esDocumentHelper;
    public static final Map<String, UserAuthInfo> userMap = new ConcurrentHashMap<String, UserAuthInfo>();

    public RspList getChatUserList(ChatSessionIndexQueryReqBO queryReqBO) {
        Rsp userRsp;
        if (queryReqBO.getStartTime() == null) {
            queryReqBO.setStartTime(DateTimeUtil.DateAddDayOfYear((int)-90));
        }
        if (queryReqBO.getEndTime() == null) {
            queryReqBO.setEndTime(new Date());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqBO.getExtUid()) && StringUtils.isBlank((CharSequence)queryReqBO.getUserId()) && (userRsp = this.userOptionService.getUserAuthInfoByEuid(queryReqBO.getTenantCode(), queryReqBO.getExtUid(), null)).isSuccess()) {
            queryReqBO.setUserId(((UserAuthInfo)userRsp.getData()).getUserId());
        }
        if (StringUtils.isBlank((CharSequence)queryReqBO.getGroup()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{queryReqBO.getChannelCode(), queryReqBO.getUserType()})) {
            queryReqBO.setGroup(queryReqBO.getChannelCode());
            queryReqBO.setChannelCode(null);
        }
        Map param = NiccCommonUtil.beanToMap((Object)queryReqBO);
        QueryCondition condition = QueryCondition.builder().propName(CommonEsMethodName.searchChatListByCondition.name()).mapperPath("esmapper/ChatUserSessionIndexMapper.xml").esIndexName(this.niccImData2ESProperties.getIdxChatSessionIndex()).pageNo(queryReqBO.getPage()).pageSize(queryReqBO.getLimit()).params(param).searchAll(false).build();
        ArrayList documentList = Lists.newArrayList();
        log.info("\u67e5\u8be2\u4f1a\u8bdd\u7d22\u5f15,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)condition));
        EsRsp esRsp = this.esDocumentHelper.searchDocs(condition, ChatSessionIndexDocument.class);
        NiccCommonUtil.copyList((List)esRsp.getRow(), (List)documentList, ChatSessionIndexDocument.class);
        log.info("\u67e5\u8be2\u4f1a\u8bdd\u7d22\u5f15,\u7ed3\u679c:{} \u6761", (Object)esRsp.getTotal());
        return BaseRspUtils.createSuccessRspList((List)documentList, (long)esRsp.getTotal());
    }

    public void updateChatIndex(SessionIndexContext context) {
        try {
            this.esDocumentHelper.add(this.buildDocument(context), this.niccImData2ESProperties.getIdxChatSessionIndex());
        }
        catch (Exception e) {
            log.error("\u4f1a\u8bdd\u7d22\u5f15\u540c\u6b65-\u5f02\u5e38:{}", (Object)e, (Object)JSONObject.toJSONString((Object)context));
        }
    }

    public void updateChatIndexBatch(List<SessionIndexContext> contextList) {
        try {
            ArrayList documentList = Lists.newArrayList();
            for (SessionIndexContext indexContext : contextList) {
                documentList.add(this.buildDocument(indexContext));
            }
            this.esDocumentHelper.addBatch(documentList, this.niccImData2ESProperties.getIdxChatSessionIndex());
        }
        catch (Exception e) {
            log.error("\u4f1a\u8bdd\u7d22\u5f15\u540c\u6b65[\u6279\u91cf]-\u5f02\u5e38:", (Throwable)e);
        }
    }

    private ChatSessionIndexDocument buildDocument(SessionIndexContext context) {
        Rsp rsp;
        UserAuthInfo userAuthInfo;
        ChatSessionIndexDocument document = new ChatSessionIndexDocument();
        String chatId = context.getChatType() + NiccCommonUtil.stringToMD5((String)(context.getUserId() + context.getChatUser()));
        document.setChatId(chatId);
        document.setTenantCode(context.getTenantCode());
        document.setUserId(context.getUserId());
        document.setChatUser(context.getChatUser());
        document.setChatType(context.getChatType());
        document.setUserSource(context.getUserSource());
        document.setChatKey(context.getChatKey());
        document.setFirstChannel(context.getFirstChannel());
        document.setLastTime(context.getLastTime());
        document.setIsActive(context.getIsActive());
        document.setLastSession(context.getLastSession());
        if (!context.getTenantCode().equals(context.getChatUser())) {
            userAuthInfo = userMap.get(context.getChatUser());
            if (userAuthInfo == null && (rsp = this.userOptionService.getUserAuthInfo(context.getChatUser(), Boolean.valueOf(false))).isSuccess()) {
                userAuthInfo = (UserAuthInfo)rsp.getData();
                userMap.put(userAuthInfo.getUserId(), userAuthInfo);
            }
            if (userAuthInfo != null) {
                this.parseUserInfo(document, userAuthInfo);
                document.setChatInfo(JSONObject.toJSONString((Object)userAuthInfo));
            }
        }
        if (!context.getTenantCode().equals(context.getUserId())) {
            userAuthInfo = userMap.get(context.getUserId());
            if (userAuthInfo == null && (rsp = this.userOptionService.getUserAuthInfo(context.getUserId(), Boolean.valueOf(false))).isSuccess()) {
                userAuthInfo = (UserAuthInfo)rsp.getData();
                userMap.put(userAuthInfo.getUserId(), userAuthInfo);
            }
            if (userAuthInfo != null) {
                document.setUserType(userAuthInfo.getUserType());
                this.parseUserInfo(document, userAuthInfo);
                document.setUserInfo(JSONObject.toJSONString((Object)userAuthInfo));
            }
        }
        return document;
    }

    private void parseUserInfo(ChatSessionIndexDocument document, UserAuthInfo user) {
        if (UserTypeField.USER.getCode().equals(user.getUserType())) {
            document.setChannelCode(user.getChannelCode());
        }
        if (UserTypeField.COMP_USER.getCode().equals(user.getUserType())) {
            document.setProvince(user.getProvince());
            document.setCity(user.getCity());
            document.setBusiCode(user.getChannelCode());
        }
    }
}

