/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.imes.service;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.api.ImMessageEsApi;
import com.tydic.nicc.common.bo.im.es.ImMessageEsDocQueryReqBO;
import com.tydic.nicc.common.bo.im.es.ImMessageEsDocument;
import com.tydic.nicc.common.bo.rocketmq.ImMsgContext;
import com.tydic.nicc.common.bo.session.GetUserSessionListBO;
import com.tydic.nicc.common.bo.session.GetUserSessionListReqBO;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.eums.CommonEsMethodName;
import com.tydic.nicc.common.eums.im.MsgFromInType;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.imes.api.bo.ImMsgDocument;
import com.tydic.nicc.imes.api.es.EsRsp;
import com.tydic.nicc.imes.api.es.QueryCondition;
import com.tydic.nicc.imes.config.NiccImData2ESProperties;
import com.tydic.nicc.imes.mapper.DataWriteMapper;
import com.tydic.nicc.imes.mapper.po.ImC2bMessage;
import com.tydic.nicc.imes.utils.EsDocumentHelper;
import com.tydic.nicc.imes.utils.ImMsgParseHelper;
import com.tydic.nicc.imes.utils.es.SearchAggImMsgCondition;
import com.tydic.nicc.imes.utils.es.SearchImAggResult;
import com.tydic.nicc.user.api.UserOptionService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.DuplicateKeyException;

@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class ImMessageEsServiceImpl
implements ImMessageEsApi {
    private static final Logger log = LoggerFactory.getLogger(ImMessageEsServiceImpl.class);
    @Resource
    private EsDocumentHelper esDocumentHelper;
    @Resource
    private NiccImData2ESProperties niccImData2ESProperties;
    @Resource
    private DataWriteMapper dataWriteMapper;
    @Resource
    private ImMsgParseHelper imMsgParseHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserOptionService userOptionService;

    public void saveMessage(ImMsgContext msgContext) {
        ImMsgDocument document = this.buildMsgDocument(msgContext);
        try {
            this.imMsgParseHelper.fillImInfo(document);
            this.saveC2bMessage(document, msgContext);
        }
        catch (DuplicateKeyException e) {
            log.error("\u6d88\u606f\u5199\u5165-\u5165\u5e93\u5f02\u5e38[\u4e3b\u952e\u51b2\u7a81]: msgId = {}", (Object)msgContext.getMsgId());
        }
        catch (Exception e2) {
            log.error("\u6d88\u606f\u5199\u5165-\u5165\u5e93\u5f02\u5e38: context = {}", (Object)JSONObject.toJSONString((Object)msgContext), (Object)e2);
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            this.saveC2bMessage(document, msgContext);
        }
    }

    public void saveC2cMessage(ImMsgContext msgContext) {
        try {
            ImMsgDocument document = this.buildMsgDocument(msgContext);
            this.imMsgParseHelper.fillImInfo(document);
            this.esDocumentHelper.add(document, this.niccImData2ESProperties.getIdxImC2cMessage());
        }
        catch (DuplicateKeyException e) {
            log.error("\u6d88\u606f\u5199\u5165-\u5165\u5e93\u5f02\u5e38[\u4e3b\u952e\u51b2\u7a81]: msgId = {}", (Object)msgContext.getMsgId());
        }
        catch (Exception e2) {
            log.error("\u6d88\u606f\u5199\u5165-\u5165\u5e93\u5f02\u5e38: context = {}", (Object)JSONObject.toJSONString((Object)msgContext), (Object)e2);
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.saveC2cMessage(msgContext);
        }
    }

    private ImMsgDocument buildMsgDocument(ImMsgContext msgContext) {
        ImMsgDocument document = new ImMsgDocument();
        BeanUtils.copyProperties((Object)msgContext, (Object)document);
        UserAuthInfo fromUser = msgContext.getUserInfo();
        Rsp userRsp = this.userOptionService.getUserAuthInfo(msgContext.getToNo(), Boolean.valueOf(false));
        if (UserTypeField.COMP_USER.getCode().equals(fromUser.getUserType())) {
            document.setFromType(UserTypeField.COMP_USER.getShotCode());
            document.setToType(UserTypeField.USER.getShotCode());
            document.setUserSource(String.valueOf(fromUser.getUserSource()));
            document.setCsName(fromUser.getUserName());
            document.setCsPhone(fromUser.getCallNum());
            document.setCsNick(fromUser.getNickName());
            document.setProvince(fromUser.getProvince());
            document.setCity(fromUser.getCity());
            if (userRsp.isSuccess()) {
                document.setUserName(((UserAuthInfo)userRsp.getData()).getUserName());
                document.setUserPhone(((UserAuthInfo)userRsp.getData()).getCallNum());
                document.setUserNick(((UserAuthInfo)userRsp.getData()).getNickName());
            }
        } else {
            document.setFromType(UserTypeField.USER.getShotCode());
            document.setToType(UserTypeField.COMP_USER.getShotCode());
            document.setUserName(fromUser.getUserName());
            document.setUserPhone(fromUser.getCallNum());
            document.setUserNick(fromUser.getNickName());
            if (userRsp.isSuccess()) {
                document.setUserSource(String.valueOf(((UserAuthInfo)userRsp.getData()).getUserSource()));
                document.setCsName(((UserAuthInfo)userRsp.getData()).getUserName());
                document.setCsPhone(((UserAuthInfo)userRsp.getData()).getCallNum());
                document.setCsNick(((UserAuthInfo)userRsp.getData()).getNickName());
                document.setProvince(((UserAuthInfo)userRsp.getData()).getProvince());
                document.setCity(((UserAuthInfo)userRsp.getData()).getCity());
            }
        }
        String c2cKey = NiccCommonUtil.getC2cChatKey((String)msgContext.getFromNo(), (String)msgContext.getToNo());
        document.setC2cKey(c2cKey);
        return document;
    }

    private void saveC2bMessage(ImMsgDocument document, ImMsgContext context) {
        ImC2bMessage record = new ImC2bMessage();
        BeanUtils.copyProperties((Object)context, (Object)record);
        record.setCustSource(Short.valueOf(MsgFromInType.PC.getCode()));
        record.setInfoSessionId(context.getSessionId());
        record.setMsgTypeTrans(context.getMsgType());
        record.setCreateTime(new Date());
        this.dataWriteMapper.insertC2bMessage(record);
        try {
            this.esDocumentHelper.add(document, this.niccImData2ESProperties.getIdxImMessage());
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u5199\u5165-\u64cd\u4f5ces\u5f02\u5e38:", (Throwable)e);
            this.esDocumentHelper.add(document, this.niccImData2ESProperties.getIdxImMessage());
        }
    }

    private void saveC2cMessage(ImMsgDocument document) {
        try {
            this.esDocumentHelper.add(document, this.niccImData2ESProperties.getIdxImC2cMessage());
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u5199\u5165-\u64cd\u4f5ces\u5f02\u5e38:", (Throwable)e);
            this.esDocumentHelper.add(document, this.niccImData2ESProperties.getIdxImC2cMessage());
        }
    }

    public RspList getC2bHistoryMessages(ImMessageEsDocQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u5386\u53f2\u6d88\u606f,\u5f00\u59cb:{}", (Object)reqBO);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{reqBO.getTenantCode(), reqBO.getFromNo()})) {
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25,\u8bf7\u68c0\u67e5\u53c2\u6570!");
        }
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{reqBO.getC2cKey(), reqBO.getChatKey(), reqBO.getToNo()})) {
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25,\u8bf7\u68c0\u67e5\u53c2\u6570!");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getChatKey()) && "cs".equals(this.niccImData2ESProperties.getImChatModel())) {
            String chatKey = "";
            chatKey = UserTypeField.USER.getCode().equals(reqBO.getFromType()) ? NiccCommonUtil.getC2bChatKey((String)reqBO.getTenantCode(), (String)reqBO.getFromNo()) : NiccCommonUtil.getC2bChatKey((String)reqBO.getTenantCode(), (String)reqBO.getToNo());
            reqBO.setChatKey(chatKey);
        }
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{reqBO.getChatKey(), reqBO.getC2cKey()})) {
            String c2cKey = NiccCommonUtil.getC2cChatKey((String)reqBO.getFromNo(), (String)reqBO.getToNo());
            reqBO.setC2cKey(c2cKey);
        }
        try {
            ImMsgDocument document;
            if (StringUtils.isNotBlank((CharSequence)reqBO.getLastMsgId()) && StringUtils.isBlank((CharSequence)reqBO.getLastMsgTime()) && (document = this.esDocumentHelper.getDocument(this.niccImData2ESProperties.getIdxImMessage(), reqBO.getLastMsgId(), ImMsgDocument.class)) != null) {
                reqBO.setLastMsgTime(DateTimeUtil.getTimeShortString((Date)document.getMsgTime(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS"));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getStartTime()) && StringUtils.isBlank((CharSequence)reqBO.getEndTime())) {
                reqBO.setEndTime(DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS"));
            }
            ArrayList documentList = Lists.newArrayList();
            Map param = NiccCommonUtil.beanToMap((Object)reqBO);
            QueryCondition condition = QueryCondition.builder().propName(CommonEsMethodName.searchByCondition.name()).mapperPath("esmapper/ESImMessageMapper.xml").esIndexName(this.niccImData2ESProperties.getIdxImMessage()).pageNo(reqBO.getPage()).pageSize(reqBO.getLimit()).params(param).searchAll(false).build();
            log.info("\u67e5\u8be2\u5386\u53f2\u6d88\u606f,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)condition));
            EsRsp esRsp = this.esDocumentHelper.searchDocs(condition, ImMsgDocument.class);
            NiccCommonUtil.copyList((List)esRsp.getRow(), (List)documentList, ImMessageEsDocument.class);
            log.info("\u67e5\u8be2\u5386\u53f2\u6d88\u606f,\u7ed3\u679c:{} \u6761", (Object)esRsp.getTotal());
            return BaseRspUtils.createSuccessRspList((List)documentList, (long)esRsp.getTotal());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5386\u53f2\u6d88\u606f-\u5f02\u5e38:", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)("\u67e5\u8be2\u5f02\u5e38:" + e.getMessage()));
        }
    }

    public RspList<ImMessageEsDocument> getC2bHistoryMessagesImModel(ImMessageEsDocQueryReqBO reqBO) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{reqBO.getTenantCode(), reqBO.getFromNo(), reqBO.getToNo()})) {
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25,\u8bf7\u68c0\u67e5\u53c2\u6570!");
        }
        String c2cKey = NiccCommonUtil.getC2cChatKey((String)reqBO.getFromNo(), (String)reqBO.getToNo());
        reqBO.setC2cKey(c2cKey);
        return this.getC2bHistoryMessages(reqBO);
    }

    public RspList<GetUserSessionListBO> getSessionListFromEsSearch(GetUserSessionListReqBO reqBO) {
        ArrayList sessionList = Lists.newArrayList();
        log.info("im\u6d88\u606f\u805a\u5408\u67e5\u8be2-\u641c\u7d22\u4f1a\u8bdd\u5217\u8868-\u5f00\u59cb:{}", (Object)reqBO);
        long start = System.currentTimeMillis();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{reqBO.getTenantCode(), reqBO.getUserId()})) {
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25,\u8bf7\u68c0\u67e5\u53c2\u6570!");
        }
        SearchAggImMsgCondition params = new SearchAggImMsgCondition();
        params.setTenantCode(reqBO.getTenantCode());
        params.setUserId(reqBO.getUserId());
        params.setUserSource(reqBO.getUserSource());
        params.setKeyword(reqBO.getQueryWords());
        if (ObjectUtils.allNotNull((Object[])new Object[]{reqBO.getStartTime(), reqBO.getEndTime()})) {
            params.setStartTime(DateTimeUtil.getTimeShortString((Date)reqBO.getStartTime(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS"));
            params.setEndTime(DateTimeUtil.getTimeShortString((Date)reqBO.getEndTime(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS"));
        } else {
            reqBO.setStartTime(new Date());
            reqBO.setEndTime(DateTimeUtil.DateAdd((Date)reqBO.getStartTime(), (int)6, (int)-90));
        }
        try {
            RspList<SearchImAggResult> rspList = this.esDocumentHelper.searchAggImMsgDocs(reqBO.getChatType(), params);
            List results = rspList.getRows();
            for (SearchImAggResult result : results) {
                GetUserSessionListBO sessionListBO = new GetUserSessionListBO();
                String chatObjId = result.getToNo();
                if (result.getToNo().equals(reqBO.getUserId())) {
                    chatObjId = result.getFromNo();
                }
                BeanUtils.copyProperties((Object)result, (Object)sessionListBO);
                sessionListBO.setChatObjId(chatObjId);
                sessionListBO.setFromType(String.valueOf(result.getFromType()));
                sessionListBO.setToType(String.valueOf(result.getToType()));
                sessionListBO.setLastMsgId(result.getMsgId());
                if (result.getMsgTime() != null) {
                    sessionListBO.setLastTime(result.getMsgTime());
                    sessionListBO.setLastMsgTime(Long.valueOf(result.getMsgTime().getTime()));
                }
                if (reqBO.isCsModel()) {
                    sessionListBO.setCallNum(result.getUserPhone());
                    sessionListBO.setChatName(result.getUserName());
                } else {
                    sessionListBO.setCallNum(result.getCsPhone());
                    sessionListBO.setChatName(result.getCsName());
                }
                sessionList.add(sessionListBO);
            }
        }
        catch (Exception e) {
            log.error("im\u6d88\u606f\u805a\u5408\u67e5\u8be2-\u67e5\u8be2\u5f02\u5e38: param = {}", (Object)params, (Object)e);
        }
        long end = System.currentTimeMillis();
        log.info("im\u6d88\u606f\u805a\u5408\u67e5\u8be2-\u641c\u7d22\u4f1a\u8bdd\u5217\u8868-\u5b8c\u6210:{}|{}", (Object)sessionList.size(), (Object)(end - start));
        return BaseRspUtils.createSuccessRspList((List)sessionList);
    }
}

