/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.imes.timer;

import com.tydic.nicc.common.eums.CommonEsMethodName;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.imes.config.AutoIndexStrategyProperties;
import com.tydic.nicc.imes.config.IdxStrategyConfig;
import com.tydic.nicc.imes.utils.EsDocumentHelper;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"nicc-im-data2es.config.idx-strategy.enable"}, havingValue="true")
@EnableScheduling
@Component
public class AutoCreateIdxStrategyTimer {
    private static final Logger log = LoggerFactory.getLogger(AutoCreateIdxStrategyTimer.class);
    private static final String IDX_AUTO_CREATE_LOCK = "IDX_AUTO_CREATE_LOCK";
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private AutoIndexStrategyProperties strategyProperties;
    @Resource
    private EsDocumentHelper esDocumentHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0 1 * * ?")
    public void doJob() {
        if (!this.strategyProperties.getEnable().booleanValue()) {
            return;
        }
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(IDX_AUTO_CREATE_LOCK).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        if (locked) {
            try {
                log.info("\u81ea\u52a8\u521b\u5efa\u7d22\u5f15\u4efb\u52a1,\u5f00\u59cb\u6267\u884c:{}", (Object)this.strategyProperties);
                if (this.strategyProperties.getConfigs() != null) {
                    for (IdxStrategyConfig config : this.strategyProperties.getConfigs()) {
                        String idxName;
                        log.info("\u81ea\u52a8\u521b\u5efa\u7d22\u5f15\u4efb\u52a1,\u914d\u7f6e\u4fe1\u606f:{}", (Object)config);
                        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getIdxName(), config.getMapperPath(), config.getStrategy()}) || !StringUtils.isNotBlank((CharSequence)(idxName = this.strategyProperties.getRealIndexName(config.getIdxName(), new Date())))) continue;
                        log.info("\u81ea\u52a8\u521b\u5efa\u7d22\u5f15\u4efb\u52a1,\u521b\u5efa\u7d22\u5f15-\u5f00\u59cb:{}", (Object)idxName);
                        this.esDocumentHelper.createIndex(config.getMapperPath(), idxName, CommonEsMethodName.createIndex.name(), false);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u81ea\u52a8\u521b\u5efa\u7d22\u5f15\u4efb\u52a1,\u6267\u884c\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }
}

