/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.imes.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.tydic.nicc.common.eums.im.MsgChatType;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.imes.api.bo.ImUserInfoDocument;
import com.tydic.nicc.imes.api.es.EsRsp;
import com.tydic.nicc.imes.api.es.QueryCondition;
import com.tydic.nicc.imes.config.NiccImData2ESProperties;
import com.tydic.nicc.imes.utils.es.SearchAggImMsgCondition;
import com.tydic.nicc.imes.utils.es.SearchImAggResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.boot.BBossESStarter;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ClientOptions;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.MapRestResponse;
import org.frameworkset.elasticsearch.serial.ESTypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EsDocumentHelper<T> {
    private static final Logger log = LoggerFactory.getLogger(EsDocumentHelper.class);
    @Value(value="${es.page.size:1000}")
    private Integer esPageSize;
    @Autowired
    private BBossESStarter bbossESStarter;
    @Resource
    NiccImData2ESProperties niccImData2ESProperties;

    public String createIndex(String mapperName, String index, String method, boolean dropOld) {
        log.info("\u521b\u5efa\u7d22\u5f15: mapperName = {},indexName = {},method = {},dropOld = {}", new Object[]{mapperName, index, method, dropOld});
        ClientInterface clientUtil = this.bbossESStarter.getConfigRestClient(mapperName);
        boolean exist = clientUtil.existIndice(index);
        if (exist) {
            if (dropOld) {
                String dropIndice = clientUtil.dropIndice(index);
                log.info("\u521b\u5efa\u7d22\u5f15: \u5220\u9664\u7d22\u5f15 index = {}", (Object)dropIndice);
                clientUtil.createIndiceMapping(index, method);
                String crtIndice = clientUtil.getIndice(index);
                log.info("\u521b\u5efa\u7d22\u5f15: \u5b8c\u6210,\u83b7\u53d6\u521b\u5efa\u7684\u7d22\u5f15\u4fe1\u606f:{}", (Object)crtIndice);
                return crtIndice;
            }
            log.warn("\u521b\u5efa\u7d22\u5f15: \u7d22\u5f15 {} \u5df2\u5b58\u5728,\u65e0\u9700\u91cd\u590d\u521b\u5efa!", (Object)index);
            return "";
        }
        clientUtil.createIndiceMapping(index, method);
        String crtIndice = clientUtil.getIndice(index);
        log.info("\u521b\u5efa\u7d22\u5f15: \u5b8c\u6210,\u83b7\u53d6\u521b\u5efa\u7684\u7d22\u5f15\u4fe1\u606f:{}", (Object)crtIndice);
        return crtIndice;
    }

    public T getDocument(String index, String docId, Class<T> clazz) {
        ClientInterface clientUtil = this.bbossESStarter.getRestClient();
        return (T)clientUtil.getDocument(index, docId, clazz);
    }

    public void add(T doc, String index) {
        ClientInterface clientUtil = this.bbossESStarter.getRestClient();
        String response = clientUtil.addDocument(index, doc);
        log.info("EsDocumentHelper.add \u5199\u5165es \u7ed3\u679c \uff1a{}", (Object)response);
    }

    public String updateDoc(ImUserInfoDocument doc, String index, String filedName) {
        log.info("\u66f4\u65b0\u6587\u6863:index = {},doc = {},filed = {}", new Object[]{index, doc, filedName});
        ClientInterface clientUtil = this.bbossESStarter.getRestClient();
        ClientOptions updateOptions = new ClientOptions();
        updateOptions.setIdField(filedName).setEsRetryOnConflict((Object)2).setReturnSource(Boolean.valueOf(true)).setTimeout("8s").setWaitForActiveShards(Integer.valueOf(1)).setRefresh("true");
        String response = clientUtil.updateDocument(index, (Object)doc, updateOptions);
        log.info("\u4fee\u6539\u6587\u6863\u4fe1\u606f:{}", (Object)response);
        return response;
    }

    public void addBatch(List<T> docs, String index) {
        ClientInterface clientUtil = this.bbossESStarter.getRestClient();
        String response = clientUtil.addDocuments(index, docs);
        if (this.niccImData2ESProperties.getPrintLog().booleanValue()) {
            log.info("EsDocumentHelper.addBatch \u6279\u91cf\u5199\u5165es \uff1a{} \u6761,\u7ed3\u679c \uff1a{}", (Object)docs.size(), (Object)response);
        }
    }

    public String deleteByQuery(QueryCondition condition) {
        log.info("\u5220\u9664\u6587\u6863\u6761\u4ef6\uff1a{}", (Object)condition);
        ClientInterface clientUtil = this.bbossESStarter.getRestClient();
        long totalSize = clientUtil.count(condition.getEsIndexName(), "deleteByQuery", condition.getParams());
        if (totalSize < 0L) {
            log.info("es\u7d22\u5f15:{} \u4e2d\u6682\u65e0\u6b64\u8bb0\u5f55:{}", (Object)condition.getEsIndexName(), (Object)condition.getParams());
            return "\u67e5\u65e0\u6b64\u8bb0\u5f55";
        }
        String result = clientUtil.deleteByQuery(condition.getEsIndexName() + "/_delete_by_query?refresh", "deleteByQuery", condition.getParams());
        log.info("\u5220\u9664\u6587\u6863\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)result);
        return result;
    }

    public <E> EsRsp searchDocs(QueryCondition condition, Class<E> eClass, Boolean isPage) {
        if (isPage.booleanValue()) {
            log.info("data2es \u4f7f\u7528\u5206\u9875\u67e5\u8be2\uff0c{}", (Object)condition);
        }
        ClientInterface clientUtil = this.bbossESStarter.getConfigRestClient(condition.getMapperPath());
        ESDatas datas = clientUtil.searchScroll("1m", condition.getScrollId(), eClass);
        return new EsRsp(datas.getDatas(), datas.getScrollId());
    }

    public <E> EsRsp searchDocs(QueryCondition condition, Class<E> eClass) {
        int pageSize = condition.getPageSize();
        int pageNo = condition.getPageNo();
        ClientInterface clientUtil = this.bbossESStarter.getConfigRestClient(condition.getMapperPath());
        try {
            condition.getParams().put("pageSize", condition.getPageSize());
            log.info("\u67e5\u8be2 \u5165\u53c2:{} ,pageNo = {}!", (Object)condition.getParams(), (Object)condition.getPageNo());
            ESDatas response = clientUtil.searchList(condition.getEsIndexName() + "/_search?scroll=1m", condition.getPropName(), condition.getParams(), eClass);
            ArrayList<String> scrollIds = new ArrayList<String>();
            scrollIds.add(response.getScrollId());
            long totalSize = response.getTotalSize();
            int totalPage = totalSize % (long)pageSize == 0L ? (int)(totalSize / (long)pageSize) : (int)(totalSize / (long)pageSize + 1L);
            if (pageNo > totalPage) {
                return new EsRsp(new ArrayList(), Long.valueOf(totalSize), Integer.valueOf(pageNo), Integer.valueOf(pageSize));
            }
            log.info("\u67e5\u8be2 \u603b\u6570\u636e:{} \u6761,\u6bcf\u9875 {} \u6761 , \u5206 {} \u9875 !", new Object[]{totalSize, pageSize, totalPage});
            List rspPageList = response.getDatas();
            if (pageNo <= 1 && !condition.isSearchAll()) {
                log.info("\u5f53\u524d\u9875\u7801 {} \u8fd4\u56de\u9996\u9875\u6570\u636e!", (Object)pageNo);
                return new EsRsp(rspPageList, Long.valueOf(totalSize), Integer.valueOf(pageNo), Integer.valueOf(pageSize), response.getScrollId());
            }
            for (int i = 2; i <= totalPage; ++i) {
                List list;
                String scrollId = response.getScrollId();
                if (scrollId == null) continue;
                scrollIds.add(scrollId);
                response = clientUtil.searchScroll("1m", scrollId, eClass);
                if (i == pageNo && !condition.isSearchAll()) {
                    log.info("\u53d6\u7b2c {} \u9875\u6570\u636e, scrollId = {}", (Object)pageNo, (Object)scrollId);
                    list = response.getDatas();
                    if (scrollIds.size() > 0) {
                        if (log.isDebugEnabled()) {
                            String scrolls = clientUtil.executeHttp(condition.getEsIndexName() + "/_search", "get");
                            log.info("scroll\u4e0a\u4e0b\u6587\u4fe1\u606f {} ", (Object)scrolls);
                        }
                        clientUtil.deleteScrolls(scrollIds);
                    }
                    return new EsRsp(list, Long.valueOf(totalSize), Integer.valueOf(pageNo), Integer.valueOf(pageSize));
                }
                if (!condition.isSearchAll()) continue;
                list = response.getDatas();
                rspPageList.addAll(list);
            }
            if (condition.isSearchAll()) {
                return new EsRsp(rspPageList, Long.valueOf(totalSize), Integer.valueOf(pageNo), Integer.valueOf(pageSize));
            }
        }
        catch (ElasticSearchException e) {
            log.error("\u67e5\u8be2\u5217\u8868\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new EsRsp(new ArrayList(), Long.valueOf(0L), Integer.valueOf(pageNo), Integer.valueOf(pageSize));
    }

    public RspList<SearchImAggResult> searchAggImMsgDocs(String chatType, SearchAggImMsgCondition params) {
        List list;
        block6: {
            String bucketName = "top_friends";
            list = new ArrayList();
            try {
                ClientInterface clientInterface = this.bbossESStarter.getConfigRestClient("esmapper/ESImMessageMapper.xml");
                String idxName = this.niccImData2ESProperties.getIdxImMessage();
                if (MsgChatType.C2C.getCode().equals(chatType)) {
                    idxName = this.niccImData2ESProperties.getIdxImC2cMessage();
                    clientInterface = this.bbossESStarter.getConfigRestClient("esmapper/ESImC2cMessageMapper.xml");
                }
                log.info("im\u6d88\u606f\u805a\u5408\u67e5\u8be2-\u5165\u53c2:{}", (Object)params);
                MapRestResponse restResponse = clientInterface.search(idxName + "/_search", "searchAggsImByCondition", (Object)params);
                List appstatics = (List)restResponse.getAggBuckets("top_friends", (ESTypeReference)new ESTypeReference<List<Map<String, Object>>>(){});
                List jsonArr = (List)JsonPath.parse((Object)appstatics).read("$.._source", new Predicate[0]);
                if (!ObjectUtils.allNotNull((Object[])new Object[]{jsonArr})) break block6;
                try {
                    list = JSONArray.parseArray((String)JSONObject.toJSONString((Object)jsonArr), SearchImAggResult.class);
                    if (log.isTraceEnabled()) {
                        log.info("im\u6d88\u606f\u805a\u5408\u67e5\u8be2-\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)jsonArr));
                    }
                }
                catch (JSONException e) {
                    log.error("im\u6d88\u606f\u805a\u5408\u67e5\u8be2-\u6570\u636e\u89e3\u6790\u5f02\u5e38:{}", (Object)jsonArr, (Object)e);
                }
            }
            catch (ElasticSearchException e) {
                log.error("im\u6d88\u606f\u805a\u5408\u67e5\u8be2-\u5f02\u5e38:{}", (Object)params, (Object)e);
            }
        }
        return BaseRspUtils.createSuccessRspList(list);
    }
}

