/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.imes.utils;

import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.imes.api.bo.ImMsgDocument;
import com.tydic.nicc.imes.config.NiccImData2ESProperties;
import com.tydic.nicc.imes.mapper.DataWriteMapper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ImMsgParseHelper {
    private static final Logger log = LoggerFactory.getLogger(ImMsgParseHelper.class);
    @Resource
    private NiccImData2ESProperties niccImData2ESProperties;
    @Resource
    private DataWriteMapper dataWriteMapper;
    public static final Map<String, String> CS_CHANNEL_MAP = new HashMap<String, String>();

    public void fillImInfo(ImMsgDocument document) {
        try {
            if ("im".equals(this.niccImData2ESProperties.getImChatModel())) {
                String csId = UserTypeField.COMP_USER.getShotCode().equals(document.getFromType()) ? document.getFromNo() : document.getToNo();
                String channel = CS_CHANNEL_MAP.get(csId);
                if (StringUtils.isBlank((CharSequence)channel)) {
                    channel = this.dataWriteMapper.selectCsChannel(csId);
                    CS_CHANNEL_MAP.put(csId, channel);
                }
                if (StringUtils.isNotBlank((CharSequence)channel)) {
                    document.setGroup(channel);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5ba2\u670d\u5f52\u5c5e\u6e20\u9053\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)document.getChannelCode()) && document.getChannelCode().length() > 1) {
            document.setMsgTag(document.getChannelCode().substring(0, 2));
        }
    }
}

