/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.imes.busi;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.imes.api.bo.BatchSyncMessageReqBO;
import com.tydic.nicc.imes.api.bo.ImMsgDocument;
import com.tydic.nicc.imes.config.NiccImData2ESProperties;
import com.tydic.nicc.imes.mapper.DataWriteMapper;
import com.tydic.nicc.imes.mapper.po.ImC2bMessage;
import com.tydic.nicc.imes.mapper.po.ImC2bMessageQueryCondition;
import com.tydic.nicc.imes.utils.EsDocumentHelper;
import com.tydic.nicc.imes.utils.ImMsgParseHelper;
import com.tydic.nicc.user.api.UserOptionService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class EsDataSyncService {
    private static final Logger log = LoggerFactory.getLogger(EsDataSyncService.class);
    @Resource
    private DataWriteMapper dataWriteMapper;
    @Resource
    private EsDocumentHelper esDocumentHelper;
    @Resource
    private NiccImData2ESProperties niccImData2ESProperties;
    @Resource
    private ImMsgParseHelper imMsgParseHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserOptionService userOptionService;

    public Rsp batchSyncMessage(BatchSyncMessageReqBO reqBO) {
        log.info("\u6279\u91cf\u540c\u6b65\u6d88\u606f-\u5f00\u59cb:{}", (Object)reqBO);
        int startPage = reqBO.getPage();
        int count = 0;
        while (true) {
            long start = System.currentTimeMillis();
            RspList<ImMsgDocument> documentRspList = this.getMessageDocuments(reqBO);
            List documents = documentRspList.getRows();
            if (documents.isEmpty()) break;
            long end1 = System.currentTimeMillis();
            this.esDocumentHelper.addBatch(documents, this.niccImData2ESProperties.getIdxImMessage());
            long end2 = System.currentTimeMillis();
            reqBO.setPage(startPage++);
            log.info("\u6279\u91cf\u540c\u6b65\u6d88\u606f-\u5199\u5165\u6d88\u606f\u6570\u636e,\u603b\u6570:{}|\u5f53\u524d\u9875:{}|\u67e5\u8be2\u8017\u65f6:{}|\u5199\u5165\u8017\u65f6:{}", new Object[]{documentRspList.getCount(), reqBO.getPage(), end1 - start, end2 - end1});
            count += documents.size();
        }
        return BaseRspUtils.createSuccessRsp((Object)count);
    }

    public RspList<ImMsgDocument> getMessageDocuments(BatchSyncMessageReqBO reqBO) {
        ImC2bMessageQueryCondition condition = new ImC2bMessageQueryCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        log.info("\u6279\u91cf\u540c\u6b65\u6d88\u606f-\u67e5\u8be2\u8d77\u59cb\u9875:page = {},limit = {}", (Object)reqBO.getPage(), (Object)reqBO.getLimit());
        this.dataWriteMapper.selectByCondition(condition);
        log.info("\u6279\u91cf\u540c\u6b65\u6d88\u606f-\u67e5\u8be2\u7ed3\u679c:size = {},total = {}", (Object)page.getResult().size(), (Object)page.getTotal());
        ArrayList<ImMsgDocument> documents = new ArrayList<ImMsgDocument>();
        for (ImC2bMessage message : page.getResult()) {
            ImMsgDocument document = new ImMsgDocument();
            Rsp fromUserRsp = this.userOptionService.getUserAuthInfo("", message.getFromNo());
            Rsp toUserRsp = this.userOptionService.getUserAuthInfo("", message.getToNo());
            BeanUtils.copyProperties((Object)message, (Object)document);
            document.setSessionId(message.getInfoSessionId());
            document.setMsgType(message.getMsgTypeTrans());
            UserAuthInfo fromUser = (UserAuthInfo)fromUserRsp.getData();
            UserAuthInfo toUser = (UserAuthInfo)toUserRsp.getData();
            if (UserTypeField.COMP_USER.getShotCode().equals(message.getFromType())) {
                if (fromUser != null) {
                    document.setUserSource(String.valueOf(fromUser.getUserSource()));
                    document.setCsName(fromUser.getUserName());
                    document.setCsPhone(fromUser.getCallNum());
                    document.setCsNick(fromUser.getNickName());
                    document.setProvince(fromUser.getProvince());
                    document.setCity(fromUser.getCity());
                }
                if (toUser != null) {
                    document.setUserName(toUser.getUserName());
                    document.setUserPhone(toUser.getCallNum());
                    document.setUserNick(toUser.getNickName());
                }
            } else {
                if (fromUser != null) {
                    document.setUserName(fromUser.getUserName());
                    document.setUserPhone(fromUser.getCallNum());
                    document.setUserNick(fromUser.getNickName());
                }
                if (toUser != null) {
                    document.setUserSource(String.valueOf(toUser.getUserSource()));
                    document.setCsName(toUser.getUserName());
                    document.setCsPhone(toUser.getCallNum());
                    document.setCsNick(toUser.getNickName());
                    document.setProvince(toUser.getProvince());
                    document.setCity(toUser.getCity());
                }
            }
            String c2cKey = NiccCommonUtil.getC2cChatKey((String)message.getFromNo(), (String)message.getToNo());
            document.setC2cKey(c2cKey);
            this.imMsgParseHelper.fillImInfo(document);
            documents.add(document);
        }
        return BaseRspUtils.createSuccessRspList(documents, (long)page.getTotal());
    }
}

