/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.imes.controller;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.api.ImMessageEsApi;
import com.tydic.nicc.common.bo.im.es.ImMessageEsDocQueryReqBO;
import com.tydic.nicc.common.bo.rocketmq.SessionIndexContext;
import com.tydic.nicc.common.bo.session.GetUserSessionListBO;
import com.tydic.nicc.common.bo.session.GetUserSessionListReqBO;
import com.tydic.nicc.common.eums.im.MsgChatType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.ImMessageLuaCacheHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.imes.api.ChatUserSessionIndexApi;
import com.tydic.nicc.imes.api.bo.BatchSyncMessageReqBO;
import com.tydic.nicc.imes.api.bo.ChatSessionIndexQueryReqBO;
import com.tydic.nicc.imes.api.bo.ImMsgDocument;
import com.tydic.nicc.imes.api.bo.UnicomImHistoryQueryReqBO;
import com.tydic.nicc.imes.api.report.ImMessageEsReportApi;
import com.tydic.nicc.imes.busi.EsDataSyncService;
import com.tydic.nicc.imes.mapper.DataWriteMapper;
import com.tydic.nicc.imes.mapper.po.ChatSessionIndex;
import com.tydic.nicc.imes.mapper.po.ChatSessionIndexQueryCondition;
import com.tydic.nicc.imes.service.ChatUserSessionIndexServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nicc-esdata"})
public class EsMessageController {
    private static final Logger log = LoggerFactory.getLogger(EsMessageController.class);
    @Resource
    private ImMessageEsApi imMessageEsApi;
    @Resource
    private ImMessageEsReportApi imMessageEsReportApi;
    @Resource
    private ImMessageLuaCacheHelper imMessageLuaCacheHelper;
    @Resource
    private EsDataSyncService esDataSyncService;
    @Resource
    private ChatUserSessionIndexApi chatUserSessionIndexApi;
    @Resource
    private DataWriteMapper dataWriteMapper;

    @GetMapping(value={"/user/cache/clear"})
    public Rsp userCacheClear() {
        int size = ChatUserSessionIndexServiceImpl.userMap.size();
        ChatUserSessionIndexServiceImpl.userMap.clear();
        return BaseRspUtils.createSuccessRsp((Object)size);
    }

    @PostMapping(value={"/chat/session/sync"})
    public Rsp chatSessionSync(@RequestBody ChatSessionIndexQueryReqBO queryReqBO) {
        Date startTime = queryReqBO.getStartTime();
        Date endTime = queryReqBO.getEndTime();
        int limit = 5000;
        int page = 1;
        int total = 0;
        while (true) {
            List<ChatSessionIndex> sessionIndexs = this.getSessionIdces(startTime, endTime, page++, limit);
            log.info("\u5904\u7406\u4f1a\u8bdd\u7d22\u5f15-\u5f00\u59cb:page = {},total = {}", (Object)page, (Object)sessionIndexs.size());
            if (sessionIndexs.isEmpty()) break;
            if (sessionIndexs.size() != limit) {
                this.processChatSessionIndex(sessionIndexs);
                total += sessionIndexs.size();
                break;
            }
            new Thread(() -> this.processChatSessionIndex(sessionIndexs.subList(0, 1000))).start();
            new Thread(() -> this.processChatSessionIndex(sessionIndexs.subList(1000, 2000))).start();
            new Thread(() -> this.processChatSessionIndex(sessionIndexs.subList(2000, 3000))).start();
            new Thread(() -> this.processChatSessionIndex(sessionIndexs.subList(3000, 4000))).start();
            this.processChatSessionIndex(sessionIndexs.subList(4000, 5000));
            total += sessionIndexs.size();
        }
        return BaseRspUtils.createSuccessRsp((Object)total);
    }

    protected List<ChatSessionIndex> getSessionIdces(Date startTime, Date endTime, int page, int limit) {
        ChatSessionIndexQueryCondition condition = new ChatSessionIndexQueryCondition();
        condition.setStartTime(startTime);
        condition.setEndTime(endTime);
        Page resultPage = PageHelper.startPage((int)page, (int)limit);
        this.dataWriteMapper.selectChatSessionIndex(condition);
        log.info("\u5904\u7406\u4f1a\u8bdd\u7d22\u5f15-\u67e5\u8be2\u7ed3\u675f:page = {},size = {},total = {}", new Object[]{page, resultPage.getResult().size(), resultPage.getTotal()});
        return resultPage.getResult();
    }

    protected void processChatSessionIndex(List<ChatSessionIndex> chatSessionIndices) {
        String id = IdWorker.nextAutoIdStr();
        log.info("\u5904\u7406\u4f1a\u8bdd\u7d22\u5f15-\u5f00\u59cb[{}]:{}", (Object)id, (Object)chatSessionIndices.size());
        List lists = Lists.partition(chatSessionIndices, (int)100);
        for (List list : lists) {
            ArrayList contextList = Lists.newArrayList();
            NiccCommonUtil.copyList((List)list, (List)contextList, SessionIndexContext.class);
            long start = System.currentTimeMillis();
            this.chatUserSessionIndexApi.updateChatIndexBatch((List)contextList);
            log.info("\u5904\u7406\u4f1a\u8bdd\u7d22\u5f15-\u6279\u91cf\u64cd\u4f5c[{}]:{}|{} ms", new Object[]{id, list.size(), System.currentTimeMillis() - start});
        }
    }

    @PostMapping(value={"/chat/list"})
    public RspList<GetUserSessionListBO> getChatUserList(@RequestBody ChatSessionIndexQueryReqBO reqBO) {
        return this.chatUserSessionIndexApi.getChatUserList(reqBO);
    }

    @PostMapping(value={"/user/friends"})
    public RspList<GetUserSessionListBO> getSessionListFromEsSearch(@RequestBody GetUserSessionListReqBO reqBO) {
        return this.imMessageEsApi.getSessionListFromEsSearch(reqBO);
    }

    @PostMapping(value={"/user/friends/all"})
    public RspList<GetUserSessionListBO> getUnicomHistoryFriends(@RequestBody UnicomImHistoryQueryReqBO reqBO) {
        return this.imMessageEsReportApi.getUnicomHistoryFriends(reqBO);
    }

    @PostMapping(value={"/c2b/message/sync"})
    public Rsp batchSyncMessage(@RequestBody BatchSyncMessageReqBO reqBO) {
        return this.esDataSyncService.batchSyncMessage(reqBO);
    }

    @PostMapping(value={"/c2b/message/docs"})
    public RspList<ImMsgDocument> getMessageDocuments(@RequestBody BatchSyncMessageReqBO reqBO) {
        return this.esDataSyncService.getMessageDocuments(reqBO);
    }

    @PostMapping(value={"/c2b/history/message"})
    public RspList getC2bHistoryMessages(@RequestBody ImMessageEsDocQueryReqBO reqBO) {
        return this.imMessageEsApi.getC2bHistoryMessages(reqBO);
    }

    @PostMapping(value={"/c2b/unread/count"})
    public Rsp getUnreadCount(@RequestBody ImMessageEsDocQueryReqBO reqBO) {
        long count = this.imMessageLuaCacheHelper.countUnread(reqBO.getFromNo(), reqBO.getToNo(), MsgChatType.C2B.getCode());
        return BaseRspUtils.createSuccessRsp((Object)count);
    }
}

