/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.imes.service;

import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.imes.api.ImUserInfoApi;
import com.tydic.nicc.imes.api.bo.ImUserInfoBO;
import com.tydic.nicc.imes.api.bo.ImUserInfoDocument;
import com.tydic.nicc.imes.api.es.EsRsp;
import com.tydic.nicc.imes.api.es.QueryCondition;
import com.tydic.nicc.imes.config.NiccImData2ESProperties;
import com.tydic.nicc.imes.utils.BeanUtil;
import com.tydic.nicc.imes.utils.EsDocumentHelper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.frameworkset.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImUserInfoServiceImpl
implements ImUserInfoApi {
    private static final Logger log = LoggerFactory.getLogger(ImUserInfoServiceImpl.class);
    @Resource
    EsDocumentHelper<ImUserInfoDocument> esDocumentHelper;
    @Resource
    NiccImData2ESProperties niccImData2ESProperties;

    public RspList query(ImUserInfoBO bo) {
        if (ObjectUtils.isEmpty((Object)bo.getStartDate())) {
            bo.setStartDate(DateTimeUtil.getTimeShortString((Date)DateTimeUtil.DateAddYear((int)-2), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (ObjectUtils.isEmpty((Object)bo.getEndDate())) {
            bo.setEndDate(DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        Map param = NiccCommonUtil.beanToMap((Object)bo);
        QueryCondition condition = QueryCondition.builder().propName("searchImUserInfoByCondition").mapperPath("esmapper/ESImUserInfoMapper.xml").esIndexName(this.niccImData2ESProperties.getIdxImUserInfo()).pageNo(bo.getPage()).pageSize(bo.getLimit()).params(param).searchAll(false).build();
        EsRsp esRsp = this.esDocumentHelper.searchDocs(condition, ImUserInfoDocument.class);
        log.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f \u7ed3\u679c\uff1a{} \u6761", (Object)esRsp.getTotal());
        return BaseRspUtils.createSuccessRspList((List)esRsp.getRow());
    }

    public void add(ImUserInfoDocument doc) {
        log.info("\u68c0\u67e5\u7d22\u5f15\u4e2d\u7684\u7528\u6237\u4fe1\u606f\uff1auserId={}", (Object)doc.getUserId());
        ImUserInfoDocument oldDoc = this.esDocumentHelper.getDocument(this.niccImData2ESProperties.getIdxImUserInfo(), doc.getUserId(), ImUserInfoDocument.class);
        if (ObjectUtils.isEmpty((Object)oldDoc)) {
            log.info("\u7d22\u5f15\u4e2d\u4e0d\u5b58\u5728\u8be5\u7528\u6237\u4fe1\u606f\uff0c\u76f4\u63a5\u5199\u5165...");
            this.esDocumentHelper.add(doc, this.niccImData2ESProperties.getIdxImUserInfo());
            return;
        }
        log.info("\u7d22\u5f15\u4e2d\u5df2\u5b58\u5728\u8be5\u7528\u6237\u4fe1\u606f\uff0c\u8fdb\u884c\u66f4\u65b0\u540e\u5199\u5165...");
        BeanUtil.copyPropertiesIgnoreNull(doc, oldDoc);
        this.esDocumentHelper.add(oldDoc, this.niccImData2ESProperties.getIdxImUserInfo());
    }

    public void addBatch(List<ImUserInfoDocument> list) {
        log.info("\u6279\u91cf\u6dfb\u52a0\u7528\u6237\u4fe1\u606f {} \u6761\u5230es", (Object)list.size());
    }
}

