/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.ability;

import com.tydic.nicc.dc.bo.user.BladeUserBO;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.ability.CallAbilityService;
import com.tydic.nicc.ocs.bo.SessionBO;
import com.tydic.nicc.ocs.busi.SessionInfoService;
import com.tydic.nicc.ocs.handler.bo.UserConnectInfoBO;
import com.tydic.nicc.ocs.handler.bo.UserJoinInfoBO;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CallAbilityServiceImpl
implements CallAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CallAbilityServiceImpl.class);
    @Autowired
    private SessionInfoService sessionInfoService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;

    public void userLinked(UserJoinInfoBO userJoinInfo) {
        this.sessionInfoService.linkedCreateSession(userJoinInfo);
    }

    public void userOut(SessionBO session) {
        this.sessionInfoService.userOutSession(session);
    }

    public void changeSession(SessionBO session) {
        this.sessionInfoService.changeSession(session);
    }

    public void switchJobChangeSession(SessionBO session) {
        this.sessionInfoService.switchJobChangeSession(session);
    }

    public void agentLogin(SessionBO session) {
        if (null == session) {
            return;
        }
        this.sessionInfoService.loginSession(session);
    }

    public void agentLogout(SessionBO session) {
        if (null == session) {
            return;
        }
        this.sessionInfoService.agentOut(session);
    }

    public void userConnect(UserConnectInfoBO userConnectInfo) {
        BladeUserBO bladeUserBO;
        if (null == userConnectInfo) {
            return;
        }
        String agentDn = userConnectInfo.getAgentId();
        String userId = userConnectInfo.getUserId();
        if (StringUtils.isEmpty((Object)agentDn)) {
            return;
        }
        if (StringUtils.isEmpty((Object)userId) && null != (bladeUserBO = this.bladeUserInterService.queryUserInfoByAgentDn(agentDn)) && !StringUtils.isEmpty((Object)bladeUserBO.getId())) {
            userId = String.valueOf(bladeUserBO.getId());
        }
        if (StringUtils.isEmpty((Object)userId)) {
            throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u7528\u6237id");
        }
        this.sessionInfoService.userConnect(agentDn, userId);
    }
}

