/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.bo.CallRecordBO;
import com.tydic.nicc.ocs.busi.CallRecordService;
import com.tydic.nicc.ocs.handler.bo.SysEnvenName;
import com.tydic.nicc.ocs.mapper.CalledCallRecordDAO;
import com.tydic.nicc.ocs.mapper.CallingCallRecordDAO;
import com.tydic.nicc.ocs.mapper.po.CalledCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.CallingCallRecordPO;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CallRecordServiceImpl
implements CallRecordService {
    private static final Logger log = LoggerFactory.getLogger(CallRecordServiceImpl.class);
    @Resource
    private CalledCallRecordDAO calledCallRecordDAO;
    @Resource
    private CallingCallRecordDAO callingCallRecordDAO;
    @Value(value="${submeterNumber:1}")
    private int submeterNumber;
    @Value(value="${IS_INSERT_CALLING:false}")
    private boolean isInsertCalling;
    @Value(value="${IS_INSERT_CALLED:false}")
    private boolean isInsertCalled;
    private static final String OB_CALLED_CALL_RECORD = "ob_called_call_record_";
    private static final String OB_CALLING_CALL_RECORD = "ob_calling_call_record_";
    private static final String placeholder = "00";

    @Override
    public void modifyCallRecord(CallRecordBO callRecord) {
        String callingParty = callRecord.getDeviceDn();
        String calledParty = callRecord.getOriDnis();
        CalledCallRecordPO calledRecord = null;
        if (this.isInsertCalled && StringUtils.isNotBlank((CharSequence)calledParty)) {
            String calledTableName = this.getTableName(OB_CALLED_CALL_RECORD, calledParty);
            calledRecord = this.calledCallRecordDAO.qryCallRecordByCallID(calledTableName, String.valueOf(callRecord.getCallId()));
            if (null == calledRecord) {
                calledRecord = new CalledCallRecordPO();
                calledRecord.setCalled(calledParty);
                calledRecord.setCalling(callingParty);
                calledRecord.setState(callRecord.getState());
                calledRecord.setStartTime(callRecord.getStartTime());
                calledRecord.setCallId(String.valueOf(callRecord.getCallId()));
                calledRecord.setCallType(String.valueOf(callRecord.getCallType()));
                this.calledCallRecordDAO.insert(calledTableName, calledRecord);
            } else {
                String eventName = callRecord.getEventName();
                if (SysEnvenName.NEED_DEAL.OffHook.name().equals(eventName)) {
                    calledRecord.setStartTime(callRecord.getStartTime());
                }
                if ((SysEnvenName.NEED_DEAL.Dialing.name().equals(eventName) || SysEnvenName.NEED_DEAL.Offering.name().equals(eventName)) && StringUtils.isBlank((CharSequence)calledRecord.getRingTime())) {
                    calledRecord.setRingTime(callRecord.getStartTime());
                }
                if (SysEnvenName.NEED_DEAL.Dialing.name().equals(eventName)) {
                    log.info("Dialing : {}", (Object)JSONObject.toJSONString((Object)callRecord));
                }
                if (SysEnvenName.NEED_DEAL.Offering.name().equals(eventName)) {
                    log.info("Offering : {}", (Object)JSONObject.toJSONString((Object)callRecord));
                }
                if (SysEnvenName.NEED_DEAL.Connected.name().equals(eventName)) {
                    calledRecord.setContactTime(callRecord.getStartTime());
                    calledRecord.setIsConn("1");
                    calledRecord.setObsIsConn("1");
                }
                if (SysEnvenName.NEED_DEAL.Recording.name().equals(eventName)) {
                    calledRecord.setRecordFile(callRecord.getFileName());
                }
                if (SysEnvenName.NEED_DEAL.Released.name().equals(eventName)) {
                    calledRecord.setEndTime(callRecord.getStartTime());
                }
                this.calledCallRecordDAO.updateByPrimaryKeySelective(calledTableName, calledRecord);
            }
        }
        if (this.isInsertCalling && StringUtils.isNotBlank((CharSequence)callingParty)) {
            String tableName = this.getTableName(OB_CALLING_CALL_RECORD, callingParty);
            CallingCallRecordPO record = this.callingCallRecordDAO.qryCallRecordByCallID(tableName, String.valueOf(callRecord.getCallId()));
            if (null == record) {
                record = new CallingCallRecordPO();
                record.setStartTime(calledRecord != null ? calledRecord.getStartTime() : callRecord.getStartTime());
                record.setCalled(calledParty);
                record.setCalling(callingParty);
                record.setState(callRecord.getState());
                record.setCallId(String.valueOf(callRecord.getCallId()));
                record.setCallType(String.valueOf(callRecord.getCallType()));
                this.calledCallRecordDAO.insert(tableName, calledRecord);
            } else {
                String eventName = callRecord.getEventName();
                if (SysEnvenName.NEED_DEAL.OffHook.name().equals(eventName)) {
                    record.setStartTime(callRecord.getStartTime());
                }
                if ((SysEnvenName.NEED_DEAL.Dialing.name().equals(eventName) || SysEnvenName.NEED_DEAL.Offering.name().equals(eventName)) && StringUtils.isBlank((CharSequence)calledRecord.getRingTime())) {
                    record.setRingTime(callRecord.getStartTime());
                }
                if (SysEnvenName.NEED_DEAL.Dialing.name().equals(eventName)) {
                    log.info("Dialing : {}", (Object)JSONObject.toJSONString((Object)callRecord));
                }
                if (SysEnvenName.NEED_DEAL.Offering.name().equals(eventName)) {
                    log.info("Offering : {}", (Object)JSONObject.toJSONString((Object)callRecord));
                }
                if (SysEnvenName.NEED_DEAL.Connected.name().equals(eventName)) {
                    record.setContactTime(callRecord.getStartTime());
                    record.setIsConn("1");
                    record.setObsIsConn("1");
                }
                if (SysEnvenName.NEED_DEAL.Recording.name().equals(eventName)) {
                    record.setRecordFile(callRecord.getFileName());
                }
                if (SysEnvenName.NEED_DEAL.Released.name().equals(eventName)) {
                    record.setEndTime(callRecord.getStartTime());
                }
                this.callingCallRecordDAO.updateByPrimaryKeySelective(tableName, record);
            }
        }
    }

    private String getTableName(String tablePrdfix, String party) {
        int hashCode = party.hashCode();
        int ii = hashCode % this.submeterNumber;
        String suffix = placeholder + ii;
        suffix = suffix.substring(suffix.length() - placeholder.length(), suffix.length());
        return tablePrdfix + suffix;
    }
}

