/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.busi.impl;

import com.tydic.nicc.ocs.bo.CustCalledRecordBO;
import com.tydic.nicc.ocs.busi.CustCalledRecordService;
import com.tydic.nicc.ocs.cache.LocalCache;
import com.tydic.nicc.ocs.mapper.CalledRecordDAO;
import com.tydic.nicc.ocs.mapper.po.CalledRecordPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CustCalledRecordServiceImpl
implements CustCalledRecordService {
    private static final Logger log = LoggerFactory.getLogger(CustCalledRecordServiceImpl.class);
    @Autowired
    CalledRecordDAO calledRecordDAO;

    @Override
    public List<CustCalledRecordBO> getCustCalledRecord(String calledNo, Integer nDay) {
        ArrayList<CustCalledRecordBO> res = new ArrayList<CustCalledRecordBO>();
        String tableName = LocalCache.getCallRecordTableNameByModelNO(calledNo);
        if (StringUtils.isEmpty((Object)tableName)) {
            return res;
        }
        List calledList = this.calledRecordDAO.selectRecordByCallNo(calledNo, nDay, tableName);
        if (calledList == null) {
            return res;
        }
        for (CalledRecordPO called : calledList) {
            CustCalledRecordBO recordBO = new CustCalledRecordBO();
            BeanUtils.copyProperties((Object)called, (Object)recordBO);
            res.add(recordBO);
        }
        return res;
    }
}

