/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.ocs.bo.QueryUserLinkProductReqBO;
import com.tydic.nicc.ocs.busi.EventBusiService;
import com.tydic.nicc.ocs.cache.LocalCache;
import com.tydic.nicc.ocs.cache.WsCache;
import com.tydic.nicc.ocs.constant.CallRecordConstant;
import com.tydic.nicc.ocs.handler.bo.EventBO;
import com.tydic.nicc.ocs.kafka.producer.KafkaProducer;
import com.tydic.nicc.ocs.mapper.EventRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCalledRecordDAO;
import com.tydic.nicc.ocs.mapper.ObDataTargetDAO;
import com.tydic.nicc.ocs.mapper.po.EventRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObCalledRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObDataTargetPO;
import com.tydic.nicc.ocs.service.TaskQueryAboutService;
import com.tydic.nicc.ocs.utils.SessionMap;
import com.tydic.nicc.ocs.utils.TaskInfoUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EventBusiServiceImpl
implements EventBusiService {
    private static final Logger log = LoggerFactory.getLogger(EventBusiServiceImpl.class);
    @Autowired
    EventRecordDAO eventRecordDAO;
    @Resource
    private ObDataTargetDAO obDataTargetDAO;
    @Resource
    private ObCallRecordDAO obCallRecordDAO;
    @Resource
    private ObCalledRecordDAO obCalledRecordDAO;
    @Resource
    private TaskQueryAboutService taskQueryAboutService;
    @Resource
    private KafkaProducer kafkaProducer;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    private static final String DIALING_EVENT_VALUE = "DialingEvent";
    private static final String CONNECTED_EVENT_VALUE = "ConnectedEvent";
    private static final String RELEASED_EVENT_VALUE = "ReleasedEvent";
    private static final String RECORD_END_EVENT_VALUE = "RecordEndEvent";
    @Value(value="${replace.target:/data/hisan/record}")
    private String target;
    @Value(value="${replace.replacement:http://192.168.10.182:8080}")
    private String replacement;
    Map<String, Object> map = new HashMap<String, Object>();
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource
    private WsCache wsCache;

    @Override
    public void saveEvent(List<EventBO> events) {
        ArrayList<EventBO> insertEvents = new ArrayList<EventBO>();
        for (EventBO event : events) {
            String ctiSessionID = event.getSessionId();
            Long eventID = event.getEventId();
            if (eventID == null) {
                insertEvents.add(event);
                continue;
            }
            EventRecordPO eventRecord = this.eventRecordDAO.selectBy(event.getEventRecordId(), ctiSessionID, eventID);
            if (eventRecord != null) {
                event.setEventRecordId(eventRecord.getEventRecordId());
                continue;
            }
            insertEvents.add(event);
        }
        for (EventBO event : insertEvents) {
            this.insertEvent(event);
        }
    }

    @Override
    public boolean checkEventDealed(EventBO event) {
        EventRecordPO eventRecord = this.eventRecordDAO.selectBy(event.getEventRecordId(), event.getSessionId(), event.getEventId());
        if (eventRecord == null) {
            this.insertEvent(event);
            return false;
        }
        return !"0".equals(eventRecord.getEventStatus());
    }

    @Override
    public void upEventStatus(String status, EventBO event) {
        EventRecordPO record = new EventRecordPO();
        record.setEventId(event.getEventId());
        record.setCtiSessionId(event.getSessionId());
        record.setEventStatus(status != null ? status : "-1");
        record.setEventRecordId(event.getEventRecordId());
        this.eventRecordDAO.upEventStatus(record);
    }

    private void insertEvent(EventBO event) {
        EventRecordPO record = new EventRecordPO();
        BeanUtils.copyProperties((Object)event, (Object)record);
        record.setResonCode(record.getResonCode() == null ? event.getReasonCode() : record.getResonCode());
        record.setRecordFile(StringUtils.isBlank((CharSequence)record.getRecordFile()) ? event.getFileName() : record.getRecordFile());
        record.setRecordDuration(record.getRecordDuration() == null ? event.getFileDuration() : record.getRecordDuration());
        record.setCtiSessionId(event.getSessionId());
        this.eventRecordDAO.insertSelective(record);
        event.setEventRecordId(record.getEventRecordId());
    }

    @Override
    public void gainPreviewRecord(EventBO event) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u9884\u89c8\u5f0f\u4efb\u52a1\u5916\u547c\u8bb0\u5f55\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)event));
        try {
            ObCallRecordPO record;
            String ucId = event.getUcid();
            if (StringUtils.isEmpty((CharSequence)ucId)) {
                log.info("ucId\u4e3a\u7a7a");
                return;
            }
            String headKey = event.getHeadKey();
            if (StringUtils.isEmpty((CharSequence)headKey)) {
                log.info("\u5f53\u524ducId\u4e3a[{}],\u79df\u6237\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u505a\u5904\u7406", (Object)ucId);
                return;
            }
            String headValue = event.getHeadValue();
            if (StringUtils.isEmpty((CharSequence)headValue)) {
                log.info("\u5f53\u524ducId\u4e3a[{}],\u4efb\u52a1ID\u4e3a\u7a7a\uff0c\u4e0d\u505a\u5904\u7406", (Object)ucId);
                return;
            }
            BladeTenantBO tenantBO = (BladeTenantBO)this.map.get(headKey);
            if (tenantBO == null) {
                tenantBO = this.getTenantInfo(headKey);
                if (tenantBO == null) {
                    log.info("\u5f53\u524ducId\u4e3a[{}],\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f", (Object)ucId);
                    return;
                }
                this.map.put(headKey, tenantBO);
            }
            String tableName = LocalCache.getCallRecordTableNameByModelNO(event.getOriDnis());
            if (SessionMap.EVENT_CLASS.checkEventClass(event.getEventClass()).booleanValue()) {
                String jobNumber;
                record = new ObCallRecordPO();
                record.setTenantOtherName(tenantBO.getTenantOtherName());
                record.setUcId(ucId);
                record.setTenantId(tenantBO.getTenantId());
                record.setTaskId(headValue);
                record.setIsTaskData(CallRecordConstant.IS_TASK_DATA_1);
                this.getRecordPO(event, record);
                if (SessionMap.EVENT_CLASS.ConnectedEvent.name().equals(event.getEventClass())) {
                    record.setObsIsConn("1");
                    record.setRingTime(this.format.format(event.getStartTime()));
                }
                if (SessionMap.EVENT_CLASS.RecordEndEvent.name().equals(event.getEventClass())) {
                    record.setEndTime(this.format.format(event.getStartTime()));
                    Long contactLength = 0L;
                    if (ObjectUtil.isNotNull((Object)event.getRecordDuration())) {
                        contactLength = Math.round((double)event.getRecordDuration().intValue() / 1000.0);
                    }
                    record.setContactLength(contactLength.toString());
                    record.setRecordFile(event.getRecordFile().replace(this.target, this.replacement));
                }
                String string = jobNumber = StringUtils.isEmpty((CharSequence)record.getJobNumber()) ? event.getDeviceDn() : record.getJobNumber();
                if (!StringUtils.isEmpty((CharSequence)jobNumber) && StringUtils.isEmpty((CharSequence)record.getUserId())) {
                    try {
                        record.setUserId(this.wsCache.getAgentDnBandUser(record.getJobNumber()));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                log.info("\u5f53\u524ducId\u4e3a[{}],\u4e8b\u4ef6\u72b6\u6001[{}]\u4e0d\u5728\u5904\u7406\u8303\u56f4\u5185", (Object)ucId, (Object)event.getEventClass());
                return;
            }
            record.setTenantOtherName(tenantBO.getTenantOtherName());
            log.info("\u5f53\u524d\u4e8b\u4ef6\u7c7b\u578b[{}], \u4fee\u6539\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)event.getEventClass(), (Object)JSONObject.toJSONString((Object)record));
            this.saveRecord(record, 0);
            this.insertObCalledRecord(event, tableName);
            this.sendKafkaMessage(event.getEventClass(), event.getUcid(), tenantBO.getTenantOtherName(), tenantBO.getTenantId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveRecord(ObCallRecordPO record, int i) {
        if (i > 3) {
            log.error("\u5f53\u524ducId\u4e3a[{}],\u6267\u884c\u66f4\u65b0\u5916\u547c\u8bb0\u5f55{}\u6b21\u5931\u8d25", (Object)record.getUcId(), (Object)i);
            return;
        }
        if (this.obCallRecordDAO.updateByUcid(record) < 1) {
            try {
                this.obCallRecordDAO.insertSelective(record);
            }
            catch (Exception e) {
                this.saveRecord(record, i++);
            }
        }
    }

    private void insertObCalledRecord(EventBO event, String tableName) {
        ObCalledRecordPO calledRecord = this.getCalledRecord(event);
        if (CONNECTED_EVENT_VALUE.equals(event.getEventClass())) {
            calledRecord.setObsIsConn("1");
        }
        calledRecord.setTableName(tableName);
        if (this.obCalledRecordDAO.updateByUcid(calledRecord) < 1) {
            try {
                this.obCalledRecordDAO.insertSelective(calledRecord);
            }
            catch (Exception e) {
                this.obCalledRecordDAO.updateByUcid(calledRecord);
            }
        }
    }

    @Deprecated
    public void gainPreviewRecordOld(EventBO event) {
        block16: {
            log.info("\u8fdb\u5165\u83b7\u53d6\u9884\u89c8\u5f0f\u4efb\u52a1\u5916\u547c\u8bb0\u5f55\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)event));
            try {
                String ucId = event.getUcid();
                if (StringUtils.isEmpty((CharSequence)ucId)) {
                    log.debug("ucId\u4e3a\u7a7a");
                    return;
                }
                String headKey = event.getHeadKey();
                if (StringUtils.isEmpty((CharSequence)headKey)) {
                    log.debug("\u5f53\u524ducId\u4e3a[{}],\u79df\u6237\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u505a\u5904\u7406", (Object)ucId);
                    return;
                }
                String headValue = event.getHeadValue();
                if (StringUtils.isEmpty((CharSequence)headValue)) {
                    log.debug("\u5f53\u524ducId\u4e3a[{}],\u4efb\u52a1ID\u4e3a\u7a7a\uff0c\u4e0d\u505a\u5904\u7406", (Object)ucId);
                    return;
                }
                BladeTenantBO tenantBO = (BladeTenantBO)this.map.get(headKey);
                if (tenantBO == null) {
                    tenantBO = this.getTenantInfo(headKey);
                    if (tenantBO == null) {
                        log.debug("\u5f53\u524ducId\u4e3a[{}],\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f", (Object)ucId);
                        return;
                    }
                    this.map.put(headKey, tenantBO);
                }
                ObCallRecordPO recordPO = new ObCallRecordPO();
                recordPO.setTenantOtherName(tenantBO.getTenantOtherName());
                recordPO.setUcId(ucId);
                recordPO.setTenantId(tenantBO.getTenantId());
                ObCallRecordPO record = this.obCallRecordDAO.selectByUcId(recordPO);
                log.info("\u5f53\u524ducId\u4e3a[{}], \u6839\u636eucId\u67e5\u8be2\u5916\u547c\u8bb0\u5f55\u8868Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)ucId, (Object)JSONObject.toJSONString((Object)record));
                String tableName = LocalCache.getCallRecordTableNameByModelNO(event.getOriDnis());
                ObCalledRecordPO calledRecordPO = new ObCalledRecordPO();
                calledRecordPO.setTableName(tableName);
                calledRecordPO.setUcId(event.getUcid());
                calledRecordPO.setTenantId(headKey);
                ObCalledRecordPO obCalledRecordPO = this.obCalledRecordDAO.selectByUcId(calledRecordPO);
                log.info("\u5f53\u524ducId[{}]\uff0c \u6839\u636eucId\u67e5\u8be2\u88ab\u53eb\u8bb0\u5f55\u8868Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)event.getUcid(), (Object)obCalledRecordPO);
                if (SessionMap.EVENT_CLASS.checkEventClass(event.getEventClass()).booleanValue()) {
                    String jobNumber;
                    if (record == null) {
                        log.info("\u672a\u67e5\u8be2\u5230\u5916\u547c\u8bb0\u5f55\uff0c\u65b0\u589e");
                        recordPO = this.getRecordPO(event, recordPO);
                        ObDataTargetPO obDataTargetPO = new ObDataTargetPO();
                        obDataTargetPO.setTenantOtherName(tenantBO.getTenantOtherName());
                        obDataTargetPO.setTenantId(tenantBO.getTenantId());
                        obDataTargetPO.setTaskId(headValue);
                        obDataTargetPO.setMobileNo(event.getCalledParty());
                        ObDataTargetPO dataTargetPO = this.obDataTargetDAO.selectByMobileNo(obDataTargetPO);
                        log.info("\u83b7\u53d6\u4efb\u52a1\u6570\u636eID, \u5f53\u524d\u88ab\u53eb\u53f7\u7801[{}], Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)event.getOriDnis(), (Object)JSONObject.toJSONString((Object)dataTargetPO));
                        if (dataTargetPO != null) {
                            recordPO.setDataId(dataTargetPO.getDataId());
                        }
                        recordPO.setTaskId(headValue);
                        recordPO.setIsTaskData(CallRecordConstant.IS_TASK_DATA_1);
                        log.info("\u5f53\u524d\u4e8b\u4ef6\u7c7b\u578b[{}], \u65b0\u589e\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)event.getEventClass(), (Object)JSONObject.toJSONString((Object)recordPO));
                        this.obCallRecordDAO.insertSelective(recordPO);
                        this.insertObCalledRecord(obCalledRecordPO, event, tableName);
                        break block16;
                    }
                    log.info("\u67e5\u8be2\u5230\u5916\u547c\u8bb0\u5f55\uff0c \u4fee\u6539");
                    if (CONNECTED_EVENT_VALUE.equals(event.getEventClass())) {
                        record.setObsIsConn("1");
                        record.setRingTime(this.format.format(event.getStartTime()));
                    }
                    if (RECORD_END_EVENT_VALUE.equals(event.getEventClass())) {
                        record.setEndTime(this.format.format(event.getStartTime()));
                        Long contactLength = 0L;
                        if ("1".equals(record.getIsConn()) && "1".equals(record.getObsIsConn())) {
                            contactLength = (event.getStartTime().getTime() - this.format.parse(record.getStartTime()).getTime()) / 1000L;
                        }
                        record.setContactLength(contactLength.toString());
                        record.setRecordFile(event.getRecordFile().replace(this.target, this.replacement));
                    }
                    String string = jobNumber = StringUtils.isEmpty((CharSequence)record.getJobNumber()) ? event.getDeviceDn() : record.getJobNumber();
                    if (!StringUtils.isEmpty((CharSequence)jobNumber) && StringUtils.isEmpty((CharSequence)record.getUserId())) {
                        try {
                            record.setUserId(this.wsCache.getAgentDnBandUser(record.getJobNumber()));
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    record.setTenantOtherName(tenantBO.getTenantOtherName());
                    log.info("\u5f53\u524d\u4e8b\u4ef6\u7c7b\u578b[{}], \u4fee\u6539\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)event.getEventClass(), (Object)JSONObject.toJSONString((Object)record));
                    this.obCallRecordDAO.updateByPrimaryKeySelective(record);
                    this.insertObCalledRecord(obCalledRecordPO, event, tableName);
                    this.sendKafkaMessage(event.getEventClass(), event.getUcid(), tenantBO.getTenantOtherName(), tenantBO.getTenantId());
                    break block16;
                }
                log.info("\u5f53\u524ducId[{}],{}\u4e8b\u4ef6\u72b6\u6001\u4e0d\u5728\u5904\u7406\u8303\u56f4\u5185", (Object)ucId, (Object)event.getEventClass());
                return;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sendKafkaMessage(String eventClass, String ucId, String tenantOtherName, String tenantId) {
        if (RECORD_END_EVENT_VALUE.equals(eventClass)) {
            log.info("\u5f53\u524ducId[{}],\u4e8b\u4ef6{}\uff0c\u53d1\u9001kafka\u6d88\u606f", (Object)ucId, (Object)eventClass);
            ObCallRecordPO recordPO = new ObCallRecordPO();
            recordPO.setUcId(ucId);
            recordPO.setTenantOtherName(tenantOtherName);
            recordPO.setTenantId(tenantId);
            ObCallRecordPO callRecordPO = this.obCallRecordDAO.selectByUcId(recordPO);
            if (null != callRecordPO) {
                this.kafkaProducer.sendNormalMessage("ob_call_record", JSONObject.toJSONString((Object)callRecordPO));
            }
        } else {
            log.debug("\u5f53\u524ducId[{}],\u4e8b\u4ef6{}\uff0c\u4e0d\u53d1\u9001kafka\u6d88\u606f", (Object)ucId, (Object)eventClass);
        }
    }

    private void insertObCalledRecord(ObCalledRecordPO obCalledRecordPO, EventBO event, String tableName) {
        if (obCalledRecordPO == null) {
            log.info("\u672a\u67e5\u8be2\u5230\u88ab\u53eb\u8bb0\u5f55\uff0c\u65b0\u589e");
            ObCalledRecordPO calledRecord = this.getCalledRecord(event);
            log.info("\u63d2\u5165\u88ab\u53eb\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)calledRecord));
            this.obCalledRecordDAO.insertSelective(calledRecord);
        } else {
            log.info("\u67e5\u8be2\u5230\u88ab\u53eb\u8bb0\u5f55\uff0c\u4fee\u6539");
            if (CONNECTED_EVENT_VALUE.equals(event.getEventClass())) {
                obCalledRecordPO.setObsIsConn("1");
            }
            obCalledRecordPO.setTableName(tableName);
            log.info("\u4fee\u6539\u88ab\u53eb\u8bb0\u5f55\u8868Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCalledRecordPO));
            this.obCalledRecordDAO.updateByPrimaryKeySelective(obCalledRecordPO);
        }
    }

    private ObCallRecordPO getRecordPO(EventBO eventBO, ObCallRecordPO record) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(eventBO.getStartTime());
        record.setRecordId(TaskInfoUtil.get16UUID());
        record.setObYear(calendar.get(1) + "");
        record.setObMonth(calendar.get(2) + 1 + "");
        record.setObDay(calendar.get(5) + "");
        record.setObHour(calendar.get(11) + "");
        record.setJobNumber(eventBO.getDeviceDn());
        record.setCallId(eventBO.getScid());
        record.setCreateTime(this.format.format(new Date()));
        record.setCalling(eventBO.getCallingParty());
        record.setCalled(eventBO.getCalledParty());
        record.setCallType("1");
        if (!StringUtils.isEmpty((CharSequence)record.getJobNumber()) && StringUtils.isEmpty((CharSequence)record.getUserId())) {
            try {
                record.setUserId(this.wsCache.getAgentDnBandUser(record.getJobNumber()));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (DIALING_EVENT_VALUE.equals(eventBO.getEventClass())) {
            record.setIsConn("1");
            record.setStartTime(this.format.format(eventBO.getStartTime()));
            record.setTalkTime(this.format.format(eventBO.getStartTime()));
        } else if (CONNECTED_EVENT_VALUE.equals(eventBO.getEventClass())) {
            record.setObsIsConn("1");
        }
        return record;
    }

    private ObCalledRecordPO getCalledRecord(EventBO eventBO) {
        ObCalledRecordPO calledRecordPO = new ObCalledRecordPO();
        String tableName = LocalCache.getCallRecordTableNameByModelNO(eventBO.getOriDnis());
        log.info("tableName:{}", (Object)tableName);
        calledRecordPO.setTableName(tableName);
        calledRecordPO.setTaskId(eventBO.getHeadValue());
        calledRecordPO.setTenantId(eventBO.getHeadKey());
        calledRecordPO.setCallId(eventBO.getCallId().toString());
        calledRecordPO.setCalling(eventBO.getCallingParty());
        calledRecordPO.setCalled(eventBO.getCalledParty());
        calledRecordPO.setCallType("1");
        calledRecordPO.setCreateTime(new Date());
        calledRecordPO.setUcId(eventBO.getUcid());
        if (DIALING_EVENT_VALUE.equals(eventBO.getEventClass())) {
            calledRecordPO.setIsConn("1");
            calledRecordPO.setCallTime(this.format.format(eventBO.getStartTime()));
        } else if (CONNECTED_EVENT_VALUE.equals(eventBO.getEventClass())) {
            calledRecordPO.setObsIsConn("1");
        }
        return calledRecordPO;
    }

    private BladeTenantBO getTenantInfo(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }

    private String getSuggestProduct(String tenantId, String taskId, String called) {
        String suggestProduct = "";
        QueryUserLinkProductReqBO reqBO = new QueryUserLinkProductReqBO();
        reqBO.setPhone(called);
        reqBO.setTaskId(taskId);
        reqBO.setTenantCode(tenantId);
        RspList rspList = this.taskQueryAboutService.qryUserLinkProduct(reqBO);
        if (!"0000".equals(rspList.getRspCode())) {
            return suggestProduct;
        }
        List rows = rspList.getRows();
        if (null == rows || rows.size() == 0) {
            return suggestProduct;
        }
        ArrayList products = new ArrayList();
        rows.stream().forEach(bo -> products.add(bo.getProductName()));
        suggestProduct = String.join((CharSequence)",", products);
        return suggestProduct;
    }

    public static void main(String[] args) {
        System.out.println(Math.round(209.435));
    }
}

