/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.busi.impl;

import com.tydic.nicc.ocs.bo.SessionBO;
import com.tydic.nicc.ocs.busi.EventBusiService;
import com.tydic.nicc.ocs.busi.SessionInfoService;
import com.tydic.nicc.ocs.cache.WsCache;
import com.tydic.nicc.ocs.handler.bo.EventBO;
import com.tydic.nicc.ocs.handler.bo.UserJoinInfoBO;
import com.tydic.nicc.ocs.mapper.EventRecordDAO;
import com.tydic.nicc.ocs.mapper.SessionChangeRecordDAO;
import com.tydic.nicc.ocs.mapper.SessionDAO;
import com.tydic.nicc.ocs.mapper.SessionTaskDAO;
import com.tydic.nicc.ocs.mapper.po.SessionChangeRecordPO;
import com.tydic.nicc.ocs.mapper.po.SessionPO;
import com.tydic.nicc.ocs.mapper.po.SessionTaskPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SessionInfoServiceImpl
implements SessionInfoService {
    private static final Logger log = LoggerFactory.getLogger(SessionInfoServiceImpl.class);
    @Resource
    private EventRecordDAO eventRecordDAO;
    @Resource
    private SessionDAO sessionDAO;
    @Resource
    private SessionChangeRecordDAO recordDAO;
    @Resource
    private SessionTaskDAO sessionTaskDAO;
    @Resource
    private WsCache wsCache;
    @Autowired
    private EventBusiService eventBusiService;

    @Override
    public void linkedCreateSession(UserJoinInfoBO userJoinInfo) {
        Integer sessionStatus = 0;
        String sessionID = UUID.randomUUID().toString();
        String joinTaskID = userJoinInfo.getJoinTaskID();
        String jobCode = userJoinInfo.getJobCode();
        userJoinInfo.setSessionId(sessionID);
        SessionPO session = new SessionPO();
        session.setCreateTime(new Date());
        session.setPromoterId(jobCode);
        session.setCurrentTaskId(joinTaskID);
        session.setSessionStatus(sessionStatus);
        session.setSessionKey(sessionID);
        session.setChannelCode(userJoinInfo.getChannelCode());
        session.setTenantCode(userJoinInfo.getTenantCode());
        session.setCtiStartTime(new Date());
        this.createSession(session);
        this.wsCache.userLinked(userJoinInfo);
    }

    @Override
    public void loginSession(SessionBO session) {
        String jobCode = session.getJobCode();
        String taskId = session.getJoinTaskID();
        String skillId = session.getSkillDesc();
        String sessionKey = session.getSessionId();
        String ctiSessionID = session.getCitSeesionID();
        this.wsCache.updateUserJoinInfo(jobCode, taskId, ctiSessionID);
        this.wsCache.ctiAndOcsSessionBound(ctiSessionID, sessionKey, jobCode, taskId);
        this.updateSession(session);
        SessionTaskPO sessionTask = new SessionTaskPO();
        sessionTask.setCtiSessionId(ctiSessionID);
        sessionTask.setJobCode(jobCode);
        sessionTask.setSessionKey(sessionKey);
        sessionTask.setTaskId(taskId);
        sessionTask.setTenantId(session.getTenantCode());
        this.sessionTaskDAO.insertSelective(sessionTask);
    }

    @Override
    public void agentOut(SessionBO session) {
        String jobCode = session.getJobCode();
        String ctiSessionID = session.getCitSeesionID();
        this.wsCache.updateUserJoinInfo(jobCode, null, ctiSessionID);
        if (!StringUtils.isEmpty((CharSequence)ctiSessionID)) {
            this.wsCache.ctiAndOcsSessionUnbundle(ctiSessionID);
        }
        this.updateSession(session);
    }

    @Override
    public void userConnect(String agentDn, String userId) {
        try {
            this.wsCache.agentDnBandUser(agentDn, userId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Async(value="asyncServiceExecutor")
    public void insertSessionList(List<SessionBO> sessionList, List<EventBO> activeList) {
        ArrayList<SessionChangeRecordPO> changeRecordList = new ArrayList<SessionChangeRecordPO>();
        for (SessionBO session : sessionList) {
            SessionChangeRecordPO newRecordPO = new SessionChangeRecordPO();
            newRecordPO.setTaskId(session.getJoinTaskID());
            newRecordPO.setLastSessionStatus(session.getLastSessionStatus());
            newRecordPO.setCtiStartTime(session.getCtiSessionTime());
            newRecordPO.setCtiSessionStatus(session.getSessionStatusName());
            newRecordPO.setCreateTime(new Date());
            newRecordPO.setSessionStatus(session.getSessionStatus());
            newRecordPO.setSessionKey(session.getSessionId());
            newRecordPO.setCtiSessionId(session.getCitSeesionID());
            newRecordPO.setTenantId(session.getTenantCode());
            newRecordPO.setPromoterId(session.getJobCode());
            changeRecordList.add(newRecordPO);
        }
        this.recordDAO.insertList(changeRecordList);
        for (EventBO event : activeList) {
            this.eventBusiService.gainPreviewRecord(event);
        }
    }

    @Override
    public void userOutSession(SessionBO session) {
        String sessionKey = session.getSessionId();
        Date endTime = new Date();
        SessionChangeRecordPO lastSessionRecord = this.qryLastSessionRecord(sessionKey);
        if (lastSessionRecord != null) {
            lastSessionRecord.setEndTime(endTime);
            this.updateLastSessionRecord(lastSessionRecord);
        }
        this.wsCache.outSession(session);
        this.updateSession(session);
        this.wsCache.ctiAndOcsSessionUnbundle(session.getCitSeesionID());
    }

    @Override
    @Deprecated
    public void changeSession(SessionBO currentSession) {
        String sessionKey = currentSession.getSessionId();
        String ctiSessionID = currentSession.getCitSeesionID();
        String jobCode = currentSession.getJobCode();
        String joinTaskID = currentSession.getJoinTaskID();
        this.updateSession(currentSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async(value="asyncServiceExecutor")
    public void changeSessionByEvent(SessionBO session) {
        long current = System.currentTimeMillis();
        String ctiSessionID = session.getCitSeesionID();
        try {
            Long obRecordID = this.qryLastSessionRecordByCti(ctiSessionID);
            if (null != obRecordID) {
                this.recordDAO.updateEndTime(obRecordID, session.getCtiSessionTime());
            }
            SessionChangeRecordPO newRecordPO = new SessionChangeRecordPO();
            newRecordPO.setTaskId(session.getJoinTaskID());
            newRecordPO.setLastSessionStatus(session.getLastSessionStatus());
            newRecordPO.setCtiStartTime(session.getCtiSessionTime());
            newRecordPO.setCtiSessionStatus(session.getSessionStatusName());
            newRecordPO.setCreateTime(new Date());
            newRecordPO.setSessionStatus(session.getSessionStatus());
            newRecordPO.setSessionKey(session.getSessionId());
            newRecordPO.setCtiSessionId(session.getCitSeesionID());
            newRecordPO.setTenantId(session.getTenantCode());
            newRecordPO.setPromoterId(session.getJobCode());
            this.recordDAO.insert(newRecordPO);
        }
        finally {
            log.info("\u4f1a\u8bdd\uff1a{} changeSessionByEvent \u8017\u65f6\uff1a{}", (Object)ctiSessionID, (Object)(System.currentTimeMillis() - current));
        }
    }

    private Long qryLastSessionRecordByCti(String ctiSessionID) {
        if (StringUtils.isEmpty((CharSequence)ctiSessionID)) {
            return null;
        }
        return this.recordDAO.qryLastSessionRecordIdByCti(ctiSessionID);
    }

    private Long qryCtiSessionCurrentStatusBySessionKey(String sessinKey) {
        if (StringUtils.isEmpty((CharSequence)sessinKey)) {
            return null;
        }
        return this.sessionDAO.qryCtiSessionCurrentStatus(null, sessinKey, null);
    }

    @Override
    public void switchJobChangeSession(SessionBO session) {
        Integer sessionStatus = session.getSessionStatus();
        String sessionKey = session.getSessionId();
        String ctiSessionID = session.getCitSeesionID();
        String jobCode = session.getJobCode();
        String oldCtiSessionID = session.getCitSeesionID();
        String joinTaskID = session.getJoinTaskID();
        String skillId = session.getSkillDesc();
        String tenantId = session.getTenantCode();
        Date endTime = new Date();
        Long infoSessionId = this.sessionDAO.qryCtiSessionCurrentStatus(ctiSessionID, sessionKey, jobCode);
        if (null != infoSessionId) {
            SessionPO infoSession = this.sessionDAO.selectByPrimaryKey(infoSessionId);
            infoSession.setSessionStatus(sessionStatus);
            infoSession.setEndTime(endTime);
            infoSession.setSessionKey(session.getSessionId());
            infoSession.setCtiStartTime(session.getCtiSessionTime());
            infoSession.setCtiSessionId(session.getCitSeesionID());
            infoSession.setSessionId(infoSessionId);
            this.sessionDAO.updateSession(infoSession);
        } else {
            SessionPO sessionPO = new SessionPO();
            sessionPO.setCreateTime(new Date());
            sessionPO.setJoinSkillId(skillId);
            sessionPO.setCurrentTaskId(joinTaskID);
            sessionPO.setCtiSessionId(ctiSessionID);
            sessionPO.setPromoterId(session.getJobCode());
            sessionPO.setSessionKey(session.getSessionId());
            sessionPO.setTenantCode(session.getTenantCode());
            sessionPO.setChannelCode(session.getChannelCode());
            sessionPO.setSessionStatus(session.getSessionStatus());
            sessionPO.setCtiStartTime(null != session.getCtiSessionTime() ? session.getCtiSessionTime() : new Date());
            this.sessionDAO.insertSelective(sessionPO);
        }
        SessionTaskPO sessionTask = new SessionTaskPO();
        sessionTask.setTenantId(tenantId);
        sessionTask.setTaskId(joinTaskID);
        sessionTask.setSessionKey(sessionKey);
        sessionTask.setJobCode(jobCode);
        sessionTask.setCtiSessionId(ctiSessionID);
        this.sessionTaskDAO.insertSelective(sessionTask);
        this.wsCache.updateUserJoinInfo(jobCode, joinTaskID, ctiSessionID);
        this.wsCache.ctiAndOcsSessionUnbundle(oldCtiSessionID);
        this.wsCache.ctiAndOcsSessionBound(ctiSessionID, sessionKey, jobCode, joinTaskID);
    }

    private void updateSession(SessionBO session) {
        String taskId = session.getJoinTaskID();
        String skillId = session.getSkillDesc();
        String sessionKey = session.getSessionId();
        String jobCode = session.getJobCode();
        String ctiSessionID = session.getCitSeesionID();
        Long sessinId = this.qryCtiSessionCurrentStatus(ctiSessionID, sessionKey, jobCode);
        if (null == sessinId || 0L >= sessinId) {
            SessionPO sessionPO = new SessionPO();
            sessionPO.setCreateTime(new Date());
            sessionPO.setJoinSkillId(skillId);
            sessionPO.setCurrentTaskId(taskId);
            sessionPO.setCtiSessionId(ctiSessionID);
            sessionPO.setPromoterId(session.getJobCode());
            sessionPO.setSessionKey(session.getSessionId());
            sessionPO.setTenantCode(session.getTenantCode());
            sessionPO.setChannelCode(session.getChannelCode());
            sessionPO.setSessionStatus(session.getSessionStatus());
            sessionPO.setEndType(session.getEndType());
            sessionPO.setCtiStartTime(null != session.getCtiSessionTime() ? session.getCtiSessionTime() : new Date());
            this.sessionDAO.insertSelective(sessionPO);
        } else {
            SessionPO sessionPO = this.sessionDAO.selectByPrimaryKey(sessinId);
            sessionPO.setSessionStatus(session.getSessionStatus());
            sessionPO.setCtiSessionId(null != ctiSessionID ? ctiSessionID : sessionPO.getCtiSessionId());
            sessionPO.setCurrentTaskId(null != taskId ? taskId : sessionPO.getCurrentTaskId());
            sessionPO.setJoinSkillId(null != skillId ? skillId : sessionPO.getJoinSkillId());
            sessionPO.setEndTime(null == session.getCtiSessionTime() ? new Date() : session.getCtiSessionTime());
            this.sessionDAO.updateSession(sessionPO);
        }
    }

    private Long qryCtiSessionCurrentStatus(String ctiSessionID, String sessionKey, String jobCode) {
        if (StringUtils.isEmpty((CharSequence)ctiSessionID) && StringUtils.isEmpty((CharSequence)sessionKey) && StringUtils.isEmpty((CharSequence)jobCode)) {
            return null;
        }
        return this.sessionDAO.qryCtiSessionCurrentStatus(ctiSessionID, sessionKey, jobCode);
    }

    private SessionChangeRecordPO qryLastSessionRecord(String sessionKey) {
        Long lastSessionRecordId = this.recordDAO.qryLastSessionRecordId(sessionKey);
        return this.recordDAO.selectByPrimaryKey(lastSessionRecordId);
    }

    private void updateLastSessionRecord(SessionChangeRecordPO lastSessionRecord) {
        this.recordDAO.updateByPrimaryKeySelective(lastSessionRecord);
    }

    private void createSession(SessionPO session) {
        this.sessionDAO.createSession(session);
    }

    private void createSessionChangeRecord(SessionBO currentSession, SessionChangeRecordPO lastRecord, SessionPO session, String joinTaskID) {
        SessionChangeRecordPO recordPO = new SessionChangeRecordPO();
        recordPO.setCreateTime(new Date());
        if (lastRecord != null) {
            recordPO.setSessionId(lastRecord.getSessionId());
            recordPO.setSessionKey(lastRecord.getSessionKey());
            recordPO.setCtiSessionId(lastRecord.getCtiSessionId());
            recordPO.setLastSessionStatus(lastRecord.getSessionStatus());
        }
        if (session != null) {
            recordPO.setSessionId(session.getSessionId());
            recordPO.setSessionKey(session.getSessionKey());
            recordPO.setCtiSessionId(session.getCtiSessionId());
            recordPO.setSessionStatus(session.getSessionStatus());
        }
        if (currentSession != null) {
            recordPO.setSessionStatus(currentSession.getSessionStatus() != null ? recordPO.getSessionStatus() : currentSession.getSessionStatus());
            recordPO.setSessionKey(StringUtils.isBlank((CharSequence)currentSession.getSessionId()) ? recordPO.getSessionKey() : currentSession.getSessionId());
            recordPO.setSkillGroup(StringUtils.isBlank((CharSequence)currentSession.getSkillDesc()) ? recordPO.getSkillGroup() : currentSession.getSkillDesc());
            recordPO.setCtiSessionId(StringUtils.isBlank((CharSequence)currentSession.getCitSeesionID()) ? recordPO.getCtiSessionId() : currentSession.getCitSeesionID());
            recordPO.setPromoterId(StringUtils.isBlank((CharSequence)currentSession.getJobCode()) ? recordPO.getPromoterId() : currentSession.getJobCode());
            recordPO.setCtiStartTime(currentSession.getCtiSessionTime());
        }
        recordPO.setTaskId(joinTaskID);
        this.recordDAO.insert(recordPO);
    }
}

