/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.busi.impl;

import com.tydic.nicc.ocs.bo.QryCallerIDReqBO;
import com.tydic.nicc.ocs.bo.TaskInfoBO;
import com.tydic.nicc.ocs.busi.TaskBusiService;
import com.tydic.nicc.ocs.mapper.ObIvrTaskDAO;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.ObTenantScoreMapper;
import com.tydic.nicc.ocs.mapper.po.ObIvrTaskPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.mapper.po.ObTenantScore;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TaskBusiServiceImpl
implements TaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(TaskBusiServiceImpl.class);
    @Resource
    private ObTaskInfoDAO taskInfoDAO;
    @Resource
    private ObIvrTaskDAO obIvrTaskDAO;
    @Resource
    private ObTenantScoreMapper tenantScoreMapper;

    @Override
    public TaskInfoBO qryTask(TaskInfoBO task) {
        ObIvrTaskPO obIvrTaskPO;
        if (task == null) {
            return null;
        }
        ObTaskInfoPO taskInfo = new ObTaskInfoPO();
        taskInfo.setTaskId(task.getTaskId());
        ObTaskInfoPO re = this.taskInfoDAO.selectTaskInfo(taskInfo);
        if (re != null) {
            BeanUtils.copyProperties((Object)re, (Object)task);
        }
        if (null != (obIvrTaskPO = this.obIvrTaskDAO.qryChildTask(task.getTaskId(), task.getTenantId()))) {
            task.setIvrTaskId(obIvrTaskPO.getIvrTaskId());
            task.setIvrListId(obIvrTaskPO.getIvrListId());
        }
        return task;
    }

    @Override
    public String getCaller(QryCallerIDReqBO req) {
        if (req == null) {
            return null;
        }
        ObTaskInfoPO taskInfo = new ObTaskInfoPO();
        taskInfo.setTenantId(req.getTenantCode());
        taskInfo.setTaskId(req.getTaskID());
        ObTaskInfoPO result = this.taskInfoDAO.selectTaskInfo(taskInfo);
        if (result != null) {
            return result.getCalling();
        }
        return null;
    }

    @Override
    public String getTenantLevel(String tenantId) {
        log.info("\u6839\u636e\u79df\u6237\u83b7\u53d6\u79df\u6237\u6700\u65b0\u8bc4\u5206 tenantId:{}", (Object)tenantId);
        String score = "1";
        Long id = 0L;
        try {
            ObTenantScore tenantScore;
            id = this.tenantScoreMapper.selectTenantLatestScore(tenantId);
            if (id != null && id > 0L && null != (tenantScore = this.tenantScoreMapper.selectByPrimaryKey(id, tenantId)) && !StringUtils.isEmpty((CharSequence)tenantScore.getScore())) {
                score = tenantScore.getScore();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("\u6839\u636e\u79df\u6237\u83b7\u53d6\u79df\u6237\u6700\u65b0\u8bc4\u5206 tenantId:{},score:{},id:{}", new Object[]{tenantId, score, id});
        return score;
    }
}

