/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.cache;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.constant.TaskConstant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class LocalCache
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(LocalCache.class);
    public static final Map<String, Object> CODE_MAP = new ConcurrentHashMap<String, Object>();
    private static final String placeholder = "000000";

    public void run(String ... args) {
        LocalCache.loadOutCallRecordTableName();
        LocalCache.loadUserProductPolicyTableName();
        log.info("\u521d\u59cb\u5316\u52a0\u8f7d\u672c\u5730map\uff1a{}", (Object)JSONObject.toJSONString(CODE_MAP));
    }

    public static String getCallRecordTableNameByModelNO(String modelNO) {
        int hastCode = Math.abs(modelNO.hashCode());
        int suffix = hastCode % TaskConstant.SUBMETER_NUMBER;
        Map recordTableNameMap = (Map)CODE_MAP.get("ob_called_record_");
        String tableName = (String)recordTableNameMap.get(String.valueOf(suffix));
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return "ob_called_record";
        }
        return tableName;
    }

    public static String getUserProductPolicyTableNameByModelNO(String modelNO) {
        int hastCode = Math.abs(modelNO.hashCode());
        int suffix = hastCode % TaskConstant.SUBMETER_NUMBER;
        Map recordTableNameMap = (Map)CODE_MAP.get("ob_user_product_policy_");
        String tableName = (String)recordTableNameMap.get(String.valueOf(suffix));
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return "ob_user_product_policy";
        }
        return tableName;
    }

    private static void loadOutCallRecordTableName() {
        try {
            int submeterLength = String.valueOf(TaskConstant.SUBMETER_NUMBER).length();
            ConcurrentHashMap<String, String> recordTableName = new ConcurrentHashMap<String, String>();
            CODE_MAP.put("ob_called_record_", recordTableName);
            for (int ii = 0; ii < TaskConstant.SUBMETER_NUMBER; ++ii) {
                String suffix = placeholder + ii;
                int suffixLength = suffix.length();
                suffix = suffix.substring(suffixLength - submeterLength, suffixLength);
                recordTableName.put(String.valueOf(ii), "ob_called_record_" + suffix);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void loadUserProductPolicyTableName() {
        try {
            int submeterLength = String.valueOf(TaskConstant.SUBMETER_NUMBER).length();
            ConcurrentHashMap userProductMap = MapUtil.newConcurrentHashMap();
            CODE_MAP.put("ob_user_product_policy_", userProductMap);
            for (int ii = 0; ii < TaskConstant.SUBMETER_NUMBER; ++ii) {
                String suffix = placeholder + ii;
                int suffixLength = suffix.length();
                suffix = suffix.substring(suffixLength - submeterLength, suffixLength);
                userProductMap.put(String.valueOf(ii), "ob_user_product_policy_" + suffix);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        LocalCache.loadOutCallRecordTableName();
        LocalCache.loadUserProductPolicyTableName();
        System.out.println(LocalCache.getCallRecordTableNameByModelNO("15609946636"));
    }
}

