/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.callRate;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.CallRateConfigBO;
import com.tydic.nicc.ocs.bo.QueryCallRateConfigReqBO;
import com.tydic.nicc.ocs.bo.QueryCallRateConfigRspBO;
import com.tydic.nicc.ocs.bo.SubmitCallRateConfigReqBO;
import com.tydic.nicc.ocs.bo.TaskInfoBO;
import com.tydic.nicc.ocs.bo.TaskTacticsBO;
import com.tydic.nicc.ocs.bo.UpdateCallRateConfigReqBO;
import com.tydic.nicc.ocs.constant.TaskConstant;
import com.tydic.nicc.ocs.mapper.ObCallRateConfigDAO;
import com.tydic.nicc.ocs.mapper.po.ObCallRateConfigPO;
import com.tydic.nicc.ocs.service.CallRateConfigService;
import com.tydic.nicc.ocs.service.IsvTaskProxyService;
import com.tydic.nicc.ocs.service.TaskInfoService;
import com.tydic.nicc.ocs.utils.RegularUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.StringUtils;

@DubboService
public class CallRateConfigServiceImpl
implements CallRateConfigService {
    private static final Logger log = LoggerFactory.getLogger(CallRateConfigServiceImpl.class);
    @Resource
    private ObCallRateConfigDAO obCallRateConfigDAO;
    @Resource
    private IsvTaskProxyService isvTaskProxyService;
    @Resource
    private TaskInfoService taskInfoService;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private BladeUserInterService userInterService;
    public static final Map<String, BladeTenantBO> tenantMap = MapUtil.newConcurrentHashMap((int)100);

    public RspList queryCallRateConfig(QueryCallRateConfigReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u5916\u547c\u901f\u7387\u914d\u7f6e\u63a5\u53e3\uff0c\u5165\u53c2\uff1a\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        List<Object> rspBOS = new ArrayList();
        Integer count = 0;
        try {
            String userId = reqBO.getLoginInfo().getUserId();
            List roleNames = this.userInterService.getUserRoleInfo(userId);
            List bladeTenants = null;
            if (null != roleNames && roleNames.size() > 0) {
                for (String roleName : roleNames) {
                    if (StringUtils.isEmpty((Object)roleName) || !roleName.equals("system:admin")) continue;
                    bladeTenants = this.bladeTenantInterService.getTenantList(tenantId);
                    break;
                }
            } else {
                log.error("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u89d2\u8272\u4fe1\u606f");
                return BaseRspUtils.createErrorRspList((String)"\u65e0\u6743\u9650");
            }
            if (null == bladeTenants || bladeTenants.size() == 0) {
                log.error("\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650");
                return BaseRspUtils.createErrorRspList((String)"\u60a8\u6ca1\u6709\u6743\u9650\u64cd\u4f5c");
            }
            if (!StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                bladeTenants = bladeTenants.stream().filter(tenant -> reqBO.getTenantId().equals(tenant.getTenantId())).collect(Collectors.toList());
            }
            List<Object> tenantIds = new ArrayList<String>();
            if (null != reqBO.getTenantIds() && reqBO.getTenantIds().size() > 0) {
                tenantIds.addAll(reqBO.getTenantIds());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                tenantIds.add(reqBO.getTenantId());
            }
            if (null != (tenantIds = tenantIds.stream().distinct().collect(Collectors.toList())) && tenantIds.size() > 0) {
                ArrayList bos = new ArrayList();
                for (String string : tenantIds) {
                    List collect = bladeTenants.stream().filter(tenant -> str.equals(tenant.getTenantId())).collect(Collectors.toList());
                    bos.addAll(collect);
                }
                bladeTenants = new ArrayList();
                bladeTenants.addAll(bos);
            }
            for (BladeTenantBO tenantBO : bladeTenants) {
                QueryCallRateConfigRspBO queryCallRateConfigRspBO = new QueryCallRateConfigRspBO();
                ObCallRateConfigPO configPO = new ObCallRateConfigPO();
                configPO.setTenantId(tenantBO.getTenantId());
                ObCallRateConfigPO rateConfigPO = this.obCallRateConfigDAO.selectByTenantId(configPO);
                log.info("\u5f53\u524d\u79df\u6237\uff1a{}\uff0c \u83b7\u53d6\u5916\u547c\u901f\u7387\u914d\u7f6eMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)tenantBO.getTenantId(), (Object)JSONObject.toJSONString((Object)rateConfigPO));
                queryCallRateConfigRspBO.setTenantId(tenantBO.getTenantId());
                queryCallRateConfigRspBO.setTenantName(tenantBO.getTenantName());
                if (null != rateConfigPO) {
                    queryCallRateConfigRspBO.setConfigId(String.valueOf(rateConfigPO.getId()));
                    queryCallRateConfigRspBO.setMaxQueue(null == rateConfigPO.getMaxQueue() ? "-" : String.valueOf(rateConfigPO.getMaxQueue()));
                    queryCallRateConfigRspBO.setMicroParam(null == rateConfigPO.getMicroParam() ? "-" : String.valueOf(rateConfigPO.getMicroParam()));
                    queryCallRateConfigRspBO.setNextNumberTime(null == rateConfigPO.getNextNumberTime() ? "-" : String.valueOf(rateConfigPO.getNextNumberTime()));
                }
                rspBOS.add(queryCallRateConfigRspBO);
            }
            count = rspBOS.size();
            rspBOS = rspBOS.stream().skip(reqBO.getLimit() * (reqBO.getPage() - 1)).limit(reqBO.getLimit()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)count.intValue());
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp submitCallRateConfig(SubmitCallRateConfigReqBO reqBO) {
        log.info("\u8fdb\u5165\u8bbe\u7f6e\u5916\u547c\u901f\u7387\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        try {
            List taskInfoBOS;
            if (!this.checkPower(reqBO.getLoginInfo().getUserId()).booleanValue()) {
                return BaseRspUtils.createErrorRsp((String)"\u60a8\u6ca1\u6709\u6743\u9650\u64cd\u4f5c");
            }
            if (StringUtils.isEmpty((Object)reqBO.getMaxQueue())) {
                return BaseRspUtils.createErrorRsp((String)"\u6700\u5927\u6392\u961f\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getMicroParam())) {
                return BaseRspUtils.createErrorRsp((String)"\u5fae\u8c03\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Rsp rsp = this.checkParam(reqBO.getMaxQueue(), reqBO.getMicroParam(), reqBO.getNextNumberTime());
            if (!"0000".equals(rsp.getRspCode())) {
                return rsp;
            }
            ObCallRateConfigPO configPO = new ObCallRateConfigPO();
            configPO.setTenantId(reqBO.getTenantId());
            configPO.setMaxQueue(Integer.valueOf(reqBO.getMaxQueue()));
            configPO.setMicroParam(Integer.valueOf(reqBO.getMicroParam()));
            configPO.setNextNumberTime(StringUtils.isEmpty((Object)reqBO.getNextNumberTime()) ? null : Long.valueOf(Long.parseLong(reqBO.getNextNumberTime())));
            if (StringUtils.isEmpty((Object)reqBO.getId())) {
                configPO.setCreateTime(new Date());
                configPO.setCreateUser(reqBO.getLoginInfo().getUserId());
                configPO.setIsDelete(TaskConstant.IS_DELETE_0);
                log.info("\u65b0\u589e\u5916\u547c\u901f\u7387\u914d\u7f6eM\u5b89\u6392Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)configPO));
                this.obCallRateConfigDAO.insertSelective(configPO);
            } else {
                configPO.setId(Long.valueOf(Long.parseLong(reqBO.getId())));
                configPO.setUpdateTime(new Date());
                configPO.setUpdateUser(reqBO.getLoginInfo().getUserId());
                this.obCallRateConfigDAO.updateByPrimaryKeySelective(configPO);
            }
            Integer nextNumberTime = null;
            if (null != reqBO.getNextNumberTime()) {
                nextNumberTime = Integer.parseInt(reqBO.getNextNumberTime());
            }
            if (null != (taskInfoBOS = this.taskInfoService.getTaskInfo(reqBO.getTenantId())) && taskInfoBOS.size() > 0) {
                this.modifyPredictive(taskInfoBOS, Integer.valueOf(reqBO.getMaxQueue()), Integer.valueOf(reqBO.getMicroParam()), nextNumberTime);
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseRspUtils.createErrorRsp((String)"\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp updateCallRateConfig(UpdateCallRateConfigReqBO reqBO) {
        log.info("\u8fdb\u5165\u4fee\u6539\u5916\u547c\u901f\u7387\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        try {
            if (!this.checkPower(reqBO.getLoginInfo().getUserId()).booleanValue()) {
                return BaseRspUtils.createErrorRsp((String)"\u60a8\u6ca1\u6709\u6743\u9650\u64cd\u4f5c");
            }
            if (null == reqBO.getIds() || reqBO.getIds().size() == 0) {
                return BaseRspUtils.createErrorRsp((String)"\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ObCallRateConfigPO configPO = new ObCallRateConfigPO();
            configPO.setUpdateTime(new Date());
            configPO.setUpdateUser(reqBO.getLoginInfo().getUserId());
            configPO.setIds(reqBO.getIds());
            configPO.setIsDelete(TaskConstant.IS_DELETE_1);
            this.obCallRateConfigDAO.updateByIds(configPO);
            List configPOS = this.obCallRateConfigDAO.selectByIds(reqBO.getIds());
            log.info("\u6839\u636eID\u96c6\u5408\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)configPOS));
            if (null != configPOS && configPOS.size() > 0) {
                for (ObCallRateConfigPO rateConfigPO : configPOS) {
                    List taskInfoBOS = this.taskInfoService.getTaskInfo(rateConfigPO.getTenantId());
                    if (null == taskInfoBOS || taskInfoBOS.size() <= 0) continue;
                    for (TaskInfoBO taskInfoBO : taskInfoBOS) {
                        this.isvTaskProxyService.modifyPredictive(taskInfoBO.getTaskId(), taskInfoBO.getTenantId());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseRspUtils.createErrorRsp((String)"\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public CallRateConfigBO getCallRateBO(String tenantId) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u79df\u6237\u5916\u547c\u901f\u7387\u914d\u7f6e\uff0c tenantId:{}", (Object)tenantId);
        ObCallRateConfigPO rateConfigPO = new ObCallRateConfigPO();
        rateConfigPO.setTenantId(tenantId);
        ObCallRateConfigPO configPO = this.obCallRateConfigDAO.selectByTenantId(rateConfigPO);
        log.info("\u83b7\u53d6\u79df\u6237\u5916\u547c\u901f\u7387\u914d\u7f6eMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)configPO));
        CallRateConfigBO configBO = null;
        if (null != configPO) {
            configBO = new CallRateConfigBO();
            BeanUtils.copyProperties((Object)configPO, (Object)configBO);
        }
        return configBO;
    }

    private Rsp checkParam(String maxQueue, String microParam, String nextNumberTime) {
        if (!RegularUtils.isNumeric(maxQueue)) {
            return BaseRspUtils.createErrorRsp((String)"\u6700\u5927\u6392\u961f\u6570\u53ea\u80fd\u8bbe\u7f6e\u6570\u5b57");
        }
        if (!RegularUtils.within100(maxQueue)) {
            return BaseRspUtils.createErrorRsp((String)"\u6700\u5927\u6392\u961f\u6570\u8303\u56f4\u4e3a 0 -- 100\uff01");
        }
        if (!RegularUtils.isNumeric(microParam)) {
            return BaseRspUtils.createErrorRsp((String)"\u5fae\u8c03\u53c2\u6570\u53ea\u80fd\u8bbe\u7f6e\u6570\u5b57");
        }
        if (!RegularUtils.withinIn(microParam)) {
            return BaseRspUtils.createErrorRsp((String)"\u5fae\u8c03\u53c2\u6570\u8303\u56f4\u4e3a -100 -- 100\uff01");
        }
        if (null != nextNumberTime) {
            if (!RegularUtils.isMatches(nextNumberTime)) {
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u8f93\u5165\u6b63\u6574\u6570");
            }
            if (Integer.parseInt(nextNumberTime) > 9999) {
                return BaseRspUtils.createErrorRsp((String)"\u5931\u8d25\u62e8\u6253\u4e0b\u4e00\u4e2a\u53f7\u7801\u95f4\u9694\u8d85\u51fa\u6700\u5927\u503c");
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    private Boolean checkPower(String userId) {
        Boolean flag = false;
        List roleNames = this.userInterService.getUserRoleInfo(userId);
        if (null != roleNames && roleNames.size() > 0) {
            for (String role : roleNames) {
                if (StringUtils.isEmpty((Object)role) || !role.equals("system:admin")) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private void modifyPredictive(List<TaskInfoBO> taskInfoBOS, Integer maxQueue, Integer microParam, Integer nextNumberTime) {
        ArrayList<TaskTacticsBO> taskTacticsBOS = new ArrayList<TaskTacticsBO>();
        TaskTacticsBO tacticsBO = new TaskTacticsBO();
        tacticsBO.setMinStartSeats(maxQueue);
        tacticsBO.setPredictionDivisor(microParam);
        tacticsBO.setNextInterval(nextNumberTime);
        taskTacticsBOS.add(tacticsBO);
        for (TaskInfoBO infoBO : taskInfoBOS) {
            this.isvTaskProxyService.modifyPredictive(infoBO.getTaskId(), infoBO.getTenantId());
        }
    }
}

