/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.callrecord;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.data.entity.CallBackRecord;
import com.tydic.nicc.data.service.task.inter.ObCenterDataTaskDataInterService;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantListReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantListRspBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.ocs.constant.CallRecordConstant;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCustServeRecordDAO;
import com.tydic.nicc.ocs.mapper.ObDataTargetDAO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObCustServeRecordPO;
import com.tydic.nicc.ocs.service.ObCallRecordService;
import com.tydic.nicc.ocs.utils.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@DubboService
public class ObCallRecordServiceImpl
implements ObCallRecordService {
    private static final Logger log = LoggerFactory.getLogger(ObCallRecordServiceImpl.class);
    @Resource
    private ObCallRecordDAO obCallRecordDAO;
    @Resource
    private ObCustServeRecordDAO obCustServeRecordDAO;
    @Resource
    private ObDataTargetDAO obDataTargetDAO;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private ObCenterDataTaskDataInterService obCenterDataTaskDataInterService;

    public Rsp pushCallRecord(Integer hours, String endTime) {
        log.info("\u8fdb\u5165\u63a8\u9001\u5916\u547c\u8bb0\u5f55\u63a5\u53e3\uff0c \u5165\u53c2\u201d{}", (Object)hours);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date endDate = null;
            if (hours == null) {
                hours = 1;
            }
            endDate = StringUtils.isEmpty((Object)endTime) ? new Date() : format.parse(endTime);
            String hour = this.getHours(hours, endDate);
            log.info("hour:{}", (Object)hour);
            List<BladeTenantBO> tenantBOS = this.getTenantList();
            if (tenantBOS == null) {
                log.error("\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
                return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
            }
            List<CallBackRecord> records = this.getRecords(tenantBOS, hour, endDate);
            if (records != null && records.size() > 0) {
                Rsp rsp = this.obCenterDataTaskDataInterService.callBack(records);
                log.info("\u5916\u547c\u53cd\u9988\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff0c rspCode\uff1a{}, rspDesc:{}", (Object)rsp.getRspCode(), (Object)rsp.getRspDesc());
            } else {
                log.info("records\u5916\u547c\u8bb0\u5f55\u96c6\u5408\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            log.error("\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)"");
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    private List<BladeTenantBO> getTenantList() {
        log.info("\u5f00\u59cb\u83b7\u53d6\u79df\u6237\u5217\u8868");
        GetBladeTenantListRspBO rspBO = this.bladeTenantInterService.getBladeTenantList(new GetBladeTenantListReqBO());
        log.info("\u83b7\u53d6\u79df\u6237\u5217\u8868\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)rspBO));
        if (!rspBO.getRspCode().equals("0000")) {
            log.error("\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
            return null;
        }
        return rspBO.getRows();
    }

    private String getHours(Integer hours, Date endDate) {
        if (hours == null || hours == 0) {
            hours = 1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.set(11, calendar.get(11) - hours);
        Integer hour = calendar.get(11);
        return String.valueOf(hour);
    }

    private List<CallBackRecord> getRecords(List<BladeTenantBO> tenantBOS, String hour, Date endDate) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u5916\u547c\u8bb0\u5f55\u4fe1\u606ftenantBOS:{}, hour\uff1a{}", (Object)JSONObject.toJSONString(tenantBOS), (Object)hour);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        String startTime = this.getStartTime(format, calendar);
        String endTime = this.getEndTime(format, calendar);
        log.info("startTime:{}\uff0c endTime\uff1a{}", (Object)startTime, (Object)endTime);
        ArrayList<Object> callBackRecords = new ArrayList<CallBackRecord>();
        if (tenantBOS != null && tenantBOS.size() > 0) {
            for (BladeTenantBO tenantBO : tenantBOS) {
                ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
                obCallRecordPO.setTenantOtherName(tenantBO.getTenantOtherName());
                obCallRecordPO.setTenantId(tenantBO.getTenantId());
                obCallRecordPO.setStartTime(startTime);
                obCallRecordPO.setEndTime(endTime);
                obCallRecordPO.setObHour(hour);
                log.info("\u67e5\u8be2\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCallRecordPO));
                List callRecordPOS = this.obCallRecordDAO.qryCallRecord(obCallRecordPO);
                log.info("\u67e5\u8be2\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)callRecordPOS));
                if (callRecordPOS != null && callRecordPOS.size() > 0) {
                    for (ObCallRecordPO recordPO : callRecordPOS) {
                        if (null == recordPO.getTaskId() || "ACTIVE_OUT".equals(recordPO.getTaskId())) {
                            log.info("\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8df3\u8fc7");
                            continue;
                        }
                        CallBackRecord backRecord = new CallBackRecord();
                        backRecord.setRecordId(recordPO.getRecordId());
                        backRecord.setTenantId(tenantBO.getTenantId());
                        backRecord.setDataId(recordPO.getDataId());
                        backRecord.setRelayNumber(recordPO.getTrunkDn());
                        backRecord.setRealCaller(recordPO.getCalling());
                        String ringTime = StringUtils.isEmpty((Object)recordPO.getRingTime()) ? recordPO.getStartTime() : recordPO.getRingTime();
                        String answerTime = recordPO.getTalkTime();
                        try {
                            Date parse = format.parse(ringTime);
                            Date parse1 = format.parse(answerTime);
                            ringTime = format.format(parse);
                            answerTime = format.format(parse1);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        backRecord.setRingTime(ringTime);
                        backRecord.setIsConn(recordPO.getIsConn());
                        backRecord.setMobileNo(recordPO.getCalled());
                        backRecord.setTaskId(recordPO.getTaskId());
                        if (recordPO.getIsConn().equals("1")) {
                            backRecord.setAnswerTime(answerTime);
                            backRecord.setEndTime(recordPO.getEndTime());
                            backRecord.setContactLength(DateUtil.parseMin(Integer.parseInt(recordPO.getContactLength())));
                            backRecord.setContactLengthSecond(recordPO.getContactLength());
                            backRecord.setRecordFile(recordPO.getRecordFile());
                        }
                        ObCustServeRecordPO obCustServeRecordPO = new ObCustServeRecordPO();
                        obCustServeRecordPO.setUcId(recordPO.getUcId());
                        obCustServeRecordPO.setTenantOtherName(tenantBO.getTenantOtherName());
                        obCustServeRecordPO.setTenantId(tenantBO.getTenantId());
                        log.info("\u6839\u636eucId\u83b7\u53d6\u5916\u547c\u63d0\u4ea4\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCustServeRecordPO));
                        ObCustServeRecordPO custServeRecordPO = this.obCustServeRecordDAO.getServiceRecord(obCustServeRecordPO);
                        log.info("\u6839\u636eucId\u83b7\u53d6\u5916\u547c\u63d0\u4ea4\u8bb0\u5f55Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)custServeRecordPO));
                        if (custServeRecordPO != null) {
                            backRecord.setUserCode(custServeRecordPO.getHandleUser());
                            backRecord.setCallResult(custServeRecordPO.getHandleResults());
                        }
                        callBackRecords.add(backRecord);
                        if (!CallRecordConstant.DATA_MAX_NUMBER.equals(callBackRecords.size())) continue;
                        Rsp rsp = this.obCenterDataTaskDataInterService.callBack(callBackRecords);
                        log.info("\u96c6\u5408\u957f\u5ea6\u8fbe\u5230{}\uff0c\u8c03\u7528\u5916\u547c\u53cd\u9988\u63a5\u53e3\uff0c\u5916\u547c\u53cd\u9988\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\uff0c rspCode\uff1a{}, rspDesc:{}", new Object[]{CallRecordConstant.DATA_MAX_NUMBER, rsp.getRspCode(), rsp.getRspDesc()});
                        callBackRecords = new ArrayList();
                    }
                    continue;
                }
                log.info("\u5f53\u524d\u79df\u6237\u7f16\u7801\uff1a{}\uff0c \u522b\u540d\uff1a{}\uff0c \u672a\u67e5\u8be2\u5230\u5916\u547c\u8bb0\u5f55", (Object)tenantBO.getTenantId(), (Object)tenantBO.getTenantOtherName());
            }
        } else {
            log.info("tenantBOS \u4e3a\u7a7a\uff01");
            return callBackRecords;
        }
        return callBackRecords;
    }

    private String getStartTime(SimpleDateFormat format, Calendar calendar) {
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        String startTime = format.format(calendar.getTime());
        return startTime;
    }

    private String getEndTime(SimpleDateFormat format, Calendar calendar) {
        calendar.set(13, 59);
        calendar.set(12, 59);
        calendar.set(11, 23);
        String endTime = format.format(calendar.getTime());
        return endTime;
    }
}

