/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.config;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.mapper.DcGeneralCodeDAO;
import com.tydic.nicc.ocs.mapper.po.DcGeneralCodePO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.tomcat.util.security.MD5Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.tool.support.StrFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@Order(value=1)
public class CodeConfig
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(CodeConfig.class);
    private static Map<String, ConcurrentHashMap<String, String>> CODE_MAP = new ConcurrentHashMap<String, ConcurrentHashMap<String, String>>();
    @Autowired
    private DcGeneralCodeDAO dcGeneralCodeDAO;

    public void run(String ... args) throws Exception {
        try {
            this.reload(null);
        }
        catch (Exception exception) {
        }
        finally {
            log.info("CODE_MAP\uff1a{}", (Object)JSONObject.toJSONString(CODE_MAP));
        }
    }

    public String getRealValue(CODE_BUSI busi, CODE_NAME name) {
        List codes = this.dcGeneralCodeDAO.qryGeneralCodeValue(busi.name(), name.name());
        if (null != codes && !codes.isEmpty()) {
            for (DcGeneralCodePO code : codes) {
                if (!"1".equals(code.getCodeStatus())) continue;
                return code.getCodeValue();
            }
        }
        return null;
    }

    public ConcurrentHashMap<String, String> reload(String codeType) {
        List codes = this.dcGeneralCodeDAO.qryGeneralCode(codeType);
        if (codes == null || codes.isEmpty()) {
            log.debug("\u672a\u914d\u7f6e\u7cfb\u7edf\u53c2\u6570");
        }
        for (DcGeneralCodePO code : codes) {
            ConcurrentHashMap<String, String> codeEntry = CODE_MAP.get(code.getCodeType());
            if (codeEntry == null) {
                codeEntry = new ConcurrentHashMap();
                CODE_MAP.put(code.getCodeType(), codeEntry);
            }
            if ("0".equals(code.getCodeStatus())) {
                codeEntry.remove(code.getCodeName());
                continue;
            }
            if (!"1".equals(code.getCodeStatus())) continue;
            codeEntry.put(code.getCodeName(), code.getCodeValue());
        }
        if (codeType != null) {
            return CODE_MAP.get(codeType);
        }
        return null;
    }

    public Map getCodeBusiMap(CODE_BUSI busi) {
        ConcurrentHashMap<String, String> codeValues = CODE_MAP.get(busi.name());
        if (codeValues == null) {
            codeValues = this.reload(busi.name());
        }
        return codeValues;
    }

    public String getCodeStrValue(CODE_BUSI codeBusi, CODE_NAME codeName) {
        ConcurrentHashMap<String, String> codeValues = CODE_MAP.get(codeBusi.name());
        if (codeValues == null) {
            codeValues = this.reload(codeBusi.name());
        }
        if (codeValues != null) {
            return codeValues.get(codeName.name());
        }
        return null;
    }

    public Long getCodeLongValue(CODE_BUSI codeBusi, CODE_NAME codeName) {
        String value;
        ConcurrentHashMap<String, String> codeValus = CODE_MAP.get(codeBusi.name());
        if (null == codeValus) {
            codeValus = this.reload(codeBusi.name());
        }
        if (null != codeValus && null != (value = codeValus.get(codeName.name()))) {
            return Long.valueOf(value);
        }
        return 0L;
    }

    public String getCodeStrValue(String codeBusi, CODE_NAME codeName) {
        ConcurrentHashMap<String, String> codeValues = CODE_MAP.get(codeBusi);
        if (codeValues == null) {
            codeValues = this.reload(codeBusi);
        }
        if (codeValues != null) {
            return codeValues.get(codeName.name());
        }
        return null;
    }

    public String getCodeStrValue(CODE_BUSI codeBusi, String codeName) {
        ConcurrentHashMap<String, String> codeValues = CODE_MAP.get(codeBusi.name());
        if (codeValues == null) {
            codeValues = this.reload(codeBusi.name());
        }
        if (codeValues != null) {
            String value = codeValues.get(codeName);
            if (value == null) {
                this.reload(codeBusi.name());
                value = codeValues.get(codeName);
            }
            return value;
        }
        throw new RuntimeException(StrFormatter.format((String)"\u672a\u914d\u7f6e\u7cfb\u7edf\u53c2\u6570\uff1a\u4e1a\u52a1\u7f16\u7801\uff1a{}\uff0ccode:{}", (Object[])new Object[]{codeBusi, codeName}));
    }

    public Integer getCodeIntegerValue(CODE_BUSI codeBusi, CODE_NAME codeName) {
        String codeValue;
        ConcurrentHashMap<String, String> codeValues = CODE_MAP.get(codeBusi.name());
        if (codeValues == null) {
            codeValues = this.reload(codeBusi.name());
        }
        if (codeValues != null && !StringUtils.isEmpty((Object)(codeValue = codeValues.get(codeName.name())))) {
            return Integer.valueOf(codeValue);
        }
        return null;
    }

    public boolean getCodeBooleanValue(CODE_BUSI codeBusi, CODE_NAME codeName) {
        String codeValue;
        ConcurrentHashMap<String, String> codeValues = CODE_MAP.get(codeBusi.name());
        if (codeValues == null) {
            codeValues = this.reload(codeBusi.name());
        }
        if (codeValues != null && !StringUtils.isEmpty((Object)(codeValue = codeValues.get(codeName.name())))) {
            return Boolean.valueOf(codeValue);
        }
        return true;
    }

    public String getOcsUrl(String codeName, String tenantCode) {
        return this.getOcsUrl(codeName, tenantCode, null);
    }

    public String getOcsUrl(String codeName, String tenantCode, String timestamp) {
        String url = this.getCodeStrValue(CODE_BUSI.OCS_URL, codeName);
        String tenantToken = this.getCodeStrValue(CODE_BUSI.SYS_PARAM, CODE_NAME.tenantToken.name());
        StringBuffer sb = new StringBuffer(url).append("?tenantId=");
        sb.append(tenantCode);
        timestamp = null == timestamp ? DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") : timestamp;
        sb.append("&timestamp=").append(timestamp);
        String binaryStr = tenantCode + tenantToken + timestamp;
        String signature = MD5Encoder.encode((byte[])binaryStr.getBytes());
        sb.append("&signature=").append(signature);
        return sb.toString();
    }

    public String getOcsGetUrl(String codeName, String tenantCode, String taskId, String timestamp) {
        String url = this.getCodeStrValue(CODE_BUSI.OCS_URL, codeName);
        String tenantToken = this.getCodeStrValue(CODE_BUSI.SYS_PARAM, CODE_NAME.tenantToken.name());
        StringBuffer sb = new StringBuffer(url).append("?tenantId=");
        sb.append(tenantCode);
        timestamp = null == timestamp ? DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") : timestamp;
        sb.append("&timestamp=").append(timestamp);
        String binaryStr = tenantCode + tenantToken + timestamp;
        String signature = MD5Encoder.encode((byte[])binaryStr.getBytes());
        sb.append("&signature=").append(signature);
        sb.append("&taskId=").append(taskId);
        return sb.toString();
    }

    public static enum CODE_NAME {
        tenantToken,
        M_DAY,
        N_DAY,
        APPOINT_FORMAT_BEGIN,
        APPOINT_FORMAT_END,
        APPOINT_FORMAT_ROLL_END,
        APPOINT_BEGIN,
        APPOINT_END,
        DEFAULT_OVERT_NUMER,
        MAXIMUM_SILENT_TIME,
        IS_OPEN_MIN_AGENT,
        OUT_PREFIX,
        OUT_PREFIX_NO,
        HUNT_GROUP_DN,
        HIGH_STAR,
        NO_HARASSMET_PREFIX,
        MAX_CALL_COUNT;

    }

    public static enum CODE_BUSI {
        OCS_URL,
        SYS_PARAM,
        CALL_DAY_CHECK,
        TASK_TACTIS_APPOINT_FORMAT,
        SPECIAL_TENANTS,
        WS,
        EXP_NUMBER;

    }
}

