/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.config;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class RestTemplateConfig {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateConfig.class);
    @Value(value="${default.pre.uri:http://192.168.198.94:30090}")
    private String defaultPreHeatUrl;

    @Bean(name={"restTemplateConfigs"})
    public RestTemplate restTemplate() {
        return this.getRestTemplate(3, this.defaultPreHeatUrl);
    }

    private RestTemplate getRestTemplate(int maxTotal, String preHeatUrl) {
        HttpComponentsClientHttpRequestFactory httpRequestFactory = this.httpComponentsClientHttpRequestFactory(maxTotal);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
        if (StringUtils.isNotEmpty((CharSequence)preHeatUrl)) {
            try {
                restTemplate.postForEntity(preHeatUrl, (Object)"", String.class, new Object[0]);
            }
            catch (Exception e) {
                log.error("preHeat url error:{}", (Object)e.getMessage());
            }
        }
        return restTemplate;
    }

    private HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory(int maxTotal) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(1L, TimeUnit.HOURS);
        connectionManager.setMaxTotal(maxTotal);
        connectionManager.setDefaultMaxPerRoute(maxTotal);
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("Accept-Encoding", "gzip, deflate"));
        headers.add(new BasicHeader("Accept-Language", "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3"));
        headers.add(new BasicHeader("Connection", "keep-alive"));
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultHeaders(headers).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true)).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy()).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        requestFactory.setConnectTimeout(10000);
        requestFactory.setReadTimeout(5000);
        requestFactory.setConnectionRequestTimeout(2000);
        requestFactory.setBufferRequestBody(false);
        return requestFactory;
    }
}

