/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.config.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.LoginInfo;
import com.tydic.nicc.ocs.config.filter.HttpHelper;
import com.tydic.nicc.secure.LoginUser;
import com.tydic.nicc.secure.SecureUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Set;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections4.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestReaderHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(RequestReaderHttpServletRequestWrapper.class);
    private final String body;
    private static final String SYSTEM_ADMIN = "system:admin";

    public RequestReaderHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        String bodyOld = HttpHelper.getBodyString(request);
        JSONObject js = null;
        if (bodyOld != null) {
            js = JSON.parseObject((String)bodyOld);
        }
        LoginUser user = SecureUtil.getUser();
        Set<String> roleSet = this.getUserRoleCodes(user);
        if (js == null) {
            js = new JSONObject();
        }
        if (user != null) {
            LoginInfo info = new LoginInfo();
            info.setLoginName(user.getUserName());
            info.setUserType(user.getRoleId());
            info.setUserId(user.getUserId().toString());
            if (!roleSet.contains(SYSTEM_ADMIN) && !"000000".equals(user.getTenantId())) {
                js.put("tenantCode", (Object)user.getTenantId());
            }
            js.put("in_tenantCode", (Object)user.getTenantId());
            js.put("loginInfo", (Object)info);
            js.put("roleSet", roleSet);
        }
        this.body = js.toJSONString();
        log.info("body:{}", (Object)this.body);
    }

    private Set<String> getUserRoleCodes(LoginUser user) {
        String roleNameStr;
        String[] roleNames;
        Set roles = SetUtils.newIdentityHashSet();
        if (null != user && null != (roleNames = (roleNameStr = user.getRoleId()).split(",", -1)) && roleNames.length > 0) {
            for (String roleName : roleNames) {
                roles.add(roleName);
            }
        }
        return roles;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body.getBytes(Charset.forName("UTF-8")));
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }
}

