/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.controller;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.ocs.bo.GrabTaskStatisticsReqBO;
import com.tydic.nicc.ocs.bo.MarketingTimedTaskReq;
import com.tydic.nicc.ocs.bo.NumberAttributeReq;
import com.tydic.nicc.ocs.bo.PushCallRecordReqBO;
import com.tydic.nicc.ocs.bo.TenantDataReqBO;
import com.tydic.nicc.ocs.bo.TenantEvaluateTaskReqBO;
import com.tydic.nicc.ocs.service.ObCallRecordService;
import com.tydic.nicc.ocs.service.OperationIssuedService;
import com.tydic.nicc.ocs.service.SeatsEtaStatisticsService;
import com.tydic.nicc.ocs.service.SeatsStatisticsService;
import com.tydic.nicc.ocs.service.TenantActivityTypeService;
import com.tydic.nicc.ocs.service.TimedTasks;
import com.tydic.nicc.ocs.utils.DateUtil;
import java.util.Date;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/3571ea912a6ec5ea/"})
public class TimingTaskController {
    private static final Logger log = LoggerFactory.getLogger(TimingTaskController.class);
    @DubboReference
    private SeatsStatisticsService seatsStatisticsService;
    @DubboReference
    private SeatsEtaStatisticsService seatsEtaStatisticsService;
    @DubboReference
    private ObCallRecordService obCallRecordService;
    @DubboReference
    private OperationIssuedService operationIssuedService;
    @DubboReference
    private TenantActivityTypeService tenantActivityTypeService;
    @DubboReference
    private TimedTasks timedTasks;

    @RequestMapping(value={"seatsDayStatistics"})
    public Rsp seatsDayStatistics(String date) {
        return this.seatsStatisticsService.seatsDayStatistics(date);
    }

    @RequestMapping(value={"seatsEtaDayStatistics"})
    public Rsp seatsEtaDayStatistics(String statisticsDate) {
        return this.seatsEtaStatisticsService.seatsEtaDayStatistics(statisticsDate);
    }

    @RequestMapping(value={"pushCallRecord"})
    public Rsp pushCallRecord(@RequestBody PushCallRecordReqBO reqBO) {
        return this.obCallRecordService.pushCallRecord(reqBO.getHours(), reqBO.getEndTime());
    }

    @RequestMapping(value={"marketingNumStatistics"})
    public Rsp marketingNumStatistics(Integer hour) {
        return this.operationIssuedService.marketingNumStatistics(hour);
    }

    @RequestMapping(value={"callRecordIssued"})
    public Rsp callRecordIssued(String tenantCode, String ucId) {
        return this.operationIssuedService.callRecordIssued(tenantCode, ucId);
    }

    @RequestMapping(value={"blackListIssued"})
    public Rsp blackListIssued(String blackId, String operation, String channel) {
        return this.operationIssuedService.blackListIssued(blackId, operation, channel);
    }

    @RequestMapping(value={"callTaskIssued"})
    public Rsp callTaskIssued(String taskId) {
        return this.operationIssuedService.callTaskIssued(taskId);
    }

    @RequestMapping(value={"tenantActivityTypeStat"})
    public void tenantActivityTypeStat(Date statTime) {
        this.tenantActivityTypeService.tenantActivityTypeStat(statTime);
    }

    @RequestMapping(value={"scriptRecordTask"})
    public void scTK() {
        long startMillis = System.currentTimeMillis();
        TenantDataReqBO reqBO = new TenantDataReqBO();
        Date yesterday = DateUtil.getYesterday();
        String startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
        String endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        log.info("\u5f00\u59cb\u65f6\u95f4={}", (Object)startTimeStr);
        log.info("\u7ed3\u675f\u65f6\u95f4={}", (Object)endTimeStr);
        reqBO.setStartTime(startTimeStr);
        reqBO.setEndTime(endTimeStr);
        try {
            this.timedTasks.scriptRecordTask(reqBO);
        }
        catch (Exception e) {
            log.error("\u95ee\u5377\u8bb0\u5f55-\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f={}", (Object)e.getMessage());
        }
        long endMillis = System.currentTimeMillis();
        log.info("\u95ee\u5377\u8bb0\u5f55\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u8017\u65f6 {} \u79d2", (Object)((endMillis - startMillis) / 1000L));
    }

    @RequestMapping(value={"tenantDataTask"})
    public void teDTK() {
        long startMillis = System.currentTimeMillis();
        TenantDataReqBO reqBO = new TenantDataReqBO();
        Date yesterday = DateUtil.getYesterday();
        String startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
        String endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        log.info("\u5f00\u59cb\u65f6\u95f4={}", (Object)startTimeStr);
        log.info("\u7ed3\u675f\u65f6\u95f4={}", (Object)endTimeStr);
        reqBO.setStartTime(startTimeStr);
        reqBO.setEndTime(endTimeStr);
        try {
            this.timedTasks.tenantDataTask(reqBO);
        }
        catch (Exception e) {
            log.error("\u79df\u6237\u6570\u636e-\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38");
        }
        long endMillis = System.currentTimeMillis();
        log.info("\u79df\u6237\u6570\u636e\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u8017\u65f6 {} \u79d2", (Object)((endMillis - startMillis) / 1000L));
    }

    @RequestMapping(value={"marketingTask"})
    public void maTK() {
        long startMillis = System.currentTimeMillis();
        MarketingTimedTaskReq req = new MarketingTimedTaskReq();
        Date yesterday = DateUtil.getYesterday();
        String startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
        String endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        log.info("\u5f00\u59cb\u65f6\u95f4={}", (Object)startTimeStr);
        log.info("\u7ed3\u675f\u65f6\u95f4={}", (Object)endTimeStr);
        req.setStartTime(startTimeStr);
        req.setEndTime(endTimeStr);
        try {
            this.timedTasks.marketingTask(req);
        }
        catch (Exception e) {
            log.error("\u8425\u9500\u4efb\u52a1-\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38");
        }
        long endMillis = System.currentTimeMillis();
        log.info("\u8425\u9500\u4efb\u52a1\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u8017\u65f6 {} \u79d2", (Object)((endMillis - startMillis) / 1000L));
    }

    @RequestMapping(value={"numberAttributeTask"})
    public void nuATk() {
        long startMillis = System.currentTimeMillis();
        NumberAttributeReq reqBO = new NumberAttributeReq();
        Date yesterday = DateUtil.getYesterday();
        String startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
        String endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        log.info("\u5f00\u59cb\u65f6\u95f4={}", (Object)startTimeStr);
        log.info("\u7ed3\u675f\u65f6\u95f4={}", (Object)endTimeStr);
        reqBO.setStartTime(startTimeStr);
        reqBO.setEndTime(endTimeStr);
        try {
            this.timedTasks.numberAttributeTask(reqBO);
        }
        catch (Exception e) {
            log.error("\u53f7\u7801\u5f52\u5c5e\u5730-\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38");
            e.printStackTrace();
        }
        long endMillis = System.currentTimeMillis();
        log.info("\u53f7\u7801\u5f52\u5c5e\u5730\u7684\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff0c\u8017\u65f6 {} \u79d2", (Object)((endMillis - startMillis) / 1000L));
    }

    @RequestMapping(value={"tenantEvaluateTask"})
    public Rsp tenantEvaluateTask(@RequestBody TenantEvaluateTaskReqBO reqBO) {
        return this.timedTasks.tenantEvaluateTask(reqBO);
    }

    @RequestMapping(value={"grabTimeTask"})
    public Rsp grabTimeTask(@RequestBody GrabTaskStatisticsReqBO reqBO) {
        return this.timedTasks.grabTimeTask(reqBO);
    }
}

