/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.issued;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.jobNumber.JobNumberBO;
import com.tydic.nicc.dc.bo.script.QryConfigScriptRspBO;
import com.tydic.nicc.dc.bo.script.QryScriptQuestionRspBO;
import com.tydic.nicc.dc.bo.script.ScriptQuestionOptionsBO;
import com.tydic.nicc.dc.bo.specialPhone.SpecialPhoneBO;
import com.tydic.nicc.dc.bo.user.BladeUserBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.jobNumber.inter.DcJobNumberInterService;
import com.tydic.nicc.dc.script.inter.ScriptInterService;
import com.tydic.nicc.dc.specialPhone.inter.SpecialPhoneInterService;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.CallRecordIssuedBO;
import com.tydic.nicc.ocs.bo.GeneralCodeBO;
import com.tydic.nicc.ocs.bo.QuestBO;
import com.tydic.nicc.ocs.bo.QuestOptionBO;
import com.tydic.nicc.ocs.mapper.ObCallRecordAnswerMapper;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCalledRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCustServeRecordDAO;
import com.tydic.nicc.ocs.mapper.ObDataTargetDAO;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.ObTaskScriptDAO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordAnswer;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObCalledRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObCustServeRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskScriptPO;
import com.tydic.nicc.ocs.service.CodeService;
import com.tydic.nicc.ocs.service.OperationIssuedService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@DubboService
public class OperationIssuedServiceImpl
implements OperationIssuedService {
    private static final Logger log = LoggerFactory.getLogger(OperationIssuedServiceImpl.class);
    @Resource
    private ObCallRecordDAO obCallRecordDAO;
    @Resource
    private ObCustServeRecordDAO obCustServeRecordDAO;
    @Resource
    private ObTaskScriptDAO obTaskScriptDAO;
    @Resource
    private ObCallRecordAnswerMapper obCallRecordAnswerMapper;
    @Resource
    private ObTaskInfoDAO obTaskInfoDAO;
    @Resource
    private ObDataTargetDAO obDataTargetDAO;
    @Resource
    private ObCalledRecordDAO obCalledRecordDAO;
    @Resource
    private CodeService codeService;
    @DubboReference
    private DcJobNumberInterService dcJobNumberInterService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @DubboReference
    private ScriptInterService scriptInterService;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private SpecialPhoneInterService specialPhoneInterService;
    private static final String CODE_TYPE = "CALLED_TABLE_NAME";

    public Rsp callRecordIssued(String tenantCode, String ucId) {
        log.info("\u8fdb\u5165\u5904\u7406\u5916\u547c\u660e\u7ec6\u63a5\u53e3\uff0c tenantId\uff1a{}\uff0c ucId\uff1a{}", (Object)tenantCode, (Object)ucId);
        HashMap<String, String> map = new HashMap<String, String>();
        CallRecordIssuedBO issuedBO = new CallRecordIssuedBO();
        try {
            if (StringUtils.isEmpty((Object)tenantCode)) {
                log.error("\u79df\u6237\u7f16\u7801\u4e3a\u7a7a\uff01");
                return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)ucId)) {
                log.error("ucId\u4e3a\u7a7a\uff01");
                return BaseRspUtils.createErrorRsp((String)"ucId\u4e3a\u7a7a");
            }
            BladeTenantBO tenantInfo = this.getTenantInfo(tenantCode);
            ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
            obCallRecordPO.setTenantId(tenantCode);
            obCallRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
            obCallRecordPO.setUcId(ucId);
            ObCallRecordPO recordPO = this.obCallRecordDAO.selectByUcId(obCallRecordPO);
            log.info("\u67e5\u8be2\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)recordPO));
            if (recordPO == null) {
                log.info("\u672a\u67e5\u8be2\u5230\u5916\u547c\u8bb0\u5f55");
                return BaseRspUtils.createSuccessRsp((Object)"\u672a\u67e5\u8be2\u5230\u5916\u547c\u8bb0\u5f55");
            }
            String TASK_ID = recordPO.getTaskId();
            issuedBO.setTASK_ID(TASK_ID);
            map.put("CALLER", recordPO.getCalling());
            issuedBO.setCALLER(recordPO.getCalling());
            map.put("CALLED", recordPO.getCalled());
            issuedBO.setCALLED(recordPO.getCalled());
            map.put("CALL_STARTTIME", recordPO.getStartTime());
            issuedBO.setCALL_STARTTIME(recordPO.getStartTime());
            map.put("CALL_ENDTIME", recordPO.getEndTime());
            issuedBO.setCALL_ENDTIME(recordPO.getEndTime());
            map.put("TIME_LENGTH", recordPO.getContactLength());
            issuedBO.setTIME_LENGTH(recordPO.getContactLength());
            String isConn = "0";
            if (recordPO.getIsConn().equals("1") && recordPO.getObsIsConn().equals("1")) {
                isConn = "1";
            }
            map.put("IS_CONNECT", isConn);
            issuedBO.setIS_CONNECT(isConn);
            map.put("IS_RECORD", StringUtils.isEmpty((Object)recordPO.getRecordFile()) ? "0" : "1");
            issuedBO.setIS_RECORD(StringUtils.isEmpty((Object)recordPO.getRecordFile()) ? "0" : "1");
            if (isConn.equals("1")) {
                List obCustServeRecordList = this.obCustServeRecordDAO.selectByUcId(tenantInfo.getTenantOtherName(), ucId);
                log.info("\u83b7\u53d6\u5750\u5e2d\u670d\u52a1\u8bb0\u5f55Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCustServeRecordList));
                if (!StringUtils.isEmpty((Object)recordPO.getJobNumber())) {
                    BladeUserBO userBO;
                    issuedBO.setWORKNO(recordPO.getJobNumber());
                    JobNumberBO jobNumberBO = this.dcJobNumberInterService.queryJobNumberInfo(recordPO.getJobNumber());
                    log.info("\u83b7\u53d6\u5de5\u53f7\u4fe1\u606f\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)jobNumberBO));
                    if (jobNumberBO != null && (userBO = this.bladeUserInterService.queryUserInfo(jobNumberBO.getUserId())) != null) {
                        map.put("EMP_NAME", userBO.getName());
                        issuedBO.setEMP_NAME(userBO.getName());
                        map.put("EMP_CODE", userBO.getAccount());
                        issuedBO.setEMP_CODE(userBO.getAccount());
                    }
                }
                ObTaskScriptPO obTaskScriptPO = this.obTaskScriptDAO.selectByTaskId(recordPO.getTaskId());
                log.info("\u83b7\u53d6\u95ee\u5377\u4fe1\u606fMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskScriptPO));
                if (obTaskScriptPO != null) {
                    issuedBO.setHAS_QUEST_FLAG("1");
                    issuedBO.setQUESTIONNAIRE_ID(obTaskScriptPO.getScriptId());
                    QryConfigScriptRspBO scriptRspBO = this.scriptInterService.queryConfigScript(obTaskScriptPO.getScriptId());
                    issuedBO.setQUESTIONNAIRE_NAME(scriptRspBO.getScriptName());
                    List bos = this.scriptInterService.qryScriptQuestion(obTaskScriptPO.getScriptId());
                    log.info("\u83b7\u53d6\u95ee\u5377\u811a\u672c\u5177\u4f53\u4fe1\u606fMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)bos));
                    if (bos != null && bos.size() > 0) {
                        ArrayList<QuestBO> questBOS = new ArrayList<QuestBO>();
                        for (QryScriptQuestionRspBO bo : bos) {
                            QuestBO questBO = new QuestBO();
                            questBO.setQUEST_ID(bo.getQuestionId());
                            questBO.setQUEST_CODE(bo.getSort() == null ? "" : bo.getSort().toString());
                            questBO.setQUEST_TYPE(bo.getQuestionType() == null ? "" : bo.getQuestionType().toString());
                            questBO.setQUEST_DESC(bo.getQuestionTitle());
                            List questionOptions = bo.getQuestionOptions();
                            ArrayList<QuestOptionBO> optionBOS = new ArrayList<QuestOptionBO>();
                            if (questionOptions != null && questionOptions.size() > 0) {
                                for (ScriptQuestionOptionsBO optionsBO : questionOptions) {
                                    QuestOptionBO optionBO = new QuestOptionBO();
                                    if (bo.getQuestionType() != 3) {
                                        optionBO.setQUEST_OPTION_ID(optionsBO.getOption());
                                        optionBO.setQUEST_OPTION_DESC(optionsBO.getOptionValue());
                                        if (obCustServeRecordList != null && !obCustServeRecordList.isEmpty()) {
                                            ObCallRecordAnswer answer = this.obCallRecordAnswerMapper.selectByQuestionId(Long.valueOf(Long.parseLong(bo.getQuestionId())), ((ObCustServeRecordPO)obCustServeRecordList.get(0)).getCallId(), optionsBO.getOption());
                                            log.info("\u83b7\u53d6\u7528\u6237\u9009\u9879Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)answer));
                                            if (answer != null) {
                                                optionBO.setQUEST_OPTION_SELECTED("0");
                                            }
                                        } else {
                                            optionBO.setQUEST_OPTION_SELECTED("1");
                                        }
                                    }
                                    optionBOS.add(optionBO);
                                }
                                questBO.setQUEST_OPTIONS(optionBOS);
                                questBOS.add(questBO);
                            } else if (bo.getQuestionType() == 3) {
                                QuestOptionBO optionBO = new QuestOptionBO();
                                if (obCustServeRecordList != null && !obCustServeRecordList.isEmpty()) {
                                    ObCallRecordAnswer answer = this.obCallRecordAnswerMapper.selectByQuestionId(Long.valueOf(Long.parseLong(bo.getQuestionId())), ((ObCustServeRecordPO)obCustServeRecordList.get(0)).getCallId(), null);
                                    log.info("\u83b7\u53d6\u7528\u6237\u586b\u7a7aMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)answer));
                                    if (answer != null) {
                                        optionBO.setQUEST_OPTION_CONTENT(StringUtils.isEmpty((Object)answer.getAnswer()) ? "" : answer.getAnswer());
                                    }
                                } else {
                                    optionBO.setQUEST_OPTION_SELECTED("1");
                                }
                                optionBOS.add(optionBO);
                                questBO.setQUEST_OPTIONS(optionBOS);
                                questBOS.add(questBO);
                            } else {
                                questBOS.add(questBO);
                            }
                            issuedBO.setQUESTIONNAIRE_CONTENT(questBOS);
                        }
                    } else {
                        issuedBO.setQUESTIONNAIRE_CONTENT(new ArrayList());
                    }
                } else {
                    issuedBO.setHAS_QUEST_FLAG("0");
                    issuedBO.setQUESTIONNAIRE_ID("");
                    issuedBO.setQUESTIONNAIRE_NAME("");
                }
            } else {
                issuedBO.setWORKNO("NONE");
                issuedBO.setEMP_NAME("NONE");
                issuedBO.setEMP_CODE("NONE");
                issuedBO.setEMP_CODE("NONE");
                issuedBO.setHAS_QUEST_FLAG("0");
                issuedBO.setQUESTIONNAIRE_ID("");
                issuedBO.setQUESTIONNAIRE_NAME("");
                issuedBO.setQUESTIONNAIRE_CONTENT(new ArrayList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseRspUtils.createSuccessRsp((Object)JSONObject.toJSONString((Object)issuedBO));
    }

    public Rsp blackListIssued(String blackId, String operation, String channel) {
        log.info("\u8fdb\u5165\u9ed1\u540d\u5355\u76d1\u63a7\u63a5\u53e3\uff0c blackId\uff1a{}, operation:{}", (Object)blackId, (Object)operation);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (StringUtils.isEmpty((Object)blackId)) {
                log.error("\u9ed1\u540d\u5355Id\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"\u9ed1\u540d\u5355id\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)operation)) {
                log.error("\u53f7\u7801\u64cd\u4f5c\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"\u53f7\u7801\u64cd\u4f5c\u4e3a\u7a7a");
            }
            SpecialPhoneBO phoneBO = this.specialPhoneInterService.querySpecialPhone(blackId);
            log.info("\u83b7\u53d6\u9ed1\u540d\u5355\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)phoneBO));
            map.put("PRO_ID", "");
            map.put("ORG_ID", "");
            map.put("LINE_ID", "");
            map.put("CALL_NUMBER", StringUtils.isEmpty((Object)phoneBO.getPhoneNo()) ? "" : phoneBO.getPhoneNo());
            map.put("INPUT_TIME", StringUtils.isEmpty((Object)phoneBO.getAddTime()) ? "" : phoneBO.getAddTime());
            map.put("INPUT_TYPE", StringUtils.isEmpty((Object)phoneBO.getAddReason()) ? "" : phoneBO.getAddReason());
            map.put("CHANNEL", channel);
            map.put("INTERFACE_TYPE", StringUtils.isEmpty((Object)phoneBO.getInterfaceType()) ? "" : phoneBO.getInterfaceType());
            map.put("OPERATION", operation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("json:{}", (Object)JSON.toJSONString(map));
        return BaseRspUtils.createSuccessRsp((Object)JSON.toJSONString(map));
    }

    public Rsp callTaskIssued(String taskId) {
        log.info("\u8fdb\u5165\u5916\u547c\u4efb\u52a1\u63a5\u53e3\uff0c taskId\uff1a{}", (Object)taskId);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (StringUtils.isEmpty((Object)taskId)) {
                log.error("\u4efb\u52a1ID\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1ID\u4e3a\u7a7a");
            }
            ObTaskInfoPO obTaskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(taskId);
            log.info("\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u4efb\u52a1\u4fe1\u606fMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskInfoPO));
            map.put("PRO_ID", "");
            map.put("ORG_ID", "");
            map.put("LINE_ID", "");
            map.put("TASK_NAME", StringUtils.isEmpty((Object)obTaskInfoPO.getTaskName()) ? "" : obTaskInfoPO.getTaskName());
            map.put("TASK_ID", StringUtils.isEmpty((Object)obTaskInfoPO.getTaskId()) ? "" : obTaskInfoPO.getTaskId());
            map.put("START_TIME", StringUtils.isEmpty((Object)obTaskInfoPO.getStartTime()) ? "" : obTaskInfoPO.getStartTime());
            map.put("END_TIME", StringUtils.isEmpty((Object)obTaskInfoPO.getEndTime()) ? "" : obTaskInfoPO.getEndTime());
            map.put("STATE", StringUtils.isEmpty((Object)obTaskInfoPO.getTaskStatus()) ? "" : (obTaskInfoPO.getTaskStatus().equalsIgnoreCase("waiting") ? "0" : (obTaskInfoPO.getTaskStatus().equalsIgnoreCase("running") ? "1" : "2")));
            String custAmount = "";
            String successAmount = "";
            String giveUpAmount = "";
            String hangUpAmount = "";
            String whitelistAmount = "";
            if (obTaskInfoPO != null) {
                List targetPOS = this.obDataTargetDAO.selectDatasByTaskId(taskId, obTaskInfoPO.getTenantSortCode());
                log.info("\u83b7\u53d6\u5df2\u7ed1\u5b9a\u5f97\u4efb\u52a1\u6570\u636eMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)targetPOS));
                int size = targetPOS.size();
                custAmount = Integer.toString(size);
                ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
                obCallRecordPO.setTaskId(taskId);
                obCallRecordPO.setTenantOtherName(obTaskInfoPO.getTenantSortCode());
                obCallRecordPO.setTenantId(obTaskInfoPO.getTaskId());
                List callRecordPOS = this.obCallRecordDAO.selectByTaskId(obCallRecordPO);
                log.info("\u83b7\u53d6\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)callRecordPOS));
                long successConn = callRecordPOS.stream().filter(record -> record.getIsConn().equals("1") && record.getObsIsConn().equals("1")).count();
                successAmount = Long.toString(successConn);
                long giveUpConn = callRecordPOS.stream().filter(record -> record.getIsConn().equals("0") && record.getObsIsConn().equals("1")).count();
                giveUpAmount = Long.toString(giveUpConn);
            }
            map.put("CUST_AMOUNT", custAmount);
            map.put("DIAL_METHOD", obTaskInfoPO.getCallType().equals("0") ? "2" : obTaskInfoPO.getCallType());
            map.put("SUCCESS_AMOUNT", successAmount);
            map.put("GIVE_UP_AMOUNT", giveUpAmount);
            map.put("HANG_UP_AMOUNT", hangUpAmount);
            map.put("WHITELIST_AMOUNT", whitelistAmount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("map:{}", (Object)JSONObject.toJSONString(map));
        return BaseRspUtils.createSuccessRsp((Object)JSONObject.toJSONString(map));
    }

    public Rsp marketingNumStatistics(Integer hour) {
        log.info("\u8fdb\u5165\u5916\u547c\u7cfb\u7edf\u8425\u9500\u6b21\u6570\u7edf\u8ba1\u63a5\u53e3\uff0c hour\uff1a{}", (Object)hour);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList mapList = new ArrayList();
        try {
            Date date = new Date();
            Date beforeOneHourStartTime = this.beforeOneHourToNowDate(date, 3);
            Date beforeOneStartTime = this.beforeOneHourToNowDate(date, 3);
            Date beforeOneHourEndTime = this.beforeOneHourToNowDate(date, 1);
            String beforeOneMonthTime = this.getBeforeMonthTime(beforeOneStartTime, 1);
            String beforeSixMonthTime = this.getBeforeMonthTime(beforeOneStartTime, 6);
            List general = this.codeService.getGeneral(CODE_TYPE);
            log.info("\u83b7\u53d6\u88ab\u53eb\u8bb0\u5f55\u8868\u540d\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)general));
            for (GeneralCodeBO codeBO : general) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                ObCalledRecordPO recordPO = new ObCalledRecordPO();
                recordPO.setTableName(codeBO.getCodeValue());
                recordPO.setBeforeMonthStartTime(format.format(beforeOneHourStartTime));
                recordPO.setCurrentEndTime(format.format(beforeOneHourEndTime));
                log.info("\u5916\u547c\u7cfb\u7edf\u8425\u9500\u6b21\u6570\u7edf\u8ba1Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)recordPO));
                List recordPOS = this.obCalledRecordDAO.selectMarkingNUm(recordPO);
                log.info("\u5916\u547c\u7cfb\u7edf\u8425\u9500\u6b21\u6570\u7edf\u8ba1Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)recordPOS));
                if (recordPOS == null || recordPOS.size() <= 0) continue;
                for (ObCalledRecordPO po : recordPOS) {
                    ObCalledRecordPO calledRecordPO = new ObCalledRecordPO();
                    calledRecordPO.setCurrentEndTime(format.format(beforeOneHourEndTime));
                    calledRecordPO.setBeforeOneMonthStartTime(beforeOneMonthTime);
                    calledRecordPO.setBeforeSixMonthStartTime(beforeSixMonthTime);
                    calledRecordPO.setTableName(codeBO.getCodeValue());
                    calledRecordPO.setCalled(po.getCalled());
                    log.info("\u5f53\u524d\u8868\u540d\uff1a{}\uff0c \u83b7\u53d6\u5f53\u524d\u624b\u673a\u53f7\u5916\u547c\u8425\u9500\u6b21\u6570Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)codeBO.getCodeValue(), (Object)JSONObject.toJSONString((Object)calledRecordPO));
                    ObCalledRecordPO calledRecord = this.obCalledRecordDAO.selectCalledMarketingNum(calledRecordPO);
                    log.info("\u83b7\u53d6\u5f53\u524d\u624b\u673a\u53f7\u5916\u547c\u8425\u9500\u6b21\u6570Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)calledRecord));
                    map.put("CALLED_NUMBER", po.getCalled());
                    map.put("MONTH_MARKET_NUM", calledRecord.getOneMonthCallNum());
                    map.put("HALFYEAR_MARKET_NUM", calledRecord.getSixMonthCallNum());
                    mapList.add(map);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp(mapList);
    }

    private BladeTenantBO getTenantInfo(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }

    private String getBeforeMonthTime(Date date, Integer num) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -num.intValue());
        Date m = c.getTime();
        String mon = format.format(m);
        log.info("\u8fc7\u53bb{}\u4e2a\u6708\u65f6\u95f4\uff1a{}", (Object)num, (Object)mon);
        return mon;
    }

    private Date beforeOneHourToNowDate(Date date, Integer flag) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(11, -1);
        if (flag == 1) {
            c.set(12, 59);
            c.set(13, 59);
        } else if (flag == 2) {
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
        } else {
            c.set(12, 0);
            c.set(13, 0);
        }
        Date m = c.getTime();
        log.info("\u8fc7\u53bb1\u5c0f\u65f6\u65f6\u95f4\uff1a{}", (Object)m);
        return m;
    }
}

