/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.LoginInfo;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.bo.user.BladeUserBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.IsvLogoutReqBO;
import com.tydic.nicc.ocs.isv.IsvLogoutService;
import com.tydic.nicc.ocs.isv.StatusControlService;
import com.tydic.nicc.ocs.isv.bo.AgentStateBO;
import com.tydic.nicc.ocs.isv.bo.ForceLogoutBO;
import com.tydic.nicc.ocs.isv.bo.GetAgentStatusBO;
import com.tydic.nicc.ocs.isv.bo.ISVRestResponseBO;
import com.tydic.nicc.ocs.utils.SessionMap;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@DubboService
public class IsvLogoutServiceImpl
implements IsvLogoutService {
    private static final Logger log = LoggerFactory.getLogger(IsvLogoutServiceImpl.class);
    @Resource
    private StatusControlService statusControlService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;

    public Rsp isvLogout(IsvLogoutReqBO reqBO) {
        log.info("\u8fdb\u5165\u6267\u884c\u5f3a\u5236\u7b7e\u51fa\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        try {
            if (StringUtils.isEmpty((Object)reqBO.getActionJobCode())) {
                return BaseRspUtils.createErrorRsp((String)"\u5206\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            LoginInfo loginInfo = reqBO.getLoginInfo();
            if (null == loginInfo) {
                return BaseRspUtils.createErrorRsp((String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
            }
            BladeUserBO userBO = this.bladeUserInterService.queryUserInfo(loginInfo.getUserId());
            log.info("\u5f53\u524d\u7ec4\u5750\u5e2d\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)userBO));
            if (null == userBO) {
                return BaseRspUtils.createErrorRsp((String)"\u9519\u8bef\u7684\u5750\u5e2d\u4fe1\u606f");
            }
            if (!reqBO.getActionJobCode().equals(userBO.getJobNumberCode())) {
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u68c0\u67e5\u5206\u673a\u53f7");
            }
            GetAgentStatusBO agentStatusBO = new GetAgentStatusBO();
            agentStatusBO.setAgentId(reqBO.getActionJobCode());
            ISVRestResponseBO isvRsp = this.statusControlService.getAgentState(agentStatusBO);
            if (null == isvRsp || null == isvRsp.getData()) {
                return BaseRspUtils.createErrorRsp((String)"\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
            }
            AgentStateBO agentStateBO = (AgentStateBO)isvRsp.getData();
            if (SessionMap.HS_LOGOUT.equals(agentStateBO.getAgentStatus())) {
                return BaseRspUtils.createErrorRsp((String)"\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
            }
            ForceLogoutBO forceLogout = new ForceLogoutBO();
            forceLogout.setAgentId(reqBO.getActionJobCode());
            ISVRestResponseBO forceLogoutRsp = this.statusControlService.forceLogout(forceLogout);
            if (null == forceLogoutRsp || 0 != forceLogoutRsp.getStatus()) {
                log.error("\u4e1a\u52a1\u5f02\u5e38\uff1a\u5ba2\u670d[{}]\u5f3a\u5236\u7b7e\u51fa\u5931\u8d25,\u5931\u8d25\u539f\u56e0:{}", (Object)reqBO.getActionJobCode(), (Object)(null == forceLogoutRsp ? "\u672a\u77e5" : forceLogoutRsp.getMessage()));
            }
        }
        catch (Exception e) {
            log.error("\u5f3a\u5236\u7b7e\u51fa\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)"\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }
}

