/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.statistics;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tydic.nicc.dc.base.bo.LoginInfo;
import com.tydic.nicc.dc.base.bo.Req;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantListReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantListRspBO;
import com.tydic.nicc.dc.bo.script.QueryScriptQuestionRspBO;
import com.tydic.nicc.dc.bo.script.ScriptQuestionOptionsBO;
import com.tydic.nicc.dc.bo.user.BladeUserBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.script.inter.ScriptInterService;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.CallRecordHistoryBO;
import com.tydic.nicc.ocs.bo.EsCallRecordHistoryBO;
import com.tydic.nicc.ocs.bo.ExcelEsSeatsCallHistoryBO;
import com.tydic.nicc.ocs.bo.ExportRspBO;
import com.tydic.nicc.ocs.bo.GetCustomerNumHistoryReqBO;
import com.tydic.nicc.ocs.bo.GetCustomerNumHistoryRspBO;
import com.tydic.nicc.ocs.bo.GetEsSeatsCallHistoryReqBO;
import com.tydic.nicc.ocs.bo.GetSeatsCallHistoryReqBO;
import com.tydic.nicc.ocs.bo.OptionsBO;
import com.tydic.nicc.ocs.bo.ProductSubscribeBO;
import com.tydic.nicc.ocs.bo.QryCallRecordReqBO;
import com.tydic.nicc.ocs.bo.QryDataPropertyReqBO;
import com.tydic.nicc.ocs.bo.QryDataPropertyRspBO;
import com.tydic.nicc.ocs.bo.QryEsCallRecordReqBO;
import com.tydic.nicc.ocs.bo.QryScriptAnswerReqBO;
import com.tydic.nicc.ocs.bo.QryScriptAnswerRspBO;
import com.tydic.nicc.ocs.bo.QryUpdRecordLogsReqBO;
import com.tydic.nicc.ocs.bo.QryUpdRecordLogsRspBO;
import com.tydic.nicc.ocs.bo.UpdateMarketingReqBO;
import com.tydic.nicc.ocs.bo.UserPurposeReqBO;
import com.tydic.nicc.ocs.cache.AreaCache;
import com.tydic.nicc.ocs.cache.LocalCache;
import com.tydic.nicc.ocs.constant.OcsConstant;
import com.tydic.nicc.ocs.mapper.ObCallRecordAnswerMapper;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCustServeRecordDAO;
import com.tydic.nicc.ocs.mapper.ObDataTargetDAO;
import com.tydic.nicc.ocs.mapper.ObProductSubscribeDAO;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.ObUpdRecordLogDAO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordAnswer;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObCustServeRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObDataTargetPO;
import com.tydic.nicc.ocs.mapper.po.ObProductSubscribePO;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.mapper.po.ObUpdRecordLogPO;
import com.tydic.nicc.ocs.service.HistoryService;
import com.tydic.nicc.ocs.service.ProductSubscribeService;
import com.tydic.nicc.ocs.service.TaskQueryAboutService;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelManageCallHistoryBO;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelSeatsCallHistoryBO;
import com.tydic.nicc.ocs.utils.DateUtil;
import com.tydic.nicc.ocs.utils.ExcelHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.frameworkset.elasticsearch.boot.BBossESStarter;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@DubboService
public class HistoryServiceImpl
implements HistoryService {
    private static final Logger log = LoggerFactory.getLogger(HistoryServiceImpl.class);
    @Resource
    private ObCallRecordDAO obCallRecordDAO;
    @Resource
    private ObCustServeRecordDAO obCustServeRecordDAO;
    @Resource
    private ObTaskInfoDAO obTaskInfoDAO;
    @Resource
    private ObDataTargetDAO obDataTargetDAO;
    @Resource
    private ObProductSubscribeDAO obProductSubscribeDAO;
    @Resource
    private ObCallRecordAnswerMapper obCallRecordAnswerMapper;
    @Resource
    private ObUpdRecordLogDAO obUpdRecordLogDAO;
    @Resource
    private TaskQueryAboutService taskQueryAboutService;
    @Resource
    private ProductSubscribeService productSubscribeService;
    @Resource
    private BBossESStarter bBossEsStarter;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @DubboReference
    private ScriptInterService scriptInterService;
    @Resource
    private ExcelHelper excelHelper;
    @Value(value="${file.path.ftUrl:http://192.168.10.112:8088/upload/}")
    private String path;
    @Value(value="${spring.elasticsearch.indexName}")
    private String indexName;
    private static final Integer LIMIT = 1000;

    public RspList getCustomerNumHistory(GetCustomerNumHistoryReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u5ba2\u6237\u53f7\u7801\u88ab\u547c\u8bb0\u5f55\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        if (StringUtils.isEmpty((Object)reqBO.getCalled())) {
            log.error("\u5ba2\u6237\u53f7\u7801\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRspList((String)"\u5ba2\u6237\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BladeTenantBO tenantInfo = this.getTenantInfo(reqBO.getTenantCode());
        if (tenantInfo == null) {
            return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
        }
        String tableNameByModelNO = LocalCache.getCallRecordTableNameByModelNO(reqBO.getCalled());
        log.info("tableNameByModelNO:{}", (Object)tableNameByModelNO);
        ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
        obCallRecordPO.setCalled(reqBO.getCalled());
        obCallRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        log.info("\u67e5\u8be2\u5ba2\u6237\u53f7\u7801\u88ab\u53eb\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCallRecordPO));
        PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        List recordPOList = this.obCallRecordDAO.selectByCalled(obCallRecordPO);
        PageInfo pageInfo = new PageInfo(recordPOList);
        log.info("\u67e5\u8be2\u5ba2\u6237\u53f7\u7801\u88ab\u53eb\u8bb0\u5f55Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)recordPOList));
        ArrayList<GetCustomerNumHistoryRspBO> rspBOS = new ArrayList<GetCustomerNumHistoryRspBO>();
        if (recordPOList != null && recordPOList.size() > 0) {
            for (ObCallRecordPO recordPO : recordPOList) {
                GetCustomerNumHistoryRspBO rspBO = new GetCustomerNumHistoryRspBO();
                BeanUtils.copyProperties((Object)recordPO, (Object)rspBO);
                if (recordPO.getIsConn().equals("1") && recordPO.getObsIsConn().equals("1")) {
                    rspBO.setConnStatus("\u5df2\u63a5\u901a");
                } else {
                    rspBO.setConnStatus("\u672a\u63a5\u901a");
                }
                rspBOS.add(rspBO);
            }
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)pageInfo.getTotal());
    }

    public RspList<CallRecordHistoryBO> getSeatsCallHistory(GetSeatsCallHistoryReqBO reqBO) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u4e2a\u4eba\u5916\u547c\u8bb0\u5f55\uff08\u5750\u5e2d\uff09\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        List<Object> rspBOS = new ArrayList<CallRecordHistoryBO>();
        Integer count = 0;
        if (StringUtils.isEmpty((Object)reqBO.getTenantCode())) {
            return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BladeTenantBO tenantInfo = this.getTenantInfo(reqBO.getTenantCode());
        if (tenantInfo == null) {
            return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
        }
        if (!DateUtil.checkTimeSpan(reqBO.getStartTime(), reqBO.getEndTime(), OcsConstant.SPAN_NUM).booleanValue()) {
            return BaseRspUtils.createErrorRspList((String)"\u6700\u5927\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u4e3a6\u4e2a\u6708");
        }
        List taskInfos = this.obTaskInfoDAO.getTaskInfo(reqBO.getStartTime(), reqBO.getEndTime());
        List<ObCustServeRecordPO> custServerRecords = this.getCustServerRecords(reqBO, tenantInfo);
        if (custServerRecords != null && custServerRecords.size() > 0) {
            for (ObCustServeRecordPO serveRecordPO : custServerRecords) {
                ObCallRecordPO record = this.getRecord(reqBO, tenantInfo, serveRecordPO.getUcId());
                if (record == null) {
                    log.info("\u5f53\u524ducId\uff1a{}, \u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5916\u547c\u8bb0\u5f55", (Object)serveRecordPO.getUcId());
                    continue;
                }
                CallRecordHistoryBO rspBO = this.getRspBO(serveRecordPO, record, taskInfos);
                rspBOS.add((CallRecordHistoryBO)((Object)rspBO));
            }
        } else {
            log.info("\u672a\u67e5\u8be2\u5230\u5916\u547c\u8bb0\u5f55");
        }
        if (null != rspBOS && rspBOS.size() > 0) {
            if (!StringUtils.isEmpty((Object)reqBO.getTaskName())) {
                rspBOS = this.filterList(rspBOS, reqBO.getTaskName());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getProductName())) {
                rspBOS = this.filterListByProductName(rspBOS, reqBO.getProductName());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getSuccessProduct())) {
                rspBOS = this.filterListBySuccessProductName(rspBOS, reqBO.getSuccessProduct());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getUserPurpose())) {
                rspBOS = this.filterListByUserPurpose(rspBOS, reqBO.getUserPurpose());
            }
        }
        count = rspBOS.size();
        rspBOS = rspBOS.stream().sorted(Comparator.comparing(CallRecordHistoryBO::getCreateTime).reversed()).collect(Collectors.toList());
        rspBOS = rspBOS.stream().skip(reqBO.getLimit() * (reqBO.getPage() - 1)).limit(reqBO.getLimit()).collect(Collectors.toList());
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)count.intValue());
    }

    public RspList qryCallRecord(QryCallRecordReqBO reqBO) {
        log.info("\u8fdb\u5165\u4ee5\u79df\u6237\u4e3a\u7ef4\u5ea6\u83b7\u53d6\u5916\u547c\u8bb0\u5f55\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        LoginInfo loginInfo = reqBO.getLoginInfo();
        List roleNames = this.bladeUserInterService.getUserRoleInfo(loginInfo.getUserId());
        Integer count = 0;
        if (!DateUtil.checkTimeSpan(reqBO.getStartTime(), reqBO.getEndTime(), OcsConstant.SPAN_NUM).booleanValue()) {
            return BaseRspUtils.createErrorRspList((String)"\u6700\u5927\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u4e3a6\u4e2a\u6708");
        }
        List taskInfos = this.obTaskInfoDAO.getTaskInfo(reqBO.getStartTime(), reqBO.getEndTime());
        ArrayList<String> tenantIds = new ArrayList<String>();
        List bladeTenants = null;
        Set roleSet = reqBO.getRoleSet();
        if (reqBO.getTenantIds() != null && reqBO.getTenantIds().size() > 0) {
            tenantIds.addAll(reqBO.getTenantIds());
        } else {
            tenantIds.add(reqBO.getTenantCode());
            for (String role : roleNames) {
                if (null == roleSet || StringUtils.isEmpty((Object)role) || !role.equals("system:admin") && !role.equals("system:administrator")) continue;
                Req req = new Req();
                req.setIn_tenantCode(req.getIn_tenantCode());
                req.setRoleSet(roleSet);
                bladeTenants = this.bladeTenantInterService.getBalseTenantList(req);
                if (null == bladeTenants) break;
                tenantIds.addAll(bladeTenants.stream().map(x -> x.getTenantId()).collect(Collectors.toList()));
                break;
            }
        }
        if (null != tenantIds && !tenantIds.isEmpty() && (null == bladeTenants || bladeTenants.isEmpty())) {
            Req req = new Req();
            req.setIn_tenantCode(req.getIn_tenantCode());
            req.setRoleSet(roleSet);
            req.setReqData(tenantIds);
            bladeTenants = this.bladeTenantInterService.getBalseTenantList(req);
        }
        List<Object> rspBOS = new ArrayList<CallRecordHistoryBO>();
        if (tenantIds == null || tenantIds.size() == 0) {
            log.info("tenantIds\u4e3a\u7a7a\uff0c \u67e5\u8be2\u6240\u6709\u79df\u6237\uff0c\u83b7\u53d6\u79df\u6237\u5217\u8868");
            GetBladeTenantListRspBO tenantRspBO = this.bladeTenantInterService.getBladeTenantList(new GetBladeTenantListReqBO());
            if (!tenantRspBO.getRspCode().equals("0000")) {
                log.error("\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
                return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
            }
            List bladeTenantBOS = tenantRspBO.getRows();
            if (bladeTenantBOS == null || bladeTenantBOS.size() == 0) {
                log.error("\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
                return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
            }
            for (BladeTenantBO tenantBO : bladeTenantBOS) {
                List<ObCallRecordPO> callRecordPOS = this.qryCallRecord(reqBO, tenantBO);
                if (callRecordPOS == null || callRecordPOS.size() == 0) {
                    log.info("\u5f53\u524d\u79df\u6237\uff1a{}\uff0c \u672a\u67e5\u8be2\u5230\u5916\u547c\u8bb0\u5f55", (Object)tenantBO.getTenantId());
                    continue;
                }
                ObCustServeRecordPO custServeRecordPO = new ObCustServeRecordPO();
                custServeRecordPO.setTenantOtherName(tenantBO.getTenantOtherName());
                custServeRecordPO.setTenantId(tenantBO.getTenantId());
                custServeRecordPO.setHandleResults(reqBO.getUserPurpose());
                custServeRecordPO.setQryStartTime(reqBO.getStartTime());
                custServeRecordPO.setQryEndTime(reqBO.getEndTime());
                List serveRecordPOS = this.obCustServeRecordDAO.queryServiceRecord(custServeRecordPO);
                for (ObCallRecordPO po : callRecordPOS) {
                    ObCustServeRecordPO serveRecordPO = null;
                    List collect = serveRecordPOS.stream().filter(serve -> po.getUcId().equals(serve.getUcId())).collect(Collectors.toList());
                    serveRecordPO = null == collect || collect.size() == 0 ? this.queryServiceCallRecord(reqBO, tenantBO, po.getUcId()) : (ObCustServeRecordPO)collect.get(0);
                    po.setTenantName(tenantBO.getTenantName());
                    CallRecordHistoryBO rspBO = this.getRspBO(serveRecordPO, po, taskInfos);
                    rspBOS.add(rspBO);
                }
            }
        } else if (null != bladeTenants) {
            for (BladeTenantBO tenantInfo : bladeTenants) {
                if (!tenantIds.contains(tenantInfo.getTenantId())) continue;
                if (tenantInfo == null) {
                    log.error("\u672a\u83b7\u53d6\u5230\u79df\u6237\u4fe1\u606f\uff0c \u79df\u6237ID\uff1a{}", (Object)tenantInfo.getTenantId());
                    continue;
                }
                List<ObCallRecordPO> callRecordPOS = this.qryCallRecord(reqBO, tenantInfo);
                if (callRecordPOS == null || callRecordPOS.size() == 0) {
                    log.info("\u5f53\u524d\u79df\u6237\uff1a{}\uff0c \u672a\u67e5\u8be2\u5230\u5916\u547c\u8bb0\u5f55", (Object)tenantInfo.getTenantId());
                    continue;
                }
                ObCustServeRecordPO custServeRecordPO = new ObCustServeRecordPO();
                custServeRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
                custServeRecordPO.setTenantId(tenantInfo.getTenantId());
                custServeRecordPO.setHandleResults(reqBO.getUserPurpose());
                custServeRecordPO.setQryStartTime(reqBO.getStartTime());
                custServeRecordPO.setQryEndTime(reqBO.getEndTime());
                List serveRecordPOS = this.obCustServeRecordDAO.queryServiceRecord(custServeRecordPO);
                for (ObCallRecordPO po : callRecordPOS) {
                    ObCustServeRecordPO serveRecordPO = null;
                    List collect = serveRecordPOS.stream().filter(serve -> po.getUcId().equals(serve.getUcId())).collect(Collectors.toList());
                    serveRecordPO = null == collect || collect.size() == 0 ? this.queryServiceCallRecord(reqBO, tenantInfo, po.getUcId()) : (ObCustServeRecordPO)collect.get(0);
                    po.setTenantName(tenantInfo.getTenantName());
                    po.setTenantOtherName(tenantInfo.getTenantOtherName());
                    CallRecordHistoryBO rspBO = this.getRspBO(serveRecordPO, po, taskInfos);
                    rspBOS.add(rspBO);
                }
            }
        }
        log.info("rspBOS:{}", (Object)JSONObject.toJSONString(rspBOS));
        if (null != rspBOS && rspBOS.size() > 0) {
            if (!StringUtils.isEmpty((Object)reqBO.getTaskName())) {
                rspBOS = this.filterList(rspBOS, reqBO.getTaskName());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getLoginName())) {
                rspBOS = this.filterListByLoginName(rspBOS, reqBO.getLoginName());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getCustomerName())) {
                rspBOS = this.filterListByCustName(rspBOS, reqBO.getCustomerName());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getProductName())) {
                rspBOS = this.filterListByProductName(rspBOS, reqBO.getProductName());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getSuccessProduct())) {
                rspBOS = this.filterListBySuccessProductName(rspBOS, reqBO.getSuccessProduct());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getUserPurpose())) {
                rspBOS = this.filterListByUserPurpose(rspBOS, reqBO.getUserPurpose());
            }
        }
        count = rspBOS.size();
        rspBOS = rspBOS.stream().sorted(Comparator.comparing(CallRecordHistoryBO::getCreateTime).reversed()).collect(Collectors.toList());
        rspBOS = rspBOS.stream().skip(reqBO.getLimit() * (reqBO.getPage() - 1)).limit(reqBO.getLimit()).collect(Collectors.toList());
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)count.intValue());
    }

    public Rsp qryDataProperty(QryDataPropertyReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u88ab\u53eb\u53f7\u7801\u5c5e\u6027\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        QryDataPropertyRspBO rspBO = new QryDataPropertyRspBO();
        String tenantId = reqBO.getTenantCode();
        List roleNames = this.bladeUserInterService.getUserRoleInfo(reqBO.getLoginInfo().getUserId());
        for (String role : roleNames) {
            if (StringUtils.isEmpty((Object)role) || !role.equals("system:admin") && !role.equals("system:administrator")) continue;
            if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            tenantId = reqBO.getTenantId();
            break;
        }
        if (StringUtils.isEmpty((Object)reqBO.getUcId())) {
            return BaseRspUtils.createErrorRsp((String)"ucId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BladeTenantBO tenantInfo = this.getTenantInfo(tenantId);
        if (tenantInfo == null) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
        }
        ObCallRecordPO obCallRecordPO = this.getCallRecord(reqBO.getUcId(), tenantInfo);
        log.info("\u83b7\u53d6\u5916\u547c\u8bb0\u5f55\uff1a{}", (Object)JSONObject.toJSONString((Object)obCallRecordPO));
        if (obCallRecordPO == null) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u83b7\u53d6\u5230\u5916\u547c\u8bb0\u5f55");
        }
        ObDataTargetPO dataTargetPO = this.getTaskData(obCallRecordPO.getDataId(), tenantInfo);
        log.info("\u83b7\u53d6\u4efb\u52a1\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)dataTargetPO));
        if (dataTargetPO == null) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u6570\u636e\uff01");
        }
        rspBO.setCalled(dataTargetPO.getMobileNo());
        rspBO.setActivityCode(dataTargetPO.getActivityCode());
        rspBO.setGridOrg(dataTargetPO.getGridOrg());
        rspBO.setBlockOrg(dataTargetPO.getBlockOrg());
        rspBO.setProduct(dataTargetPO.getProduct());
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public RspList qryScriptAnswer(QryScriptAnswerReqBO reqBO) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u63d0\u4ea4\u95ee\u5377\u8bb0\u5f55\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ArrayList<QryScriptAnswerRspBO> rspBOS = new ArrayList<QryScriptAnswerRspBO>();
        String tenantId = reqBO.getTenantId();
        if (StringUtils.isEmpty((Object)tenantId)) {
            String string = tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        }
        if (StringUtils.isEmpty((Object)tenantId)) {
            return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUcId())) {
            return BaseRspUtils.createErrorRspList((String)"ucId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BladeTenantBO tenantInfo = this.getTenantInfo(tenantId);
        if (tenantInfo == null) {
            return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
        }
        List<ObCallRecordAnswer> answers = this.getScriptAnswerInfo(reqBO.getUcId(), tenantInfo);
        log.info("\u83b7\u53d6\u63d0\u4ea4\u95ee\u5377\u8bb0\u5f55\uff1a{}", (Object)JSONObject.toJSONString(answers));
        if (answers != null && answers.size() > 0) {
            for (ObCallRecordAnswer answer : answers) {
                QryScriptAnswerRspBO rspBO = new QryScriptAnswerRspBO();
                QueryScriptQuestionRspBO questionRspBO = this.scriptInterService.queryScriptQuestion(answer.getQuestionId().toString());
                log.info("\u83b7\u53d6\u95ee\u9898\u5177\u4f53\u4fe1\u606f\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)questionRspBO));
                rspBO.setAnswer(answer.getAnswer());
                rspBO.setQuestionId(questionRspBO.getQuestionId());
                rspBO.setQuestionTitle(questionRspBO.getQuestionTitle());
                rspBO.setQuestionType(questionRspBO.getQuestionType());
                rspBO.setTenantId(answer.getTenantId());
                ArrayList<OptionsBO> optionsBOS = new ArrayList<OptionsBO>();
                List questionOptions = questionRspBO.getQuestionOptions();
                if (questionOptions != null && questionOptions.size() > 0) {
                    for (ScriptQuestionOptionsBO optionsBO : questionOptions) {
                        optionsBOS.add(new OptionsBO(optionsBO.getOption(), optionsBO.getOptionValue()));
                    }
                }
                rspBO.setOptionsBOS(optionsBOS);
                rspBOS.add(rspBO);
            }
        } else {
            log.info("\u672a\u67e5\u8be2\u5230\u95ee\u5377\u63d0\u4ea4\u8bb0\u5f55");
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)rspBOS.size());
    }

    public Rsp updateMarketing(UpdateMarketingReqBO reqBO) {
        log.info("\u8fdb\u5165\u4fee\u6539\u8425\u9500\u7ed3\u679c\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        String tenantId = reqBO.getTenantCode();
        if (StringUtils.isEmpty((Object)tenantId)) {
            if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            tenantId = reqBO.getTenantId();
        }
        if (StringUtils.isEmpty((Object)reqBO.getMarketing())) {
            return BaseRspUtils.createErrorRsp((String)"\u8425\u9500\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUcId())) {
            return BaseRspUtils.createErrorRsp((String)"ucId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BladeTenantBO tenantInfo = this.getTenantInfo(tenantId);
        if (tenantInfo == null) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
        }
        ObCustServeRecordPO obCustServeRecordPO = new ObCustServeRecordPO();
        obCustServeRecordPO.setTenantId(tenantId);
        obCustServeRecordPO.setUcId(reqBO.getUcId());
        obCustServeRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        ObCustServeRecordPO record = this.obCustServeRecordDAO.getServiceRecord(obCustServeRecordPO);
        log.info("\u6839\u636eucId\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)record));
        String handleResults = null;
        String handleUser = null;
        if (record == null) {
            ObCallRecordPO callRecordPO = this.obCallRecordDAO.getCallRecordByUcId(reqBO.getUcId(), tenantInfo.getTenantOtherName());
            if (null == callRecordPO) {
                return BaseRspUtils.createSuccessRsp((Object)"\u672a\u83b7\u53d6\u5230\u76f8\u5173\u5916\u547c\u8bb0\u5f55");
            }
            String s = UUID.randomUUID().toString();
            String replace = s.replace("-", "");
            obCustServeRecordPO.setRecordId(replace);
            obCustServeRecordPO.setObYear(callRecordPO.getObYear());
            obCustServeRecordPO.setObMonth(callRecordPO.getObMonth());
            obCustServeRecordPO.setObDay(callRecordPO.getObDay());
            obCustServeRecordPO.setObHour(callRecordPO.getObHour());
            obCustServeRecordPO.setTaskId(callRecordPO.getTaskId());
            obCustServeRecordPO.setTenantId(callRecordPO.getTenantId());
            obCustServeRecordPO.setHandleUser(callRecordPO.getUserId());
            obCustServeRecordPO.setHandleResults(reqBO.getMarketing());
            obCustServeRecordPO.setHandleTime(callRecordPO.getRingTime());
            obCustServeRecordPO.setHandleRemark(reqBO.getRemark());
            obCustServeRecordPO.setState("0");
            this.obCustServeRecordDAO.insertSelective(obCustServeRecordPO);
        } else {
            handleResults = record.getHandleResults();
            handleUser = record.getHandleUser();
            obCustServeRecordPO.setHandleResults(reqBO.getMarketing());
            if (StringUtils.isEmpty((Object)record.getHandleRemark())) {
                obCustServeRecordPO.setHandleRemark(reqBO.getRemark());
            } else {
                obCustServeRecordPO.setHandleRemark(record.getHandleRemark() + "|" + reqBO.getRemark());
            }
            log.info("\u4fee\u6539\u8425\u9500\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCustServeRecordPO));
            this.obCustServeRecordDAO.updateByUcId(obCustServeRecordPO);
        }
        ObUpdRecordLogPO updRecordLogPO = this.getUpdRecordLogPO(obCustServeRecordPO, handleResults);
        updRecordLogPO.setUpdateUser(reqBO.getLoginInfo().getUserId());
        updRecordLogPO.setHandleUser(handleUser);
        updRecordLogPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        updRecordLogPO.setUpdateRemark(reqBO.getRemark());
        log.info("\u63d2\u5165\u4fee\u6539\u8425\u9500\u7ed3\u679c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)updRecordLogPO));
        this.obUpdRecordLogDAO.insertSelective(updRecordLogPO);
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    private ObUpdRecordLogPO getUpdRecordLogPO(ObCustServeRecordPO obCustServeRecordPO, String marketing) {
        log.info("\u7ec4\u88c5\u4fee\u6539\u8425\u9500\u7ed3\u679c\u8bb0\u5f55PO\uff0c obCustServeRecordPO\uff1a{}, marketing:{}", (Object)JSONObject.toJSONString((Object)obCustServeRecordPO), (Object)marketing);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ObUpdRecordLogPO logPO = new ObUpdRecordLogPO();
        logPO.setTenantId(obCustServeRecordPO.getTenantId());
        logPO.setUcId(obCustServeRecordPO.getUcId());
        logPO.setBeforeMarketing(marketing);
        logPO.setLaterMarketing(obCustServeRecordPO.getHandleResults());
        logPO.setCreateTime(format.format(new Date()));
        return logPO;
    }

    public RspList qryUpdRecordLogs(QryUpdRecordLogsReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u8425\u9500\u7ed3\u679c\u4fee\u6539\u8bb0\u5f55\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        String tenantId = reqBO.getTenantCode();
        ObUpdRecordLogPO obUpdRecordLogPO = new ObUpdRecordLogPO();
        if (StringUtils.isEmpty((Object)tenantId)) {
            obUpdRecordLogPO.setIsSupper(Integer.valueOf(0));
            if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            tenantId = reqBO.getTenantId();
        }
        List roleNames = this.bladeUserInterService.getUserRoleInfo(reqBO.getLoginInfo().getUserId());
        ArrayList<String> tenantIds = new ArrayList<String>();
        List bladeTenants = null;
        Set roleSet = reqBO.getRoleSet();
        for (String role : roleNames) {
            if (null == roleSet || StringUtils.isEmpty((Object)role) || !role.equals("system:admin") && !role.equals("system:administrator")) continue;
            Req req = new Req();
            req.setIn_tenantCode(null == reqBO.getIn_tenantCode() ? reqBO.getTenantCode() : reqBO.getIn_tenantCode());
            req.setRoleSet(roleSet);
            bladeTenants = this.bladeTenantInterService.getBalseTenantList(req);
            if (null == bladeTenants) break;
            tenantIds.addAll(bladeTenants.stream().map(x -> x.getTenantId()).collect(Collectors.toList()));
            tenantIds.add(tenantId);
            tenantId = null;
            break;
        }
        if (StringUtils.isEmpty((Object)reqBO.getUcId())) {
            return BaseRspUtils.createErrorRspList((String)"ucId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BladeTenantBO tenantInfo = this.getTenantInfo(null == reqBO.getTenantId() ? reqBO.getTenantCode() : reqBO.getTenantId());
        if (tenantInfo == null) {
            return BaseRspUtils.createErrorRspList((String)"\u672a\u83b7\u53d6\u5230\u79df\u6237\u4fe1\u606f");
        }
        obUpdRecordLogPO.setTenantId(tenantId);
        obUpdRecordLogPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        obUpdRecordLogPO.setUcId(reqBO.getUcId());
        obUpdRecordLogPO.setTenantIds(tenantIds);
        log.info("\u67e5\u8be2\u8425\u9500\u7ed3\u679c\u4fee\u6539\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obUpdRecordLogPO));
        PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        List recordLogPOS = this.obUpdRecordLogDAO.selectByUcId(obUpdRecordLogPO);
        PageInfo pageInfo = new PageInfo(recordLogPOS);
        log.info("\u67e5\u8be2\u8425\u9500\u7ed3\u679cMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)recordLogPOS));
        ArrayList<QryUpdRecordLogsRspBO> rspBOS = new ArrayList<QryUpdRecordLogsRspBO>();
        if (recordLogPOS != null && recordLogPOS.size() > 0) {
            for (ObUpdRecordLogPO recordLogPO : recordLogPOS) {
                QryUpdRecordLogsRspBO rspBO = new QryUpdRecordLogsRspBO();
                BeanUtils.copyProperties((Object)recordLogPO, (Object)rspBO);
                BladeUserBO updUserBO = this.bladeUserInterService.queryUserInfo(recordLogPO.getUpdateUser());
                log.info("\u83b7\u53d6\u4fee\u6539\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)updUserBO));
                if (updUserBO != null) {
                    rspBO.setUpdateUserName(updUserBO.getName());
                }
                BladeUserBO handleUserBO = this.bladeUserInterService.queryUserInfo(recordLogPO.getHandleUser());
                log.info("\u83b7\u53d6\u83b7\u53d6handleUser\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)handleUserBO));
                if (handleUserBO != null) {
                    rspBO.setHandleUserName(handleUserBO.getName());
                }
                rspBOS.add(rspBO);
            }
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)pageInfo.getTotal());
    }

    public Rsp exportGetSeatsCallHistory(GetSeatsCallHistoryReqBO reqBO) {
        log.info("\u8fdb\u5165\u5bfc\u51fa\u4e2a\u4eba\u5916\u547c\u8bb0\u5f55\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        String fileName = "\u4e2a\u4eba\u5916\u547c\u8bb0\u5f55_" + tenantId + "_" + System.currentTimeMillis();
        int limit = reqBO.getLimit();
        reqBO.setLimit(1);
        RspList<CallRecordHistoryBO> rspList = this.getSeatsCallHistoryRefactor(reqBO);
        if (!rspList.getRspCode().equals("0000")) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)rspList.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        int pageCount = (int)rspList.getCount();
        if (pageCount == 0) {
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u83b7\u53d6\u5230\u5916\u547c\u8bb0\u5f55");
        }
        int pageNumber = (pageCount - 1) / limit + 1;
        reqBO.setLimit(limit);
        ArrayList<ExcelSeatsCallHistoryBO> excelBOS = new ArrayList<ExcelSeatsCallHistoryBO>();
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList<CallRecordHistoryBO> rsp = this.getSeatsCallHistoryRefactor(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
            for (CallRecordHistoryBO historyBO : rows) {
                ExcelSeatsCallHistoryBO excelBO = new ExcelSeatsCallHistoryBO();
                BeanUtils.copyProperties((Object)historyBO, (Object)excelBO);
                excelBO.setIndexCode(index + "");
                excelBO.setUserPurpose(historyBO.getUserPurpose());
                excelBOS.add(excelBO);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        log.info("excelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
        String filePath = null;
        try {
            filePath = this.excelHelper.writeExcel(excelBOS, ExcelSeatsCallHistoryBO.class, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
        log.info("filePath:{}", (Object)filePath);
        ExportRspBO rspBO = new ExportRspBO();
        rspBO.setFilePath(filePath);
        rspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public Rsp exportQryCallRecord(QryCallRecordReqBO reqBO) {
        RspList rspBO;
        log.info("\u8fdb\u5165\u5bfc\u51fa\u5916\u547c\u8bb0\u5f55(\u79df\u6237/\u8d85\u7ba1)\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        int limit = reqBO.getLimit();
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        String fileName = "\u5916\u547c\u8bb0\u5f55_" + tenantId + "_" + System.currentTimeMillis();
        reqBO.setLimit(1);
        RspList rsp = this.qryCallRecordRefactor(reqBO);
        if (!rsp.getRspCode().equals("0000")) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)rsp.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        int pageCount = (int)rsp.getCount();
        if (pageCount == 0) {
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u83b7\u53d6\u5230\u5916\u547c\u8bb0\u5f55");
        }
        limit = LIMIT;
        int pageNumber = (pageCount - 1) / limit + 1;
        reqBO.setLimit(limit);
        ArrayList<ExcelManageCallHistoryBO> excelBOS = new ArrayList<ExcelManageCallHistoryBO>();
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            rspBO = this.qryCallRecordRefactor(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rspBO.getRows()) == null || rows.size() <= 0) continue;
            for (CallRecordHistoryBO historyBO : rows) {
                ExcelManageCallHistoryBO excelBO = new ExcelManageCallHistoryBO();
                BeanUtils.copyProperties((Object)historyBO, (Object)excelBO);
                excelBO.setIndexCode(index + "");
                excelBO.setUserPurpose(historyBO.getUserPurpose());
                excelBO.setTenantName(historyBO.getTenantName());
                excelBOS.add(excelBO);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        log.info("excelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
        String filePath = null;
        try {
            filePath = this.excelHelper.writeExcel(excelBOS, ExcelManageCallHistoryBO.class, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
        log.info("filePath:{}", (Object)filePath);
        rspBO = new ExportRspBO();
        rspBO.setFilePath(filePath);
        rspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public RspList getUserPurpose(UserPurposeReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u7528\u6237\u610f\u5411\u5217\u8868\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            return BaseRspUtils.createErrorRspList((String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ObTaskInfoPO obTaskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(reqBO.getTaskId());
        log.info("\u4efb\u52a1ID\uff1a{}\uff0c \u67e5\u8be2\u63a5\u53e3Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)reqBO.getTaskId(), (Object)JSONObject.toJSONString((Object)obTaskInfoPO));
        List<Object> userPurposes = new ArrayList();
        if (null == obTaskInfoPO) {
            log.info("\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u4fe1\u606f\uff0c\u8fd4\u56de\u9ed8\u8ba4\u7528\u6237\u610f\u5411\u5217\u8868");
            String userPurpose = "\u6709\u610f\u5411, \u7528\u6237\u53cd\u611f, \u7528\u6237\u62d2\u7edd, \u540c\u610f, \u672a\u63a5\u89e6";
            userPurposes = Arrays.asList(userPurpose.split(","));
        } else {
            String resultSet = obTaskInfoPO.getCallResultSet();
            userPurposes = JSONArray.parseArray((String)resultSet, String.class);
        }
        return BaseRspUtils.createSuccessRspList(userPurposes);
    }

    public RspList qryCallRecordRefactor(QryCallRecordReqBO reqBO) {
        log.info("\u91cd\u6784\u5916\u547c\u8bb0\u5f55\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        List<Object> bos = new ArrayList();
        PageInfo pageInfo = null;
        long count = 0L;
        try {
            if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
                return BaseRspUtils.createErrorRspList((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u8303\u56f4");
            }
            if (!DateUtil.checkTimeSpan(reqBO.getStartTime(), reqBO.getEndTime(), OcsConstant.SPAN_NUM).booleanValue()) {
                return BaseRspUtils.createErrorRspList((String)"\u6700\u5927\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u4e3a6\u4e2a\u6708");
            }
            ArrayList<String> tenantIds = reqBO.getTenantIds();
            if (null == tenantIds || tenantIds.size() == 0) {
                String tenantCode;
                tenantIds = new ArrayList<String>();
                String string = tenantCode = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
                if (StringUtils.isEmpty((Object)tenantCode)) {
                    return BaseRspUtils.createErrorRspList((String)"\u8bf7\u9009\u62e9\u79df\u6237");
                }
                tenantIds.add(tenantCode);
            }
            ArrayList<String> userIds = new ArrayList<String>();
            List<Object> userBOS = new ArrayList();
            if (!StringUtils.isEmpty((Object)reqBO.getCustomerName()) || !StringUtils.isEmpty((Object)reqBO.getLoginName())) {
                userBOS = this.getCustIds(reqBO.getCustomerName(), reqBO.getLoginName());
                if (null == userBOS || userBOS.size() == 0) {
                    return BaseRspUtils.createSuccessRspList(bos);
                }
                userBOS.forEach(x -> userIds.add(String.valueOf(x.getId())));
            }
            for (String tenantId : tenantIds) {
                BladeTenantBO tenantInfo = this.getTenantInfo(tenantId);
                List<Object> obCustServeRecordPOS = new ArrayList();
                ArrayList<String> ucIds = new ArrayList<String>();
                if (!StringUtils.isEmpty((Object)reqBO.getUserPurpose())) {
                    obCustServeRecordPOS = this.qryHandleResults(reqBO.getUserPurpose(), tenantInfo, reqBO.getStartTime(), reqBO.getEndTime());
                    if (null == obCustServeRecordPOS || obCustServeRecordPOS.size() == 0) continue;
                    obCustServeRecordPOS.forEach(x -> ucIds.add(x.getUcId()));
                }
                List<Object> taskInfoPOS = new ArrayList();
                ArrayList<String> taskIds = new ArrayList<String>();
                if (!StringUtils.isEmpty((Object)reqBO.getTaskName())) {
                    taskInfoPOS = this.qryTask(reqBO.getTaskName());
                    if (null == taskInfoPOS || taskInfoPOS.size() == 0) continue;
                    taskInfoPOS.forEach(x -> taskIds.add(x.getTaskId()));
                }
                List<Object> dataTargetPOS = new ArrayList();
                ArrayList<String> dataIds = new ArrayList<String>();
                if (!StringUtils.isEmpty((Object)reqBO.getProductName())) {
                    dataTargetPOS = this.qryTaskData(reqBO.getProductName(), tenantInfo);
                    if (null == dataTargetPOS || dataTargetPOS.size() == 0) continue;
                    dataTargetPOS.forEach(x -> dataIds.add(x.getDataId()));
                }
                List<Object> productSubscribePOS = new ArrayList();
                ArrayList<String> productUcIds = new ArrayList<String>();
                if (!StringUtils.isEmpty((Object)reqBO.getSuccessProduct())) {
                    productSubscribePOS = this.qryProductSubscribe(reqBO.getSuccessProduct(), tenantId);
                    if (null == productSubscribePOS || productSubscribePOS.size() == 0) continue;
                    productSubscribePOS.forEach(x -> productUcIds.add(x.getUcId()));
                }
                ObCallRecordPO obCallRecordPO = this.getCallRecordPO(tenantInfo, reqBO, ucIds, taskIds, productUcIds, userIds, dataIds);
                long qryStartTime = System.currentTimeMillis();
                log.info("\u67e5\u8be2\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCallRecordPO));
                PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
                List callRecordPOS = this.obCallRecordDAO.selectCallRecords(obCallRecordPO);
                pageInfo = new PageInfo(callRecordPOS);
                long qryEndTime = System.currentTimeMillis();
                log.info("\u67e5\u8be2\u5916\u547c\u8bb0\u5f55\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{} ms", (Object)(qryEndTime - qryStartTime));
                count += pageInfo.getTotal();
                if (null == callRecordPOS || callRecordPOS.size() <= 0) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                HashMap<String, List<Object>> custMap = new HashMap<String, List<Object>>();
                for (ObCallRecordPO record : callRecordPOS) {
                    CallRecordHistoryBO rspBO = new CallRecordHistoryBO();
                    rspBO.setRecordId(record.getRecordId());
                    rspBO.setCreateTime(record.getCreateTime());
                    rspBO.setCalling(record.getCalling());
                    rspBO.setCalled(record.getCalled());
                    rspBO.setCallType(record.getCallType());
                    rspBO.setUcId(record.getUcId());
                    rspBO.setTenantId(tenantId);
                    if ("1".equals(record.getIsConn()) && "1".equals(record.getObsIsConn())) {
                        rspBO.setConnStatus("\u5df2\u63a5\u901a");
                    } else {
                        rspBO.setConnStatus("\u672a\u63a5\u901a");
                    }
                    rspBO.setStartTime(record.getStartTime());
                    rspBO.setEndTime(record.getEndTime());
                    rspBO.setContactLength(record.getContactLength());
                    rspBO.setRecordFile(record.getRecordFile());
                    rspBO.setTenantName(tenantInfo.getTenantName());
                    rspBO.setSuggestProduct(record.getSuggestProduct());
                    ObTaskInfoPO taskInfoPO = new ObTaskInfoPO();
                    if (!map.containsKey(record.getTaskId())) {
                        taskInfoPO = this.getTaskName(record.getTaskId(), taskInfoPOS);
                        map.put(record.getTaskId(), taskInfoPO);
                    } else {
                        taskInfoPO = (ObTaskInfoPO)map.get(record.getTaskId());
                    }
                    String taskName = "--";
                    String taskId = "ACTIVE_OUT";
                    if (null != taskInfoPO) {
                        taskName = taskInfoPO.getTaskName();
                        taskId = taskInfoPO.getTaskId();
                    }
                    ObDataTargetPO dataTargetPO = this.getDataPO(record.getDataId(), tenantInfo, dataTargetPOS);
                    String productId = null;
                    String productName = "--";
                    if (null != dataTargetPO) {
                        productId = dataTargetPO.getDataId();
                        productName = dataTargetPO.getProductName();
                    }
                    rspBO.setTaskName(taskName);
                    rspBO.setMainProductId(productId);
                    rspBO.setMainProduct(productName);
                    rspBO.setTaskId(taskId);
                    String city = AreaCache.getArea(record.getCity());
                    rspBO.setCity(StringUtils.isEmpty((Object)city) ? record.getCity() : city);
                    Integer flag = null;
                    if (null == obCustServeRecordPOS || obCustServeRecordPOS.size() == 0) {
                        if (!custMap.containsKey(record.getTaskId())) {
                            ObCustServeRecordPO serveRecordPO = new ObCustServeRecordPO();
                            serveRecordPO.setTenantId(record.getTenantId());
                            serveRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
                            serveRecordPO.setTaskId(record.getTaskId());
                            serveRecordPO.setQryStartTime(reqBO.getStartTime());
                            serveRecordPO.setQryEndTime(reqBO.getEndTime());
                            obCustServeRecordPOS = this.obCustServeRecordDAO.getCustServeRecord(serveRecordPO);
                            custMap.put(record.getTaskId(), obCustServeRecordPOS);
                        } else {
                            obCustServeRecordPOS = (List)custMap.get(record.getTaskId());
                        }
                        flag = 0;
                    }
                    ObCustServeRecordPO custServeRecordPO = this.getCustServerInfo(record.getUcId(), obCustServeRecordPOS, tenantInfo.getTenantOtherName());
                    if (null != flag && flag.equals(0)) {
                        obCustServeRecordPOS = new ArrayList();
                    }
                    if (null != custServeRecordPO) {
                        rspBO.setUserPurpose(custServeRecordPO.getHandleResults());
                        rspBO.setRemark(custServeRecordPO.getHandleRemark());
                    }
                    String successProduct = this.getSuccessProducts(record.getUcId(), productSubscribePOS);
                    rspBO.setSuccessProduct(successProduct);
                    BladeUserBO userBO = new BladeUserBO();
                    if (!StringUtils.isEmpty((Object)record.getUserId())) {
                        if (!map.containsKey(record.getUserId())) {
                            userBO = this.bladeUserInterService.queryUserInfo(record.getUserId());
                            map.put(record.getUserId(), userBO);
                        } else {
                            userBO = (BladeUserBO)map.get(record.getUserId());
                        }
                        if (null != userBO) {
                            rspBO.setLoginName(userBO.getAccount());
                            rspBO.setRealName(userBO.getRealName());
                        }
                    }
                    bos.add(rspBO);
                    if (reqBO.getLimit() != bos.size()) continue;
                    return BaseRspUtils.createSuccessRspList(bos, (long)count);
                }
            }
            bos = bos.stream().sorted(Comparator.comparing(CallRecordHistoryBO::getCreateTime).reversed()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5916\u547c\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRspList(bos, (long)count);
    }

    public RspList getEsSeatsCallHistory(GetEsSeatsCallHistoryReqBO reqBO) {
        log.info("\u8fdb\u5165Es\u83b7\u53d6\u4e2a\u4eba\u8bb0\u5f55\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ClientInterface restClient = this.bBossEsStarter.getConfigRestClient("esMapper/EsCallRecordHistory.xml");
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            return BaseRspUtils.createErrorRspList((String)"\u65f6\u95f4\u8303\u56f4\u5fc5\u586b");
        }
        if (!DateUtil.checkTimeSpan(reqBO.getStartTime(), reqBO.getEndTime(), OcsConstant.SPAN_NUM).booleanValue()) {
            return BaseRspUtils.createErrorRspList((String)"\u6700\u5927\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc76\u4e2a\u6708");
        }
        LoginInfo loginInfo = reqBO.getLoginInfo();
        if (null == loginInfo) {
            return BaseRspUtils.createErrorRspList((String)"\u672a\u83b7\u53d6\u5230\u5750\u5e2d\u4fe1\u606f");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("startTime", reqBO.getStartTime());
        params.put("endTime", reqBO.getEndTime());
        params.put("userId", loginInfo.getUserId());
        params.put("from", (reqBO.getPage() - 1) * reqBO.getLimit());
        params.put("size", reqBO.getLimit());
        if (!StringUtils.isEmpty((Object)reqBO.getCalled())) {
            params.put("called", "*" + reqBO.getCalled() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCalling())) {
            params.put("calling", "*" + reqBO.getCalling() + "*");
        }
        if (null != reqBO.getConnState()) {
            params.put("connState", reqBO.getConnState());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTaskName())) {
            params.put("taskName", "*" + reqBO.getTaskName() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getProductName())) {
            params.put("productName", "*" + reqBO.getProductName() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getHandleResults())) {
            params.put("handleResults", reqBO.getHandleResults());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSuccessProduct())) {
            params.put("successProduct", "*" + reqBO.getSuccessProduct() + "*");
        }
        if (null != reqBO.getIsTaskData()) {
            params.put("isTaskData", reqBO.getIsTaskData());
        }
        try {
            ESDatas response = restClient.searchList(this.indexName + "/_search", "getEsSeatsCallHistory", params, EsCallRecordHistoryBO.class);
            List seatsCallHistory = response.getDatas();
            if (null == seatsCallHistory || seatsCallHistory.size() == 0) {
                return BaseRspUtils.createSuccessRspList(Collections.emptyList());
            }
            for (int i = 0; i < seatsCallHistory.size(); ++i) {
                String is_conn = ((EsCallRecordHistoryBO)seatsCallHistory.get(i)).getIs_conn();
                String obs_is_conn = ((EsCallRecordHistoryBO)seatsCallHistory.get(i)).getObs_is_conn();
                String city = ((EsCallRecordHistoryBO)seatsCallHistory.get(i)).getCity();
                String cityName = ((EsCallRecordHistoryBO)seatsCallHistory.get(i)).getCity_name();
                if (!StringUtils.isEmpty((Object)city) && !StringUtils.isEmpty((Object)cityName)) {
                    ((EsCallRecordHistoryBO)seatsCallHistory.get(i)).setCity(cityName);
                    ((EsCallRecordHistoryBO)seatsCallHistory.get(i)).setCity_name(cityName);
                }
                if ("1".equals(is_conn) && "1".equals(obs_is_conn)) {
                    ((EsCallRecordHistoryBO)seatsCallHistory.get(i)).setConnState("\u5df2\u63a5\u901a");
                } else {
                    ((EsCallRecordHistoryBO)seatsCallHistory.get(i)).setConnState("\u672a\u63a5\u901a");
                }
                if (StringUtils.isEmpty((Object)((EsCallRecordHistoryBO)seatsCallHistory.get(i)).getTask_name())) {
                    ((EsCallRecordHistoryBO)seatsCallHistory.get(i)).setTask_name("--");
                }
                if (!StringUtils.isEmpty((Object)((EsCallRecordHistoryBO)seatsCallHistory.get(i)).getProduct_name())) continue;
                ((EsCallRecordHistoryBO)seatsCallHistory.get(i)).setProduct_name("--");
            }
            long totalSize = response.getTotalSize();
            log.info("\u603b\u8bb0\u5f55\u6570\uff1a{}", (Object)totalSize);
            List esSeatsCallHistory = JSON.parseArray((String)JSONObject.toJSONString((Object)seatsCallHistory), Object.class);
            return BaseRspUtils.createSuccessRspList((List)esSeatsCallHistory, (long)totalSize);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    public RspList qryEsCallRecord(QryEsCallRecordReqBO reqBO) {
        LoginInfo loginInfo;
        log.info("\u8fdb\u5165Es\u83b7\u53d6\u5916\u547c\u8bb0\u5f55\u63a5\u53e3\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ClientInterface restClient = this.bBossEsStarter.getConfigRestClient("esMapper/EsCallRecordHistory.xml");
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            return BaseRspUtils.createErrorRspList((String)"\u65f6\u95f4\u8303\u56f4\u5fc5\u586b");
        }
        if (!DateUtil.checkTimeSpan(reqBO.getStartTime(), reqBO.getEndTime(), OcsConstant.SPAN_NUM).booleanValue()) {
            return BaseRspUtils.createErrorRspList((String)"\u6700\u5927\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc76\u4e2a\u6708");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> tenantIds = new ArrayList<String>();
        params.put("startTime", reqBO.getStartTime());
        params.put("endTime", reqBO.getEndTime());
        params.put("from", (reqBO.getPage() - 1) * reqBO.getLimit());
        params.put("size", reqBO.getLimit());
        if (!StringUtils.isEmpty((Object)reqBO.getCalled())) {
            params.put("called", "*" + reqBO.getCalled() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCalling())) {
            params.put("calling", "*" + reqBO.getCalling() + "*");
        }
        if (null != reqBO.getConnState()) {
            params.put("connState", reqBO.getConnState());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getRealName())) {
            params.put("realName", "*" + reqBO.getRealName() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getAccount())) {
            params.put("account", "*" + reqBO.getAccount() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTaskName())) {
            params.put("taskName", "*" + reqBO.getTaskName() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getProductName())) {
            params.put("productName", "*" + reqBO.getProductName() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getHandleResults())) {
            params.put("handleResults", reqBO.getHandleResults());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSuccessProduct())) {
            params.put("successProduct", "*" + reqBO.getSuccessProduct() + "*");
        }
        if (null != reqBO.getIsTaskData()) {
            params.put("isTaskData", reqBO.getIsTaskData());
        }
        if (null == (loginInfo = reqBO.getLoginInfo())) {
            return BaseRspUtils.createErrorRspList((String)"\u672a\u83b7\u53d6\u5230\u767b\u5f55\u4fe1\u606f");
        }
        List roleNames = this.bladeUserInterService.getUserRoleInfo(loginInfo.getUserId());
        if (null == roleNames || roleNames.size() == 0) {
            log.error("\u89d2\u8272\u83b7\u53d6\u5931\u8d25\uff0cuserId\uff1a{}", (Object)loginInfo.getUserId());
            return BaseRspUtils.createErrorRspList((String)"\u672a\u83b7\u53d6\u5230\u89d2\u8272\u4fe1\u606f");
        }
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        for (String role : roleNames) {
            if ("system:admin".equals(role) || "system:administrator".equals(role) || "tousu".equals(role)) {
                if (null == reqBO.getTenantIds() || reqBO.getTenantIds().size() <= 0) break;
                tenantIds.addAll(reqBO.getTenantIds());
                break;
            }
            if (StringUtils.isEmpty((Object)tenantId)) {
                return BaseRspUtils.createErrorRspList((String)"\u672a\u83b7\u53d6\u5230\u79df\u6237\u4fe1\u606f");
            }
            tenantIds.add(tenantId);
        }
        log.info("\u79df\u6237id:{}", tenantIds);
        if (null != tenantIds && tenantIds.size() > 0) {
            params.put("tenantIds", tenantIds);
        }
        try {
            ESDatas response = restClient.searchList(this.indexName + "/_search", "qryEsCallRecord", params, EsCallRecordHistoryBO.class);
            List callRecord = response.getDatas();
            if (null == callRecord || callRecord.size() == 0) {
                return BaseRspUtils.createSuccessRspList(Collections.emptyList());
            }
            for (int i = 0; i < callRecord.size(); ++i) {
                String is_conn = ((EsCallRecordHistoryBO)callRecord.get(i)).getIs_conn();
                String obs_is_conn = ((EsCallRecordHistoryBO)callRecord.get(i)).getObs_is_conn();
                String city = ((EsCallRecordHistoryBO)callRecord.get(i)).getCity();
                String cityName = ((EsCallRecordHistoryBO)callRecord.get(i)).getCity_name();
                if (!StringUtils.isEmpty((Object)city) && !StringUtils.isEmpty((Object)cityName)) {
                    ((EsCallRecordHistoryBO)callRecord.get(i)).setCity(cityName);
                    ((EsCallRecordHistoryBO)callRecord.get(i)).setCity_name(cityName);
                }
                if ("1".equals(is_conn) && "1".equals(obs_is_conn)) {
                    ((EsCallRecordHistoryBO)callRecord.get(i)).setConnState("\u5df2\u63a5\u901a");
                } else {
                    ((EsCallRecordHistoryBO)callRecord.get(i)).setConnState("\u672a\u63a5\u901a");
                }
                if (StringUtils.isEmpty((Object)((EsCallRecordHistoryBO)callRecord.get(i)).getTask_name())) {
                    ((EsCallRecordHistoryBO)callRecord.get(i)).setTask_name("--");
                }
                if (!StringUtils.isEmpty((Object)((EsCallRecordHistoryBO)callRecord.get(i)).getProduct_name())) continue;
                ((EsCallRecordHistoryBO)callRecord.get(i)).setProduct_name("--");
            }
            long totalSize = response.getTotalSize();
            log.info("\u603b\u8bb0\u5f55\u6570\uff1a{}", (Object)totalSize);
            List esCallRecord = JSONArray.parseArray((String)JSONObject.toJSONString((Object)callRecord), Object.class);
            return BaseRspUtils.createSuccessRspList((List)esCallRecord, (long)totalSize);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    public Rsp exportEsGetSeatsCallHistory(GetEsSeatsCallHistoryReqBO reqBO) {
        log.info("\u8fdb\u5165Es\u5bfc\u51fa\u4e2a\u4eba\u5916\u547c\u8bb0\u5f55\u63a5\u53e3\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ClientInterface restClient = this.bBossEsStarter.getConfigRestClient("esMapper/EsCallRecordHistory.xml");
        String fileName = "\u4e2a\u4eba\u5916\u547c\u8bb0\u5f55_" + reqBO.getTenantCode() + "_" + System.currentTimeMillis();
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            return BaseRspUtils.createErrorRsp((String)"\u65f6\u95f4\u8303\u56f4\u5fc5\u586b");
        }
        if (!DateUtil.checkTimeSpan(reqBO.getStartTime(), reqBO.getEndTime(), OcsConstant.SPAN_NUM).booleanValue()) {
            return BaseRspUtils.createErrorRsp((String)"\u6700\u5927\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc76\u4e2a\u6708");
        }
        LoginInfo loginInfo = reqBO.getLoginInfo();
        if (null == loginInfo) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u83b7\u53d6\u5230\u5750\u5e2d\u4fe1\u606f");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> scrollIds = new ArrayList<String>();
        ArrayList<ExcelEsSeatsCallHistoryBO> excelEsSeatsCallHistoryBOS = new ArrayList<ExcelEsSeatsCallHistoryBO>();
        Integer indexCode = 1;
        ArrayList seatsCallHistoric = new ArrayList();
        params.put("startTime", reqBO.getStartTime());
        params.put("endTime", reqBO.getEndTime());
        params.put("userId", loginInfo.getUserId());
        if (!StringUtils.isEmpty((Object)reqBO.getCalled())) {
            params.put("called", "*" + reqBO.getCalled() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCalling())) {
            params.put("calling", "*" + reqBO.getCalling() + "*");
        }
        if (null != reqBO.getConnState()) {
            params.put("connState", reqBO.getConnState());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTaskName())) {
            params.put("taskName", "*" + reqBO.getTaskName() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getProductName())) {
            params.put("productName", "*" + reqBO.getProductName() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getHandleResults())) {
            params.put("handleResults", reqBO.getHandleResults());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSuccessProduct())) {
            params.put("successProduct", "*" + reqBO.getSuccessProduct() + "*");
        }
        if (null != reqBO.getIsTaskData()) {
            params.put("isTaskData", reqBO.getIsTaskData());
        }
        try {
            ESDatas response = restClient.searchList(this.indexName + "/_search?scroll=1m", "exportEsGetSeatsCallHistory", params, EsCallRecordHistoryBO.class);
            long totalSize = response.getTotalSize();
            log.info("\u603b\u8bb0\u5f55\u6570\uff1a{}", (Object)totalSize);
            if (totalSize == 0L) {
                return BaseRspUtils.createErrorRsp((String)"\u672a\u83b7\u53d6\u5230\u5916\u547c\u8bb0\u5f55");
            }
            List seatsCallHistory = response.getDatas();
            String scrollId = response.getScrollId();
            if (!StringUtils.isEmpty((Object)scrollId)) {
                scrollIds.add(scrollId);
            }
            if (null != seatsCallHistory && seatsCallHistory.size() > 0) {
                seatsCallHistoric.addAll(seatsCallHistory);
                while (true) {
                    if (!StringUtils.isEmpty((Object)(scrollId = (response = restClient.searchScroll("1m", scrollId, EsCallRecordHistoryBO.class)).getScrollId()))) {
                        scrollIds.add(scrollId);
                    }
                    if (null == (seatsCallHistory = response.getDatas()) || seatsCallHistory.size() == 0) break;
                    seatsCallHistoric.addAll(seatsCallHistory);
                }
                for (int i = 0; i < seatsCallHistoric.size(); ++i) {
                    String is_conn = ((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getIs_conn();
                    String obs_is_conn = ((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getObs_is_conn();
                    if ("1".equals(is_conn) && "1".equals(obs_is_conn)) {
                        ((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).setConnState("\u5df2\u63a5\u901a");
                    } else {
                        ((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).setConnState("\u672a\u63a5\u901a");
                    }
                    if (StringUtils.isEmpty((Object)((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getTask_name())) {
                        ((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).setTask_name("--");
                    }
                    if (StringUtils.isEmpty((Object)((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getProduct_name())) {
                        ((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).setProduct_name("--");
                    }
                    ExcelEsSeatsCallHistoryBO excelEsSeatsCallHistoryBO = new ExcelEsSeatsCallHistoryBO();
                    excelEsSeatsCallHistoryBO.setIndexCode(indexCode + "");
                    excelEsSeatsCallHistoryBO.setTaskName(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getTask_name());
                    excelEsSeatsCallHistoryBO.setProductName(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getProduct_name());
                    excelEsSeatsCallHistoryBO.setCalling(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getCalling());
                    excelEsSeatsCallHistoryBO.setCalled(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getCalled());
                    excelEsSeatsCallHistoryBO.setCityName(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getCity_name());
                    excelEsSeatsCallHistoryBO.setStartTime(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getStart_time());
                    excelEsSeatsCallHistoryBO.setEndTime(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getEnd_time());
                    excelEsSeatsCallHistoryBO.setContactLength(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getContact_length());
                    excelEsSeatsCallHistoryBO.setConnStatus(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getConnState());
                    excelEsSeatsCallHistoryBO.setHandleResults(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getHandle_results());
                    excelEsSeatsCallHistoryBO.setRemark(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getRemark());
                    excelEsSeatsCallHistoryBO.setSuggestProduct(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getSuggest_product());
                    excelEsSeatsCallHistoryBO.setSuccessProduct(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getSuccess_product());
                    excelEsSeatsCallHistoryBO.setAccount(((EsCallRecordHistoryBO)seatsCallHistoric.get(i)).getAccount());
                    Integer n = indexCode;
                    Integer n2 = indexCode = Integer.valueOf(indexCode + 1);
                    excelEsSeatsCallHistoryBOS.add(excelEsSeatsCallHistoryBO);
                }
            }
            if (scrollIds.size() > 0) {
                restClient.deleteScrolls(scrollIds);
            }
            String filePath = null;
            filePath = this.excelHelper.writeExcel(excelEsSeatsCallHistoryBOS, ExcelEsSeatsCallHistoryBO.class, fileName);
            filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
            log.info("filePath:{}", (Object)filePath);
            ExportRspBO exportRspBO = new ExportRspBO();
            exportRspBO.setFilePath(filePath);
            exportRspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
            return BaseRspUtils.createSuccessRsp((Object)exportRspBO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
        }
    }

    public Rsp exportEsQryCallRecord(QryEsCallRecordReqBO reqBO) {
        LoginInfo loginInfo;
        log.info("\u8fdb\u5165Es\u5bfc\u51fa\u5916\u547c\u8bb0\u5f55\u63a5\u53e3\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ClientInterface restClient = this.bBossEsStarter.getConfigRestClient("esMapper/EsCallRecordHistory.xml");
        String fileName = "\u5916\u547c\u8bb0\u5f55_" + reqBO.getTenantCode() + "_" + System.currentTimeMillis();
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            return BaseRspUtils.createErrorRsp((String)"\u65f6\u95f4\u8303\u56f4\u5fc5\u586b");
        }
        if (!DateUtil.checkTimeSpan(reqBO.getStartTime(), reqBO.getEndTime(), OcsConstant.SPAN_NUM).booleanValue()) {
            return BaseRspUtils.createErrorRsp((String)"\u6700\u5927\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc76\u4e2a\u6708");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> scrollIds = new ArrayList<String>();
        ArrayList callRecords = new ArrayList();
        ArrayList<String> tenantIds = new ArrayList<String>();
        Integer indexCode = 1;
        ArrayList<ExcelEsSeatsCallHistoryBO> excelEsSeatsCallHistoryBOS = new ArrayList<ExcelEsSeatsCallHistoryBO>();
        params.put("startTime", reqBO.getStartTime());
        params.put("endTime", reqBO.getEndTime());
        if (!StringUtils.isEmpty((Object)reqBO.getCalled())) {
            params.put("called", "*" + reqBO.getCalled() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCalling())) {
            params.put("calling", "*" + reqBO.getCalling() + "*");
        }
        if (null != reqBO.getConnState()) {
            params.put("connState", reqBO.getConnState());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getRealName())) {
            params.put("realName", "*" + reqBO.getRealName() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getAccount())) {
            params.put("account", "*" + reqBO.getAccount() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTaskName())) {
            params.put("taskName", "*" + reqBO.getTaskName() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getProductName())) {
            params.put("productName", "*" + reqBO.getProductName() + "*");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getHandleResults())) {
            params.put("handleResults", reqBO.getHandleResults());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSuccessProduct())) {
            params.put("successProduct", "*" + reqBO.getSuccessProduct() + "*");
        }
        if (null != reqBO.getIsTaskData()) {
            params.put("isTaskData", reqBO.getIsTaskData());
        }
        if (null == (loginInfo = reqBO.getLoginInfo())) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u83b7\u53d6\u5230\u767b\u5f55\u4fe1\u606f");
        }
        List roleNames = this.bladeUserInterService.getUserRoleInfo(loginInfo.getUserId());
        if (null == roleNames || roleNames.size() == 0) {
            log.error("\u89d2\u8272\u83b7\u53d6\u5931\u8d25\uff0cuserId\uff1a{}", (Object)loginInfo.getUserId());
            return BaseRspUtils.createErrorRsp((String)"\u672a\u83b7\u53d6\u5230\u89d2\u8272\u4fe1\u606f");
        }
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        for (String role : roleNames) {
            if ("system:admin".equals(role) || "system:administrator".equals(role)) {
                if (null == reqBO.getTenantIds() || reqBO.getTenantIds().size() <= 0) break;
                tenantIds.addAll(reqBO.getTenantIds());
                break;
            }
            if (StringUtils.isEmpty((Object)tenantId)) {
                return BaseRspUtils.createErrorRsp((String)"\u672a\u83b7\u53d6\u5230\u79df\u6237\u4fe1\u606f");
            }
            tenantIds.add(tenantId);
        }
        log.info("\u79df\u6237id:{}", tenantIds);
        if (null != tenantIds && tenantIds.size() > 0) {
            params.put("tenantIds", tenantIds);
        }
        try {
            ESDatas response = restClient.searchList(this.indexName + "/_search?scroll=1m", "exportEsQryCallRecord", params, EsCallRecordHistoryBO.class);
            long totalSize = response.getTotalSize();
            log.info("\u603b\u8bb0\u5f55\u6570\uff1a{}", (Object)totalSize);
            if (totalSize == 0L) {
                return BaseRspUtils.createErrorRsp((String)"\u672a\u83b7\u53d6\u5230\u5916\u547c\u8bb0\u5f55");
            }
            List callRecord = response.getDatas();
            String scrollId = response.getScrollId();
            if (!StringUtils.isEmpty((Object)scrollId)) {
                scrollIds.add(scrollId);
            }
            if (null != callRecord && callRecord.size() > 0) {
                callRecords.addAll(callRecord);
                while (true) {
                    if (!StringUtils.isEmpty((Object)(scrollId = (response = restClient.searchScroll("1m", scrollId, EsCallRecordHistoryBO.class)).getScrollId()))) {
                        scrollIds.add(scrollId);
                    }
                    if (null == (callRecord = response.getDatas()) || callRecord.size() == 0) break;
                    callRecords.addAll(callRecord);
                }
                for (int i = 0; i < callRecords.size(); ++i) {
                    String is_conn = ((EsCallRecordHistoryBO)callRecords.get(i)).getIs_conn();
                    String obs_is_conn = ((EsCallRecordHistoryBO)callRecords.get(i)).getObs_is_conn();
                    if ("1".equals(is_conn) && "1".equals(obs_is_conn)) {
                        ((EsCallRecordHistoryBO)callRecords.get(i)).setConnState("\u5df2\u63a5\u901a");
                    } else {
                        ((EsCallRecordHistoryBO)callRecords.get(i)).setConnState("\u672a\u63a5\u901a");
                    }
                    if (StringUtils.isEmpty((Object)((EsCallRecordHistoryBO)callRecords.get(i)).getTask_name())) {
                        ((EsCallRecordHistoryBO)callRecords.get(i)).setTask_name("--");
                    }
                    if (StringUtils.isEmpty((Object)((EsCallRecordHistoryBO)callRecords.get(i)).getProduct_name())) {
                        ((EsCallRecordHistoryBO)callRecords.get(i)).setProduct_name("--");
                    }
                    ExcelEsSeatsCallHistoryBO excelEsSeatsCallHistoryBO = new ExcelEsSeatsCallHistoryBO();
                    excelEsSeatsCallHistoryBO.setIndexCode(indexCode + "");
                    excelEsSeatsCallHistoryBO.setTaskName(((EsCallRecordHistoryBO)callRecords.get(i)).getTask_name());
                    excelEsSeatsCallHistoryBO.setProductName(((EsCallRecordHistoryBO)callRecords.get(i)).getProduct_name());
                    excelEsSeatsCallHistoryBO.setCalling(((EsCallRecordHistoryBO)callRecords.get(i)).getCalling());
                    excelEsSeatsCallHistoryBO.setCalled(((EsCallRecordHistoryBO)callRecords.get(i)).getCalled());
                    excelEsSeatsCallHistoryBO.setCityName(((EsCallRecordHistoryBO)callRecords.get(i)).getCity_name());
                    excelEsSeatsCallHistoryBO.setStartTime(((EsCallRecordHistoryBO)callRecords.get(i)).getStart_time());
                    excelEsSeatsCallHistoryBO.setEndTime(((EsCallRecordHistoryBO)callRecords.get(i)).getEnd_time());
                    excelEsSeatsCallHistoryBO.setContactLength(((EsCallRecordHistoryBO)callRecords.get(i)).getContact_length());
                    excelEsSeatsCallHistoryBO.setConnStatus(((EsCallRecordHistoryBO)callRecords.get(i)).getConnState());
                    excelEsSeatsCallHistoryBO.setHandleResults(((EsCallRecordHistoryBO)callRecords.get(i)).getHandle_results());
                    excelEsSeatsCallHistoryBO.setRemark(((EsCallRecordHistoryBO)callRecords.get(i)).getRemark());
                    excelEsSeatsCallHistoryBO.setSuggestProduct(((EsCallRecordHistoryBO)callRecords.get(i)).getSuggest_product());
                    excelEsSeatsCallHistoryBO.setSuccessProduct(((EsCallRecordHistoryBO)callRecords.get(i)).getSuccess_product());
                    excelEsSeatsCallHistoryBO.setAccount(((EsCallRecordHistoryBO)callRecords.get(i)).getAccount());
                    Integer n = indexCode;
                    Integer n2 = indexCode = Integer.valueOf(indexCode + 1);
                    excelEsSeatsCallHistoryBOS.add(excelEsSeatsCallHistoryBO);
                }
            }
            if (scrollIds.size() > 0) {
                restClient.deleteScrolls(scrollIds);
            }
            String filePath = null;
            filePath = this.excelHelper.writeExcel(excelEsSeatsCallHistoryBOS, ExcelEsSeatsCallHistoryBO.class, fileName);
            filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
            log.info("filePath:{}", (Object)filePath);
            ExportRspBO exportRspBO = new ExportRspBO();
            exportRspBO.setFilePath(filePath);
            exportRspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
            return BaseRspUtils.createSuccessRsp((Object)exportRspBO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
        }
    }

    public RspList<CallRecordHistoryBO> getSeatsCallHistoryRefactor(GetSeatsCallHistoryReqBO reqBO) {
        log.info("\u8fdb\u5165\u4e2a\u4eba\u5916\u547c\u8bb0\u5f55\u91cd\u6784\u63a5\u53e3\uff0c \u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ArrayList<CallRecordHistoryBO> rspBOS = new ArrayList<CallRecordHistoryBO>();
        PageInfo pageInfo = null;
        try {
            String tenantId;
            String string = tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
            if (StringUtils.isEmpty((Object)tenantId)) {
                return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BladeTenantBO tenantInfo = this.getTenantInfo(reqBO.getTenantCode());
            if (tenantInfo == null) {
                return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
            }
            LoginInfo loginInfo = reqBO.getLoginInfo();
            if (null == loginInfo) {
                return BaseRspUtils.createErrorRspList((String)"\u672a\u83b7\u53d6\u5230\u5750\u5e2d\u4fe1\u606f");
            }
            BladeUserBO userBO = this.bladeUserInterService.queryUserInfo(loginInfo.getUserId());
            if (null == userBO) {
                return BaseRspUtils.createErrorRspList((String)"\u672a\u83b7\u53d6\u5230\u5750\u5e2d\u4fe1\u606f");
            }
            if (!DateUtil.checkTimeSpan(reqBO.getStartTime(), reqBO.getEndTime(), OcsConstant.SPAN_NUM).booleanValue()) {
                return BaseRspUtils.createErrorRspList((String)"\u6700\u5927\u67e5\u8be2\u65f6\u95f4\u8303\u56f4\u4e3a6\u4e2a\u6708");
            }
            List<Object> custServeRecordPOS = new ArrayList();
            ArrayList<String> ucIds = new ArrayList<String>();
            if (!StringUtils.isEmpty((Object)reqBO.getUserPurpose())) {
                custServeRecordPOS = this.qryHandleResults(reqBO.getUserPurpose(), tenantInfo, reqBO.getStartTime(), reqBO.getEndTime());
                if (null == custServeRecordPOS || custServeRecordPOS.size() == 0) {
                    return BaseRspUtils.createSuccessRspList(rspBOS);
                }
                custServeRecordPOS.forEach(x -> ucIds.add(x.getUcId()));
            }
            List<ObTaskInfoPO> taskInfoPOS = new ArrayList();
            ArrayList<String> taskIds = new ArrayList<String>();
            if (!StringUtils.isEmpty((Object)reqBO.getTaskName())) {
                ObTaskInfoPO taskInfoPO = new ObTaskInfoPO();
                taskInfoPO.setTaskName(reqBO.getTaskName());
                taskInfoPOS = this.obTaskInfoDAO.selectTaskIdByTaskName(taskInfoPO);
                if (null == taskInfoPOS || taskInfoPOS.size() == 0) {
                    return BaseRspUtils.createSuccessRspList(rspBOS);
                }
                taskInfoPOS.forEach(x -> taskIds.add(x.getTaskId()));
            }
            List<Object> targetPOS = new ArrayList();
            ArrayList<String> dataIds = new ArrayList<String>();
            if (!StringUtils.isEmpty((Object)reqBO.getProductName())) {
                targetPOS = this.qryTaskData(reqBO.getProductName(), tenantInfo);
                if (null == targetPOS || targetPOS.size() == 0) {
                    return BaseRspUtils.createSuccessRspList(rspBOS);
                }
                targetPOS.forEach(x -> dataIds.add(x.getDataId()));
            }
            List<Object> productSubscribePOS = new ArrayList();
            ArrayList<String> productUcIds = new ArrayList<String>();
            if (!StringUtils.isEmpty((Object)reqBO.getSuccessProduct())) {
                productSubscribePOS = this.qryProductSubscribe(reqBO.getSuccessProduct(), tenantId);
                if (null == productSubscribePOS || productSubscribePOS.size() == 0) {
                    return BaseRspUtils.createSuccessRspList(rspBOS);
                }
                productSubscribePOS.forEach(x -> productUcIds.add(x.getUcId()));
            }
            QryCallRecordReqBO recordReqBO = new QryCallRecordReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)recordReqBO);
            ObCallRecordPO recordPO = this.getCallRecordPO(tenantInfo, recordReqBO, ucIds, taskIds, productUcIds, Collections.singletonList(loginInfo.getUserId()), dataIds);
            log.info("\u67e5\u8be2\u4e2a\u4eba\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)recordPO));
            PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
            List callRecordPOS = this.obCallRecordDAO.selectCallRecords(recordPO);
            pageInfo = new PageInfo(callRecordPOS);
            if (null != callRecordPOS && callRecordPOS.size() > 0) {
                HashMap<String, ObTaskInfoPO> map = new HashMap<String, ObTaskInfoPO>();
                HashMap<String, List<Object>> custMap = new HashMap<String, List<Object>>();
                for (ObCallRecordPO po : callRecordPOS) {
                    ObCustServeRecordPO serveRecordPO;
                    CallRecordHistoryBO bo = new CallRecordHistoryBO();
                    bo.setRecordId(po.getRecordId());
                    bo.setTaskId(po.getTaskId());
                    ObTaskInfoPO taskInfo = new ObTaskInfoPO();
                    if (!map.containsKey(po.getTaskId())) {
                        taskInfo = this.getTaskName(po.getTaskId(), taskInfoPOS);
                        map.put(po.getTaskId(), taskInfo);
                    } else {
                        taskInfo = (ObTaskInfoPO)map.get(po.getTaskId());
                    }
                    String taskName = "--";
                    String taskId = "ACTIVE_OUT";
                    if (null != taskInfo) {
                        taskName = taskInfo.getTaskName();
                        taskId = taskInfo.getTaskId();
                    }
                    bo.setTaskName(taskName);
                    bo.setTaskId(taskId);
                    bo.setCalling(po.getCalling());
                    bo.setCalled(po.getCalled());
                    bo.setContactLength(po.getContactLength());
                    if (po.getIsConn().equals("1") && po.getObsIsConn().equals("1")) {
                        bo.setConnStatus("\u5df2\u63a5\u901a");
                    } else {
                        bo.setConnStatus("\u672a\u63a5\u901a");
                    }
                    bo.setCallType(po.getCallType());
                    bo.setStartTime(po.getStartTime());
                    bo.setEndTime(po.getEndTime());
                    bo.setSuggestProduct(po.getSuggestProduct());
                    ObDataTargetPO dataPO = this.getDataPO(po.getDataId(), tenantInfo, targetPOS);
                    String productName = "--";
                    if (null != dataPO) {
                        productName = dataPO.getProductName();
                        bo.setMainProductId(dataPO.getProduct());
                    }
                    bo.setMainProduct(productName);
                    bo.setCity(StringUtils.isEmpty((Object)AreaCache.getArea(po.getCity())) ? po.getCity() : AreaCache.getArea(po.getCity()));
                    bo.setRecordFile(po.getRecordFile());
                    Integer flag = null;
                    if (null == custServeRecordPOS || custServeRecordPOS.size() == 0) {
                        if (!custMap.containsKey(po.getTaskId())) {
                            serveRecordPO = new ObCustServeRecordPO();
                            serveRecordPO.setTenantId(po.getTenantId());
                            serveRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
                            serveRecordPO.setTaskId(po.getTaskId());
                            serveRecordPO.setQryStartTime(reqBO.getStartTime());
                            serveRecordPO.setQryEndTime(reqBO.getEndTime());
                            custServeRecordPOS = this.obCustServeRecordDAO.getCustServeRecord(serveRecordPO);
                            custMap.put(po.getTaskId(), custServeRecordPOS);
                        } else {
                            custServeRecordPOS = (List)custMap.get(po.getTaskId());
                        }
                        flag = 0;
                    }
                    if (null == custServeRecordPOS || custServeRecordPOS.size() == 0) {
                        if (!custMap.containsKey(po.getTaskId())) {
                            serveRecordPO = new ObCustServeRecordPO();
                            serveRecordPO.setTenantId(po.getTenantId());
                            serveRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
                            serveRecordPO.setTaskId(po.getTaskId());
                            serveRecordPO.setQryStartTime(reqBO.getStartTime());
                            serveRecordPO.setQryEndTime(reqBO.getEndTime());
                            custServeRecordPOS = this.obCustServeRecordDAO.getCustServeRecord(serveRecordPO);
                            custMap.put(po.getTaskId(), custServeRecordPOS);
                        } else {
                            custServeRecordPOS = (List)custMap.get(po.getTaskId());
                        }
                        flag = 0;
                    }
                    ObCustServeRecordPO custServerInfo = this.getCustServerInfo(po.getUcId(), custServeRecordPOS, tenantInfo.getTenantOtherName());
                    if (null != flag && flag.equals(0)) {
                        custServeRecordPOS = new ArrayList();
                    }
                    if (null != custServerInfo) {
                        bo.setUserPurpose(custServerInfo.getHandleResults());
                        bo.setRemark(custServerInfo.getHandleRemark());
                    }
                    bo.setTenantId(tenantId);
                    bo.setTenantName(tenantInfo.getTenantName());
                    bo.setUcId(po.getUcId());
                    bo.setCreateTime(po.getCreateTime());
                    String successProducts = this.getSuccessProducts(po.getUcId(), productSubscribePOS);
                    bo.setSuccessProduct(successProducts);
                    if (null != userBO) {
                        bo.setLoginName(userBO.getAccount());
                        bo.setRealName(userBO.getRealName());
                    }
                    rspBOS.add(bo);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)"\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)pageInfo.getTotal());
    }

    private ObCallRecordPO getCallRecordPO(BladeTenantBO tenantInfo, QryCallRecordReqBO reqBO, List<String> ucIds, List<String> taskIds, List<String> productUcIds, List<String> userIds, List<String> dataIds) {
        ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
        obCallRecordPO.setTenantId(tenantInfo.getTenantId());
        obCallRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        obCallRecordPO.setCalling(reqBO.getCalling());
        obCallRecordPO.setCalled(reqBO.getCalled());
        obCallRecordPO.setStartTime(reqBO.getStartTime());
        obCallRecordPO.setEndTime(reqBO.getEndTime());
        obCallRecordPO.setIsTaskData(reqBO.getIsTaskData());
        obCallRecordPO.setConnStatus(reqBO.getConnStatus());
        obCallRecordPO.setUcIds(ucIds);
        obCallRecordPO.setProductUcIds(productUcIds);
        obCallRecordPO.setTaskIds(taskIds);
        obCallRecordPO.setUserIds(userIds);
        obCallRecordPO.setDataIds(dataIds);
        return obCallRecordPO;
    }

    private ObCallRecordPO getCallRecord(String ucId, BladeTenantBO tenantBO, List<ObCallRecordPO> callRecordPOs) {
        ObCallRecordPO callRecordPO;
        List collect = callRecordPOs.stream().filter(x -> ucId.equals(x.getUcId())).collect(Collectors.toList());
        if (null != collect && collect.size() > 0) {
            callRecordPO = (ObCallRecordPO)collect.get(0);
        } else {
            ObCallRecordPO recordPO = new ObCallRecordPO();
            recordPO.setTenantId(tenantBO.getTenantId());
            recordPO.setTenantOtherName(tenantBO.getTenantOtherName());
            recordPO.setUcId(ucId);
            callRecordPO = this.obCallRecordDAO.selectByUcId(recordPO);
        }
        return callRecordPO;
    }

    private List<ObProductSubscribePO> qryProductSubscribe(String successProduct, String tenantId) {
        ObProductSubscribePO productSubscribePO = new ObProductSubscribePO();
        productSubscribePO.setTenantId(tenantId);
        productSubscribePO.setProductName(successProduct);
        return this.obProductSubscribeDAO.selectUcId(productSubscribePO);
    }

    private List<ObCustServeRecordPO> qryHandleResults(String userPurpose, BladeTenantBO tenantBO, String startTime, String endTime) {
        ObCustServeRecordPO custServeRecordPO = new ObCustServeRecordPO();
        custServeRecordPO.setTenantId(tenantBO.getTenantId());
        custServeRecordPO.setTenantOtherName(tenantBO.getTenantOtherName());
        custServeRecordPO.setHandleResults(userPurpose);
        custServeRecordPO.setQryStartTime(startTime);
        custServeRecordPO.setQryEndTime(endTime);
        return this.obCustServeRecordDAO.selectUcIdByHandleResults(custServeRecordPO);
    }

    private List<ObDataTargetPO> qryTaskData(String productName, BladeTenantBO tenantBO) {
        ObDataTargetPO dataTargetPO = new ObDataTargetPO();
        dataTargetPO.setTenantId(tenantBO.getTenantId());
        dataTargetPO.setTenantOtherName(tenantBO.getTenantOtherName());
        dataTargetPO.setProductName(productName);
        return this.obDataTargetDAO.selectByProductName(dataTargetPO);
    }

    private List<ObTaskInfoPO> qryTask(String taskName) {
        ObTaskInfoPO taskInfoPO = new ObTaskInfoPO();
        taskInfoPO.setTaskName(taskName);
        return this.obTaskInfoDAO.selectTaskIdByTaskName(taskInfoPO);
    }

    private ObDataTargetPO getDataPO(String dataId, BladeTenantBO tenantBO, List<ObDataTargetPO> dataTargetPOS) {
        ObDataTargetPO targetPO;
        if (StringUtils.isEmpty((Object)dataId)) {
            return null;
        }
        List collect = dataTargetPOS.stream().filter(x -> dataId.equals(x.getDataId())).collect(Collectors.toList());
        if (null == collect || collect.size() == 0) {
            ObDataTargetPO dataTargetPO = new ObDataTargetPO();
            dataTargetPO.setTenantId(tenantBO.getTenantId());
            dataTargetPO.setTenantOtherName(tenantBO.getTenantOtherName());
            dataTargetPO.setDataId(dataId);
            targetPO = this.obDataTargetDAO.selectByDataId(dataTargetPO);
        } else {
            targetPO = (ObDataTargetPO)collect.get(0);
        }
        return targetPO;
    }

    private String getSuccessProducts(String ucId, List<ObProductSubscribePO> productSubscribePOS) {
        ArrayList successProducts = new ArrayList();
        String successProduct = "";
        List<Object> collect = new ArrayList();
        collect = null != productSubscribePOS && productSubscribePOS.size() > 0 ? productSubscribePOS.stream().filter(x -> ucId.equals(x.getUcId())).collect(Collectors.toList()) : this.obProductSubscribeDAO.selectByUcId(ucId);
        if (null != collect && collect.size() > 0) {
            collect.forEach(x -> successProducts.add(x.getProductName()));
            successProduct = String.join((CharSequence)",", successProducts);
        }
        return successProduct;
    }

    private ObCustServeRecordPO getCustServerInfo(String ucId, List<ObCustServeRecordPO> obCustServeRecordPOS, String tenantOtherName) {
        ObCustServeRecordPO serveRecordPO = null;
        List<Object> collect = new ArrayList();
        if (null != obCustServeRecordPOS && obCustServeRecordPOS.size() > 0) {
            collect = obCustServeRecordPOS.stream().filter(x -> ucId.equals(x.getUcId())).collect(Collectors.toList());
        }
        if (null != collect && collect.size() > 0) {
            serveRecordPO = (ObCustServeRecordPO)collect.get(0);
        }
        return serveRecordPO;
    }

    private ObTaskInfoPO getTaskName(String taskId, List<ObTaskInfoPO> taskInfoPOS) {
        ObTaskInfoPO taskInfoPO = new ObTaskInfoPO();
        if (null != taskInfoPOS && taskInfoPOS.size() > 0) {
            List collect = taskInfoPOS.stream().filter(x -> taskId.equals(x.getTaskId())).collect(Collectors.toList());
            if (null != collect && collect.size() > 0) {
                taskInfoPO = (ObTaskInfoPO)collect.get(0);
            }
        } else {
            taskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(taskId);
        }
        return taskInfoPO;
    }

    private List<BladeUserBO> getCustIds(String customerName, String loginName) {
        List userBOS = this.bladeUserInterService.queryUserIds(customerName, loginName);
        return userBOS;
    }

    private List<ObCustServeRecordPO> getUcId(ObCustServeRecordPO custServeRecordPO) {
        List<Object> obCustServeRecordPOS = new ArrayList<ObCustServeRecordPO>();
        if (null != custServeRecordPO.getUserIds() && custServeRecordPO.getUserIds().size() > 0 && !StringUtils.isEmpty((Object)custServeRecordPO.getHandleResults())) {
            obCustServeRecordPOS = this.obCustServeRecordDAO.selectUcId(custServeRecordPO);
        } else if (null != custServeRecordPO.getUserIds() && custServeRecordPO.getUserIds().size() > 0) {
            obCustServeRecordPOS = this.obCustServeRecordDAO.selectUcIdByUserIds(custServeRecordPO);
        } else if (!StringUtils.isEmpty((Object)custServeRecordPO.getHandleResults())) {
            obCustServeRecordPOS = this.obCustServeRecordDAO.selectUcIdByHandleResults(custServeRecordPO);
        }
        return obCustServeRecordPOS;
    }

    private List<ObCallRecordAnswer> getScriptAnswerInfo(String callId, BladeTenantBO tenantInfo) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u63d0\u4ea4\u95ee\u5377\u8bb0\u5f55\uff0cdataId\uff1a{}\uff0c tenantInfo\uff1a{}", (Object)callId, (Object)JSONObject.toJSONString((Object)tenantInfo));
        ObCallRecordAnswer recordAnswer = new ObCallRecordAnswer();
        recordAnswer.setTenantId(tenantInfo.getTenantId());
        recordAnswer.setCallId(callId);
        log.info("\u83b7\u53d6\u63d0\u4ea4\u95ee\u5377\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)recordAnswer));
        List answers = this.obCallRecordAnswerMapper.selectByDataId(recordAnswer);
        log.info("\u83b7\u53d6\u63d0\u4ea4\u95ee\u5377\u8bb0\u5f55Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)answers));
        return answers;
    }

    private ObDataTargetPO getTaskData(String dataId, BladeTenantBO tenantInfo) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u4efb\u52a1\u6570\u636e\u4fe1\u606f\uff0c dataId\uff1a{}\uff0c tenangInfo\uff1a{}", (Object)dataId, (Object)JSONObject.toJSONString((Object)tenantInfo));
        ObDataTargetPO obDataTargetPO = new ObDataTargetPO();
        obDataTargetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        obDataTargetPO.setTenantId(tenantInfo.getTenantId());
        obDataTargetPO.setDataId(dataId);
        log.info("\u83b7\u53d6\u4efb\u52a1\u6570\u636eMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obDataTargetPO));
        ObDataTargetPO targetPO = this.obDataTargetDAO.selectByDataId(obDataTargetPO);
        return targetPO;
    }

    private ObCallRecordPO getCallRecord(String ucId, BladeTenantBO tenantInfo) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u5916\u547c\u8bb0\u5f55\uff0c ucId:{}, tenantInfo:{}", (Object)ucId, (Object)JSONObject.toJSONString((Object)tenantInfo));
        ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
        obCallRecordPO.setTenantId(tenantInfo.getTenantId());
        obCallRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        obCallRecordPO.setUcId(ucId);
        log.info("\u67e5\u8be2\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCallRecordPO));
        ObCallRecordPO recordPO = this.obCallRecordDAO.selectByUcId(obCallRecordPO);
        return recordPO;
    }

    private List<ObCustServeRecordPO> getCustServerRecords(GetSeatsCallHistoryReqBO reqBO, BladeTenantBO tenantInfo) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u5ba2\u670d\u670d\u52a1\u8bb0\u5f55\u4fe1\u606f\uff0c reqBO\uff1a{}\uff0c tenantInfo\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO), (Object)JSONObject.toJSONString((Object)tenantInfo));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LoginInfo loginInfo = reqBO.getLoginInfo();
        Date startTime = null;
        Date endTime = null;
        if (!StringUtils.isEmpty((Object)reqBO.getStartTime()) && !StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            try {
                startTime = format.parse(reqBO.getStartTime());
                endTime = format.parse(reqBO.getEndTime());
            }
            catch (ParseException e) {
                log.error("\u65f6\u95f4\u8f6c\u6362\u5931\u8d25");
                e.printStackTrace();
            }
        }
        ObCustServeRecordPO obCustServeRecordPO = new ObCustServeRecordPO();
        obCustServeRecordPO.setStartTime(startTime);
        obCustServeRecordPO.setEndTime(endTime);
        obCustServeRecordPO.setTenantId(tenantInfo.getTenantId());
        obCustServeRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        if (null != loginInfo) {
            obCustServeRecordPO.setHandleUser(loginInfo.getUserId());
        }
        log.info("\u83b7\u53d6\u5ba2\u670d\u670d\u52a1\u8bb0\u5f55\u4fe1\u606fMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCustServeRecordPO));
        List serveRecordPOList = this.obCustServeRecordDAO.queryServiceRecord(obCustServeRecordPO);
        return serveRecordPOList;
    }

    private ObCallRecordPO getRecord(GetSeatsCallHistoryReqBO reqBO, BladeTenantBO tenantInfo, String ucId) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u5916\u547c\u8bb0\u5f55\u4fe1\u606f\uff0c reqBO\uff1a{}\uff0c tenantInfo\uff1a{}\uff0c ucId:{}", new Object[]{JSONObject.toJSONString((Object)reqBO), JSONObject.toJSONString((Object)tenantInfo), ucId});
        ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
        obCallRecordPO.setCalled(reqBO.getCalled());
        obCallRecordPO.setConnStatus(reqBO.getConnStatus());
        obCallRecordPO.setTenantId(tenantInfo.getTenantId());
        obCallRecordPO.setCalling(reqBO.getCalling());
        obCallRecordPO.setIsTaskData(reqBO.getIsTaskData());
        obCallRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        obCallRecordPO.setUcId(ucId);
        log.info("\u83b7\u53d6\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCallRecordPO));
        ObCallRecordPO recordPO = this.obCallRecordDAO.queryCallRecord(obCallRecordPO);
        return recordPO;
    }

    private BladeTenantBO getTenantInfo(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }

    private CallRecordHistoryBO getRspBO(ObCustServeRecordPO serveRecordPO, ObCallRecordPO record, List<ObTaskInfoPO> taskInfos) {
        BladeUserBO userBO;
        CallRecordHistoryBO rspBO = new CallRecordHistoryBO();
        rspBO.setRecordId(record.getRecordId());
        rspBO.setTaskId(record.getTaskId());
        rspBO.setSuggestProduct(record.getSuggestProduct());
        ObTaskInfoPO obTaskInfoPO = null;
        if (!"ACTIVE_OUT".equals(record.getTaskId())) {
            List collect = taskInfos.stream().filter(taskInfo -> record.getTaskId().equals(taskInfo.getTaskId())).collect(Collectors.toList());
            if (null == collect || collect.size() == 0) {
                obTaskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(record.getTaskId());
                log.info("\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskInfoPO));
            } else {
                obTaskInfoPO = (ObTaskInfoPO)collect.get(0);
            }
        }
        rspBO.setTaskName(null == obTaskInfoPO ? "--" : obTaskInfoPO.getTaskName());
        rspBO.setMainProduct(null == obTaskInfoPO ? "--" : obTaskInfoPO.getProductName());
        if (obTaskInfoPO != null) {
            rspBO.setCallType(obTaskInfoPO.getCallType());
            rspBO.setMainProductId(obTaskInfoPO.getProductId());
            if (null != serveRecordPO) {
                String successProduct = this.getSuccessProduct(record.getUcId(), record.getCalled(), obTaskInfoPO.getTenantId());
                rspBO.setSuccessProduct(successProduct);
            }
        } else {
            log.error("\u5f53\u524d\u4efb\u52a1ID\uff1a{}\uff0c \u672a\u83b7\u53d6\u5230\u4efb\u52a1\u4fe1\u606f\uff01", (Object)record.getTaskId());
        }
        rspBO.setCalling(record.getCalling());
        rspBO.setCalled(record.getCalled());
        rspBO.setStartTime(record.getStartTime());
        rspBO.setEndTime(record.getEndTime());
        rspBO.setContactLength(record.getContactLength());
        rspBO.setTenantId(record.getTenantId());
        rspBO.setTenantName(record.getTenantName());
        rspBO.setUcId(record.getUcId());
        rspBO.setCity(StringUtils.isEmpty((Object)AreaCache.getArea(record.getCity())) ? record.getCity() : AreaCache.getArea(record.getCity()));
        if (record.getIsConn().equals("1") && record.getObsIsConn().equals("1")) {
            rspBO.setConnStatus("\u5df2\u63a5\u901a");
        } else {
            rspBO.setConnStatus("\u672a\u63a5\u901a");
        }
        rspBO.setRecordFile(record.getRecordFile());
        if (serveRecordPO != null) {
            rspBO.setUserPurpose(serveRecordPO.getHandleResults());
            userBO = this.bladeUserInterService.queryUserInfo(serveRecordPO.getHandleUser());
            log.info("\u83b7\u53d6\u5750\u5e2d\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)userBO));
            if (userBO != null) {
                rspBO.setLoginName(userBO.getAccount());
            } else {
                log.error("\u5f53\u524d\u5750\u5e2dID\uff1a{}\uff0c\u672a\u83b7\u53d6\u5230\u5750\u5e2d\u4fe1\u606f\uff01", (Object)serveRecordPO.getHandleUsers());
            }
            rspBO.setRemark(serveRecordPO.getHandleRemark());
        } else {
            log.info("\u5f53\u524ducId:{}, \u672a\u83b7\u53d6\u5230\u5750\u5e2d\u63d0\u4ea4\u8bb0\u5f55", (Object)record.getUcId());
        }
        rspBO.setCreateTime(record.getCreateTime());
        if (!StringUtils.isEmpty((Object)record.getUserId())) {
            userBO = this.bladeUserInterService.queryUserInfo(record.getUserId());
            rspBO.setRealName(null == userBO ? null : userBO.getRealName());
        }
        return rspBO;
    }

    private String getSuccessProduct(String ucId, String callId, String tenantId) {
        String successProduct = "";
        ProductSubscribeBO subscribeBO = new ProductSubscribeBO();
        subscribeBO.setUcId(ucId);
        subscribeBO.setCalled(callId);
        subscribeBO.setTenantId(tenantId);
        List subscribeBOS = this.productSubscribeService.getSuccessProduct(subscribeBO);
        if (null == subscribeBOS || subscribeBOS.size() == 0) {
            return successProduct;
        }
        ArrayList products = new ArrayList();
        subscribeBOS.stream().forEach(bo -> products.add(bo.getProductName()));
        successProduct = String.join((CharSequence)",", products);
        return successProduct;
    }

    private List<CallRecordHistoryBO> filterList(List<CallRecordHistoryBO> rspBOS, String patternName) {
        ArrayList<CallRecordHistoryBO> bos = new ArrayList<CallRecordHistoryBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (CallRecordHistoryBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getTaskName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private List<CallRecordHistoryBO> filterListByProductName(List<CallRecordHistoryBO> rspBOS, String patternName) {
        ArrayList<CallRecordHistoryBO> bos = new ArrayList<CallRecordHistoryBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (CallRecordHistoryBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getMainProduct());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private List<CallRecordHistoryBO> filterListByUserPurpose(List<CallRecordHistoryBO> rspBOS, String patternName) {
        ArrayList<CallRecordHistoryBO> bos = new ArrayList<CallRecordHistoryBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (CallRecordHistoryBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getUserPurpose());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private List<CallRecordHistoryBO> filterListBySuccessProductName(List<CallRecordHistoryBO> rspBOS, String patternName) {
        ArrayList<CallRecordHistoryBO> bos = new ArrayList<CallRecordHistoryBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (CallRecordHistoryBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getSuccessProduct());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private List<CallRecordHistoryBO> filterListByLoginName(List<CallRecordHistoryBO> rspBOS, String patternName) {
        ArrayList<CallRecordHistoryBO> bos = new ArrayList<CallRecordHistoryBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (CallRecordHistoryBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getLoginName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private List<CallRecordHistoryBO> filterListByCustName(List<CallRecordHistoryBO> rspBOS, String patternName) {
        ArrayList<CallRecordHistoryBO> bos = new ArrayList<CallRecordHistoryBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (CallRecordHistoryBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getRealName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private Boolean getPatternName(Pattern pattern, String str) {
        Matcher matcher;
        if (!StringUtils.isEmpty((Object)str) && (matcher = pattern.matcher(str)).find()) {
            return true;
        }
        return false;
    }

    private List<ObCallRecordPO> qryCallRecord(QryCallRecordReqBO reqBO, BladeTenantBO tenantInfo) {
        log.info("\u5f00\u59cb\u4ee5\u79df\u6237\u7ef4\u5ea6\u83b7\u53d6\u5916\u547c\u8bb0\u5f55\uff0creqBO\uff1a{}\uff0c tenantInfo\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO), (Object)JSONObject.toJSONString((Object)tenantInfo));
        ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
        obCallRecordPO.setTenantId(tenantInfo.getTenantId());
        obCallRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        obCallRecordPO.setCalled(reqBO.getCalled());
        obCallRecordPO.setConnStatus(reqBO.getConnStatus());
        obCallRecordPO.setStartTime(reqBO.getStartTime());
        obCallRecordPO.setEndTime(reqBO.getEndTime());
        obCallRecordPO.setCalling(reqBO.getCalling());
        obCallRecordPO.setIsTaskData(reqBO.getIsTaskData());
        log.info("\u79df\u6237\u7ef4\u5ea6\u83b7\u53d6\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCallRecordPO));
        List callRecordPOS = this.obCallRecordDAO.queryCallRecords(obCallRecordPO);
        return callRecordPOS;
    }

    private ObCustServeRecordPO queryServiceCallRecord(QryCallRecordReqBO reqBO, BladeTenantBO tenantInfo, String ucId) {
        log.info("\u5f00\u59cb\u4ee5\u79df\u6237\u7ef4\u5ea6\u83b7\u53d6\u5750\u5e2d\u63d0\u4ea4\u8bb0\u5f55, tenantInfo\uff1a{}\uff0c ucId\uff1a{}", (Object)JSONObject.toJSONString((Object)tenantInfo), (Object)ucId);
        ObCustServeRecordPO serveRecordPO = new ObCustServeRecordPO();
        serveRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        serveRecordPO.setTenantId(tenantInfo.getTenantId());
        serveRecordPO.setUcId(ucId);
        serveRecordPO.setHandleResults(reqBO.getUserPurpose());
        log.info("\u79df\u6237\u7ef4\u5ea6\u83b7\u53d6\u5750\u5e2d\u63d0\u4ea4\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)serveRecordPO));
        ObCustServeRecordPO record = this.obCustServeRecordDAO.getServiceRecord(serveRecordPO);
        return record;
    }
}

