/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.statistics;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tydic.nicc.dc.base.bo.LoginInfo;
import com.tydic.nicc.dc.base.bo.Req;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.ExportRspBO;
import com.tydic.nicc.ocs.bo.QjStatisticsReqBO;
import com.tydic.nicc.ocs.bo.QjStatisticsRspBO;
import com.tydic.nicc.ocs.mapper.ObMarketingTaskStatisticsMapper;
import com.tydic.nicc.ocs.mapper.po.ObMarketingTaskStatistics;
import com.tydic.nicc.ocs.service.StatisticsService;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelQjStatistics;
import com.tydic.nicc.ocs.utils.ExcelHelper;
import com.tydic.nicc.ocs.utils.TaskInfoUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@DubboService
public class StatisticsServiceImpl
implements StatisticsService {
    private static final Logger log = LoggerFactory.getLogger(StatisticsServiceImpl.class);
    @Resource
    private ObMarketingTaskStatisticsMapper obMarketingTaskStatisticsMapper;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @Resource
    private ExcelHelper excelHelper;
    @Value(value="${file.path.ftUrl:http://192.168.10.112:8088/upload/}")
    private String path;

    public RspList<QjStatisticsRspBO> qjStatistics(QjStatisticsReqBO reqBO) {
        PageInfo pageInfo;
        log.info("\u8fdb\u5165\u5168\u7586\u6570\u636e\u7edf\u8ba1\u62a5\u8868\u67e5\u8be2\u63a5\u53e3\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ArrayList<QjStatisticsRspBO> rspBOS = new ArrayList<QjStatisticsRspBO>();
        Set roleSet = reqBO.getRoleSet();
        try {
            LoginInfo loginInfo = reqBO.getLoginInfo();
            List roleNames = this.bladeUserInterService.getUserRoleInfo(loginInfo.getUserId());
            ArrayList<String> tenantIds = new ArrayList<String>();
            List bladeTenants = null;
            if (null != reqBO.getTenantIds() && reqBO.getTenantIds().size() > 0) {
                tenantIds.addAll(reqBO.getTenantIds());
            } else {
                tenantIds.add(reqBO.getTenantCode());
                for (String roleAlias : roleNames) {
                    if (null == roleSet || StringUtils.isEmpty((Object)roleAlias) || !roleAlias.equals("system:admin") && !roleAlias.equals("system:administrator")) continue;
                    Req req = new Req();
                    req.setIn_tenantCode(req.getIn_tenantCode());
                    req.setRoleSet(roleSet);
                    bladeTenants = this.bladeTenantInterService.getBalseTenantList(req);
                    if (null == bladeTenants) break;
                    tenantIds.addAll(bladeTenants.stream().map(x -> x.getTenantId()).collect(Collectors.toList()));
                    break;
                }
            }
            if (StringUtils.isEmpty((Object)reqBO.getStartTime())) {
                return BaseRspUtils.createErrorRspList((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65f6\u95f4");
            }
            if (StringUtils.isEmpty((Object)reqBO.getEndTime())) {
                return BaseRspUtils.createErrorRspList((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u65f6\u95f4");
            }
            log.info("\u5168\u7586\u6570\u636e\u7edf\u8ba1\u62a5\u8868\u67e5\u8be2Mapper\u5c42\u5165\u53c2, startTime:{}, endTime:{}, tenantIds:{}", new Object[]{reqBO.getStartTime(), reqBO.getEndTime(), JSONObject.toJSONString(tenantIds)});
            PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
            List marketingTaskStatistics = this.obMarketingTaskStatisticsMapper.selectQjStatistics(reqBO.getStartTime(), reqBO.getEndTime(), tenantIds);
            pageInfo = new PageInfo(marketingTaskStatistics);
            log.info("\u5168\u7586\u6570\u636e\u7edf\u8ba1\u62a5\u8868\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)marketingTaskStatistics));
            if (marketingTaskStatistics != null && marketingTaskStatistics.size() > 0) {
                for (ObMarketingTaskStatistics statistics : marketingTaskStatistics) {
                    QjStatisticsRspBO rspBO = new QjStatisticsRspBO();
                    rspBO.setCallNumber(statistics.getCallNumber());
                    rspBO.setTenantName(this.getTenantInfo(statistics.getTenantCode()).getTenantName());
                    rspBO.setConnectNumber(statistics.getConnectNumber());
                    rspBO.setSuccessNumber(statistics.getSuccessNumber());
                    rspBO.setConnectRate(TaskInfoUtil.getRate(statistics.getConnectNumber(), statistics.getCallNumber()));
                    rspBO.setSuccessRate(TaskInfoUtil.getRate(statistics.getSuccessNumber(), statistics.getConnectNumber()));
                    rspBO.setCallDate(statistics.getData().substring(0, statistics.getData().indexOf(":") - 2).trim());
                    rspBOS.add(rspBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)pageInfo.getTotal());
    }

    public Rsp exportQjStatistics(QjStatisticsReqBO reqBO) {
        log.info("\u8fdb\u5165\u5168\u7586\u6570\u636e\u62a5\u8868\u5bfc\u51fa\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ExportRspBO exportRspBO = new ExportRspBO();
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        try {
            Integer limit = reqBO.getLimit();
            reqBO.setLimit(1);
            RspList<QjStatisticsRspBO> rspBO = this.qjStatistics(reqBO);
            if (!rspBO.getRspCode().equals("0000")) {
                log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)rspBO.getRspDesc());
                return BaseRspUtils.createErrorRsp((String)rspBO.getRspDesc());
            }
            int pageCount = (int)rspBO.getCount();
            if (pageCount == 0) {
                return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u83b7\u53d6\u5230\u6570\u636e");
            }
            int pageNumber = (pageCount - 1) / limit + 1;
            reqBO.setLimit(limit.intValue());
            Integer index = 1;
            ArrayList<ExcelQjStatistics> excelBOS = new ArrayList<ExcelQjStatistics>();
            for (int i = 1; i <= pageNumber; ++i) {
                List rows;
                reqBO.setPage(i);
                RspList<QjStatisticsRspBO> rsp = this.qjStatistics(reqBO);
                if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
                for (QjStatisticsRspBO bo : rows) {
                    ExcelQjStatistics excelBO = new ExcelQjStatistics();
                    BeanUtils.copyProperties((Object)bo, (Object)excelBO);
                    excelBO.setIndexCode(index);
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                    excelBOS.add(excelBO);
                }
            }
            log.info("\u5168\u7586\u7edf\u8ba1\u62a5\u8868\u5bfc\u51fa\uff0cexcelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
            String filePath = null;
            try {
                String fileName = "\u5168\u7586\u6570\u636e\u7edf\u8ba1\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
                filePath = this.excelHelper.writeExcel(excelBOS, ExcelQjStatistics.class, fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage());
                return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
            }
            filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
            log.info("filePath:{}", (Object)filePath);
            exportRspBO.setFilePath(filePath);
            exportRspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        return BaseRspUtils.createSuccessRsp((Object)exportRspBO);
    }

    private BladeTenantBO getTenantInfo(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }
}

