/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.statistics;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantListReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantListRspBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.CallDataNumBO;
import com.tydic.nicc.ocs.bo.ExportRspBO;
import com.tydic.nicc.ocs.bo.TenantActivityBO;
import com.tydic.nicc.ocs.bo.TenantActivityTypeBO;
import com.tydic.nicc.ocs.bo.TenantActivityTypeStatReqBO;
import com.tydic.nicc.ocs.constant.OcsConstant;
import com.tydic.nicc.ocs.mapper.ObActivityTypeStatDAO;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCustServeRecordDAO;
import com.tydic.nicc.ocs.mapper.ObDataTargetDAO;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.ObTaskTenantDAO;
import com.tydic.nicc.ocs.mapper.po.ObActivityTypeStatPO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObCustServeRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObDataTargetPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskTenantPO;
import com.tydic.nicc.ocs.service.TenantActivityTypeService;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelActivityBO;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelTenantActivityBO;
import com.tydic.nicc.ocs.utils.DateUtil;
import com.tydic.nicc.ocs.utils.ExcelHelper;
import com.tydic.nicc.ocs.utils.TaskInfoUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@DubboService
public class TenantActivityTypeServiceImpl
implements TenantActivityTypeService {
    private static final Logger log = LoggerFactory.getLogger(TenantActivityTypeServiceImpl.class);
    @Resource
    private ObActivityTypeStatDAO obActivityTypeStatDAO;
    @Resource
    private ObTaskInfoDAO obTaskInfoDAO;
    @Resource
    private ObCallRecordDAO obCallRecordDAO;
    @Resource
    private ObCustServeRecordDAO obCustServeRecordDAO;
    @Resource
    private ObTaskTenantDAO obTaskTenantDAO;
    @Resource
    private ObDataTargetDAO obDataTargetDAO;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @Resource
    private ExcelHelper excelHelper;
    @Value(value="${file.path.ftUrl:http://192.168.10.112:8088/upload/}")
    private String path;
    public static final Integer maxMonth = 6;
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void tenantActivityTypeStat(Date statTime) {
        log.info("\u5f00\u59cb\u7edf\u8ba1\u79df\u6237\u6d3b\u52a8\u7c7b\u578b\u6570\u636e\uff0c \u5f53\u524d\u65f6\u95f4:{}", (Object)format.format(new Date()));
        if (null == statTime) {
            statTime = new Date();
        }
        Date beforeDate = DateUtil.getBeforeDate(statTime);
        Date startTime = DateUtil.getStartTime(beforeDate);
        Date endTime = DateUtil.getEndTime(beforeDate);
        log.info("startTime:{}, endTime:{}", (Object)startTime, (Object)endTime);
        GetBladeTenantListRspBO rspBO = this.bladeTenantInterService.getBladeTenantList(new GetBladeTenantListReqBO());
        if (!"0000".equals(rspBO.getRspCode())) {
            log.error("\u83b7\u53d6\u79df\u6237\u5217\u8868\u5931\u8d25");
            return;
        }
        Integer dataTime = DateUtil.getIntDate(startTime);
        List rows = rspBO.getRows();
        if (null == rows || rows.size() == 0) {
            log.error("\u672a\u83b7\u53d6\u5230\u79df\u6237\u5217\u8868");
            return;
        }
        for (BladeTenantBO tenantBO : rows) {
            ObTaskInfoPO taskInfoPO = new ObTaskInfoPO();
            taskInfoPO.setTenantId(tenantBO.getTenantId());
            taskInfoPO.setStartTime(format.format(startTime));
            List taskInfoPOS = this.obTaskInfoDAO.selectValidTask(taskInfoPO);
            log.info("\u83b7\u53d6\u79df\u6237\uff1a\u3010{}\u3011\u4e0b\u6709\u6548\u4efb\u52a1\u5217\u8868Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)tenantBO.getTenantId(), (Object)JSONObject.toJSONString((Object)taskInfoPOS));
            if (null == taskInfoPOS || taskInfoPOS.size() == 0) {
                log.info("\u5f53\u524d\u79df\u6237\u4e0b\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u4efb\u52a1\u5217\u8868\uff0c\u8df3\u8fc7");
                continue;
            }
            for (ObTaskInfoPO infoPO : taskInfoPOS) {
                if (StringUtils.isEmpty((Object)infoPO.getProductId())) {
                    log.info("\u5f53\u524d\u4efb\u52a1\u3010{}\u3011\u65e0\u4ea7\u54c1\u4fe1\u606f\uff0c\u8df3\u8fc7\u672c\u6b21\u5faa\u73af", (Object)infoPO.getTaskId());
                    continue;
                }
                if ("grab".equals(infoPO.getTaskType())) {
                    log.info("\u5f53\u524d\u4efb\u52a1\u4e3a\u62a2\u5355\u4efb\u52a1");
                    List taskTenantPOS = this.obTaskTenantDAO.selectByTaskId(infoPO.getTaskId());
                    if (null == taskTenantPOS || taskTenantPOS.size() == 0) {
                        log.info("\u5f53\u524d\u62a2\u5355\u4efb\u52a1\u672a\u5206\u914d\u79df\u6237\uff0c\u8df3\u8fc7");
                        continue;
                    }
                    Integer grabTotalDataNumber = this.getGrabDataNum(tenantBO, infoPO, format.format(startTime), format.format(endTime));
                    Integer grabCallNumber = this.getGrabCallNumber(tenantBO, taskTenantPOS, infoPO.getTaskId(), rows);
                    if ("PAGE".equals(infoPO.getTaskSource())) {
                        grabTotalDataNumber = grabTotalDataNumber - grabCallNumber;
                    }
                    for (ObTaskTenantPO taskTenantPO : taskTenantPOS) {
                        List collect = rows.stream().filter(tenant -> tenant.getTenantId().equals(taskTenantPO.getTenantId())).collect(Collectors.toList());
                        BladeTenantBO tenantBO1 = (BladeTenantBO)collect.get(0);
                        CallDataNumBO grabCallData = this.getCallData(tenantBO1, infoPO, format.format(startTime), format.format(endTime));
                        grabCallData.setDataNumber(grabTotalDataNumber);
                        TenantActivityTypeBO typeBO = new TenantActivityTypeBO();
                        this.getTypeBO(grabCallData, typeBO);
                        typeBO.setTaskId(infoPO.getTaskId());
                        this.getActivityTypePO(typeBO, tenantBO1, infoPO, dataTime, statTime);
                    }
                    continue;
                }
                CallDataNumBO callData = this.getCallData(tenantBO, infoPO, format.format(startTime), format.format(endTime));
                TenantActivityTypeBO typeBO = new TenantActivityTypeBO();
                this.getTypeBO(callData, typeBO);
                typeBO.setTaskId(infoPO.getTaskId());
                this.getActivityTypePO(typeBO, tenantBO, infoPO, dataTime, statTime);
            }
        }
    }

    public RspList<TenantActivityBO> queryTenantActivityTypeStat(TenantActivityTypeStatReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u79df\u6237\u6d3b\u52a8\u7c7b\u578b\u62a5\u8868\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        List<Object> activityBOS = new ArrayList();
        int count = 0;
        try {
            RspList rspList = this.checkParam(reqBO);
            if (!"0000".equals(rspList.getRspCode())) {
                return rspList;
            }
            ObActivityTypeStatPO obActivityTypeStatPO = new ObActivityTypeStatPO();
            this.getPo(reqBO, obActivityTypeStatPO, OcsConstant.TENANT_ACTIVITY_FLAG_0);
            activityBOS = this.getStatBOS(obActivityTypeStatPO);
            if (null != activityBOS && activityBOS.size() > 0) {
                HashMap<String, TenantActivityBO> map = new HashMap<String, TenantActivityBO>();
                for (TenantActivityBO tenantActivityBO : activityBOS) {
                    BladeTenantBO tenantInfo = this.getTenantInfo(tenantActivityBO.getTenantId());
                    tenantActivityBO.setTenantName(tenantInfo.getTenantName());
                    String key = tenantActivityBO.getTenantId() + "_" + tenantActivityBO.getProductId();
                    if (!map.containsKey(key)) {
                        map.put(key, tenantActivityBO);
                        continue;
                    }
                    TenantActivityBO bo = (TenantActivityBO)map.get(key);
                    bo.setDataNumber(Integer.valueOf(bo.getDataNumber() + tenantActivityBO.getDataNumber()));
                    bo.setCallNumber(Integer.valueOf(bo.getCallNumber() + tenantActivityBO.getCallNumber()));
                    bo.setConnNumber(Integer.valueOf(bo.getConnNumber() + tenantActivityBO.getConnNumber()));
                    bo.setHandleNumber(Integer.valueOf(bo.getHandleNumber() + tenantActivityBO.getHandleNumber()));
                    map.put(key, bo);
                }
                log.info("map :{}", (Object)JSONObject.toJSONString(map));
                activityBOS = new ArrayList();
                for (TenantActivityBO tenantActivityBO : map.values()) {
                    tenantActivityBO.setConnRate(TaskInfoUtil.getRate(tenantActivityBO.getConnNumber(), tenantActivityBO.getCallNumber()));
                    tenantActivityBO.setHandleRate(TaskInfoUtil.getRate(tenantActivityBO.getHandleNumber(), tenantActivityBO.getConnNumber()));
                    activityBOS.add(tenantActivityBO);
                }
            }
            count = activityBOS.size();
            activityBOS = activityBOS.stream().skip(reqBO.getLimit() * (reqBO.getPage() - 1)).limit(reqBO.getLimit()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)"\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRspList(activityBOS, (long)count);
    }

    public RspList<TenantActivityBO> queryActivityTypeStat(TenantActivityTypeStatReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u6d3b\u52a8\u7c7b\u578b\u62a5\u8868\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        List<Object> activityBOS = new ArrayList();
        int count = 0;
        try {
            RspList rspList = this.checkParam(reqBO);
            if (!"0000".equals(rspList.getRspCode())) {
                return rspList;
            }
            ObActivityTypeStatPO obActivityTypeStatPO = new ObActivityTypeStatPO();
            this.getPo(reqBO, obActivityTypeStatPO, OcsConstant.TENANT_ACTIVITY_FLAG_1);
            activityBOS = this.getStatBOS(obActivityTypeStatPO);
            if (null == activityBOS || activityBOS.size() == 0) {
                return BaseRspUtils.createSuccessRspList(activityBOS, (long)count);
            }
            HashMap<String, TenantActivityBO> map = new HashMap<String, TenantActivityBO>();
            for (TenantActivityBO activityBO : activityBOS) {
                String key = activityBO.getProductId();
                if (!map.containsKey(key)) {
                    map.put(key, activityBO);
                    continue;
                }
                TenantActivityBO bo = (TenantActivityBO)map.get(key);
                if (!bo.getTaskId().equals(activityBO.getTaskId())) {
                    bo.setDataNumber(Integer.valueOf(bo.getDataNumber() + activityBO.getDataNumber()));
                }
                bo.setCallNumber(Integer.valueOf(bo.getCallNumber() + activityBO.getCallNumber()));
                bo.setConnNumber(Integer.valueOf(bo.getConnNumber() + activityBO.getConnNumber()));
                bo.setHandleNumber(Integer.valueOf(bo.getHandleNumber() + activityBO.getHandleNumber()));
                map.put(key, bo);
            }
            log.info("map :{}", (Object)JSONObject.toJSONString(map));
            activityBOS = new ArrayList();
            for (TenantActivityBO activityBO : map.values()) {
                activityBO.setConnRate(TaskInfoUtil.getRate(activityBO.getConnNumber(), activityBO.getCallNumber()));
                activityBO.setHandleRate(TaskInfoUtil.getRate(activityBO.getHandleNumber(), activityBO.getConnNumber()));
                activityBOS.add(activityBO);
            }
            count = activityBOS.size();
            activityBOS = activityBOS.stream().skip(reqBO.getLimit() * (reqBO.getPage() - 1)).limit(reqBO.getLimit()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)"\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRspList(activityBOS, (long)count);
    }

    public Rsp exportTenantActivityTypeStat(TenantActivityTypeStatReqBO reqBO) {
        log.info("\u8fdb\u5165\u79df\u6237\u6d3b\u52a8\u7c7b\u578b\u62a5\u8868\u5bfc\u51fa\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ExportRspBO exportRspBO = null;
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        try {
            int limit = reqBO.getLimit();
            RspList<TenantActivityBO> rspList = this.queryTenantActivityTypeStat(reqBO);
            if (!"0000".equals(rspList.getRspCode())) {
                return BaseRspUtils.createErrorRsp((String)rspList.getRspDesc());
            }
            int pageCount = (int)rspList.getCount();
            if (pageCount == 0) {
                return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u6570\u636e");
            }
            int pageNumber = (pageCount - 1) / limit + 1;
            reqBO.setLimit(limit);
            Integer index = 1;
            ArrayList<ExcelTenantActivityBO> excelBOS = new ArrayList<ExcelTenantActivityBO>();
            for (int i = 1; i <= pageNumber; ++i) {
                reqBO.setPage(i);
                RspList<TenantActivityBO> rsp = this.queryTenantActivityTypeStat(reqBO);
                if (!"0000".equals(rsp.getRspCode())) {
                    log.error("\u5f53\u524d\u9875\u3010{}\u3011\uff0c \u67e5\u8be2\u51fa\u9519\uff0c\u8df3\u8fc7", (Object)i);
                    continue;
                }
                List rows = rsp.getRows();
                if (rows == null || rows.size() <= 0) continue;
                for (TenantActivityBO bo : rows) {
                    ExcelTenantActivityBO excelBO = new ExcelTenantActivityBO();
                    BeanUtils.copyProperties((Object)bo, (Object)excelBO);
                    excelBO.setIndex(index);
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                    excelBOS.add(excelBO);
                }
            }
            log.info("\u79df\u6237\u6d3b\u52a8\u7c7b\u578b\u62a5\u8868\u5bfc\u51fa\uff0cexcelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
            exportRspBO = this.getExportRspBO(excelBOS, OcsConstant.TENANT_ACTIVITY_FLAG_0, tenantId);
            if (null == exportRspBO) {
                return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)exportRspBO);
    }

    public Rsp exportActivityTypeStat(TenantActivityTypeStatReqBO reqBO) {
        log.info("\u8fdb\u5165\u6d3b\u52a8\u7c7b\u578b\u62a5\u8868\u5bfc\u51fa\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ExportRspBO exportRspBO = null;
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        try {
            int limit = reqBO.getLimit();
            RspList<TenantActivityBO> rspList = this.queryActivityTypeStat(reqBO);
            if (!"0000".equals(rspList.getRspCode())) {
                return BaseRspUtils.createErrorRsp((String)rspList.getRspDesc());
            }
            int pageCount = (int)rspList.getCount();
            if (pageCount == 0) {
                return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u6570\u636e");
            }
            int pageNumber = (pageCount - 1) / limit + 1;
            reqBO.setLimit(limit);
            Integer index = 1;
            ArrayList<ExcelActivityBO> excelBOS = new ArrayList<ExcelActivityBO>();
            for (int i = 1; i <= pageNumber; ++i) {
                reqBO.setPage(i);
                RspList<TenantActivityBO> rsp = this.queryActivityTypeStat(reqBO);
                if (!"0000".equals(rsp.getRspCode())) {
                    log.error("\u5f53\u524d\u9875\u3010{}\u3011\uff0c \u67e5\u8be2\u51fa\u9519\uff0c\u8df3\u8fc7", (Object)i);
                    continue;
                }
                List rows = rsp.getRows();
                if (rows == null || rows.size() <= 0) continue;
                for (TenantActivityBO bo : rows) {
                    ExcelActivityBO excelBO = new ExcelActivityBO();
                    BeanUtils.copyProperties((Object)bo, (Object)excelBO);
                    excelBO.setIndex(index);
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                    excelBOS.add(excelBO);
                }
            }
            log.info("\u79df\u6237\u6d3b\u52a8\u7c7b\u578b\u62a5\u8868\u5bfc\u51fa\uff0cexcelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
            exportRspBO = this.getExportRspBO(excelBOS, OcsConstant.TENANT_ACTIVITY_FLAG_1, tenantId);
            if (null == exportRspBO) {
                return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)exportRspBO);
    }

    private ExportRspBO getExportRspBO(List excelBOS, Integer flag, String tenantId) {
        ExportRspBO exportRspBO = new ExportRspBO();
        String filePath = null;
        try {
            String fileName = "";
            if (OcsConstant.TENANT_ACTIVITY_FLAG_0.equals(flag)) {
                fileName = "\u79df\u6237\u6d3b\u52a8\u7c7b\u578b\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
                filePath = this.excelHelper.writeExcel(excelBOS, ExcelTenantActivityBO.class, fileName);
            } else {
                fileName = "\u6d3b\u52a8\u7c7b\u578b\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
                filePath = this.excelHelper.writeExcel(excelBOS, ExcelActivityBO.class, fileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return null;
        }
        filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
        log.info("filePath:{}", (Object)filePath);
        exportRspBO.setFilePath(filePath);
        exportRspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        return exportRspBO;
    }

    private void getPo(TenantActivityTypeStatReqBO reqBO, ObActivityTypeStatPO obActivityTypeStatPO, Integer flag) {
        if (OcsConstant.TENANT_ACTIVITY_FLAG_0.equals(flag)) {
            ArrayList tenantIds = new ArrayList();
            if (null == reqBO.getTenantIds() || reqBO.getTenantIds().size() == 0) {
                List tenantList = this.bladeTenantInterService.getTenantList(StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode());
                tenantList.forEach(tenant -> tenantIds.add(tenant.getTenantId()));
                log.info("\u5f53\u524d\u79df\u6237\u4e0b\u5b50\u79df\u6237ID\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString(tenantIds));
            } else {
                tenantIds.addAll(reqBO.getTenantIds());
            }
            obActivityTypeStatPO.setTenantIds(tenantIds);
        }
        SimpleDateFormat format1 = new SimpleDateFormat("yyyyMMdd");
        String qryStartTime = null;
        String qryEndTime = null;
        try {
            qryStartTime = format1.format(format.parse(reqBO.getStartTime()));
            qryEndTime = format1.format(format.parse(reqBO.getEndTime()));
        }
        catch (ParseException e) {
            log.error("\u65f6\u95f4\u8f6c\u6362\u9519\u8bef");
            e.printStackTrace();
        }
        obActivityTypeStatPO.setStartTime(qryStartTime);
        obActivityTypeStatPO.setEndTime(qryEndTime);
        obActivityTypeStatPO.setProductName(reqBO.getProductName());
    }

    private List<TenantActivityBO> getStatBOS(ObActivityTypeStatPO statPO) {
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        ArrayList<TenantActivityBO> activityBOS = new ArrayList<TenantActivityBO>();
        log.info("\u67e5\u8be2\u79df\u6237\u6d3b\u52a8\u7c7b\u578b\u5217\u8868Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)statPO));
        List statPOS = this.obActivityTypeStatDAO.selectTenantActivity(statPO);
        log.info("\u67e5\u8be2\u79df\u6237\u6d3b\u52a8\u7c7b\u578b\u5217\u8868Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)statPOS));
        if (null != statPOS && statPOS.size() > 0) {
            for (ObActivityTypeStatPO po : statPOS) {
                TenantActivityBO activityBO = new TenantActivityBO();
                BeanUtils.copyProperties((Object)po, (Object)activityBO);
                activityBO.setId(String.valueOf(po.getId()));
                try {
                    Date parse = sdf.parse(po.getDataTime().toString());
                    activityBO.setDataTimeStr(format1.format(parse));
                }
                catch (ParseException e) {
                    log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
                    e.printStackTrace();
                }
                activityBOS.add(activityBO);
            }
        }
        return activityBOS;
    }

    private RspList checkParam(TenantActivityTypeStatReqBO reqBO) {
        List roleNames = this.bladeUserInterService.getUserRoleInfo(reqBO.getLoginInfo().getUserId());
        boolean flag = false;
        for (String role : roleNames) {
            if (!"system:admin".equals(role)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return BaseRspUtils.createErrorRspList((String)"\u65e0\u6743\u9650");
        }
        if (StringUtils.isEmpty((Object)reqBO.getStartTime())) {
            return BaseRspUtils.createErrorRspList((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65f6\u95f4");
        }
        if (StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            return BaseRspUtils.createErrorRspList((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u65f6\u95f4");
        }
        if (!DateUtil.checkTimeSpan(reqBO.getStartTime(), reqBO.getEndTime(), maxMonth).booleanValue()) {
            return BaseRspUtils.createErrorRspList((String)"\u65f6\u95f4\u8de8\u5ea6\u4e0d\u80fd\u5927\u4e8e{}\u4e2a\u6708", (String)String.valueOf(maxMonth));
        }
        return BaseRspUtils.createSuccessRspList(null, (long)0L);
    }

    private CallDataNumBO getCallData(BladeTenantBO tenantBO, ObTaskInfoPO infoPO, String startTime, String endTime) {
        Integer dataNumber = 0;
        if (!"grab".equals(infoPO.getTaskType())) {
            ObDataTargetPO dataTargetPO = new ObDataTargetPO();
            dataTargetPO.setTenantId(tenantBO.getTenantId());
            dataTargetPO.setTenantOtherName(tenantBO.getTenantOtherName());
            dataTargetPO.setTaskId(infoPO.getTaskId());
            if (!"PAGE".equals(infoPO.getTaskSource())) {
                dataTargetPO.setStartTime(startTime);
                dataTargetPO.setEndTime(endTime);
            }
            dataNumber = this.obDataTargetDAO.getDataNumber(dataTargetPO);
            log.info("\u5f53\u524d\u4efb\u52a1Id\u3010{}\u3011, \u83b7\u53d6\u5230{}\u6761\u4efb\u52a1\u6570\u636e", (Object)infoPO.getTaskId(), (Object)dataNumber);
        }
        ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
        obCallRecordPO.setTenantId(tenantBO.getTenantId());
        obCallRecordPO.setTenantOtherName(tenantBO.getTenantOtherName());
        obCallRecordPO.setTaskId(infoPO.getTaskId());
        int totalCallNumber = this.obCallRecordDAO.getTotalCallNUmber(obCallRecordPO);
        log.info("\u5f53\u524d\u4efb\u52a1ID\u3010{}\u3011\uff0c\u603b\u5916\u547c\u8bb0\u5f55\u4e3a{}\u6761", (Object)infoPO.getTaskId(), (Object)totalCallNumber);
        obCallRecordPO.setQryStartTime(startTime);
        obCallRecordPO.setQryEndTime(endTime);
        ObCallRecordPO callRecordPO = this.obCallRecordDAO.getCallNumber(obCallRecordPO);
        log.info("\u5f53\u524d\u4efb\u52a1ID\u3010{}\u3011\uff0c\u5f53\u65e5\u5916\u547c\u3010{}\u3011\u6761\uff0c\u63a5\u901a\u3010{}\u3011\u6761", new Object[]{infoPO.getTaskId(), callRecordPO.getCallNum(), callRecordPO.getConnNum()});
        ObCustServeRecordPO serveRecordPO = new ObCustServeRecordPO();
        serveRecordPO.setTenantId(tenantBO.getTenantId());
        serveRecordPO.setTenantOtherName(tenantBO.getTenantOtherName());
        serveRecordPO.setTaskId(infoPO.getTaskId());
        serveRecordPO.setQryStartTime(startTime);
        serveRecordPO.setQryEndTime(endTime);
        int successNumber = this.obCustServeRecordDAO.getSuccessNumber(serveRecordPO);
        log.info("\u5f53\u524d\u4efb\u52a1ID\u3010{}\u3011\uff0c\u529e\u7406\u6210\u529f\u91cf\uff1a{}", (Object)infoPO.getTaskId(), (Object)successNumber);
        if ("PAGE".equals(infoPO.getTaskSource()) && !"grab".equals(infoPO.getTaskType())) {
            dataNumber = dataNumber - totalCallNumber;
            log.info("\u9875\u9762\u914d\u7f6e\u4efb\u52a1\uff0c \u603b\u6570\u636e\u91cf\u51cf\u53bb\u603b\u5916\u547c\u91cf\uff1a{}", (Object)dataNumber);
        }
        CallDataNumBO numBO = new CallDataNumBO();
        numBO.setDataNumber(dataNumber);
        numBO.setTotalCallNumber(Integer.valueOf(totalCallNumber));
        numBO.setDayCallNumber(callRecordPO.getCallNum());
        numBO.setDayConnNumber(callRecordPO.getConnNum());
        numBO.setSuccessNumber(Integer.valueOf(successNumber));
        return numBO;
    }

    private void getActivityTypePO(TenantActivityTypeBO typeBO, BladeTenantBO tenantBO, ObTaskInfoPO infoPO, Integer dataTime, Date statTime) {
        ObActivityTypeStatPO activityTypeStatPO = new ObActivityTypeStatPO();
        activityTypeStatPO.setTenantId(tenantBO.getTenantId());
        activityTypeStatPO.setProductId(infoPO.getProductId());
        activityTypeStatPO.setProductName(infoPO.getProductName());
        activityTypeStatPO.setDataTime(dataTime);
        activityTypeStatPO.setDataNumber(typeBO.getDataNumber());
        activityTypeStatPO.setCallNumber(typeBO.getCallNumber());
        activityTypeStatPO.setConnNumber(typeBO.getConnNumber());
        activityTypeStatPO.setHandleNumber(typeBO.getHandleNumber());
        activityTypeStatPO.setCreateTime(statTime);
        activityTypeStatPO.setStatTime(statTime);
        activityTypeStatPO.setTaskId(typeBO.getTaskId());
        log.info("\u5f53\u524d\u4efb\u52a1ID\uff1a{}\uff0c \u6267\u884c\u7b2c\u4e00\u6b21\u4fee\u6539\u64cd\u4f5c", (Object)infoPO.getTaskId());
        int updNum = this.obActivityTypeStatDAO.updateActivityTypeStat(activityTypeStatPO);
        if (updNum == 0) {
            log.info("\u5f53\u524d\u4efb\u52a1ID\uff1a{}\uff0c \u7b2c\u4e00\u6b21\u4fee\u6539\u64cd\u4f5c\u6267\u884c\u5931\u8d25\uff0c\u6267\u884c\u65b0\u589e\u64cd\u4f5c", (Object)infoPO.getTaskId());
            int insertNum = this.obActivityTypeStatDAO.insertSelective(activityTypeStatPO);
            if (insertNum == 0) {
                log.info("\u5f53\u524d\u4efb\u52a1ID\uff1a{}\uff0c \u65b0\u589e\u5931\u8d25\uff0c\u6267\u884c\u7b2c\u4e8c\u6b21\u4fee\u6539\u64cd\u4f5c", (Object)infoPO.getTaskId());
                this.obActivityTypeStatDAO.updateActivityTypeStat(activityTypeStatPO);
            }
        }
    }

    private BladeTenantBO getTenantInfo(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }

    private Integer getGrabDataNum(BladeTenantBO tenantBO, ObTaskInfoPO infoPO, String startTime, String endTime) {
        ObDataTargetPO dataTargetPO = new ObDataTargetPO();
        dataTargetPO.setTenantId(tenantBO.getTenantId());
        dataTargetPO.setTenantOtherName(tenantBO.getTenantOtherName());
        dataTargetPO.setTaskId(infoPO.getTaskId());
        if (!"PAGE".equals(infoPO.getTaskSource())) {
            dataTargetPO.setStartTime(startTime);
            dataTargetPO.setEndTime(endTime);
        }
        log.info("\u83b7\u53d6\u4efb\u52a1\u6570\u636e\u4fe1\u606fMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dataTargetPO));
        int count = this.obDataTargetDAO.selectByTaskIdCount(dataTargetPO);
        log.info("\u5f53\u524d\u62a2\u5355\u4efb\u52a1\u540d\u79f0\uff1a{}\uff0c \u4efb\u52a1\u4e0b\u6709\u3010{}\u3011\u6761\u6570\u636e", (Object)infoPO.getTaskName(), (Object)count);
        return count;
    }

    private void getTypeBO(CallDataNumBO callData, TenantActivityTypeBO typeBO) {
        log.info("\u7ec4\u88c5\u6570\u636e, CallDataNumBO:{}", (Object)JSONObject.toJSONString((Object)callData));
        typeBO.setDataNumber(Integer.valueOf(callData.getDataNumber() < 0 ? 0 : callData.getDataNumber()));
        typeBO.setCallNumber(callData.getDayCallNumber());
        typeBO.setConnNumber(callData.getDayConnNumber());
        typeBO.setHandleNumber(callData.getSuccessNumber());
    }

    private Integer getGrabCallNumber(BladeTenantBO tenantBO, List<ObTaskTenantPO> taskTenantPOS, String taskId, List<BladeTenantBO> tenantBOS) {
        int callNumber = 0;
        Integer totalCallNumber = this.getCallNumber(tenantBO.getTenantId(), tenantBO.getTenantOtherName(), taskId);
        callNumber = totalCallNumber;
        for (ObTaskTenantPO po : taskTenantPOS) {
            List collect = tenantBOS.stream().filter(tenant -> tenant.getTenantId().equals(po.getTenantId())).collect(Collectors.toList());
            BladeTenantBO tenantBO1 = (BladeTenantBO)collect.get(0);
            Integer callNumber1 = this.getCallNumber(tenantBO1.getTenantId(), tenantBO.getTenantOtherName(), taskId);
            callNumber += callNumber1.intValue();
        }
        return callNumber;
    }

    private Integer getCallNumber(String tenantId, String tenantOtherName, String taskId) {
        ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
        obCallRecordPO.setTenantId(tenantId);
        obCallRecordPO.setTenantOtherName(tenantOtherName);
        obCallRecordPO.setTaskId(taskId);
        int totalCallNumber = this.obCallRecordDAO.getTotalCallNUmber(obCallRecordPO);
        return totalCallNumber;
    }
}

