/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.task.info.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.jobNumber.JobNumberBO;
import com.tydic.nicc.dc.bo.user.BladeUserBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.jobNumber.inter.DcJobNumberInterService;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.CustomerStatusMonitoringReqBO;
import com.tydic.nicc.ocs.bo.GrabeCustInfoBO;
import com.tydic.nicc.ocs.bo.TaskCustStatusInfo;
import com.tydic.nicc.ocs.bo.TaskExecuteCaseBO;
import com.tydic.nicc.ocs.bo.TaskExecuteCaseReqBO;
import com.tydic.nicc.ocs.bo.TaskExecuteCaseRspBO;
import com.tydic.nicc.ocs.bo.TaskExecuteRateBO;
import com.tydic.nicc.ocs.bo.TaskExecuteRateReqBO;
import com.tydic.nicc.ocs.bo.TaskExecuteRateRspBO;
import com.tydic.nicc.ocs.bo.TelephoneTrendBO;
import com.tydic.nicc.ocs.bo.TelephoneTrendRspBO;
import com.tydic.nicc.ocs.bo.UpdateTaskTacticsReqBO;
import com.tydic.nicc.ocs.cache.WsCache;
import com.tydic.nicc.ocs.handler.TaskMonitorService;
import com.tydic.nicc.ocs.handler.bo.TaskMonitorBO;
import com.tydic.nicc.ocs.handler.bo.TaskMonitorInfo;
import com.tydic.nicc.ocs.mapper.ObCallRateConfigDAO;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCustServeRecordDAO;
import com.tydic.nicc.ocs.mapper.ObDataTargetDAO;
import com.tydic.nicc.ocs.mapper.ObIvrTaskDAO;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.ObTaskMemberDAO;
import com.tydic.nicc.ocs.mapper.ObTaskTacticsDAO;
import com.tydic.nicc.ocs.mapper.ObTaskTenantDAO;
import com.tydic.nicc.ocs.mapper.SessionChangeRecordDAO;
import com.tydic.nicc.ocs.mapper.po.MostNewDataPO;
import com.tydic.nicc.ocs.mapper.po.ObCallRateConfigPO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObIvrTaskPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskMemberPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskTacticsPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskTenantPO;
import com.tydic.nicc.ocs.service.IsvTaskProxyService;
import com.tydic.nicc.ocs.service.TaskInfoMonitoringService;
import com.tydic.nicc.ocs.utils.DateTimeUtils;
import com.tydic.nicc.ocs.utils.DateUtil;
import com.tydic.nicc.ocs.utils.RegularUtils;
import com.tydic.nicc.ocs.utils.RequestApiHelper;
import com.tydic.nicc.ocs.utils.es.DocumentCRUD;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.StringUtils;

@DubboService
public class TaskInfoMonitoringServiceImpl
implements TaskInfoMonitoringService {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoMonitoringServiceImpl.class);
    private static final String SYSTEM_ADMIN = "system:admin";
    private static final String TENANT_ADMIN = "tenant:admin";
    @Resource
    private ObCallRecordDAO obCallRecordDAO;
    @Autowired
    private ObDataTargetDAO obDataTargetDAO;
    @Autowired
    private ObCustServeRecordDAO obCustServeRecordDAO;
    @Autowired
    private SessionChangeRecordDAO sessionChangeRecordDAO;
    @Autowired
    private ObTaskMemberDAO obTaskMemberDAO;
    @Autowired
    private ObTaskTacticsDAO obTaskTacticsDAO;
    @Autowired
    private ObTaskInfoDAO obTaskInfoDAO;
    @Autowired
    private ObIvrTaskDAO ivrTaskDAO;
    @Autowired
    private ObTaskTenantDAO obTaskTenantDAO;
    @Resource
    private ObCallRateConfigDAO obCallRateConfigDAO;
    @Resource
    private IsvTaskProxyService isvTaskProxyService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @DubboReference
    private DcJobNumberInterService dcJobNumberInterService;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @Resource
    private RequestApiHelper requestApiHelper;
    @Resource
    private DocumentCRUD documentCRUD;
    @Autowired
    TaskMonitorService taskMonitorService;
    @Resource
    WsCache wsCache;

    public RspList<TaskCustStatusInfo> customerStatusMonitoring(CustomerStatusMonitoringReqBO reqBO) {
        ArrayList<TaskCustStatusInfo> boList;
        block34: {
            List taskMemberPOS;
            block33: {
                log.info("\u8fdb\u5165\u4efb\u52a1\u5750\u5e2d\u72b6\u6001\u76d1\u63a7\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)reqBO);
                Date date = new Date();
                Date qryStartTime = this.creatStartTime(date);
                Date qryEndTime = this.creatEndTime(date);
                if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                    log.info("taskId\u4e0d\u80fd\u4e3a\u7a7a");
                    return BaseRspUtils.createErrorRspList((String)"taskId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                    log.info("tenantId\u4e0d\u80fd\u4e3a\u7a7a");
                    return BaseRspUtils.createErrorRspList((String)"tenantId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)reqBO.getTaskType())) {
                    log.info("taskType\u4e0d\u80fd\u4e3a\u7a7a");
                    return BaseRspUtils.createErrorRspList((String)"taskType\u4e0d\u80fd\u4e3a\u7a7a");
                }
                boList = new ArrayList<TaskCustStatusInfo>();
                ArrayList<String> existUserList = new ArrayList<String>();
                List<Object> custInfoBOS = new ArrayList();
                if (!StringUtils.isEmpty((Object)reqBO.getTaskType())) {
                    List userRoleInfo = this.bladeUserInterService.getUserRoleInfo(reqBO.getLoginInfo().getUserId());
                    if ("grab".equals(reqBO.getTaskType())) {
                        String code;
                        String string = code = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
                        if (userRoleInfo.contains(SYSTEM_ADMIN)) {
                            custInfoBOS = this.grabeCustomerStatusMonitoring(code, reqBO.getTaskId(), SYSTEM_ADMIN, qryStartTime, qryEndTime);
                        } else {
                            List<GrabeCustInfoBO> tenantCustData = this.grabeCustomerStatusMonitoring(code, reqBO.getTaskId(), TENANT_ADMIN, qryStartTime, qryEndTime);
                            if (null != tenantCustData && tenantCustData.size() > 0) {
                                for (GrabeCustInfoBO po : tenantCustData) {
                                    if (null != reqBO.getTenantIds() && reqBO.getTenantIds().size() > 0) {
                                        for (String tenantId : reqBO.getTenantIds()) {
                                            if (!tenantId.equals(po.getTenantId())) continue;
                                            custInfoBOS.add(po);
                                        }
                                        continue;
                                    }
                                    if (!code.equals(po.getTenantId())) continue;
                                    custInfoBOS.add(po);
                                }
                            }
                        }
                        List tenantIds = reqBO.getTenantIds();
                        List custIds = reqBO.getCustIds();
                        ArrayList filterSum = new ArrayList();
                        ArrayList filterCustSum = new ArrayList();
                        boolean isExistCustId = false;
                        if (tenantIds != null && !tenantIds.isEmpty()) {
                            for (String string2 : tenantIds) {
                                List filterONE = custInfoBOS.stream().filter(e -> e.getTenantId().equals(tenantId)).collect(Collectors.toList());
                                filterSum.addAll(filterONE);
                            }
                            if (custIds != null && !custIds.isEmpty()) {
                                isExistCustId = true;
                                for (String string3 : custIds) {
                                    List filterCust = filterSum.stream().filter(e -> e.getCustId().equals(custId)).collect(Collectors.toList());
                                    filterCustSum.addAll(filterCust);
                                }
                            }
                            if (custIds != null && custIds.size() > 0) {
                                custInfoBOS = new ArrayList();
                                custInfoBOS.addAll(filterCustSum);
                            } else if (isExistCustId) {
                                custInfoBOS = new ArrayList();
                            } else {
                                custInfoBOS = new ArrayList();
                                custInfoBOS.addAll(filterSum);
                            }
                        }
                        if (custInfoBOS != null && custInfoBOS.size() > 0) {
                            for (GrabeCustInfoBO grabeCustInfoBO : custInfoBOS) {
                                TaskCustStatusInfo bo = new TaskCustStatusInfo();
                                BeanUtils.copyProperties((Object)grabeCustInfoBO, (Object)bo);
                                bo.setCustStatus(grabeCustInfoBO.getCustStatus());
                                if (StringUtils.isEmpty((Object)bo.getCustStatus())) {
                                    bo.setCustStatus("3");
                                }
                                boList.add(bo);
                            }
                        }
                        return BaseRspUtils.createSuccessRspList(boList);
                    }
                }
                taskMemberPOS = this.obTaskMemberDAO.selectByTaskId(reqBO.getTaskId());
                log.info("\u67e5\u8be2\u5f53\u524d\u5750\u5e2d\u6700\u65b0\u6570\u636eMapper\u5c42\u5165\u53c2\uff1btaskId={}\uff0cstartTime={}\uff0cendTime={}", new Object[]{reqBO.getTaskId(), qryStartTime, qryEndTime});
                List newDataPOListPO = this.sessionChangeRecordDAO.selectMostNewData(reqBO.getTaskId(), qryStartTime, qryEndTime);
                log.info("\u67e5\u8be2\u5f53\u524d\u5750\u5e2d\u6700\u65b0\u6570\u636eMapper\u5c42\u51fa\u53c2={}", (Object)JSONObject.toJSONString((Object)newDataPOListPO));
                ArrayList<MostNewDataPO> newDataPOList = new ArrayList<MostNewDataPO>();
                for (MostNewDataPO dataPO : newDataPOListPO) {
                    boolean b = newDataPOList.stream().anyMatch(e -> e.getPromoterId().equals(dataPO.getPromoterId()));
                    if (b) continue;
                    newDataPOList.add(dataPO);
                }
                log.info("\u53bb\u91cd\u540e={}", (Object)JSONObject.toJSONString(newDataPOList));
                if (newDataPOList == null || newDataPOList.size() <= 0) break block33;
                for (MostNewDataPO newDataPO : newDataPOList) {
                    String userName = null;
                    TaskCustStatusInfo bo = new TaskCustStatusInfo();
                    JobNumberBO jobNumberInfo = this.dcJobNumberInterService.queryJobNumberInfo(newDataPO.getPromoterId());
                    if (jobNumberInfo != null) {
                        existUserList.add(jobNumberInfo.getUserId());
                        BladeUserBO bladeUserBO = this.bladeUserInterService.queryUserInfo(jobNumberInfo.getUserId());
                        if (bladeUserBO != null) {
                            userName = bladeUserBO.getRealName();
                        }
                    }
                    if (newDataPO.getCtiSessionStatus() != null) {
                        String string = this.getStatus(newDataPO.getCtiSessionStatus());
                        bo.setCustStatus(string);
                    } else {
                        bo.setCustStatus("3");
                    }
                    long l = newDataPO.getCreateTime().getTime();
                    long endTime = 0L;
                    if (newDataPO.getEndTime() != null) {
                        endTime = newDataPO.getEndTime().getTime();
                    } else {
                        Date en = new Date();
                        endTime = en.getTime();
                    }
                    long la = (endTime - l) / 1000L;
                    String lastTime = DateTimeUtils.secondSwitchForHMS(la);
                    bo.setCustStatusTime(lastTime);
                    bo.setCustName(userName);
                    boList.add(bo);
                }
                if (taskMemberPOS.size() == newDataPOList.size()) break block34;
                for (ObTaskMemberPO memberPO : taskMemberPOS) {
                    BladeUserBO userBO;
                    boolean b = existUserList.stream().anyMatch(e -> e.equals(memberPO.getUserId()));
                    if (b || (userBO = this.bladeUserInterService.queryUserInfo(memberPO.getUserId())) == null) continue;
                    TaskCustStatusInfo bo = new TaskCustStatusInfo();
                    bo.setCustName(userBO.getRealName());
                    bo.setCustStatusTime("00:00:00");
                    bo.setCustStatus("3");
                    boList.add(bo);
                }
                break block34;
            }
            for (ObTaskMemberPO m : taskMemberPOS) {
                String userName = null;
                TaskCustStatusInfo bo = new TaskCustStatusInfo();
                BladeUserBO userBO = this.bladeUserInterService.queryUserInfo(m.getUserId());
                if (userBO != null) {
                    userName = userBO.getRealName();
                }
                bo.setCustName(userName);
                bo.setCustStatus("3");
                bo.setCustStatusTime("00:00:00");
                boList.add(bo);
            }
        }
        return BaseRspUtils.createSuccessRspList(boList);
    }

    private String getStatus(String ctiSessionStatus) {
        String status = "";
        if (ctiSessionStatus.equals("AgentWorking")) {
            status = "1";
        }
        if (ctiSessionStatus.equals("AgentNotReady") || ctiSessionStatus.equals("AgentAfterCallWork")) {
            status = "0";
        }
        if (ctiSessionStatus.equals("AgentReady")) {
            status = "2";
        }
        if (ctiSessionStatus.equals("AgentLogout")) {
            status = "3";
        }
        if (ctiSessionStatus.equals("AgentLogin")) {
            status = "0";
        }
        return status;
    }

    public TelephoneTrendRspBO telephoneTrend(TaskExecuteRateReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u4eca\u65e5\u8bdd\u52a1\u8d8b\u52bf\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        TelephoneTrendRspBO rspBO = new TelephoneTrendRspBO();
        Date date = new Date();
        Date qryStartTime = this.creatStartTime(date);
        Date qryEndTime = this.creatEndTime(date);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String tenantId = reqBO.getTenantId();
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskType())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("taskType\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)tenantId)) {
                if (StringUtils.isEmpty((Object)reqBO.getTenantCode())) {
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                tenantId = reqBO.getTenantCode();
            }
            List userRoleInfo = this.bladeUserInterService.getUserRoleInfo(reqBO.getLoginInfo().getUserId());
            if (!StringUtils.isEmpty((Object)reqBO.getTaskType()) && "grab".equals(reqBO.getTaskType())) {
                TelephoneTrendBO trend = new TelephoneTrendBO();
                String code = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
                trend = userRoleInfo.contains(SYSTEM_ADMIN) ? this.grabeTelephoneTrend(code, reqBO.getTaskId(), SYSTEM_ADMIN, format.format(qryStartTime), format.format(qryEndTime)) : this.grabeTelephoneTrend(code, reqBO.getTaskId(), TENANT_ADMIN, format.format(qryStartTime), format.format(qryEndTime));
                rspBO.setData((Object)trend);
                rspBO.setRspCode("0000");
                rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
                return rspBO;
            }
            BladeTenantBO tenantInfo = this.getTenantInfo(tenantId);
            if (tenantId == null) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u67e5\u8be2\u5931\u8d25");
                return rspBO;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("taskId", reqBO.getTaskId());
            params.put("startTime", qryStartTime);
            params.put("endTime", qryEndTime);
            params.put("tenantId", tenantInfo.getTenantId());
            List<ObCallRecordPO> callRecords = this.documentCRUD.qryCallRecordByHour(params);
            log.info("\u67e5\u8be2\u4eca\u65e5\u8bdd\u52a1\u8d8b\u52bf\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString(callRecords));
            List<String> hourList = Arrays.asList("08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22");
            List<Long> obCallCountList = new LinkedList<Long>();
            List<Long> obTalkCountList = new LinkedList<Long>();
            List<Long> turnCustomerCountList = new LinkedList<Long>();
            obCallCountList = this.getList(obCallCountList);
            obTalkCountList = this.getList(obTalkCountList);
            turnCustomerCountList = this.getList(turnCustomerCountList);
            if (callRecords != null && callRecords.size() > 0) {
                for (ObCallRecordPO record : callRecords) {
                    Long isConnCount = record.getIsConnCount();
                    Long isNotConnCount = record.getIsNotConnCount();
                    Long obsIsConnCount = record.getObsIsConnCount();
                    Long rgjrCount = isConnCount + obsIsConnCount;
                    Long callCount = record.getCallCount();
                    for (int i = 0; i < 15; ++i) {
                        if (!hourList.get(i).equals(record.getObHour())) continue;
                        obCallCountList.set(i, callCount);
                        obTalkCountList.set(i, rgjrCount);
                        turnCustomerCountList.set(i, obsIsConnCount);
                    }
                }
            }
            TelephoneTrendBO trendBO = new TelephoneTrendBO();
            trendBO.setObCallCountList(obCallCountList);
            trendBO.setObTalkCountList(obTalkCountList);
            trendBO.setTurnCustomerCountList(turnCustomerCountList);
            trendBO.setHourList(hourList);
            rspBO.setData((Object)trendBO);
            rspBO.setRspCode("0000");
            rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            rspBO.setRspCode("8888");
            rspBO.setRspDesc(e.getMessage());
            return rspBO;
        }
        log.info("\u67e5\u8be2\u4eca\u65e5\u8bdd\u52a1\u8d8b\u52bf\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    public TaskExecuteRateRspBO taskExecuteRate(TaskExecuteRateReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u767e\u5206\u6bd4\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        TaskExecuteRateRspBO rspBO = new TaskExecuteRateRspBO();
        try {
            String tenantId = reqBO.getTenantId();
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)tenantId)) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskType())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            BladeTenantBO bladeTenantBO = this.getTenantInfo(tenantId);
            if (bladeTenantBO == null) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u67e5\u8be2\u5931\u8d25");
                return rspBO;
            }
            Long taskTotalCount = 0L;
            Long isConnCount = 0L;
            Long isNotConnCount = 0L;
            Long dialCount = 0L;
            Long callLoseCount = 0L;
            if ("grab".equals(reqBO.getTaskType())) {
                String code = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
                TaskExecuteRateBO taskExecute = this.grabeTaskExecute(code, reqBO.getTaskId(), SYSTEM_ADMIN);
                rspBO.setData((Object)taskExecute);
                rspBO.setRspCode("0000");
                rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
                return rspBO;
            }
            ObTaskInfoPO taskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(reqBO.getTaskId());
            if (null != taskInfoPO) {
                taskTotalCount = StringUtils.isEmpty((Object)taskInfoPO.getDataNumber()) ? 0L : taskInfoPO.getDataNumber();
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (!"PAGE".equals(taskInfoPO.getTaskSource())) {
                Date date = new Date();
                params.put("startTime", DateUtil.getDayStartTimeStr(date));
                params.put("endTime", DateUtil.getDayEndTimeStr(date));
            }
            params.put("tenantId", tenantId);
            params.put("taskId", reqBO.getTaskId());
            dialCount = this.documentCRUD.qryCallRecordCase(params);
            params.put("isConn", "1");
            isConnCount = this.documentCRUD.qryCallRecordCase(params);
            params.remove("isConn");
            params.put("isConn", "0");
            params.put("obsIsConn", "0");
            isNotConnCount = this.documentCRUD.qryCallRecordCase(params);
            params.remove("obsIsConn");
            params.put("obsIsConn", "1");
            callLoseCount = this.documentCRUD.qryCallRecordCase(params);
            Long waitCallCount = taskTotalCount - dialCount;
            if (waitCallCount < 0L) {
                waitCallCount = 0L;
            }
            TaskExecuteRateBO rateBO = new TaskExecuteRateBO();
            rateBO.setTaskTotalCount(taskTotalCount.toString());
            rateBO.setIsConnCount(isConnCount.toString());
            rateBO.setIsNotConnCount(isNotConnCount.toString());
            rateBO.setDialCount(dialCount.toString());
            rateBO.setWaitCallCount(waitCallCount.toString());
            rateBO.setCallLossCount(callLoseCount.toString());
            rateBO.setTaskSource(taskInfoPO.getTaskSource());
            rspBO.setData((Object)rateBO);
            rspBO.setRspCode("0000");
            rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            rspBO.setRspCode("8888");
            rspBO.setRspDesc(e.getMessage());
            return rspBO;
        }
        log.info("\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u767e\u5206\u6bd4\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    @Transactional(readOnly=true)
    public TaskExecuteCaseRspBO taskExecuteCase(TaskExecuteCaseReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u60c5\u51b5\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        TaskExecuteCaseRspBO rspBO = new TaskExecuteCaseRspBO();
        Date date = new Date();
        Date qryStartTime = this.creatStartTime(date);
        Date qryEndTime = this.creatEndTime(date);
        try {
            String tenantId = reqBO.getTenantId();
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)tenantId)) {
                if (StringUtils.isEmpty((Object)reqBO.getTenantCode())) {
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                tenantId = reqBO.getTenantCode();
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskType())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("taskType\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if ("grab".equals(reqBO.getTaskType())) {
                List userRoleInfo = this.bladeUserInterService.getUserRoleInfo(reqBO.getLoginInfo().getUserId());
                String code = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
                TaskExecuteCaseBO executeCaseBO = userRoleInfo.contains(SYSTEM_ADMIN) ? this.grabeTaskExecuteCase(code, reqBO.getTaskId(), SYSTEM_ADMIN) : this.grabeTaskExecuteCase(code, reqBO.getTaskId(), TENANT_ADMIN);
                rspBO.setData((Object)executeCaseBO);
                rspBO.setRspCode("0000");
                rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
                return rspBO;
            }
            BladeTenantBO tenantInfo = this.getTenantInfo(tenantId);
            if (tenantInfo == null) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u79df\u6237\u67e5\u8be2\u5931\u8d25");
                return rspBO;
            }
            TaskExecuteRateReqBO rateReqBO = new TaskExecuteRateReqBO();
            rateReqBO.setTenantId(tenantId);
            rateReqBO.setTaskId(reqBO.getTaskId());
            rateReqBO.setTaskType(reqBO.getTaskType());
            TaskExecuteCaseRspBO rs = this.wsCache.getTaskMointorByTask(tenantId, reqBO.getTaskId());
            if (null != rs) {
                return rs;
            }
            TaskExecuteRateRspBO rateBO = this.taskExecuteRateInIsv(rateReqBO);
            if (!rateBO.getRspCode().equals("0000")) {
                rspBO.setRspCode(rateBO.getRspCode());
                rspBO.setRspDesc(rateBO.getRspDesc());
                return rspBO;
            }
            TaskExecuteRateBO executeRateBO = (TaskExecuteRateBO)rateBO.getData();
            if (executeRateBO != null) {
                TaskExecuteCaseBO caseBO = new TaskExecuteCaseBO();
                BeanUtils.copyProperties((Object)executeRateBO, (Object)caseBO);
                String isConnRate = this.percent(Integer.valueOf(executeRateBO.getIsConnCount()), Integer.valueOf(executeRateBO.getDialCount()));
                long startTime = System.currentTimeMillis();
                int successSum = this.obCustServeRecordDAO.selectSuccessCountNew(tenantInfo.getTenantOtherName(), reqBO.getTaskId());
                long endTime = System.currentTimeMillis();
                log.info("\u83b7\u53d6\u6210\u529f\u91cf\u8017\u65f6\uff1a{} ms", (Object)(endTime - startTime));
                caseBO.setWinCount(String.valueOf(successSum));
                String winCallRate = this.percent(Integer.valueOf(caseBO.getWinCount()), Integer.valueOf(executeRateBO.getIsConnCount()));
                caseBO.setIsConnRate(isConnRate);
                caseBO.setWinCallRate(winCallRate);
                caseBO.setCallLossCount(executeRateBO.getCallLossCount());
                long calling = 0L;
                long sessionStartTime = System.currentTimeMillis();
                List newDataPOList = this.sessionChangeRecordDAO.selectMostNewData(reqBO.getTaskId(), qryStartTime, qryEndTime);
                long sessionEndTime = System.currentTimeMillis();
                log.info("\u67e5\u8be2\u5750\u5e2d\u72b6\u6001\u63a5\u53e3\u51fa\u53c2={}, \u8017\u65f6\uff1a{}", (Object)JSONObject.toJSONString((Object)newDataPOList), (Object)(sessionEndTime - sessionStartTime));
                if (null != newDataPOList && newDataPOList.size() > 0) {
                    calling = newDataPOList.stream().filter(e -> "AgentWorking".equals(e.getCtiSessionStatus())).count();
                }
                caseBO.setCallNowCount(String.valueOf(calling));
                rspBO.setData((Object)caseBO);
            }
            rspBO.setRspCode("0000");
            rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
            this.wsCache.setTaskMonitorByTask(tenantId, reqBO.getTaskId(), rspBO);
        }
        catch (Exception e2) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e2.getMessage());
            e2.printStackTrace();
            rspBO.setRspCode("8888");
            rspBO.setRspDesc(e2.getMessage());
            return rspBO;
        }
        log.info("\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u60c5\u51b5\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    private TaskExecuteRateRspBO taskExecuteRateInIsv(TaskExecuteRateReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u767e\u5206\u6bd4\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        TaskExecuteRateRspBO rspBO = new TaskExecuteRateRspBO();
        try {
            ObIvrTaskPO ivrTask;
            String tenantId = reqBO.getTenantId();
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)tenantId)) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskType())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            BladeTenantBO bladeTenantBO = this.getTenantInfo(tenantId);
            if (bladeTenantBO == null) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u67e5\u8be2\u5931\u8d25");
                return rspBO;
            }
            Long taskTotalCount = 0L;
            Long isConnCount = 0L;
            Long isNotConnCount = 0L;
            Long dialCount = 0L;
            Long waitCallCount = 0L;
            Long callLoseCount = 0L;
            Long callNowCount = 0L;
            Integer recordUsedToday = 0;
            Integer recordNewCount = 0;
            Integer recordSuccToday = 0;
            Integer recordConnToday = 0;
            Integer currentCallCount = 0;
            ObTaskInfoPO taskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(reqBO.getTaskId());
            if (null != taskInfoPO) {
                taskTotalCount = StringUtils.isEmpty((Object)taskInfoPO.getDataNumber()) ? 0L : taskInfoPO.getDataNumber();
            }
            if (null == (ivrTask = this.ivrTaskDAO.selectByTaskId(reqBO.getTaskId()))) {
                rspBO.setRspCode("0000");
                rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
                return rspBO;
            }
            TaskMonitorBO taskMonitorBO = new TaskMonitorBO();
            taskMonitorBO.setIvrTaskID(ivrTask.getIvrTaskId());
            taskMonitorBO.setLocalTaskID(reqBO.getTaskId());
            taskMonitorBO.setTenantID("1");
            TaskMonitorInfo taskMonitorInfo = this.taskMonitorService.monitorTask(taskMonitorBO);
            TaskExecuteRateBO rateBO = new TaskExecuteRateBO();
            if (null == taskMonitorBO) {
                return this.taskExecuteRate(reqBO);
            }
            currentCallCount = taskMonitorInfo.getCurrentCallCount();
            recordNewCount = taskMonitorInfo.getRecordNewCount();
            recordUsedToday = taskMonitorInfo.getRecordUsedToday();
            recordSuccToday = taskMonitorInfo.getRecordSuccToday();
            recordConnToday = taskMonitorInfo.getRecordConnToday();
            rateBO.setTaskStatus(this.taskStatus(taskMonitorInfo.getTaskState()));
            if (null != recordSuccToday) {
                isConnCount = (long)recordSuccToday;
            }
            if (null != recordUsedToday) {
                dialCount = (long)recordUsedToday;
            }
            if (null != recordNewCount && (long)recordNewCount.intValue() > 0L) {
                waitCallCount = (long)recordNewCount;
            }
            if (null != currentCallCount) {
                callNowCount = (long)currentCallCount;
            }
            if (dialCount > 0L || waitCallCount > 0L || callNowCount > 0L) {
                taskTotalCount = dialCount + waitCallCount + callNowCount;
            }
            if (waitCallCount <= 0L) {
                waitCallCount = taskTotalCount - dialCount - callNowCount;
            }
            if (0 < recordUsedToday && 0 < recordConnToday) {
                isNotConnCount = recordUsedToday - recordConnToday;
            }
            rateBO.isTaskDataEnd();
            rateBO.setTaskTotalCount(taskTotalCount.toString());
            rateBO.setIsConnCount(isConnCount.toString());
            rateBO.setIsNotConnCount(isNotConnCount.toString());
            rateBO.setDialCount(dialCount.toString());
            rateBO.setWaitCallCount(waitCallCount.toString());
            rateBO.setCallLossCount(callLoseCount.toString());
            rateBO.setTaskSource(taskInfoPO.getTaskSource());
            rspBO.setData((Object)rateBO);
            rspBO.setRspCode("0000");
            rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            rspBO.setRspCode("8888");
            rspBO.setRspDesc(e.getMessage());
            return rspBO;
        }
        log.info("\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u767e\u5206\u6bd4\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    private String taskStatus(String taskState) {
        if ("NEW".equals(taskState)) {
            return "\u65b0\u5efa";
        }
        if ("START".equals(taskState)) {
            return "\u542f\u52a8";
        }
        if ("RUN".equals(taskState)) {
            return "\u8fd0\u884c";
        }
        if ("STOP".equals(taskState)) {
            return "\u6682\u505c";
        }
        if ("END".equals(taskState)) {
            return "\u7ed3\u675f";
        }
        if ("STOPEX".equals(taskState)) {
            return "\u5f02\u5e38\u6682\u505c";
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp updateTaskTactics(UpdateTaskTacticsReqBO reqBO) {
        log.info("\u4efb\u52a1\u76d1\u63a7-\u4fee\u6539\u4efb\u52a1\u7b56\u7565\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        try {
            String value;
            boolean within;
            String s;
            boolean b;
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                log.info("taskId\u4e0d\u80fd\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"taskId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getTenantCode())) {
                log.info("tenantCode\u4e0d\u80fd\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"tenantCode\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getMaxQueue())) {
                log.info("MaxQueue\u4e0d\u80fd\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"MaxQueue\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getParameter())) {
                log.info("\u5fae\u8c03\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"\u5fae\u8c03\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != reqBO.getMaxQueue() && !(b = RegularUtils.within100(s = String.valueOf(reqBO.getMaxQueue())))) {
                log.info("\u6700\u5927\u6392\u961f\u6570\u53ea\u80fd\u5728100\u4ee5\u5185");
                return BaseRspUtils.createErrorRsp((String)"\u6700\u5927\u6392\u961f\u6570\u53ea\u80fd\u5728100\u4ee5\u5185");
            }
            if (null != reqBO.getParameter() && !(within = RegularUtils.withinIn(value = String.valueOf(reqBO.getParameter())))) {
                log.info("\u5fae\u8c03\u53c2\u6570\u5728-100\u5230100\u4e4b\u5185");
                return BaseRspUtils.createErrorRsp((String)"\u5fae\u8c03\u53c2\u6570\u5728-100\u5230100\u4e4b\u5185");
            }
            ObTaskTacticsPO tacticsPO = new ObTaskTacticsPO();
            tacticsPO.setMaxQueue(reqBO.getMaxQueue());
            tacticsPO.setTaskId(reqBO.getTaskId());
            tacticsPO.setPredictionDivisor(reqBO.getParameter());
            log.info("\u4fee\u6539\u4efb\u52a1\u7b56\u7565mapper\u5c42\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)tacticsPO));
            int update = this.obTaskTacticsDAO.updateObTaskTacticsPOByTaskId(tacticsPO);
            ObTaskInfoPO selectBO = new ObTaskInfoPO();
            selectBO.setTaskId(reqBO.getTaskId());
            ObTaskInfoPO taskInfo = this.obTaskInfoDAO.selectTaskInfo(selectBO);
            if (null == taskInfo) {
                return BaseRspUtils.createSuccessRsp((Object)"\u4fee\u6539\u4efb\u52a1\u7b56\u7565\u6210\u529f\uff01");
            }
            ObCallRateConfigPO rateConfigPO = new ObCallRateConfigPO();
            rateConfigPO.setTenantId(taskInfo.getTenantId());
            ObCallRateConfigPO configPO = this.obCallRateConfigDAO.selectByTenantId(rateConfigPO);
            if (null == configPO) {
                this.isvTaskProxyService.modifyPredictive(reqBO.getTaskId(), taskInfo.getTenantId());
            } else {
                log.info("\u8d85\u7ba1\u8fdb\u884c\u4e86\u8be5\u79df\u6237\u7684\u5916\u547c\u901f\u7387\u9650\u5236\uff1a{}", (Object)JSONObject.toJSONString((Object)configPO));
            }
            if (update > 0) {
                return BaseRspUtils.createSuccessRsp((Object)"\u4fee\u6539\u4efb\u52a1\u7b56\u7565\u6210\u529f\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseRspUtils.createErrorRsp((String)"\u5931\u8d25");
        }
        return BaseRspUtils.createErrorRsp((String)"\u5931\u8d25");
    }

    private BladeTenantBO getTenantInfo(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }

    private Date creatStartTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date zeroTime = calendar.getTime();
        return zeroTime;
    }

    private Date creatEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date endTime = calendar.getTime();
        return endTime;
    }

    private List<Long> getList(List<Long> list) {
        if (list.size() < 15) {
            list.add(0L);
            this.getList(list);
        }
        return list;
    }

    public String percent(Integer a, Integer b) {
        if (b == 0) {
            return "0%";
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String result = numberFormat.format((float)a.intValue() / (float)b.intValue() * 100.0f);
        return result + "%";
    }

    public TaskExecuteRateBO grabeTaskExecute(String tenantCode, String taskId, String role) {
        List bindTenantList;
        log.info("\u67e5\u8be2\u62a2\u5355\u4efb\u52a1\u6267\u884c\u767e\u5206\u6bd4---tenantCode\uff1b{}\uff0ctaskId\uff1b{}\uff0crole\uff1b{}", new Object[]{tenantCode, taskId, role});
        Long taskTotalCount = 0L;
        Long isConnCount = 0L;
        Long isNotConnCount = 0L;
        Long dialCount = 0L;
        Long waitCallCount = 0L;
        Long callLoseCount = 0L;
        TaskExecuteRateBO bo = new TaskExecuteRateBO();
        ObTaskInfoPO taskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(taskId);
        if (null != taskInfoPO) {
            taskTotalCount = StringUtils.isEmpty((Object)taskInfoPO.getDataNumber()) ? 0L : taskInfoPO.getDataNumber();
        }
        if (null != (bindTenantList = this.obTaskTenantDAO.selectByTaskId(taskId)) && bindTenantList.size() > 0) {
            ObTaskTenantPO po = new ObTaskTenantPO();
            po.setTenantId(tenantCode);
            po.setTaskId(taskId);
            bindTenantList.add(po);
            for (ObTaskTenantPO taskTenantPO : bindTenantList) {
                BladeTenantBO tenantInfo = this.getTenantInfo(taskTenantPO.getTenantId());
                ObCallRecordPO callRecordPO = new ObCallRecordPO();
                callRecordPO.setTenantId(taskTenantPO.getTenantId());
                callRecordPO.setTaskId(taskId);
                callRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
                List obCallRecordPOS = this.obCallRecordDAO.selectCurrentDateTaskByIdNew(callRecordPO);
                if (null == obCallRecordPOS || obCallRecordPOS.size() <= 0) continue;
                Long conn = obCallRecordPOS.stream().filter(callRecord -> callRecord.getIsConn().equals("1") && callRecord.getObsIsConn().equals("1")).count();
                Long notConn = obCallRecordPOS.stream().filter(callRecord -> callRecord.getIsConn().equals("0") && callRecord.getObsIsConn().equals("0")).count();
                Long callLose = obCallRecordPOS.stream().filter(callRecord -> callRecord.getObsIsConn().equals("1") && callRecord.getIsConn().equals("0")).count();
                isConnCount = isConnCount + conn;
                isNotConnCount = isNotConnCount + notConn;
                callLoseCount = callLoseCount + callLose;
            }
            dialCount = isConnCount + isNotConnCount + callLoseCount;
            waitCallCount = taskTotalCount - dialCount;
            if (waitCallCount < 0L) {
                waitCallCount = 0L;
            }
        }
        if (TENANT_ADMIN.equals(role)) {
            BladeTenantBO tenantInfo = this.getTenantInfo(tenantCode);
            ObCallRecordPO callRecordPO = new ObCallRecordPO();
            callRecordPO.setTenantId(tenantInfo.getTenantId());
            callRecordPO.setTaskId(taskId);
            callRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
            List recordPOList = this.obCallRecordDAO.selectCurrentDateTaskByIdNew(callRecordPO);
            if (null != recordPOList && recordPOList.size() > 0) {
                Long conn;
                isConnCount = conn = Long.valueOf(recordPOList.stream().filter(callRecord -> callRecord.getIsConn().equals("1") && callRecord.getObsIsConn().equals("1")).count());
            }
        }
        bo.setIsConnCount(isConnCount.toString());
        bo.setIsNotConnCount(isNotConnCount.toString());
        bo.setCallLossCount(callLoseCount.toString());
        bo.setWaitCallCount(waitCallCount.toString());
        bo.setTaskTotalCount(taskTotalCount.toString());
        bo.setDialCount(dialCount.toString());
        return bo;
    }

    public TaskExecuteCaseBO grabeTaskExecuteCase(String tenantCode, String taskId, String role) {
        List bindTenantList;
        log.info("\u67e5\u8be2\u62a2\u5355\u4efb\u52a1\u6267\u884c\u60c5\u51b5---tenantCode\uff1b{}\uff0ctaskId\uff1b{}\uff0crole\uff1b{}", new Object[]{tenantCode, taskId, role});
        TaskExecuteCaseBO bo = new TaskExecuteCaseBO();
        long winCount = 0L;
        long calling = 0L;
        Date date = new Date();
        Date qryStartTime = this.creatStartTime(date);
        Date qryEndTime = this.creatEndTime(date);
        TaskExecuteRateBO taskExecute = this.grabeTaskExecute(tenantCode, taskId, role);
        if (null != taskExecute) {
            bo.setDialCount(taskExecute.getDialCount());
            bo.setIsConnCount(taskExecute.getIsConnCount());
            bo.setTaskTotalCount(taskExecute.getTaskTotalCount());
            bo.setWaitCallCount(taskExecute.getWaitCallCount());
        }
        if (null != (bindTenantList = this.obTaskTenantDAO.selectByTaskId(taskId)) && bindTenantList.size() > 0) {
            for (ObTaskTenantPO po : bindTenantList) {
                List newDataPOList = this.sessionChangeRecordDAO.selectMostNewData(taskId, qryStartTime, qryEndTime);
                log.info("\u67e5\u8be2\u5750\u5e2d\u72b6\u6001\u63a5\u53e3\u51fa\u53c2={}", (Object)JSONObject.toJSONString((Object)newDataPOList));
                if (null == newDataPOList || newDataPOList.size() <= 0) continue;
                Long callingNum = newDataPOList.stream().filter(e -> "AgentWorking".equals(e.getCtiSessionStatus())).count();
                calling += callingNum.longValue();
            }
        }
        bo.setCallNowCount(String.valueOf(calling));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", taskId);
        params.put("startTime", qryStartTime);
        params.put("endTime", qryEndTime);
        params.put("handleResults", "\u540c\u610f");
        params.put("state", "0");
        if (SYSTEM_ADMIN.equals(role) && bindTenantList != null && bindTenantList.size() > 0) {
            ArrayList tenantIds = new ArrayList();
            bindTenantList.forEach(x -> tenantIds.add(x.getTenantId()));
            params.put("tenantIds", tenantIds);
            winCount = this.documentCRUD.qryCallRecordCase(params);
            bo.setWinCount(String.valueOf(winCount));
            String percent = this.percent((int)winCount, Integer.valueOf(taskExecute.getIsConnCount()));
            bo.setWinCallRate(percent);
            params.remove("tenantIds");
        }
        if (TENANT_ADMIN.equals(role)) {
            params.put("tenantId", tenantCode);
            winCount = this.documentCRUD.qryCallRecordCase(params);
            String winCallRate = this.percent((int)winCount, Integer.valueOf(taskExecute.getIsConnCount()));
            bo.setWinCount(String.valueOf(winCount));
            bo.setWinCallRate(winCallRate);
        }
        return bo;
    }

    public TelephoneTrendBO grabeTelephoneTrend(String tenantCode, String taskId, String role, String startTime, String endTime) {
        List bindTenantList;
        log.info("\u67e5\u8be2\u62a2\u5355\u4efb\u52a1\u4eca\u65e5\u8bdd\u52a1\u91cf---tenantCode\uff1b{}\uff0ctaskId\uff1b{}\uff0crole\uff1b{}\uff0cstartTime\uff1b{}\uff0cendTime\uff1b{}", new Object[]{tenantCode, taskId, role, startTime, endTime});
        TelephoneTrendBO bo = new TelephoneTrendBO();
        List<String> hourList = Arrays.asList("08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22");
        List<Long> obCallCountList = new LinkedList<Long>();
        List<Long> obTalkCountList = new LinkedList<Long>();
        List<Long> turnCustomerCountList = new LinkedList<Long>();
        obCallCountList = this.getList(obCallCountList);
        obTalkCountList = this.getList(obTalkCountList);
        turnCustomerCountList = this.getList(turnCustomerCountList);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", taskId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        if (SYSTEM_ADMIN.equals(role) && null != (bindTenantList = this.obTaskTenantDAO.selectByTaskId(taskId)) && bindTenantList.size() > 0) {
            ArrayList tenantIds = new ArrayList();
            bindTenantList.forEach(x -> tenantIds.add(x.getTenantId()));
            params.put("tenantIds", tenantIds);
            List<ObCallRecordPO> callRecords = this.documentCRUD.qryCallRecordByHour(params);
            if (callRecords != null && callRecords.size() > 0) {
                for (ObCallRecordPO record : callRecords) {
                    Long isConnCount = record.getIsConnCount();
                    Long isNotConnCount = record.getIsNotConnCount();
                    Long obsIsConnCount = record.getObsIsConnCount();
                    Long rgjrCount = isConnCount + obsIsConnCount;
                    Long callCount = record.getCallCount();
                    for (int i = 0; i < 15; ++i) {
                        if (!hourList.get(i).equals(record.getObHour())) continue;
                        obCallCountList.set(i, obCallCountList.get(i) + callCount);
                        obTalkCountList.set(i, obTalkCountList.get(i) + rgjrCount);
                        turnCustomerCountList.set(i, turnCustomerCountList.get(i) + obsIsConnCount);
                    }
                }
                params.remove("tenantIds");
            }
        }
        if (TENANT_ADMIN.equals(role)) {
            params.put("tenantId", tenantCode);
            List<ObCallRecordPO> callRecords = this.documentCRUD.qryCallRecordByHour(params);
            if (callRecords != null && callRecords.size() > 0) {
                for (ObCallRecordPO record : callRecords) {
                    Long isConnCount = record.getIsConnCount();
                    Long isNotConnCount = record.getIsNotConnCount();
                    Long obsIsConnCount = record.getObsIsConnCount();
                    Long rgjrCount = isConnCount + obsIsConnCount;
                    Long callCount = record.getCallCount();
                    for (int i = 0; i < 15; ++i) {
                        if (!hourList.get(i).equals(record.getObHour())) continue;
                        obTalkCountList.set(i, rgjrCount);
                    }
                }
            }
        }
        bo.setHourList(hourList);
        bo.setObCallCountList(obCallCountList);
        bo.setObTalkCountList(obTalkCountList);
        bo.setTurnCustomerCountList(turnCustomerCountList);
        return bo;
    }

    public List<GrabeCustInfoBO> grabeCustomerStatusMonitoring(String tenantCode, String taskId, String role, Date qStartTime, Date qEndTime) {
        log.info("\u67e5\u8be2\u62a2\u5355\u4efb\u52a1\u5750\u5e2d\u76d1\u63a7---tenantCode\uff1b{}\uff0ctaskId\uff1b{}\uff0crole\uff1b{}\uff0cstartTime\uff1b{}\uff0cendTime\uff1b{}", new Object[]{tenantCode, taskId, role, qStartTime, qEndTime});
        ArrayList<GrabeCustInfoBO> boList = new ArrayList<GrabeCustInfoBO>();
        List newDataPOListPO = this.sessionChangeRecordDAO.selectMostNewData(taskId, qStartTime, qEndTime);
        log.info("\u67e5\u8be2\u5f53\u524d\u5750\u5e2d\u6700\u65b0\u6570\u636eMapper\u5c42\u51fa\u53c2={}", (Object)JSONObject.toJSONString((Object)newDataPOListPO));
        ArrayList<MostNewDataPO> newDataPOList = new ArrayList<MostNewDataPO>();
        for (MostNewDataPO dataPO : newDataPOListPO) {
            boolean b = newDataPOList.stream().anyMatch(e -> e.getPromoterId().equals(dataPO.getPromoterId()));
            if (b) continue;
            newDataPOList.add(dataPO);
        }
        log.info("\u53bb\u91cd\u540e={}", (Object)JSONObject.toJSONString(newDataPOList));
        if (newDataPOList != null && newDataPOList.size() > 0) {
            for (MostNewDataPO newDataPO : newDataPOList) {
                BladeUserBO userInfo;
                String userName = null;
                GrabeCustInfoBO bo = new GrabeCustInfoBO();
                bo.setCustStatus(newDataPO.getCtiSessionStatus());
                JobNumberBO jobNumberInfo = this.dcJobNumberInterService.queryJobNumberInfo(newDataPO.getPromoterId());
                if (jobNumberInfo != null && (userInfo = this.bladeUserInterService.queryUserInfo(jobNumberInfo.getUserId())) != null) {
                    userName = userInfo.getRealName();
                    bo.setCustId(userInfo.getId().toString());
                    bo.setTenantId(userInfo.getTenantId());
                }
                if (newDataPO.getCtiSessionStatus() != null) {
                    if (newDataPO.getCtiSessionStatus().equals("AgentWorking")) {
                        bo.setCustStatus("1");
                    }
                    if (newDataPO.getCtiSessionStatus().equals("AgentNotReady") || newDataPO.getCtiSessionStatus().equals("AgentAfterCallWork")) {
                        bo.setCustStatus("0");
                    }
                    if (newDataPO.getCtiSessionStatus().equals("AgentReady")) {
                        bo.setCustStatus("2");
                    }
                    if (newDataPO.getCtiSessionStatus().equals("AgentLogout")) {
                        bo.setCustStatus("3");
                    }
                    if (newDataPO.getCtiSessionStatus().equals("AgentLogin")) {
                        bo.setCustStatus("0");
                    }
                }
                long startTime = newDataPO.getCreateTime().getTime();
                long endTime = 0L;
                if (newDataPO.getEndTime() != null) {
                    endTime = newDataPO.getEndTime().getTime();
                } else {
                    Date en = new Date();
                    endTime = en.getTime();
                }
                long la = (endTime - startTime) / 1000L;
                String lastTime = DateTimeUtils.secondSwitchForHMS(la);
                bo.setCustStatusTime(lastTime);
                bo.setCustName(userName);
                boList.add(bo);
            }
        }
        return boList;
    }
}

