/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.task.relation.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.dept.QueryDeptRspBo;
import com.tydic.nicc.dc.bo.quick.QueryQuickNameBO;
import com.tydic.nicc.dc.bo.script.QryConfigScriptRspBO;
import com.tydic.nicc.dc.bo.script.QueryScriptByTaskIdReqBO;
import com.tydic.nicc.dc.bo.script.QueryScriptByTaskIdRspBO;
import com.tydic.nicc.dc.bo.speech.QuerySpeechTemlateReqBO;
import com.tydic.nicc.dc.bo.speech.QuerySpeechTemlateRspBO;
import com.tydic.nicc.dc.bo.speech.QuerySpeechTemplateRspBo;
import com.tydic.nicc.dc.bo.user.BladeUserBO;
import com.tydic.nicc.dc.bo.voice.QueryVoiceNameBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.dept.inter.BladeDeptInterService;
import com.tydic.nicc.dc.quick.inter.DcUserQuickInterService;
import com.tydic.nicc.dc.script.DcConfigScriptService;
import com.tydic.nicc.dc.speech.DcSpeechService;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.dc.voice.inter.DcVoiceInterService;
import com.tydic.nicc.dc.workTeam.inter.DcWorkTeamInterService;
import com.tydic.nicc.ocs.bo.AddTaskAllotReqBO;
import com.tydic.nicc.ocs.bo.GetBatchListReqBO;
import com.tydic.nicc.ocs.bo.GetDeptDataInfoReqBO;
import com.tydic.nicc.ocs.bo.GetDeptDataInfoRspBO;
import com.tydic.nicc.ocs.bo.QuerySpeechTemplateReqBO;
import com.tydic.nicc.ocs.bo.QuerySpeechTemplateRspBO;
import com.tydic.nicc.ocs.bo.QueryTaskQuickRspBO;
import com.tydic.nicc.ocs.bo.QueryTaskScriptReqBo;
import com.tydic.nicc.ocs.bo.QueryTaskScriptRspBO;
import com.tydic.nicc.ocs.bo.QueryTaskSmsTemplateRspBO;
import com.tydic.nicc.ocs.bo.QueryTaskUserReqBO;
import com.tydic.nicc.ocs.bo.QueryTaskUserRspBO;
import com.tydic.nicc.ocs.bo.QueryTaskVoiceRspBO;
import com.tydic.nicc.ocs.bo.RecycleDataReqBO;
import com.tydic.nicc.ocs.bo.TaskRelationBO;
import com.tydic.nicc.ocs.bo.TaskRelationParamBO;
import com.tydic.nicc.ocs.bo.TaskRelationParamsBO;
import com.tydic.nicc.ocs.bo.TaskRelationRspBO;
import com.tydic.nicc.ocs.bo.TaskUserRelationReqBO;
import com.tydic.nicc.ocs.bo.TryCallingReqBO;
import com.tydic.nicc.ocs.bo.UpdateTaskScriptReqBO;
import com.tydic.nicc.ocs.bo.UpdateTaskScriptRspBO;
import com.tydic.nicc.ocs.bo.UpdateTaskUserReqBO;
import com.tydic.nicc.ocs.bo.UpdateTaskUserRspBO;
import com.tydic.nicc.ocs.constant.TaskConstant;
import com.tydic.nicc.ocs.mapper.ObDataTargetDAO;
import com.tydic.nicc.ocs.mapper.ObTaskAllotDAO;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.ObTaskMemberDAO;
import com.tydic.nicc.ocs.mapper.ObTaskQuickDAO;
import com.tydic.nicc.ocs.mapper.ObTaskScriptDAO;
import com.tydic.nicc.ocs.mapper.ObTaskSmsTemplateDAO;
import com.tydic.nicc.ocs.mapper.ObTaskSpeechTemplateDAO;
import com.tydic.nicc.ocs.mapper.ObTaskVoiceDAO;
import com.tydic.nicc.ocs.mapper.po.ObDataTargetPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskAllotPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskMemberPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskQuickPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskScriptPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskSmsTemplatePO;
import com.tydic.nicc.ocs.mapper.po.ObTaskSpeechTemplatePO;
import com.tydic.nicc.ocs.mapper.po.ObTaskVoicePO;
import com.tydic.nicc.ocs.service.TaskConfigRelationService;
import com.tydic.nicc.ocs.utils.TaskInfoUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@DubboService
public class TaskConfigRelationServiceImpl
implements TaskConfigRelationService {
    private static final Logger log = LoggerFactory.getLogger(TaskConfigRelationServiceImpl.class);
    @Resource
    private ObTaskInfoDAO obTaskInfoDAO;
    @Resource
    private ObTaskSmsTemplateDAO obTaskSmsTemplateDAO;
    @Resource
    private ObTaskQuickDAO obTaskQuickDAO;
    @Resource
    private ObTaskSpeechTemplateDAO obTaskSpeechTemplateDAO;
    @Resource
    private ObTaskScriptDAO obTaskScriptDAO;
    @Resource
    private ObTaskMemberDAO obTaskMemberDAO;
    @Resource
    private ObTaskVoiceDAO obTaskVoiceDAO;
    @Resource
    private ObDataTargetDAO obDataTargetDAO;
    @Resource
    private ObTaskAllotDAO obTaskAllotDAO;
    @DubboReference
    private DcSpeechService dcSpeechService;
    @DubboReference
    private DcConfigScriptService dcConfigScriptService;
    @DubboReference
    private DcVoiceInterService dcVoiceInterService;
    @DubboReference
    private DcUserQuickInterService dcUserQuickInterService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @DubboReference
    private DcWorkTeamInterService dcWorkTeamInterService;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private BladeDeptInterService bladeDeptInterService;
    private static final Integer STATUS_0 = 0;
    private static final Integer STATUS_1 = 1;
    private static final String SUCCESS_MESSAGE = "SUCCESS";
    private static final String DELETE_FLAG_0 = "0";
    private static final String DELETE_FLAG_1 = "1";
    private static List<String> list = Lists.newArrayList();
    private static List<Map<String, List<String>>> los = Lists.newArrayList();

    public TaskRelationBO taskSmsTemplateRelation(TaskRelationParamBO smsBO) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u77ed\u4fe1\u6a21\u677f\u5173\u8054\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)smsBO));
        TaskRelationBO relationBO = this.checkParam(smsBO.getTaskId(), smsBO.getRelationId(), "\u77ed\u4fe1\u6a21\u677fID\u4e3a\u7a7a");
        if (relationBO.getStatus() == STATUS_1) {
            return relationBO;
        }
        ObTaskSmsTemplatePO obTaskSmsTemplatePO = new ObTaskSmsTemplatePO();
        obTaskSmsTemplatePO.setSmsId(TaskInfoUtil.get16UUID());
        obTaskSmsTemplatePO.setDeleteFlag(DELETE_FLAG_0);
        obTaskSmsTemplatePO.setTaskId(smsBO.getTaskId());
        obTaskSmsTemplatePO.setTemplateId(smsBO.getRelationId());
        this.obTaskSmsTemplateDAO.updateByTaskId(smsBO.getTaskId());
        log.info("\u4efb\u52a1-\u77ed\u4fe1\u6a21\u677f\u5173\u8054Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskSmsTemplatePO));
        return this.getTaskRelationBO(this.obTaskSmsTemplateDAO.insertSelective(obTaskSmsTemplatePO), "\u4efb\u52a1-\u77ed\u4fe1\u6a21\u677f\u5173\u8054\u5931\u8d25");
    }

    public QueryTaskSmsTemplateRspBO queryTaskSmsTemplate(String taskId) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u77ed\u4fe1\u6a21\u677f\u67e5\u8be2\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)taskId);
        QueryTaskSmsTemplateRspBO queryTaskSmsTemplateRspBO = new QueryTaskSmsTemplateRspBO();
        if (StringUtils.isEmpty((Object)taskId)) {
            log.error("taskId\u4e3a\u7a7a");
            return new QueryTaskSmsTemplateRspBO();
        }
        ObTaskSmsTemplatePO smsTemplatePO = this.obTaskSmsTemplateDAO.selectByTaskId(taskId);
        log.info("\u4efb\u52a1-\u77ed\u4fe1\u6a21\u677f\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)smsTemplatePO));
        if (smsTemplatePO != null) {
            BeanUtils.copyProperties((Object)smsTemplatePO, (Object)queryTaskSmsTemplateRspBO);
        }
        return queryTaskSmsTemplateRspBO;
    }

    public TaskRelationBO taskQuickRelation(TaskRelationParamsBO quickBO) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u5e38\u7528\u8bed\u5173\u8054\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)quickBO));
        TaskRelationBO relationBO = this.checkParams(quickBO.getTaskId(), quickBO.getRelationParams(), "\u5e38\u7528\u8bedID\u96c6\u5408\u4e3a\u7a7a");
        if (relationBO.getStatus() == STATUS_1) {
            return relationBO;
        }
        if (StringUtils.isEmpty((Object)quickBO.getQuickJosn())) {
            relationBO.setStatus(STATUS_1);
            relationBO.setMessage("\u5e38\u7528\u8bedjson\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
            return relationBO;
        }
        ArrayList<ObTaskQuickPO> obTaskQuickPOS = new ArrayList<ObTaskQuickPO>();
        for (String quickId : quickBO.getRelationParams()) {
            ObTaskQuickPO obTaskQuickPO = new ObTaskQuickPO();
            obTaskQuickPO.setTaskQuickId(TaskInfoUtil.get16UUID());
            obTaskQuickPO.setDeleteFlag(DELETE_FLAG_0);
            obTaskQuickPO.setQuickId(quickId);
            obTaskQuickPO.setTaskId(quickBO.getTaskId());
            obTaskQuickPO.setQuickJson(quickBO.getQuickJosn());
            obTaskQuickPOS.add(obTaskQuickPO);
        }
        int insertNum = 0;
        if (!obTaskQuickPOS.isEmpty()) {
            this.obTaskQuickDAO.updateByTaskId(quickBO.getTaskId());
            log.info("\u4efb\u52a1-\u5e38\u7528\u8bed\u5173\u8054Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(obTaskQuickPOS));
            insertNum = this.obTaskQuickDAO.inserts(obTaskQuickPOS);
        }
        return this.getTaskRelationBO(insertNum, "\u4efb\u52a1-\u5e38\u7528\u8bed\u5173\u8054\u5931\u8d25");
    }

    public List<QueryTaskQuickRspBO> queryTaskQuick(String taskId) {
        log.info("\u4efb\u52a1-\u5e38\u7528\u8bed\u67e5\u8be2\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)taskId);
        ArrayList<QueryTaskQuickRspBO> rspBOS = new ArrayList<QueryTaskQuickRspBO>();
        if (StringUtils.isEmpty((Object)taskId)) {
            log.error("taskId\u4e3a\u7a7a");
            return new ArrayList<QueryTaskQuickRspBO>();
        }
        List obTaskQuickPOs = this.obTaskQuickDAO.selectByTaskId(taskId);
        log.info("\u4efb\u52a1-\u5e38\u7528\u8bed\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskQuickPOs));
        if (obTaskQuickPOs != null && obTaskQuickPOs.size() > 0) {
            for (ObTaskQuickPO obTaskQuickPO : obTaskQuickPOs) {
                QueryQuickNameBO queryQuickNameBO;
                QueryTaskQuickRspBO queryTaskQuickRspBO = new QueryTaskQuickRspBO();
                BeanUtils.copyProperties((Object)obTaskQuickPO, (Object)queryTaskQuickRspBO);
                queryTaskQuickRspBO.setQuickJson(obTaskQuickPO.getQuickJson());
                if (!StringUtils.isEmpty((Object)obTaskQuickPO.getQuickId()) && (queryQuickNameBO = this.dcUserQuickInterService.queryQuickName(obTaskQuickPO.getQuickId())) != null) {
                    queryTaskQuickRspBO.setQuickName(queryQuickNameBO.getQuickName());
                }
                rspBOS.add(queryTaskQuickRspBO);
            }
        }
        return rspBOS;
    }

    public Rsp taskSpeechTemplateRelation(TaskRelationParamBO reqBO) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u8bdd\u672f\u914d\u7f6e\u5173\u8054\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        try {
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                log.error("\u4efb\u52a1ID\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1ID\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getRelationId())) {
                log.error("\u8bdd\u672fID\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"\u8bdd\u672fID\u4e3a\u7a7a");
            }
            ObTaskSpeechTemplatePO obTaskSpeechTemplatePO = new ObTaskSpeechTemplatePO();
            obTaskSpeechTemplatePO.setTsId(TaskInfoUtil.get16UUID());
            obTaskSpeechTemplatePO.setDeleteFlag(DELETE_FLAG_0);
            obTaskSpeechTemplatePO.setTaskId(reqBO.getTaskId());
            obTaskSpeechTemplatePO.setSpeechId(reqBO.getRelationId());
            int insertNum = 0;
            log.info("\u4efb\u52a1-\u8bdd\u672f\u914d\u7f6e\u5173\u8054Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskSpeechTemplatePO));
            insertNum = this.obTaskSpeechTemplateDAO.insertSelective(obTaskSpeechTemplatePO);
            if (insertNum == 0) {
                return BaseRspUtils.createErrorRsp((String)"\u65b0\u589e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25:{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public RspList<QuerySpeechTemplateRspBO> querySpeechTemplate(QuerySpeechTemplateReqBO reqBO) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u8bdd\u672f\u914d\u7f6e\u67e5\u8be2\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)reqBO);
        ArrayList<QuerySpeechTemplateRspBO> rspBOS = new ArrayList<QuerySpeechTemplateRspBO>();
        List<Object> templateRspBOS = new ArrayList<QuerySpeechTemplateRspBO>();
        List rows = new ArrayList();
        try {
            String tenantId;
            String string = tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                log.error("taskId\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRspList((String)"taskId\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)tenantId)) {
                if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                    return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                tenantId = reqBO.getTenantId();
            }
            List obTaskSpeechTemplatePOS = this.obTaskSpeechTemplateDAO.selectByTaskId(reqBO.getTaskId());
            log.info("\u4efb\u52a1-\u8bdd\u672f\u914d\u7f6e\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskSpeechTemplatePOS));
            ArrayList<String> speecgIds = new ArrayList<String>();
            if (!obTaskSpeechTemplatePOS.isEmpty()) {
                for (ObTaskSpeechTemplatePO speechTemplatePO : obTaskSpeechTemplatePOS) {
                    speecgIds.add(speechTemplatePO.getSpeechId());
                }
            }
            QuerySpeechTemlateReqBO querySpeechTemlateReqBO = new QuerySpeechTemlateReqBO();
            querySpeechTemlateReqBO.setSpeechIds(speecgIds);
            querySpeechTemlateReqBO.setTenantId(tenantId);
            querySpeechTemlateReqBO.setSpeechName(reqBO.getSpeechName());
            querySpeechTemlateReqBO.setStartTime(reqBO.getStartTime());
            querySpeechTemlateReqBO.setEndTime(reqBO.getEndTime());
            QuerySpeechTemlateRspBO rspBO = this.dcSpeechService.querySpeechTemlate(querySpeechTemlateReqBO);
            log.info("\u67e5\u8be2\u8bdd\u672f\u5217\u8868\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)rspBO));
            if (rspBO.getRspCode().equals("0000") && (rows = rspBO.getRows()) != null && rows.size() > 0) {
                for (QuerySpeechTemplateRspBo row : rows) {
                    int flag = 0;
                    QuerySpeechTemplateRspBO speechTemplateRspBO = new QuerySpeechTemplateRspBO();
                    if (obTaskSpeechTemplatePOS != null && obTaskSpeechTemplatePOS.size() > 0) {
                        for (ObTaskSpeechTemplatePO speecgId : obTaskSpeechTemplatePOS) {
                            if (!row.getSpeechId().equals(Long.parseLong(speecgId.getSpeechId()))) continue;
                            QuerySpeechTemplateRspBO templateRspBO = new QuerySpeechTemplateRspBO();
                            templateRspBO.setTsId(speecgId.getTsId());
                            templateRspBO.setTaskId(speecgId.getTaskId());
                            templateRspBO.setDeleteFlag(speecgId.getDeleteFlag());
                            templateRspBO.setSpeechId(speecgId.getSpeechId());
                            templateRspBO.setSpeechName(row.getSpeechName());
                            templateRspBO.setSpeechText(row.getSpeechText());
                            templateRspBO.setSpeechTextSecond(row.getSpeechTextSecond());
                            templateRspBO.setSpeechType(row.getSpeechType());
                            templateRspBO.setSpeechTypeStr(row.getSpeechTypeStr());
                            templateRspBO.setStatus(row.getStatus());
                            templateRspBO.setRemark(row.getRemark());
                            templateRspBO.setAddPerson(row.getAddPerson());
                            templateRspBO.setFiles(row.getFiles());
                            templateRspBO.setTenantId(reqBO.getTenantCode());
                            templateRspBO.setCreateTime(row.getCreateTime());
                            templateRspBOS.add(templateRspBO);
                            ++flag;
                        }
                    }
                    if (flag != 0) continue;
                    BeanUtils.copyProperties((Object)row, (Object)speechTemplateRspBO);
                    speechTemplateRspBO.setSpeechId(row.getSpeechId().toString());
                    rspBOS.add(speechTemplateRspBO);
                }
            }
            templateRspBOS.addAll(rspBOS);
            templateRspBOS = templateRspBOS.stream().skip(reqBO.getLimit() * (reqBO.getPage() - 1)).limit(reqBO.getLimit()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRspList(templateRspBOS, (long)rows.size());
    }

    public Rsp updateSpeechTemplate(TaskRelationParamBO reqBO) {
        log.info("\u8fdb\u5165\u8bdd\u672f\u914d\u7f6e\u89e3\u7ed1\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)reqBO);
        try {
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                log.error("\u4efb\u52a1ID\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1ID\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getRelationId())) {
                log.error("\u8bdd\u672fID\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"\u8bdd\u672fID\u4e3a\u7a7a");
            }
            ObTaskSpeechTemplatePO obTaskSpeechTemplatePO = new ObTaskSpeechTemplatePO();
            obTaskSpeechTemplatePO.setTaskId(reqBO.getTaskId());
            obTaskSpeechTemplatePO.setSpeechId(reqBO.getRelationId());
            obTaskSpeechTemplatePO.setDeleteFlag(DELETE_FLAG_1);
            int updNum = this.obTaskSpeechTemplateDAO.updateByTaskIdAndSpeechId(obTaskSpeechTemplatePO);
            if (updNum == 0) {
                log.error("\u89e3\u7ed1\u5931\u8d25");
                return BaseRspUtils.createErrorRsp((String)"\u89e3\u7ed1\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u7ed1\u5931\u8d25:{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp taskScriptRelation(TaskRelationParamBO reqBO) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u95ee\u5377\u811a\u672c\u5173\u8054\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        try {
            TaskRelationBO relationBO = this.checkParam(reqBO.getTaskId(), reqBO.getRelationId(), "\u95ee\u5377\u811a\u672cID\u4e3a\u7a7a");
            if (relationBO.getStatus() == STATUS_1) {
                return BaseRspUtils.createErrorRsp((String)relationBO.getMessage());
            }
            if (StringUtils.isEmpty((Object)reqBO.getDeleteFlag())) {
                return BaseRspUtils.createErrorRsp((String)"\u5220\u9664\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ObTaskScriptPO obTaskScriptPO = new ObTaskScriptPO();
            obTaskScriptPO.setTaskScriptId(TaskInfoUtil.get16UUID());
            obTaskScriptPO.setDeleteFlag(reqBO.getDeleteFlag());
            obTaskScriptPO.setTaskId(reqBO.getTaskId());
            obTaskScriptPO.setScriptId(reqBO.getRelationId());
            this.obTaskScriptDAO.updateByTaskId(reqBO.getTaskId());
            log.info("\u4efb\u52a1-\u95ee\u5377\u811a\u672c\u5173\u8054Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskScriptPO));
            this.obTaskScriptDAO.insertSelective(obTaskScriptPO);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new RuntimeException();
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public RspList<QueryTaskScriptRspBO> queryTaskScript(QueryTaskScriptReqBo reqBo) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u95ee\u5377\u811a\u672c\u67e5\u8be2\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)reqBo);
        QueryTaskScriptRspBO bo = new QueryTaskScriptRspBO();
        List<Object> bos = new ArrayList();
        List rows = new ArrayList();
        try {
            if (StringUtils.isEmpty((Object)reqBo.getTaskId())) {
                log.error("taskId\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRspList((String)"taskId\u4e3a\u7a7a");
            }
            ObTaskScriptPO obTaskScriptPO = this.obTaskScriptDAO.selectByTaskId(reqBo.getTaskId());
            log.info("\u4efb\u52a1-\u95ee\u5377\u811a\u672c\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskScriptPO));
            QueryScriptByTaskIdReqBO scriptByTaskIdReqBO = new QueryScriptByTaskIdReqBO();
            if (obTaskScriptPO != null) {
                scriptByTaskIdReqBO.setScriptId(obTaskScriptPO.getScriptId());
            }
            scriptByTaskIdReqBO.setTenantId(StringUtils.isEmpty((Object)reqBo.getTenantCode()) ? reqBo.getIn_tenantCode() : reqBo.getTenantCode());
            QueryScriptByTaskIdRspBO rspBO = this.dcConfigScriptService.queryScriptByTaskId(scriptByTaskIdReqBO);
            if (rspBO.getRspCode().equals("0000")) {
                rows = rspBO.getRows();
                if (rows != null) {
                    for (QryConfigScriptRspBO scriptRspBO : rows) {
                        QueryTaskScriptRspBO taskScriptRspBO = new QueryTaskScriptRspBO();
                        if (obTaskScriptPO != null && scriptRspBO.getScriptId().equals(obTaskScriptPO.getScriptId())) {
                            taskScriptRspBO.setTaskScriptId(obTaskScriptPO.getTaskScriptId());
                            taskScriptRspBO.setTaskId(obTaskScriptPO.getTaskId());
                            taskScriptRspBO.setDeleteFlag(obTaskScriptPO.getDeleteFlag());
                            taskScriptRspBO.setScriptId(obTaskScriptPO.getScriptId());
                            taskScriptRspBO.setIsBind(Integer.valueOf(0));
                            BeanUtils.copyProperties((Object)scriptRspBO, (Object)taskScriptRspBO);
                            bos.add(taskScriptRspBO);
                            continue;
                        }
                        taskScriptRspBO.setIsBind(Integer.valueOf(1));
                        BeanUtils.copyProperties((Object)scriptRspBO, (Object)taskScriptRspBO);
                        bos.add(taskScriptRspBO);
                    }
                }
                bos = bos.stream().skip(reqBo.getLimit() * (reqBo.getPage() - 1)).limit(reqBo.getLimit()).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRspList(bos, (long)rows.size());
    }

    public UpdateTaskScriptRspBO updateTaskScript(UpdateTaskScriptReqBO reqBO) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u95ee\u5377\u811a\u672c\u89e3\u7ed1\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        UpdateTaskScriptRspBO rspBO = new UpdateTaskScriptRspBO();
        try {
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)reqBO.getScriptId())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u95ee\u5377\u811a\u672cID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)reqBO.getDeleteFlag())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskScriptId())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            ObTaskScriptPO obTaskScriptPO = new ObTaskScriptPO();
            obTaskScriptPO.setTaskId(reqBO.getTaskId());
            obTaskScriptPO.setScriptId(reqBO.getScriptId());
            obTaskScriptPO.setTaskScriptId(reqBO.getTaskScriptId());
            obTaskScriptPO.setDeleteFlag(reqBO.getDeleteFlag());
            ObTaskScriptPO taskScriptPO = this.obTaskScriptDAO.selectTakScript(obTaskScriptPO);
            log.info("\u6839\u636e\u4efb\u52a1ID\u4e0e\u811a\u672cID\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)taskScriptPO));
            if (taskScriptPO == null) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u5165\u53c2\u9519\u8bef");
                return rspBO;
            }
            int updNum = this.obTaskScriptDAO.updateByPrimaryKeySelective(obTaskScriptPO);
            if (updNum == 0) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u89e3\u7ed1\u5931\u8d25");
                return rspBO;
            }
            rspBO.setRspCode("0000");
            rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u89e3\u7ed1\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            rspBO.setRspCode("8888");
            rspBO.setRspDesc(e.getMessage());
            e.printStackTrace();
            return rspBO;
        }
        return rspBO;
    }

    public Rsp taskUserRelation(TaskUserRelationReqBO reqBO) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u4eba\u5458\u914d\u7f6e\u5173\u8054\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        boolean insertNum = false;
        try {
            if (reqBO == null) {
                log.error("\u5165\u53c2\u9519\u8bef");
                return BaseRspUtils.createErrorRsp((String)"\u5165\u53c2\u9519\u8bef");
            }
            List<Object> userIds = new ArrayList();
            if (reqBO.getRelationParams() != null && reqBO.getRelationParams().size() > 0) {
                userIds.addAll(reqBO.getRelationParams());
            }
            if (reqBO.getWorkGroups() != null && reqBO.getWorkGroups().size() > 0) {
                for (String str : reqBO.getWorkGroups()) {
                    List userIdList = this.dcWorkTeamInterService.getUserIds(str);
                    if (userIdList == null || userIdList.size() <= 0) continue;
                    userIds.addAll(userIdList);
                }
            }
            if (userIds == null || userIds.size() == 0) {
                return BaseRspUtils.createErrorRsp((String)"\u4eba\u5458ID\u96c6\u5408\u6216\u6240\u9009\u5de5\u4f5c\u7ec4\u4e0b\u672a\u914d\u7f6e\u4eba\u5458");
            }
            List taskMemberPOS = this.obTaskMemberDAO.selectByTaskId(reqBO.getTaskId());
            log.info("\u67e5\u8be2\u5f53\u524d\u4efb\u52a1\u4e0b\u662f\u5426\u5df2\u7ecf\u5206\u914d\u4eba\u5458Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)taskMemberPOS));
            if (taskMemberPOS != null && taskMemberPOS.size() > 0) {
                ArrayList<String> ids = new ArrayList<String>();
                for (ObTaskMemberPO po : taskMemberPOS) {
                    ids.add(po.getUserId());
                }
                userIds = userIds.stream().filter(item -> !ids.contains(item)).collect(Collectors.toList());
            }
            if (userIds == null || userIds.size() == 0) {
                return BaseRspUtils.createErrorRsp((String)"\u6240\u9009\u5750\u5e2d\u5df2\u5728\u5206\u914d\u5217\u8868\u4e2d\uff01");
            }
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            ArrayList<ObTaskMemberPO> obTaskMemberPOS = new ArrayList<ObTaskMemberPO>();
            for (String userId : userIds) {
                ObTaskMemberPO obTaskMemberPO = new ObTaskMemberPO();
                obTaskMemberPO.setMemberId(TaskInfoUtil.get16UUID());
                obTaskMemberPO.setTaskId(reqBO.getTaskId());
                obTaskMemberPO.setUserId(userId);
                obTaskMemberPO.setDeleteFlag(DELETE_FLAG_0);
                obTaskMemberPOS.add(obTaskMemberPO);
            }
            if (!obTaskMemberPOS.isEmpty()) {
                this.obTaskMemberDAO.inserts(obTaskMemberPOS);
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public RspList<QueryTaskUserRspBO> queryTaskUser(QueryTaskUserReqBO reqBO) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u4eba\u5458\u914d\u7f6e\u67e5\u8be2\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        List<Object> rspBOS = new ArrayList<QueryTaskUserRspBO>();
        Integer count = 0;
        try {
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                log.error("taskId\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRspList((String)"taskId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getCallType())) {
                return BaseRspUtils.createErrorRspList((String)"\u5916\u547c\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String tenantId = reqBO.getTenantCode();
            if (StringUtils.isEmpty((Object)tenantId)) {
                if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                    return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                tenantId = reqBO.getTenantId();
            }
            List obTaskMemberPOS = this.obTaskMemberDAO.selectByTaskId(reqBO.getTaskId());
            log.info("\u4efb\u52a1-\u4eba\u5458\u914d\u7f6e\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskMemberPOS));
            ObTaskAllotPO po = new ObTaskAllotPO();
            po.setTenantId(tenantId);
            po.setTaskId(reqBO.getTaskId());
            po.setAllotType(Integer.valueOf(0));
            if (obTaskMemberPOS != null && obTaskMemberPOS.size() > 0) {
                for (ObTaskMemberPO obTaskMemberPO : obTaskMemberPOS) {
                    BladeUserBO bladeUserBO;
                    Integer dataCount = 0;
                    Integer finishCount = 0;
                    if (reqBO.getCallType().equals(DELETE_FLAG_1)) {
                        if (reqBO.getAllotType() == null) {
                            return BaseRspUtils.createErrorRspList((String)"\u5206\u5355\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (reqBO.getAllotType() == 0) {
                            po.setUserId(obTaskMemberPO.getUserId());
                            List pos = this.obTaskAllotDAO.selectTaskDataNum(po);
                            log.info("\u83b7\u53d6\u5750\u5e2d\u5206\u5355\u4fe1\u606fMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)pos));
                            dataCount = pos.size();
                            ArrayList<String> dataIds = new ArrayList<String>();
                            if (pos != null && pos.size() > 0) {
                                for (ObTaskAllotPO allotPO : pos) {
                                    dataIds.add(allotPO.getDataId());
                                }
                                ObDataTargetPO dataTargetPO = new ObDataTargetPO();
                                BladeTenantBO tenantInfo = this.getTenantInfo(tenantId);
                                dataTargetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
                                dataTargetPO.setDataIds(dataIds);
                                dataTargetPO.setDataStatus("assigned");
                                dataTargetPO.setTenantId(tenantId);
                                Integer dataNum = this.obDataTargetDAO.selectByDataIds(dataTargetPO);
                                log.info("\u83b7\u53d6\u5750\u5e2d\u5206\u5355\u6570\u636e\u672a\u5b8c\u6210\u91cfMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)dataNum);
                                finishCount = dataNum;
                            }
                        }
                    }
                    QueryTaskUserRspBO queryTaskUserRspBO = new QueryTaskUserRspBO();
                    BeanUtils.copyProperties((Object)obTaskMemberPO, (Object)queryTaskUserRspBO);
                    queryTaskUserRspBO.setDataNum(dataCount);
                    queryTaskUserRspBO.setFinishNum(finishCount);
                    if (!StringUtils.isEmpty((Object)obTaskMemberPO.getUserId()) && (bladeUserBO = this.bladeUserInterService.queryUserInfo(obTaskMemberPO.getUserId())) != null) {
                        queryTaskUserRspBO.setUserName(bladeUserBO.getRealName());
                        queryTaskUserRspBO.setAccount(bladeUserBO.getAccount());
                        queryTaskUserRspBO.setName(bladeUserBO.getName());
                    }
                    rspBOS.add(queryTaskUserRspBO);
                }
            }
            if (rspBOS != null && rspBOS.size() > 0) {
                if (!StringUtils.isEmpty((Object)reqBO.getUserName())) {
                    rspBOS = this.filterListByName(rspBOS, reqBO.getUserName());
                }
                if (!StringUtils.isEmpty((Object)reqBO.getAccount())) {
                    rspBOS = this.filterListByUserId(rspBOS, reqBO.getAccount());
                }
            }
            count = rspBOS.size();
            rspBOS = rspBOS.stream().skip((reqBO.getPage() - 1) * reqBO.getLimit()).limit(reqBO.getLimit()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)count.intValue());
    }

    private List<QueryTaskUserRspBO> filterListByName(List<QueryTaskUserRspBO> rspBOS, String patternName) {
        ArrayList<QueryTaskUserRspBO> bos = new ArrayList<QueryTaskUserRspBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (QueryTaskUserRspBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getUserName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private List<QueryTaskUserRspBO> filterListByUserId(List<QueryTaskUserRspBO> rspBOS, String patternName) {
        ArrayList<QueryTaskUserRspBO> bos = new ArrayList<QueryTaskUserRspBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (QueryTaskUserRspBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getAccount());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private Boolean getPatternName(Pattern pattern, String str) {
        if (!StringUtils.isEmpty((Object)str)) {
            Matcher matcher = pattern.matcher(str);
            return matcher.find();
        }
        return false;
    }

    public UpdateTaskUserRspBO updateTaskUser(UpdateTaskUserReqBO reqBO) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u4eba\u5458\u914d\u7f6e\u89e3\u7ed1\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        UpdateTaskUserRspBO rspBO = new UpdateTaskUserRspBO();
        try {
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)reqBO.getUserId())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)reqBO.getTenantCode())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            ObTaskMemberPO obTaskMemberPO = new ObTaskMemberPO();
            obTaskMemberPO.setTaskId(reqBO.getTaskId());
            obTaskMemberPO.setUserId(reqBO.getUserId());
            ObTaskMemberPO taskMemberPO = this.obTaskMemberDAO.selectTaskMember(obTaskMemberPO);
            log.info("\u6839\u636e\u4efb\u52a1ID\u4e0e\u4eba\u5458ID\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)taskMemberPO));
            if (taskMemberPO == null) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u5165\u53c2\u9519\u8bef");
                return rspBO;
            }
            BladeTenantBO tenantInfo = this.getTenantInfo(reqBO.getTenantCode());
            if (tenantInfo == null) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u5f53\u524d\u79df\u6237\u5f02\u5e38\uff01");
                return rspBO;
            }
            if (TaskConstant.ALLOT_TYPE_2.equals(reqBO.getAllotType())) {
                RecycleDataReqBO dataReqBO = new RecycleDataReqBO();
                dataReqBO.setTenantCode(reqBO.getTenantCode());
                dataReqBO.setAllotType(reqBO.getAllotType());
                dataReqBO.setUserId(reqBO.getUserId());
                dataReqBO.setTaskId(reqBO.getTaskId());
                this.recycle(dataReqBO);
            } else {
                ObTaskAllotPO allotPO = new ObTaskAllotPO();
                allotPO.setTaskId(reqBO.getTaskId());
                allotPO.setUserId(reqBO.getUserId());
                allotPO.setTenantId(reqBO.getTenantCode());
                List allotPos = this.obTaskAllotDAO.selectByTaskId(allotPO);
                if (allotPos != null && allotPos.size() > 0) {
                    this.recycleUserData(allotPos, tenantInfo);
                }
            }
            obTaskMemberPO.setDeleteFlag(DELETE_FLAG_1);
            int denNum = this.obTaskMemberDAO.updateByPrimaryKeySelective(obTaskMemberPO);
            if (denNum == 0) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u89e3\u7ed1\u5931\u8d25");
                return rspBO;
            }
            rspBO.setRspCode("0000");
            rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspBO;
    }

    private void recycleUserData(List<ObTaskAllotPO> allotPos, BladeTenantBO tenantInfo) {
        log.info("\u5f00\u59cb\u56de\u6536\u89e3\u7ed1\u4eba\u5458\u5df2\u5206\u914d\u7684\u6570\u636e");
        ArrayList<String> dataIds = new ArrayList<String>();
        ArrayList<String> allotIds = new ArrayList<String>();
        for (ObTaskAllotPO po : allotPos) {
            dataIds.add(po.getDataId());
            allotIds.add(po.getId());
        }
        if (allotIds != null && allotIds.size() > 0) {
            this.obTaskAllotDAO.updateByIds(allotIds);
        }
        if (dataIds != null && dataIds.size() > 0) {
            ObDataTargetPO targetPO = new ObDataTargetPO();
            targetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
            targetPO.setTenantId(tenantInfo.getTenantId());
            targetPO.setDataIds(dataIds);
            targetPO.setDataStatus("waiting");
            this.obDataTargetDAO.updateDateByIds(targetPO);
        }
    }

    public TaskRelationRspBO taskRelationVoice(TaskRelationParamBO reqBO) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u5916\u547c\u8bed\u97f3\u5173\u8054\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        TaskRelationRspBO rspBO = new TaskRelationRspBO();
        try {
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                log.error("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)reqBO.getRelationId())) {
                log.error("\u5916\u547c\u8bed\u97f3ID\u4e0d\u80fd\u4e3a\u7a7a");
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u5916\u547c\u8bed\u97f3ID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (StringUtils.isEmpty((Object)reqBO.getRelationName())) {
                log.error("\u5916\u547c\u8bed\u97f3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u5916\u547c\u8bed\u97f3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            this.obTaskVoiceDAO.updateByTaskId(reqBO.getTaskId());
            ObTaskVoicePO obTaskVoicePO = new ObTaskVoicePO();
            obTaskVoicePO.setTaskVoiceId(TaskInfoUtil.get16UUID());
            obTaskVoicePO.setTaskId(reqBO.getTaskId());
            obTaskVoicePO.setVoiceId(reqBO.getRelationId());
            obTaskVoicePO.setVoiceName(reqBO.getRelationName());
            log.info("\u4efb\u52a1-\u5916\u547c\u8bed\u97f3\u5173\u8054Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskVoicePO));
            this.obTaskVoiceDAO.insertSelective(obTaskVoicePO);
            rspBO.setRspCode("0000");
            rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            rspBO.setRspCode("8888");
            rspBO.setRspDesc(e.getMessage());
            return rspBO;
        }
        return rspBO;
    }

    public QueryTaskVoiceRspBO queryTaskVoice(String taskId) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u4efb\u52a1\u5916\u547c\u8bed\u97f3\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)taskId);
        QueryTaskVoiceRspBO rspBO = new QueryTaskVoiceRspBO();
        try {
            if (StringUtils.isEmpty((Object)taskId)) {
                log.error("\u4efb\u52a1ID\u4e3a\u7a7a");
                return rspBO;
            }
            ObTaskVoicePO obTaskVoicePO = this.obTaskVoiceDAO.selectByTaskId(taskId);
            log.info("\u6839\u636e\u4efb\u52a1ID\u67e5\u8be2\u4efb\u52a1\u8bed\u97f3Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskVoicePO));
            if (obTaskVoicePO != null) {
                BeanUtils.copyProperties((Object)obTaskVoicePO, (Object)rspBO);
                QueryVoiceNameBO queryVoiceNameBO = this.dcVoiceInterService.queryVoiceName(obTaskVoicePO.getVoiceId());
                if (queryVoiceNameBO != null) {
                    rspBO.setVoiceName(queryVoiceNameBO.getVoiceName());
                    rspBO.setVoiceUrl(queryVoiceNameBO.getVoiceUrl());
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return new QueryTaskVoiceRspBO();
        }
        return rspBO;
    }

    public Boolean queryTaskScriptByScriptId(String scriptId) {
        log.info("\u8fdb\u5165\u6821\u9a8c\u5f53\u524d\u95ee\u5377\u811a\u672cID\u662f\u5426\u7ed1\u5b9a\u4efb\u52a1\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)scriptId);
        Boolean flag = false;
        ObTaskScriptPO obTaskScriptPO = new ObTaskScriptPO();
        obTaskScriptPO.setScriptId(scriptId);
        List obTaskScriptPOS = this.obTaskScriptDAO.selectByScriptId(obTaskScriptPO);
        log.info("\u6839\u636e\u811a\u672cID\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)obTaskScriptPOS);
        if (obTaskScriptPOS != null && obTaskScriptPOS.size() > 0) {
            ArrayList<String> taskIds = new ArrayList<String>();
            for (ObTaskScriptPO scriptPO : obTaskScriptPOS) {
                taskIds.add(scriptPO.getTaskId());
            }
            flag = this.checkTaskStatus(taskIds);
        } else {
            flag = true;
        }
        return flag;
    }

    public Boolean queryTaskSmsBySmsId(String smsId) {
        log.info("\u8fdb\u5165\u6821\u9a8c\u5f53\u524d\u77ed\u4fe1\u6a21\u677fID\u662f\u5426\u7ed1\u5b9a\u4efb\u52a1\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)smsId);
        Boolean flag = false;
        ObTaskSmsTemplatePO obTaskSmsTemplatePO = new ObTaskSmsTemplatePO();
        obTaskSmsTemplatePO.setTemplateId(smsId);
        List obTaskSmsTemplatePOS = this.obTaskSmsTemplateDAO.selectBtSmsId(obTaskSmsTemplatePO);
        log.info("\u6839\u636e\u77ed\u4fe1\u6a21\u677fID\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)obTaskSmsTemplatePOS);
        if (obTaskSmsTemplatePOS != null && obTaskSmsTemplatePOS.size() > 0) {
            ArrayList<String> taskIds = new ArrayList<String>();
            for (ObTaskSmsTemplatePO templatePO : obTaskSmsTemplatePOS) {
                taskIds.add(templatePO.getTaskId());
            }
            flag = this.checkTaskStatus(taskIds);
        } else {
            flag = true;
        }
        return flag;
    }

    public Boolean queryTaskQuickByQuickId(String quickId) {
        log.info("\u8fdb\u5165\u6821\u9a8c\u5f53\u524d\u5e38\u7528\u8bedID\u662f\u5426\u7ed1\u5b9a\u4efb\u52a1\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)quickId);
        Boolean flag = false;
        ObTaskQuickPO obTaskQuickPO = new ObTaskQuickPO();
        obTaskQuickPO.setQuickId(quickId);
        List quickPOS = this.obTaskQuickDAO.selectByQuickId(obTaskQuickPO);
        log.info("\u6839\u636e\u5e38\u7528\u8bedID\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)quickPOS));
        if (quickPOS != null && quickPOS.size() > 0) {
            ArrayList<String> taskIds = new ArrayList<String>();
            for (ObTaskQuickPO quickPO : quickPOS) {
                taskIds.add(quickPO.getTaskId());
            }
            flag = this.checkTaskStatus(taskIds);
        } else {
            flag = true;
        }
        return flag;
    }

    public Boolean queryTaskSpeechBySpeechId(String speechId) {
        log.info("\u8fdb\u5165\u6821\u9a8c\u5f53\u524d\u8bdd\u672fID\u662f\u5426\u7ed1\u5b9a\u4efb\u52a1\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)speechId);
        Boolean flag = false;
        ObTaskSpeechTemplatePO obTaskSpeechTemplatePO = new ObTaskSpeechTemplatePO();
        obTaskSpeechTemplatePO.setSpeechId(speechId);
        List speechTemplatePOS = this.obTaskSpeechTemplateDAO.selectBySpeechId(obTaskSpeechTemplatePO);
        log.info("\u6839\u636e\u8bdd\u672fID\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)speechTemplatePOS);
        if (speechTemplatePOS != null && speechTemplatePOS.size() > 0) {
            ArrayList<String> taskIds = new ArrayList<String>();
            for (ObTaskSpeechTemplatePO templatePO : speechTemplatePOS) {
                taskIds.add(templatePO.getTaskId());
            }
            flag = this.checkTaskStatus(taskIds);
        } else {
            flag = true;
        }
        return flag;
    }

    private Boolean checkTaskStatus(List<String> taskIds) {
        log.info("\u5f00\u59cb\u6821\u9a8c\u4efb\u52a1\u72b6\u6001");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Boolean flag = false;
        ObTaskInfoPO taskInfoPO = new ObTaskInfoPO();
        taskInfoPO.setTaskIds(taskIds);
        taskInfoPO.setCreateTime(sdf.format(new Date()));
        List infoPOS = this.obTaskInfoDAO.selectBytaskIds(taskInfoPO);
        log.info("\u6839\u636e\u4efb\u52a1ID\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)infoPOS));
        if (infoPOS == null) {
            flag = true;
        }
        return flag;
    }

    private TaskRelationBO getTaskRelationBO(int insertNum, String errorMessage) {
        TaskRelationBO relationBO = new TaskRelationBO();
        if (insertNum == 0) {
            log.error(errorMessage, (Object)"insertNum\uff1a{}", (Object)insertNum);
            relationBO.setStatus(STATUS_1);
            relationBO.setMessage(errorMessage);
            return relationBO;
        }
        relationBO.setStatus(STATUS_0);
        relationBO.setMessage(SUCCESS_MESSAGE);
        return relationBO;
    }

    private TaskRelationBO checkParam(String taskId, String relationId, String errorMessage) {
        TaskRelationBO relationBO = new TaskRelationBO();
        if (StringUtils.isEmpty((Object)taskId)) {
            log.error("\u4efb\u52a1Id\u4e3a\u7a7a");
            relationBO.setStatus(STATUS_1);
            relationBO.setMessage("\u4efb\u52a1ID\u4e3a\u7a7a");
            return relationBO;
        }
        if (StringUtils.isEmpty((Object)relationId)) {
            log.error(errorMessage);
            relationBO.setStatus(STATUS_1);
            relationBO.setMessage(errorMessage);
            return relationBO;
        }
        relationBO.setStatus(STATUS_0);
        relationBO.setMessage(SUCCESS_MESSAGE);
        return relationBO;
    }

    private TaskRelationBO checkParams(String taskId, List<String> relationParams, String errorMessage) {
        TaskRelationBO relationBO = new TaskRelationBO();
        if (StringUtils.isEmpty((Object)taskId)) {
            log.error("\u4efb\u52a1Id\u4e3a\u7a7a");
            relationBO.setStatus(STATUS_1);
            relationBO.setMessage("\u4efb\u52a1ID\u4e3a\u7a7a");
            return relationBO;
        }
        if (relationParams == null || relationParams.size() == 0) {
            log.error(errorMessage);
            relationBO.setStatus(STATUS_1);
            relationBO.setMessage(errorMessage);
            return relationBO;
        }
        relationBO.setStatus(STATUS_0);
        relationBO.setMessage(SUCCESS_MESSAGE);
        return relationBO;
    }

    private Boolean getUser(Pattern pattern, String str) {
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            return true;
        }
        return false;
    }

    private Boolean getUser(Pattern pattern, Pattern pattern1, String str, String str1) {
        Matcher matcher = pattern.matcher(str);
        Matcher matcher1 = pattern1.matcher(str1);
        if (matcher.find() && matcher1.find()) {
            return true;
        }
        return false;
    }

    public Rsp addTaskAllot(AddTaskAllotReqBO reqBO) {
        log.info("\u8fdb\u5165\u4efb\u52a1-\u6570\u636e\u5206\u5355\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        try {
            BladeTenantBO tenantInfo;
            String tenantCode = reqBO.getTenantCode();
            if (StringUtils.isEmpty((Object)tenantCode)) {
                if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                    return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                tenantCode = reqBO.getTenantId();
            }
            if (reqBO.getAllotType() == null) {
                return BaseRspUtils.createErrorRsp((String)"\u5206\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<String> objList = new ArrayList();
            if (TaskConstant.ALLOT_TYPE_0.equals(reqBO.getAllotType())) {
                if (reqBO.getUserIds() == null || reqBO.getUserIds().size() == 0) {
                    return BaseRspUtils.createErrorRsp((String)"\u4eba\u5458ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
                }
                objList = reqBO.getUserIds();
            }
            if (TaskConstant.ALLOT_TYPE_1.equals(reqBO.getAllotType())) {
                if (reqBO.getDeptIds() == null || reqBO.getDeptIds().size() == 0) {
                    return BaseRspUtils.createErrorRsp((String)"\u90e8\u95e8ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
                }
                objList = reqBO.getDeptIds();
            }
            if (!TaskConstant.ALLOT_TYPE_2.equals(reqBO.getAllotType())) {
                if (reqBO.getAllotCount() == null) {
                    return BaseRspUtils.createErrorRsp((String)"\u5206\u914d\u6570\u636e\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (reqBO.getAllotCount() == 0) {
                    return BaseRspUtils.createErrorRsp((String)"\u5206\u914d\u6570\u636e\u91cf\u81f3\u5c11\u4e3a1");
                }
            }
            if ((tenantInfo = this.getTenantInfo(tenantCode)) == null) {
                return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u9519\u8bef");
            }
            ObDataTargetPO obDataTargetPO = new ObDataTargetPO();
            obDataTargetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
            obDataTargetPO.setTaskId(reqBO.getTaskId());
            obDataTargetPO.setLimitNum(reqBO.getAllotCount());
            obDataTargetPO.setTenantId(tenantCode);
            obDataTargetPO.setDataStatus("waiting");
            obDataTargetPO.setActivityCode(reqBO.getActivityCode());
            obDataTargetPO.setBatch(reqBO.getBatch());
            obDataTargetPO.setStartTime(reqBO.getImportStartTime());
            obDataTargetPO.setEndTime(reqBO.getImportEndTime());
            obDataTargetPO.setBlockOrg(reqBO.getBlockOrg());
            obDataTargetPO.setIsBind(TaskConstant.IS_BIND_0);
            obDataTargetPO.setAllotType(reqBO.getAllotType());
            log.info("\u67e5\u8be2\u5177\u4f53\u5206\u914d\u6570\u636eMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obDataTargetPO));
            List targetPOS = this.obDataTargetDAO.selectTaskDataByLimit(obDataTargetPO);
            log.info("\u67e5\u8be2\u5177\u4f53\u5206\u914d\u6570\u636eMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)targetPOS));
            ArrayList<String> dataIds = new ArrayList<String>();
            if (targetPOS != null && targetPOS.size() > 0) {
                for (ObDataTargetPO targetPO : targetPOS) {
                    dataIds.add(targetPO.getDataId());
                }
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = format.format(new Date());
            if (TaskConstant.ALLOT_TYPE_2.equals(reqBO.getAllotType())) {
                return this.autoAllot(reqBO, dataIds, tenantInfo, createTime);
            }
            List<Map<String, List<String>>> maps = TaskConfigRelationServiceImpl.averageData(dataIds, objList);
            log.info("MAPS:{}", (Object)JSONObject.toJSONString(maps));
            ArrayList<ObTaskAllotPO> obTaskAllotPOS = new ArrayList<ObTaskAllotPO>();
            for (Map<String, List<String>> map : maps) {
                for (String key : map.keySet()) {
                    for (String dataId : map.get(key)) {
                        ObTaskAllotPO allotPO = new ObTaskAllotPO();
                        allotPO.setTaskId(reqBO.getTaskId());
                        allotPO.setAllotType(reqBO.getAllotType());
                        allotPO.setTenantId(tenantCode);
                        allotPO.setCreateTime(createTime);
                        allotPO.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                        allotPO.setIsDelete(TaskConstant.IS_DELETE_0);
                        if (reqBO.getAllotType() == 0) {
                            allotPO.setUserId(key);
                        }
                        if (reqBO.getAllotType() == 1) {
                            allotPO.setDeptId(key);
                        }
                        allotPO.setDataId(dataId);
                        obTaskAllotPOS.add(allotPO);
                    }
                }
            }
            int inserts = 0;
            if (obTaskAllotPOS != null && obTaskAllotPOS.size() > 0) {
                log.info("\u65b0\u589e\u5206\u5355\u6570\u636eMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(obTaskAllotPOS));
                inserts = this.obTaskAllotDAO.inserts(obTaskAllotPOS);
                log.info("\u65b0\u589e{}\u6761\u6570\u636e\uff1a{}", (Object)inserts);
            }
            this.updateDataStatus(dataIds, tenantInfo.getTenantOtherName(), "assigned");
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    private Rsp autoAllot(AddTaskAllotReqBO reqBO, List<String> dataIds, BladeTenantBO tenantInfo, String createTime) {
        log.info("\u8fdb\u5165\u81ea\u52a8\u5206\u5355\u903b\u8f91");
        if (reqBO.getUserIds() == null || reqBO.getUserIds().size() == 0) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u5148\u5206\u914d\u4eba\u5458");
        }
        if (dataIds == null || dataIds.size() == 0) {
            return BaseRspUtils.createErrorRsp((String)"\u6682\u65e0\u4efb\u52a1\u6570\u636e\uff01");
        }
        String userIds = JSONObject.toJSONString((Object)reqBO.getUserIds());
        ArrayList<ObTaskAllotPO> obTaskAllotPOS = new ArrayList<ObTaskAllotPO>();
        for (String dataId : dataIds) {
            ObTaskAllotPO allotPO = new ObTaskAllotPO();
            allotPO.setTaskId(reqBO.getTaskId());
            allotPO.setAllotType(reqBO.getAllotType());
            allotPO.setTenantId(tenantInfo.getTenantId());
            allotPO.setCreateTime(createTime);
            allotPO.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            allotPO.setIsDelete(TaskConstant.IS_DELETE_0);
            allotPO.setUserId(userIds);
            allotPO.setDataId(dataId);
            obTaskAllotPOS.add(allotPO);
        }
        int inserts = 0;
        if (obTaskAllotPOS != null && obTaskAllotPOS.size() > 0) {
            log.info("\u65b0\u589e\u5206\u5355\u6570\u636eMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(obTaskAllotPOS));
            inserts = this.obTaskAllotDAO.inserts(obTaskAllotPOS);
            log.info("\u65b0\u589e{}\u6761\u6570\u636e\uff1a{}", (Object)inserts);
        }
        this.updateDataStatus(dataIds, tenantInfo.getTenantOtherName(), "assigned");
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    private void updateDataStatus(List<String> dataIds, String tenantName, String dataStatus) {
        log.info("\u5f00\u59cb\u4fee\u6539\u5df2\u5206\u914d\u4efb\u52a1\u6570\u636e\u72b6\u6001");
        ObDataTargetPO obDataTargetPO = new ObDataTargetPO();
        obDataTargetPO.setDataStatus(dataStatus);
        obDataTargetPO.setDataIds(dataIds);
        obDataTargetPO.setTenantOtherName(tenantName);
        this.obDataTargetDAO.updateDateByIds(obDataTargetPO);
    }

    public RspList getBatchList(GetBatchListReqBO reqBO) {
        BladeTenantBO tenantInfo;
        log.info("\u83b7\u53d6\u6279\u6b21\u53f7\u5217\u8868,\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            return BaseRspUtils.createErrorRspList((String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tenantCode = reqBO.getTenantCode();
        if (StringUtils.isEmpty((Object)tenantCode)) {
            if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            tenantCode = reqBO.getTenantId();
        }
        if ((tenantInfo = this.getTenantInfo(tenantCode)) == null) {
            return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u9519\u8bef");
        }
        ObDataTargetPO obDataTargetPO = new ObDataTargetPO();
        obDataTargetPO.setTaskId(reqBO.getTaskId());
        obDataTargetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        obDataTargetPO.setDataStatus("waiting");
        List batchList = this.obDataTargetDAO.getBatch(obDataTargetPO);
        log.info("\u83b7\u53d6\u6279\u6b21\u53f7Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)batchList));
        return BaseRspUtils.createSuccessRspList((List)batchList, (long)batchList.size());
    }

    public Rsp recycleData(RecycleDataReqBO reqBO) {
        log.info("\u8fdb\u5165\u56de\u6536\u6570\u636e\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        try {
            String tenantCode = reqBO.getTenantCode();
            if (StringUtils.isEmpty((Object)tenantCode)) {
                return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getAllotType() == null) {
                return BaseRspUtils.createErrorRsp((String)"\u5206\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1Id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ObTaskAllotPO allotPO = new ObTaskAllotPO();
            allotPO.setTaskId(reqBO.getTaskId());
            allotPO.setTenantId(tenantCode);
            allotPO.setAllotType(reqBO.getAllotType());
            if (TaskConstant.ALLOT_TYPE_0.equals(reqBO.getAllotType()) || TaskConstant.ALLOT_TYPE_2.equals(reqBO.getAllotType())) {
                if (StringUtils.isEmpty((Object)reqBO.getUserId())) {
                    return BaseRspUtils.createErrorRsp((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                allotPO.setUserId(reqBO.getUserId());
            }
            if (TaskConstant.ALLOT_TYPE_1.equals(reqBO.getAllotType())) {
                if (StringUtils.isEmpty((Object)reqBO.getDeptId())) {
                    return BaseRspUtils.createErrorRsp((String)"\u90e8\u95e8Id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                allotPO.setDeptId(reqBO.getDeptId());
            }
            if (TaskConstant.ALLOT_TYPE_2.equals(reqBO.getAllotType())) {
                return this.recycle(reqBO);
            }
            List<ObTaskAllotPO> pos = this.getDataIds(allotPO);
            if (pos == null || pos.size() == 0) {
                return BaseRspUtils.createErrorRsp((String)"\u6682\u65e0\u5206\u914d\u6570\u636e\u4fe1\u606f");
            }
            ArrayList<String> dataIds = new ArrayList<String>();
            ArrayList<String> allotIds = new ArrayList<String>();
            for (ObTaskAllotPO po : pos) {
                dataIds.add(po.getDataId());
                allotIds.add(po.getId());
            }
            this.obTaskAllotDAO.updateByIds(allotIds);
            ObDataTargetPO targetPO = new ObDataTargetPO();
            targetPO.setDataStatus("waiting");
            BladeTenantBO tenantInfo = this.getTenantInfo(tenantCode);
            if (tenantInfo == null) {
                return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u6709\u8bef");
            }
            targetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
            targetPO.setDataIds(dataIds);
            this.obDataTargetDAO.updateDateByIds(targetPO);
        }
        catch (Exception e) {
            log.error("\u56de\u6536\u6570\u636e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    private Rsp recycle(RecycleDataReqBO reqBO) {
        ObTaskAllotPO allotPO = new ObTaskAllotPO();
        allotPO.setAllotType(reqBO.getAllotType());
        allotPO.setTaskId(reqBO.getTaskId());
        allotPO.setTenantId(reqBO.getTenantCode());
        List obTaskAllotPOS = this.obTaskAllotDAO.selectByTaskId(allotPO);
        log.info("\u6839\u636e\u4efb\u52a1ID\u67e5\u8be2\u5206\u5355\u6570\u636eMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskAllotPOS));
        String userId = null;
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> dataIds = new ArrayList<String>();
        if (obTaskAllotPOS != null && obTaskAllotPOS.size() > 0) {
            for (ObTaskAllotPO obTaskAllotPO : obTaskAllotPOS) {
                userId = obTaskAllotPO.getUserId();
                ids.add(obTaskAllotPO.getId());
                dataIds.add(obTaskAllotPO.getDataId());
            }
            List userIds = JSONArray.parseArray(userId, String.class);
            userIds.remove(reqBO.getUserId());
            ObTaskAllotPO taskAllotPO = new ObTaskAllotPO();
            if (userIds == null || userIds.size() == 0) {
                taskAllotPO.setIsDelete(TaskConstant.IS_DELETE_1);
                BladeTenantBO tenantInfo = this.getTenantInfo(reqBO.getTenantCode());
                this.updateDataStatus(dataIds, tenantInfo.getTenantOtherName(), "waiting");
            } else {
                taskAllotPO.setUserId(JSONObject.toJSONString((Object)userIds));
            }
            taskAllotPO.setIds(ids);
            log.info("\u56de\u6536\u81ea\u52a8\u5206\u5355\u6570\u636eMapper\u5c42\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)taskAllotPO));
            this.obTaskAllotDAO.recycleAllotDate(taskAllotPO);
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public RspList getDeptDataInfo(GetDeptDataInfoReqBO reqBO) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u90e8\u95e8\u5206\u5355\u6570\u636e\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        String tenantCode = reqBO.getTenantCode();
        if (StringUtils.isEmpty((Object)tenantCode)) {
            if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            tenantCode = reqBO.getTenantId();
        }
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            return BaseRspUtils.createErrorRspList((String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getUserIds() == null || reqBO.getUserIds().size() == 0) {
            return BaseRspUtils.createErrorRspList((String)"\u4eba\u5458ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List userBOS = this.bladeUserInterService.queryUserInfo(reqBO.getUserIds());
        if (userBOS == null || userBOS.size() == 0) {
            return BaseRspUtils.createErrorRspList((String)"\u5750\u5e2dID\u5165\u53c2\u6709\u8bef");
        }
        ArrayList<String> deptIds = new ArrayList<String>();
        for (BladeUserBO userBO : userBOS) {
            deptIds.add(userBO.getDeptId());
        }
        RspList deptInfos = this.bladeDeptInterService.getDeptInfos(deptIds);
        log.info("deptInfos:{}", (Object)JSONObject.toJSONString((Object)deptInfos));
        if (!deptInfos.getRspCode().equals("0000")) {
            return BaseRspUtils.createErrorRspList((String)"\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u5931\u8d25");
        }
        ObTaskAllotPO po = new ObTaskAllotPO();
        po.setTenantId(tenantCode);
        po.setTaskId(reqBO.getTaskId());
        po.setAllotType(Integer.valueOf(1));
        ArrayList<GetDeptDataInfoRspBO> rspBOS = new ArrayList<GetDeptDataInfoRspBO>();
        for (QueryDeptRspBo dept : deptInfos.getRows()) {
            Integer dataNum = 0;
            Integer finishCount = 0;
            po.setDeptId(dept.getId());
            List pos = this.obTaskAllotDAO.selectTaskDataNum(po);
            log.info("\u5f53\u524d\u90e8\u95e8ID\uff1a{}\uff0c \u90e8\u95e8\u5206\u5355\u6570\u636eMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)dept.getId(), (Object)JSONObject.toJSONString((Object)pos));
            ArrayList<String> dataIds = new ArrayList<String>();
            if (pos != null && pos.size() > 0) {
                for (ObTaskAllotPO allotPO : pos) {
                    dataIds.add(allotPO.getDataId());
                }
                dataNum = pos.size();
                ObDataTargetPO dataTargetPO = new ObDataTargetPO();
                BladeTenantBO tenantInfo = this.getTenantInfo(tenantCode);
                dataTargetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
                dataTargetPO.setDataIds(dataIds);
                dataTargetPO.setDataStatus("assigned");
                dataTargetPO.setTenantId(tenantCode);
                dataTargetPO.setTaskId(reqBO.getTaskId());
                Integer dataCount = this.obDataTargetDAO.selectByDataIds(dataTargetPO);
                log.info("\u83b7\u53d6\u5750\u5e2d\u5206\u5355\u6570\u636e\u672a\u5b8c\u6210\u91cfMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)dataCount);
                if (dataNum > 0) {
                    finishCount = dataNum - dataCount;
                }
            }
            GetDeptDataInfoRspBO rspBO = new GetDeptDataInfoRspBO();
            rspBO.setDeptId(dept.getId());
            rspBO.setDeptName(dept.getDeptName());
            rspBO.setFullName(dept.getFullName());
            rspBO.setDataNum(dataNum);
            rspBO.setFinishCount(finishCount);
            rspBOS.add(rspBO);
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)rspBOS.size());
    }

    public Boolean checkVoiceBindTask(String voiceId) {
        log.info("\u5f00\u59cb\u6821\u9a8c\u5f53\u524d\u8bed\u97f3\u662f\u5426\u7ed1\u5b9a\u4efb\u52a1");
        Boolean flag = false;
        List obTaskVoicePOS = this.obTaskVoiceDAO.selectByVoiceId(voiceId);
        if (obTaskVoicePOS != null && obTaskVoicePOS.size() > 0) {
            ArrayList<String> taskIds = new ArrayList<String>();
            for (ObTaskVoicePO voice : obTaskVoicePOS) {
                taskIds.add(voice.getTaskId());
            }
            flag = this.checkTaskStatus(taskIds);
        } else {
            flag = true;
        }
        return flag;
    }

    public Rsp tryCalling(TryCallingReqBO reqBO) {
        log.info("\u81ea\u52a8\u5916\u547c-\u8bd5\u547c\u5165\u53c2={}", (Object)reqBO);
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            log.info("\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPhone())) {
            log.info("\u8bd5\u547c\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u8bd5\u547c\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }

    public static List<Map<String, List<String>>> averageData(List<String> dataIds, List<String> userIds) {
        TaskConfigRelationServiceImpl.initCollections(dataIds, userIds);
        if (dataIds.size() >= userIds.size()) {
            TaskConfigRelationServiceImpl.groupByData(los.size());
            return TaskConfigRelationServiceImpl.getMaps();
        }
        TaskConfigRelationServiceImpl.groupByData(list.size());
        return TaskConfigRelationServiceImpl.getMaps();
    }

    @NotNull
    private static List<Map<String, List<String>>> getMaps() {
        ArrayList listMap = Lists.newArrayList();
        listMap.addAll(los);
        los = Lists.newArrayList();
        list = Lists.newArrayList();
        return listMap;
    }

    private static void groupByData(int size) {
        List<String> augmented = list;
        List<List<String>> lists = TaskConfigRelationServiceImpl.chunk2(augmented, size);
        for (int i = 0; i < size; ++i) {
            Map<String, List<String>> map = los.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            if (!iterator.hasNext()) continue;
            String next = iterator.next();
            map.put(next, lists.get(i));
        }
    }

    private static void initCollections(List<String> dataIds, List<String> userIds) {
        if (list.size() > 0) {
            list = Lists.newArrayList();
        }
        if (los.size() > 0) {
            los = Lists.newArrayList();
        }
        list.addAll(dataIds);
        ArrayList list1 = new ArrayList();
        for (String sellerId : userIds) {
            HashMap map = new HashMap(16);
            ArrayList list = new ArrayList();
            map.put(sellerId, list);
            list1.add(map);
        }
        los.addAll(list1);
    }

    private static <T> List<List<T>> chunk2(List<T> list, int group) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        HashMap temp = Maps.newHashMap();
        for (int i = 0; i < list.size(); ++i) {
            Set<T> ts;
            if (temp.containsKey(i % group)) {
                ts = (Set)temp.get(i % group);
                ts.add(list.get(i));
                temp.put(i % group, ts);
                continue;
            }
            ts = Sets.newHashSet();
            ts.add(list.get(i));
            temp.put(i % group, ts);
        }
        for (Set<T> ts : temp.values()) {
            result.add(Lists.newArrayList((Iterable)ts));
        }
        return result;
    }

    private List<ObTaskAllotPO> getDataIds(ObTaskAllotPO obTaskAllotPO) {
        log.info("\u83b7\u53d6\u9700\u8981\u89e3\u7ed1\u5f97\u4efb\u52a1\u6570\u636eID\u96c6\u5408\uff0cObTaskAllotPO: {}", (Object)JSONObject.toJSONString((Object)obTaskAllotPO));
        List pos = this.obTaskAllotDAO.selectByTaskId(obTaskAllotPO);
        log.info("\u83b7\u53d6\u9700\u8981\u89e3\u7ed1\u5f97\u6570\u636eID\u96c6\u5408Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)pos));
        return pos;
    }

    public BladeTenantBO getTenantInfo(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }
}

