/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.task.relation.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.specialPhone.QuerySpecialPhoneOutBo;
import com.tydic.nicc.dc.bo.specialPhone.QuerySpecialPhoneReqBo;
import com.tydic.nicc.dc.boot.starter.ftp.FtpConfigBean;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.specialPhone.inter.SpecialPhoneInterService;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.ErrInfoRspBO;
import com.tydic.nicc.ocs.bo.ImportTaskDataErrorInfoBO;
import com.tydic.nicc.ocs.bo.ImportTaskDataReqBO;
import com.tydic.nicc.ocs.bo.ImportTaskDataRspBO;
import com.tydic.nicc.ocs.bo.OcsDownLoadReqBO;
import com.tydic.nicc.ocs.bo.OcsDownLoadRspBO;
import com.tydic.nicc.ocs.bo.OcsUploadReqBO;
import com.tydic.nicc.ocs.bo.OcsUploadRspBO;
import com.tydic.nicc.ocs.bo.QueryTaskDataTargetReqBO;
import com.tydic.nicc.ocs.bo.QueryTaskDataTargetRspBO;
import com.tydic.nicc.ocs.bo.TaskDataTargetBO;
import com.tydic.nicc.ocs.bo.UpdatePhoneStatusReqBO;
import com.tydic.nicc.ocs.bo.UpdateTaskDataTargetReqBO;
import com.tydic.nicc.ocs.cache.LocalCache;
import com.tydic.nicc.ocs.constant.TaskConstant;
import com.tydic.nicc.ocs.mapper.ObDataCustomerMapper;
import com.tydic.nicc.ocs.mapper.ObDataTargetDAO;
import com.tydic.nicc.ocs.mapper.ObNetworkNumberSegmentDAO;
import com.tydic.nicc.ocs.mapper.ObTaskAllotDAO;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.UserProductPolicyDAO;
import com.tydic.nicc.ocs.mapper.po.DataTypePo;
import com.tydic.nicc.ocs.mapper.po.ObDataCustomerPO;
import com.tydic.nicc.ocs.mapper.po.ObDataTargetPO;
import com.tydic.nicc.ocs.mapper.po.ObNetworkNumberSegmentPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskAllotPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.mapper.po.UserProductPolicyPO;
import com.tydic.nicc.ocs.service.OCSFileService;
import com.tydic.nicc.ocs.service.TaskDataTargetService;
import com.tydic.nicc.ocs.utils.MD5CheckUtils;
import com.tydic.nicc.ocs.utils.TaskInfoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jumpmind.symmetric.csv.CsvReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@DubboService
public class TaskDataTargetServiceImpl
implements TaskDataTargetService {
    private static final Logger log = LoggerFactory.getLogger(TaskDataTargetServiceImpl.class);
    @Resource
    private ObDataTargetDAO obDataTargetDAO;
    private static final String DATA_STATUS_WAITING = "waiting";
    @Resource
    private ObDataCustomerMapper ObDataCustomerPOMapper;
    @Resource
    private ObTaskAllotDAO obTaskAllotDAO;
    @Resource
    private ObTaskInfoDAO obTaskInfoDAO;
    @Resource
    private UserProductPolicyDAO userProductPolicyDAO;
    @Resource
    private ObNetworkNumberSegmentDAO obNetworkNumberSegmentDAO;
    @DubboReference
    private SpecialPhoneInterService specialPhoneInterService;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @Resource
    private FtpConfigBean ftpConfigBean;
    @Autowired
    private OCSFileService ocsFileService;

    public ImportTaskDataRspBO importTaskData(ImportTaskDataReqBO reqBO) {
        log.info("\u8fdb\u5165\u5bfc\u5165\u4efb\u52a1\u6570\u636e\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ImportTaskDataRspBO rspBO = new ImportTaskDataRspBO();
        try {
            ErrInfoRspBO data;
            Rsp rsp;
            if (StringUtils.isEmpty((Object)reqBO.getFilePath())) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (reqBO.getIsBind() == null) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u662f\u5426\u7ed1\u5b9a\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (reqBO.getFileName() == null) {
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
            Boolean isExport = this.checkPower(reqBO.getLoginInfo().getUserId(), tenantId);
            List networkNumberSegmentPOS = this.obNetworkNumberSegmentDAO.selectNetworkNumberAll();
            String filePath = reqBO.getFilePath();
            String fileName = reqBO.getFileName();
            String[] goodsHeaders = new String[]{"\u5730\u5e02", "\u5957\u9910", "\u54c1\u724c", "\u8bc1\u4ef6\u53f7", "\u7ea7\u522b", "\u8fd1\u4e09\u4e2a\u6708\u5e73\u5747\u6d41\u91cf\uff08M\uff09"};
            String dataId = "";
            ArrayList<String[]> csvList = new ArrayList<String[]>();
            HashMap map = new HashMap();
            int uploadIndex = filePath.indexOf("/upload");
            int fen = filePath.lastIndexOf("/");
            String newPath = filePath.substring(uploadIndex, fen + 1);
            log.info("\u622a\u53d6\u8def\u5f84={}", (Object)newPath);
            String homeDir = this.ftpConfigBean.getHomeDir();
            log.info("\u670d\u52a1\u5668\u6587\u4ef6\u8def\u5f84={}", (Object)homeDir);
            int of = homeDir.indexOf("/upload");
            String sp = homeDir.substring(0, of);
            String s1 = sp + newPath;
            log.info("\u62fc\u63a5\u540e\u8def\u5f84\uff1a{}", (Object)s1);
            OcsDownLoadReqBO downLoadReqBO = new OcsDownLoadReqBO();
            downLoadReqBO.setDirectory(s1);
            downLoadReqBO.setDownloadFile(fileName);
            log.info("\u83b7\u53d6\u6587\u4ef6\u5230\u672c\u5730\u5165\u53c2={}", (Object)JSON.toJSONString((Object)downLoadReqBO));
            Rsp rsp1 = this.ocsFileService.ocsDownLoad(downLoadReqBO);
            log.info("\u83b7\u53d6\u6587\u4ef6\u5230\u672c\u5730\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)rsp1));
            if (null != rsp1) {
                String rspCode = rsp1.getRspCode();
                OcsDownLoadRspBO data2 = (OcsDownLoadRspBO)rsp1.getData();
                if ("0000".equals(rspCode) && null != data2) {
                    filePath = data2.getFilePath();
                }
            }
            log.info("\u672c\u5730\u6587\u4ef6\u8def\u5f84={}", (Object)filePath);
            String tenantOtherName = null;
            BladeTenantBO tenantInfo = this.getTenantInfo(reqBO.getTenantCode());
            if (null != tenantInfo) {
                tenantOtherName = tenantInfo.getTenantOtherName();
            }
            String taskId = reqBO.getTaskId();
            MD5CheckUtils md5CheckUtils = new MD5CheckUtils();
            String fileMD5String = md5CheckUtils.getFileMD5String(new FileInputStream(new File(filePath)));
            log.info("\u6587\u4ef6MD5\u6807\u7b7e={}", (Object)fileMD5String);
            List dataTargetPOS = this.obDataTargetDAO.selectByChannelCode(tenantOtherName, fileMD5String, taskId);
            if (null != dataTargetPOS && dataTargetPOS.size() > 0) {
                log.info("\u6587\u4ef6\u6807\u7b7e\u5df2\u5b58\u5728\uff0c\u91cd\u590d\u63d0\u4ea4\uff01");
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4\uff01");
                return rspBO;
            }
            String batchId = UUID.randomUUID().toString().trim().replaceAll("-", "");
            String substring = filePath.substring(filePath.indexOf(".") + 1);
            log.info("\u6587\u4ef6\u683c\u5f0f\u4e3a{}", (Object)substring);
            if ("xlsx".equals(substring) || "xls".equals(substring)) {
                log.info("\u5f00\u59cb\u89e3\u6790xlsx\u6587\u4ef6");
                Rsp rsp2 = this.importDataByXLS(tenantOtherName, filePath, reqBO.getTenantCode(), batchId, taskId, reqBO.getForecast(), reqBO.getIsBind(), fileMD5String, networkNumberSegmentPOS, isExport);
                if (rsp2 != null) {
                    rspBO.setRspCode(rsp2.getRspCode());
                    rspBO.setRspDesc(rsp2.getRspDesc());
                    rspBO.setData(rsp2.getData());
                    return rspBO;
                }
            }
            ObDataTargetPO suPO = new ObDataTargetPO();
            suPO.setTenantOtherName(tenantOtherName);
            suPO.setTenantId(reqBO.getTenantCode());
            suPO.setTaskId(taskId);
            List alreadyExistTaskData = this.obDataTargetDAO.selectByTaskId(suPO);
            CsvReader reader = new CsvReader(filePath, ',', Charset.forName("GBK"));
            while (reader.readRecord()) {
                csvList.add(reader.getValues());
            }
            reader.close();
            String[] strings = (String[])csvList.get(0);
            List<String> heards = Arrays.asList(strings);
            int badNUm = 0;
            int sum = 0;
            ArrayList<ImportTaskDataErrorInfoBO> errList = new ArrayList<ImportTaskDataErrorInfoBO>();
            ArrayList<String> successPhone = new ArrayList<String>();
            successPhone.add("123");
            for (int row = 1; row < csvList.size(); ++row) {
                sum = csvList.size() - 1;
                ArrayList<DataTypePo> typeList = new ArrayList<DataTypePo>();
                dataId = TaskInfoUtil.get16UUID();
                StringBuffer buffer = new StringBuffer();
                TaskDataTargetBO targetBO = new TaskDataTargetBO();
                String phone = ((String[])csvList.get(row))[0];
                boolean b = this.isPhone(phone);
                Boolean aBoolean = this.checkPhone(phone, networkNumberSegmentPOS);
                if (!b || !isExport.booleanValue() && !aBoolean.booleanValue()) {
                    ImportTaskDataErrorInfoBO errorInfoBO = new ImportTaskDataErrorInfoBO();
                    errorInfoBO.setPhone(phone);
                    errorInfoBO.setActivity(((String[])csvList.get(row))[1]);
                    errorInfoBO.setManagerAccount(((String[])csvList.get(row))[2]);
                    errorInfoBO.setCity(((String[])csvList.get(row))[3]);
                    errorInfoBO.setMeal(((String[])csvList.get(row))[4]);
                    errorInfoBO.setBrand(((String[])csvList.get(row))[5]);
                    errorInfoBO.setIdNumber(((String[])csvList.get(row))[6]);
                    errorInfoBO.setLeavel(((String[])csvList.get(row))[7]);
                    errorInfoBO.setThreeMouthFlow(((String[])csvList.get(row))[8]);
                    if (!b) {
                        errorInfoBO.setErrorReason("\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
                    }
                    if (!isExport.booleanValue() && !aBoolean.booleanValue()) {
                        errorInfoBO.setErrorReason("\u4e0d\u53ef\u5bfc\u5165\u672c\u7f51\u53f7\u7801");
                    }
                    errList.add(errorInfoBO);
                    ++badNUm;
                    continue;
                }
                QuerySpecialPhoneOutBo req = new QuerySpecialPhoneOutBo();
                req.setTenantCode(reqBO.getTenantCode());
                QuerySpecialPhoneReqBo rb = new QuerySpecialPhoneReqBo();
                rb.setPhoneNo(phone);
                req.setReqData(rb);
                RspList rspList = this.specialPhoneInterService.exposeQrySpecialPhone(phone);
                log.info("\u8c03\u7528\u914d\u7f6e\u4e2d\u5fc3\u63a5\u53e3\u67e5\u8be2\u662f\u5426\u9ed1\u540d\u5355\u7ed3\u679c\uff1b{}", (Object)JSON.toJSONString((Object)rspList));
                if (null != rspList && rspList.getCount() > 0L) {
                    ImportTaskDataErrorInfoBO errorInfoBO = new ImportTaskDataErrorInfoBO();
                    errorInfoBO.setPhone(phone);
                    errorInfoBO.setActivity(((String[])csvList.get(row))[1]);
                    errorInfoBO.setManagerAccount(((String[])csvList.get(row))[2]);
                    errorInfoBO.setCity(((String[])csvList.get(row))[3]);
                    errorInfoBO.setMeal(((String[])csvList.get(row))[4]);
                    errorInfoBO.setBrand(((String[])csvList.get(row))[5]);
                    errorInfoBO.setIdNumber(((String[])csvList.get(row))[6]);
                    errorInfoBO.setLeavel(((String[])csvList.get(row))[7]);
                    errorInfoBO.setThreeMouthFlow(((String[])csvList.get(row))[8]);
                    errorInfoBO.setErrorReason("\u53f7\u7801\u5df2\u88ab\u52a0\u5165\u9ed1\u540d\u5355");
                    errList.add(errorInfoBO);
                    ++badNUm;
                    continue;
                }
                boolean isExist = successPhone.stream().anyMatch(e -> e.equals(phone));
                if (isExist) {
                    ImportTaskDataErrorInfoBO errorInfoBO = new ImportTaskDataErrorInfoBO();
                    errorInfoBO.setPhone(phone);
                    errorInfoBO.setActivity(((String[])csvList.get(row))[1]);
                    errorInfoBO.setManagerAccount(((String[])csvList.get(row))[2]);
                    errorInfoBO.setCity(((String[])csvList.get(row))[3]);
                    errorInfoBO.setMeal(((String[])csvList.get(row))[4]);
                    errorInfoBO.setBrand(((String[])csvList.get(row))[5]);
                    errorInfoBO.setIdNumber(((String[])csvList.get(row))[6]);
                    errorInfoBO.setLeavel(((String[])csvList.get(row))[7]);
                    errorInfoBO.setThreeMouthFlow(((String[])csvList.get(row))[8]);
                    errorInfoBO.setErrorReason("\u8be5\u53f7\u7801\u91cd\u590d\uff0c\u4e0d\u4e88\u5bfc\u5165");
                    errList.add(errorInfoBO);
                    ++badNUm;
                    continue;
                }
                boolean isEx = false;
                if (alreadyExistTaskData != null && alreadyExistTaskData.size() > 0) {
                    isEx = alreadyExistTaskData.stream().anyMatch(ObDataTargetPO2 -> ObDataTargetPO2.getMobileNo().equals(phone));
                }
                if (isEx) {
                    ImportTaskDataErrorInfoBO errorInfoBO = new ImportTaskDataErrorInfoBO();
                    errorInfoBO.setPhone(phone);
                    errorInfoBO.setActivity(((String[])csvList.get(row))[1]);
                    errorInfoBO.setManagerAccount(((String[])csvList.get(row))[2]);
                    errorInfoBO.setCity(((String[])csvList.get(row))[3]);
                    errorInfoBO.setMeal(((String[])csvList.get(row))[4]);
                    errorInfoBO.setBrand(((String[])csvList.get(row))[5]);
                    errorInfoBO.setIdNumber(((String[])csvList.get(row))[6]);
                    errorInfoBO.setLeavel(((String[])csvList.get(row))[7]);
                    errorInfoBO.setThreeMouthFlow(((String[])csvList.get(row))[8]);
                    errorInfoBO.setErrorReason("\u8be5\u53f7\u7801\u5df2\u5728\u4efb\u52a1\u6570\u636e\u4e2d\u5b58\u5728\uff0c\u4e0d\u4e88\u5bfc\u5165");
                    errList.add(errorInfoBO);
                    ++badNUm;
                    continue;
                }
                String encryptMobileNo = phone.replaceAll("(\\w{3})\\w*(\\w{4})", "$1****$2");
                targetBO.setEncryptMobileNo(encryptMobileNo);
                targetBO.setMobileNo(phone);
                targetBO.setActivityCode(((String[])csvList.get(row))[1]);
                targetBO.setCustom1(((String[])csvList.get(row))[2]);
                targetBO.setCity(((String[])csvList.get(row))[3]);
                targetBO.setDataStatus(DATA_STATUS_WAITING);
                targetBO.setImportTime(new Date());
                targetBO.setTaskId(reqBO.getTaskId());
                targetBO.setForecast(reqBO.getForecast());
                targetBO.setDataSource("import");
                targetBO.setVersion(TaskConstant.DATA_VERSION_0);
                targetBO.setTenantId(reqBO.getTenantCode());
                targetBO.setBatch(batchId);
                targetBO.setIsBind(reqBO.getIsBind());
                targetBO.setDataId(dataId);
                targetBO.setChannelCode(fileMD5String);
                try {
                    Rsp rsp3 = this.addTaskDataTarget(targetBO);
                    if (!rsp3.getRspCode().equals("0000")) {
                        ++badNUm;
                    }
                    for (int i = 3; i < ((String[])csvList.get(row)).length; ++i) {
                        DataTypePo dataTypePo = new DataTypePo();
                        dataTypePo.setName(heards.get(i));
                        dataTypePo.setValue(((String[])csvList.get(row))[i]);
                        typeList.add(dataTypePo);
                    }
                    String jsonString = JSON.toJSONString(typeList);
                    ObDataCustomerPO ob = new ObDataCustomerPO();
                    ob.setTenantId(reqBO.getTenantCode());
                    ob.setDataId(dataId);
                    ob.setAttribute(jsonString);
                    ob.setTenantOtherName(tenantOtherName);
                    int i = this.ObDataCustomerPOMapper.insertSelective(ob);
                    if (i <= 0) continue;
                    log.info("\u5bfc\u5165\u5173\u8054\u5c5e\u6027\u8868\u6210\u529f");
                    successPhone.add(phone);
                    continue;
                }
                catch (Exception e2) {
                    ++badNUm;
                    e2.printStackTrace();
                    throw new RuntimeException();
                }
            }
            ErrInfoRspBO errInfoRspBO = new ErrInfoRspBO();
            if (null != errList && errList.size() > 0 && (rsp = this.exportTaskErrorData(errList)).getRspCode().equals("0000") && rsp.getData() != null && null != (data = (ErrInfoRspBO)rsp.getData())) {
                errInfoRspBO.setFileName(data.getFileName());
                errInfoRspBO.setFilePath(data.getFilePath());
            }
            rspBO.setRspCode("0000");
            rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff0c\u6210\u529f\u5bfc\u5165" + (sum - badNUm) + "\u6761\u6570\u636e, \u5931\u8d25" + badNUm + "\u6761\uff0c\u603b\u6570" + sum + "\u6761");
            try {
                ObTaskInfoPO taskInfoPO = new ObTaskInfoPO();
                taskInfoPO.setTaskId(taskId);
                taskInfoPO.setDataNumber(Long.valueOf(sum - badNUm));
                this.obTaskInfoDAO.updateTaskNumber(taskInfoPO);
                rspBO.setData((Object)errInfoRspBO);
            }
            catch (Exception e3) {
                log.info(e3.getMessage(), (Throwable)e3);
            }
        }
        catch (Exception e3) {
            log.error("\u5bfc\u5165\u5931\u8d25\uff1a{}", (Object)e3.getMessage(), (Object)e3);
        }
        return rspBO;
    }

    public Rsp addTaskDataTarget(TaskDataTargetBO taskDataTargetBO) {
        log.info("\u8fdb\u5165\u65b0\u589e\u4efb\u52a1\u6570\u636e\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)taskDataTargetBO));
        if (StringUtils.isEmpty((Object)taskDataTargetBO.getEncryptMobileNo())) {
            log.error("\u8131\u654f\u53f7\u7801\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u8131\u654f\u53f7\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)taskDataTargetBO.getMobileNo())) {
            log.error("\u539f\u59cb\u53f7\u7801\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u539f\u59cb\u53f7\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)taskDataTargetBO.getDataStatus())) {
            log.error("\u6570\u636e\u72b6\u6001\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u6570\u636e\u72b6\u6001\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)taskDataTargetBO.getBatch())) {
            log.error("\u6279\u6b21\u53f7\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u6279\u6b21\u53f7\u4e3a\u7a7a");
        }
        if (taskDataTargetBO.getIsBind() == null) {
            log.error("\u6807\u8bc6\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u6807\u8bc6\u4e3a\u7a7a");
        }
        if (taskDataTargetBO.getIsBind() == 0 && StringUtils.isEmpty((Object)taskDataTargetBO.getTaskId())) {
            log.error("\u4efb\u52a1ID\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1ID\u4e3a\u7a7a");
        }
        ObDataTargetPO obDataTargetPO = new ObDataTargetPO();
        BeanUtils.copyProperties((Object)taskDataTargetBO, (Object)obDataTargetPO);
        obDataTargetPO.setDataId(taskDataTargetBO.getDataId());
        BladeTenantBO tenantInfo = this.getTenantInfo(taskDataTargetBO.getTenantId());
        if (tenantInfo == null) {
            return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u9519\u8bef");
        }
        obDataTargetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        int insertNum = this.obDataTargetDAO.insertSelective(obDataTargetPO);
        if (insertNum == 0) {
            log.error("\u65b0\u589e\u5931\u8d25");
            return BaseRspUtils.createErrorRsp((String)"\u65b0\u589e\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public RspList<QueryTaskDataTargetRspBO> queryTaskDataTarget(QueryTaskDataTargetReqBO reqBO) {
        PageInfo pageInfo;
        log.info("\u8fdb\u5165\u67e5\u8be2\u4efb\u52a1\u6570\u636e\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ArrayList<QueryTaskDataTargetRspBO> rspBOS = new ArrayList<QueryTaskDataTargetRspBO>();
        try {
            String tenantCode = reqBO.getTenantCode();
            if (!StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                tenantCode = reqBO.getTenantId();
            }
            if (StringUtils.isEmpty((Object)tenantCode)) {
                return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                return BaseRspUtils.createErrorRspList((String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ObDataTargetPO obDataTargetPO = new ObDataTargetPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)obDataTargetPO);
            if (StringUtils.isEmpty((Object)reqBO.getImportEndTime()) && StringUtils.isEmpty((Object)reqBO.getImportStartTime())) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    obDataTargetPO.setStartTime(format.format(calendar.getTime()));
                    calendar.add(6, 1);
                    obDataTargetPO.setEndTime(format.format(calendar.getTime()));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                obDataTargetPO.setStartTime(reqBO.getImportStartTime());
                obDataTargetPO.setEndTime(reqBO.getImportEndTime());
            }
            obDataTargetPO.setTenantId(tenantCode);
            obDataTargetPO.setIsBind(reqBO.getIsBind());
            obDataTargetPO.setTaskId(reqBO.getTaskId());
            BladeTenantBO tenantInfo = this.getTenantInfo(tenantCode);
            log.info("tenantInfo:{}", (Object)JSONObject.toJSONString((Object)tenantInfo));
            if (tenantInfo == null) {
                return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u9519\u8bef");
            }
            obDataTargetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
            log.info("\u67e5\u8be2\u4efb\u52a1\u6570\u636eMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obDataTargetPO));
            PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
            List dataTarget10010kfPOS = this.obDataTargetDAO.selectTaskData(obDataTargetPO);
            pageInfo = new PageInfo(dataTarget10010kfPOS);
            if (dataTarget10010kfPOS != null && dataTarget10010kfPOS.size() > 0) {
                for (ObDataTargetPO po : dataTarget10010kfPOS) {
                    QueryTaskDataTargetRspBO rspBO = new QueryTaskDataTargetRspBO();
                    BeanUtils.copyProperties((Object)po, (Object)rspBO);
                    if (po.getCallNum() == null) {
                        rspBO.setCallNum(Integer.valueOf(0));
                    }
                    rspBOS.add(rspBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)pageInfo.getTotal());
    }

    public Rsp updateTaskDataTarget(UpdateTaskDataTargetReqBO reqBO) {
        log.info("\u8fdb\u5165\u7ed1\u5b9a/\u89e3\u7ed1\u4efb\u52a1\u6570\u636e\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        try {
            if (reqBO == null) {
                log.error("\u5165\u53c2\u9519\u8bef");
                return BaseRspUtils.createErrorRsp((String)"\u5165\u53c2\u9519\u8bef");
            }
            if (reqBO.getIsBind() == null) {
                log.error("\u662f\u5426\u7ed1\u5b9a\u6807\u8bc6\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"\u662f\u5426\u7ed1\u5b9a\u6807\u8bc6\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getTenantCode())) {
                log.error("\u79df\u6237\u7f16\u7801\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                log.error("\u4efb\u52a1ID\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1ID\u4e3a\u7a7a");
            }
            BladeTenantBO tenantInfo = this.getTenantInfo(StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode());
            if (tenantInfo == null) {
                return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u9519\u8bef");
            }
            ObDataTargetPO dataTargetPO = new ObDataTargetPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)dataTargetPO);
            dataTargetPO.setStartTime(reqBO.getImportStartTime());
            dataTargetPO.setEndTime(reqBO.getImportEndTime());
            dataTargetPO.setTenantId(StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode());
            dataTargetPO.setIsBind(reqBO.getQryIsBand());
            dataTargetPO.setTaskId(reqBO.getTaskId());
            dataTargetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
            log.info("\u83b7\u53d6\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636eID\u96c6\u5408Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dataTargetPO));
            List dataIds = this.obDataTargetDAO.selectTaskDataIds(dataTargetPO);
            log.info("\u83b7\u53d6\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636eID\u96c6\u5408Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dataIds));
            if (dataIds == null || dataIds.size() == 0) {
                log.info("\u672a\u67e5\u8be2\u5230\u6709\u6548\u6570\u636e");
                return BaseRspUtils.createSuccessRsp((Object)"");
            }
            if (reqBO.getIsBind() == TaskConstant.IS_BIND_1) {
                ObTaskAllotPO obTaskAllotPO = new ObTaskAllotPO();
                obTaskAllotPO.setDataIds(dataIds);
                obTaskAllotPO.setTaskId(reqBO.getTaskId());
                log.info("\u6839\u636e\u6570\u636eId\u96c6\u5408\u67e5\u8be2Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskAllotPO));
                List allotPOS = this.obTaskAllotDAO.selectByDataIds(obTaskAllotPO);
                log.info("\u6839\u636e\u6570\u636eId\u96c6\u5408\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)allotPOS));
                if (allotPOS != null && allotPOS.size() > 0) {
                    return BaseRspUtils.createErrorRsp((String)"\u8bf7\u5148\u56de\u6536\u5df2\u5206\u914d\u7684\u6570\u636e\u518d\u8fdb\u884c\u89e3\u7ed1\u64cd\u4f5c\uff01");
                }
            }
            ObDataTargetPO obDataTargetPO = new ObDataTargetPO();
            obDataTargetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
            obDataTargetPO.setTaskId(reqBO.getTaskId());
            obDataTargetPO.setTenantId(reqBO.getTenantCode());
            obDataTargetPO.setIsBind(reqBO.getIsBind());
            obDataTargetPO.setDataIds(dataIds);
            log.info("\u7ed1\u5b9a/\u89e3\u7ed1\u4efb\u52a1\u6570\u636eMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obDataTargetPO));
            int updNum = this.obDataTargetDAO.updateByDataIds(obDataTargetPO);
            if (updNum == 0) {
                return BaseRspUtils.createErrorRsp((String)"\u4fee\u6539\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    private List<String> getDataIds(UpdateTaskDataTargetReqBO reqBO) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u7b26\u5408\u6761\u4ef6\u5f97\u6570\u636e\u4e3b\u952e\uff0cReqBO\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ArrayList<String> dataIds = new ArrayList<String>();
        QueryTaskDataTargetReqBO qryReqBO = new QueryTaskDataTargetReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryReqBO);
        qryReqBO.setIsBind(reqBO.getQryIsBand());
        RspList<QueryTaskDataTargetRspBO> rsp = this.queryTaskDataTarget(qryReqBO);
        if (!rsp.getRspCode().equals("0000")) {
            log.error("\u67e5\u8be2\u5931\u8d25:{}", (Object)rsp.getRspDesc());
            return dataIds;
        }
        int pageCount = (int)rsp.getCount();
        if (pageCount == 0) {
            log.info("\u672a\u67e5\u8be2\u5230\u6709\u6548\u6570\u636e");
            return dataIds;
        }
        int pageNumber = (pageCount - 1) / reqBO.getLimit() + 1;
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList<QueryTaskDataTargetRspBO> rspBO = this.queryTaskDataTarget(qryReqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rspBO.getRows()) == null || rows.size() <= 0) continue;
            for (QueryTaskDataTargetRspBO bo : rows) {
                dataIds.add(bo.getDataId());
            }
        }
        return dataIds;
    }

    public boolean isPhone(String phone) {
        log.info("\u6821\u9a8c\u53f7\u7801\u683c\u5f0f\u5165\u53c2={}", (Object)phone);
        if (null == phone) {
            return false;
        }
        Pattern p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$");
        Matcher m = p.matcher(phone);
        boolean b = m.matches();
        log.info("\u6821\u9a8c\u7ed3\u679c\uff1b{}", (Object)b);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp exportTaskErrorData(List<ImportTaskDataErrorInfoBO> errorInfoBOList) {
        ErrInfoRspBO errInfoRspBO = new ErrInfoRspBO();
        log.info("\u5bfc\u51fa\u4efb\u52a1\u6570\u636e\u9519\u8bef\u4fe1\u606f\u5165\u53c2={}", (Object)JSON.toJSONString(errorInfoBOList));
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("sheet1");
        XSSFRow headRow = sheet.createRow(0);
        headRow.createCell(0).setCellValue("\u5ba2\u6237\u53f7\u7801");
        headRow.createCell(1).setCellValue("\u6d3b\u52a8");
        headRow.createCell(2).setCellValue("\u7ecf\u7406\u8d26\u53f7");
        headRow.createCell(3).setCellValue("\u5730\u5e02");
        headRow.createCell(4).setCellValue("\u5957\u9910");
        headRow.createCell(5).setCellValue("\u54c1\u724c");
        headRow.createCell(6).setCellValue("\u8bc1\u4ef6\u53f7");
        headRow.createCell(7).setCellValue("\u7ea7\u522b");
        headRow.createCell(8).setCellValue("\u8fdb\u4e09\u4e2a\u6708\u5e73\u5747\u6d41\u91cf(M)");
        headRow.createCell(9).setCellValue("\u5931\u8d25\u539f\u56e0");
        headRow.setHeightInPoints(30.0f);
        for (int i = 0; i < errorInfoBOList.size(); ++i) {
            ImportTaskDataErrorInfoBO infoBO = errorInfoBOList.get(i);
            XSSFRow dataRow = sheet.createRow(i + 1);
            dataRow.createCell(0).setCellValue(infoBO.getPhone());
            dataRow.createCell(1).setCellValue(infoBO.getActivity());
            dataRow.createCell(2).setCellValue(infoBO.getManagerAccount());
            dataRow.createCell(3).setCellValue(infoBO.getCity());
            dataRow.createCell(4).setCellValue(infoBO.getMeal());
            dataRow.createCell(5).setCellValue(infoBO.getBrand());
            dataRow.createCell(6).setCellValue(infoBO.getIdNumber());
            dataRow.createCell(7).setCellValue(infoBO.getLeavel());
            dataRow.createCell(8).setCellValue(infoBO.getThreeMouthFlow());
            dataRow.createCell(9).setCellValue(infoBO.getErrorReason());
        }
        Object data = null;
        FileOutputStream fos = null;
        File file = null;
        String fileName = "\u4efb\u52a1\u6570\u636e\u5931\u8d25\u539f\u56e0-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xlsx";
        try {
            String path = System.getProperty("java.io.tmpdir") + File.separator;
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdir();
            }
            String filePath = path + File.separator + fileName;
            file = new File(filePath);
            log.debug("filePath={}", (Object)filePath);
            fos = new FileOutputStream(file);
            workbook.write((OutputStream)fos);
            workbook.close();
            OcsUploadReqBO upLoadReqBO = new OcsUploadReqBO();
            upLoadReqBO.setUploadFileName(fileName);
            upLoadReqBO.setUploadPath(filePath);
            log.info("\u8c03\u7528\u4e0a\u4f20\u63a5\u53e3\u5165\u53c2={}", (Object)JSON.toJSONString((Object)upLoadReqBO));
            OcsUploadRspBO uploadRspBO = this.ocsFileService.ocsUpload(upLoadReqBO);
            log.info("\u8c03\u7528\u4e0a\u4f20\u63a5\u53e3\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)uploadRspBO));
            if (null != uploadRspBO) {
                String uploadRspBOFileName = uploadRspBO.getFileName();
                String uploadRspBOFilePath = uploadRspBO.getFilePath();
                if (!StringUtils.isEmpty((Object)uploadRspBOFilePath)) {
                    errInfoRspBO.setFilePath(uploadRspBOFilePath);
                }
                if (!StringUtils.isEmpty((Object)uploadRspBOFileName)) {
                    errInfoRspBO.setFileName(uploadRspBOFileName);
                }
            }
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)errInfoRspBO, (String)"\u5bfc\u51fa\u4efb\u52a1\u9519\u8bef\u4fe1\u606f\u6210\u529f");
    }

    public Rsp getAllotDataCount(QueryTaskDataTargetReqBO reqBO) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u53ef\u5206\u914d\u4efb\u52a1\u6570\u636e\u6570\u91cf\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        String tenantCode = reqBO.getTenantCode();
        if (StringUtils.isEmpty((Object)tenantCode)) {
            if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            tenantCode = reqBO.getTenantId();
        }
        reqBO.setTenantId(tenantCode);
        reqBO.setTaskId(reqBO.getTaskId());
        reqBO.setIsBind(TaskConstant.IS_BIND_0);
        RspList<QueryTaskDataTargetRspBO> rspList = this.queryTaskDataTarget(reqBO);
        if (!rspList.getRspCode().equals("0000")) {
            return BaseRspUtils.createErrorRsp((String)rspList.getRspDesc());
        }
        int pageCount = (int)rspList.getCount();
        if (pageCount == 0) {
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u83b7\u53d6\u5230\u4efb\u52a1\u6570\u636e\u6570\u636e");
        }
        int pageNumber = (pageCount - 1) / reqBO.getLimit() + 1;
        ArrayList dataTargetBOS = new ArrayList();
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList<QueryTaskDataTargetRspBO> rsp = this.queryTaskDataTarget(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
            dataTargetBOS.addAll(rows);
        }
        Integer allotCount = 0;
        if (dataTargetBOS != null && dataTargetBOS.size() > 0) {
            allotCount = (int)dataTargetBOS.stream().filter(row -> DATA_STATUS_WAITING.equals(row.getDataStatus()) || "issued".equals(row.getDataStatus())).count();
        }
        return BaseRspUtils.createSuccessRsp((Object)allotCount);
    }

    public List<TaskDataTargetBO> qryTaskDataByTaskId(String taskID, String tenantId, String tenantSortCode) {
        if (StringUtils.isEmpty((Object)tenantSortCode)) {
            BladeTenantBO bladeTenant = this.getTenantInfo(tenantId);
            tenantSortCode = bladeTenant.getTenantOtherName();
        }
        List datas = this.obDataTargetDAO.qryAssignedTaskDataByTaskId(taskID, tenantId, tenantSortCode);
        ArrayList<TaskDataTargetBO> dataTargetList = new ArrayList<TaskDataTargetBO>();
        for (ObDataTargetPO data : datas) {
            TaskDataTargetBO targetBO = new TaskDataTargetBO();
            BeanUtils.copyProperties((Object)data, (Object)targetBO);
            dataTargetList.add(targetBO);
        }
        return dataTargetList;
    }

    public void updateDataStatus(List<TaskDataTargetBO> targetList, String tenantOtherName, String newDataStatus) {
        if (targetList == null || StringUtils.isEmpty((Object)tenantOtherName) || StringUtils.isEmpty((Object)newDataStatus)) {
            return;
        }
        for (TaskDataTargetBO target : targetList) {
            this.obDataTargetDAO.updateDateStautsById(tenantOtherName, newDataStatus, target.getDataId());
        }
    }

    public Rsp updatePhoneStatus(UpdatePhoneStatusReqBO reqBO) {
        log.info("\u66f4\u65b0\u4efb\u52a1\u6570\u636e\u53f7\u7801\u72b6\u6001\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        if (null == reqBO.getVersion()) {
            log.info("\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getDataId())) {
            log.info("dataId\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"dataId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getStatus())) {
            log.info("status\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"status\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            log.info("taskId\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"taskId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTenantCode())) {
            log.info("tenantCode\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"tenantCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BladeTenantBO tenantInfo = this.getTenantInfo(reqBO.getTenantCode());
        if (null == tenantInfo) {
            log.info("\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
        }
        ObDataTargetPO targetPO = new ObDataTargetPO();
        targetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        targetPO.setTenantId(reqBO.getTenantCode());
        targetPO.setDataId(reqBO.getDataId());
        log.info("\u6839\u636edataId\u67e5\u8be2\u4efb\u52a1\u6570\u636emapper\u5c42\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)targetPO));
        ObDataTargetPO byDataId = this.obDataTargetDAO.selectByDataId(targetPO);
        log.info("\u6839\u636edataId\u67e5\u8be2\u4efb\u52a1\u6570\u636emapper\u5c42\u51fa\u53c2={}", (Object)JSONObject.toJSONString((Object)byDataId));
        if (null != byDataId && byDataId.getVersion() == reqBO.getVersion()) {
            targetPO.setVersion(Integer.valueOf(byDataId.getVersion() + 1));
            targetPO.setDataStatus(reqBO.getStatus());
            int update = this.obDataTargetDAO.updateByPrimaryKeySelective(targetPO);
            if (update > 0) {
                return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
            }
        }
        return BaseRspUtils.createErrorRsp((String)"\u5931\u8d25");
    }

    public void addTaskData(List<TaskDataTargetBO> targets) {
        if (null == targets || targets.isEmpty()) {
            return;
        }
        log.info("\u8fdb\u5165\u65b0\u589e\u4efb\u52a1\u6570\u636e\u63a5\u53e3\uff0c \u5f85\u5165\u5e93\u6570\u636e\u6570\uff1a{}", (Object)targets.size());
        String taskId = "";
        for (TaskDataTargetBO bo : targets) {
            if (StringUtils.isEmpty((Object)taskId)) {
                taskId = bo.getTaskId();
            }
            ObDataTargetPO obDataTargetPO = new ObDataTargetPO();
            BeanUtils.copyProperties((Object)bo, (Object)obDataTargetPO);
            obDataTargetPO.setDataId(bo.getDataId());
            obDataTargetPO.setTenantOtherName(bo.getTenantOtherName());
            this.obDataTargetDAO.insertSelective(obDataTargetPO);
            String tableName = LocalCache.getUserProductPolicyTableNameByModelNO(bo.getMobileNo());
            UserProductPolicyPO userProductPolicy = new UserProductPolicyPO();
            userProductPolicy.setMobileNo(bo.getMobileNo());
            userProductPolicy.setTaskId(bo.getTaskId());
            userProductPolicy.setTableName(tableName);
            userProductPolicy.setTenantSortCode(bo.getTenantOtherName());
            userProductPolicy.setTenantId(bo.getTenantId());
            try {
                userProductPolicy.setPriority(Integer.valueOf(bo.getProvince()));
            }
            catch (Exception e) {
                userProductPolicy.setPriority(Integer.valueOf(0));
            }
            userProductPolicy.setDataId(bo.getDataId());
            userProductPolicy.setDataEndTime(bo.getEndTime());
            userProductPolicy.setDataStartTime(bo.getStartTime());
            userProductPolicy.setProductName(bo.getProductName());
            userProductPolicy.setProductId(bo.getProduct());
            this.userProductPolicyDAO.insertSelective(userProductPolicy);
        }
        ObTaskInfoPO taskInfoPO = new ObTaskInfoPO();
        taskInfoPO.setTaskId(taskId);
        taskInfoPO.setDataNumber(Long.valueOf(targets.size()));
        this.obTaskInfoDAO.updateTaskNumber(taskInfoPO);
    }

    public BladeTenantBO getTenantInfo(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }

    public Rsp importDataByXLS(String tenantOtherName, String filePath, String tenantCode, String batchId, String taskId, String foreCast, Integer isBind, String fileMD5String, List<ObNetworkNumberSegmentPO> networkNumberSegmentPOS, Boolean isExport) {
        XSSFWorkbook workbook = null;
        try {
            ErrInfoRspBO data;
            Rsp rsp;
            File file = new File(filePath);
            FileInputStream fileInputStream = new FileInputStream(file);
            if (file.getName().endsWith("xlsx")) {
                workbook = new XSSFWorkbook((InputStream)fileInputStream);
            } else if (file.getName().endsWith("xls")) {
                workbook = new HSSFWorkbook((InputStream)fileInputStream);
            }
            Sheet sheetAt = workbook.getSheetAt(0);
            int ofRows = sheetAt.getPhysicalNumberOfRows();
            Row heads = sheetAt.getRow(0);
            ArrayList<ImportTaskDataErrorInfoBO> errList = new ArrayList<ImportTaskDataErrorInfoBO>();
            int badNUm = 0;
            int sum = ofRows - 1;
            ArrayList<String> successPhone = new ArrayList<String>();
            successPhone.add("123");
            String dataId = "";
            ObDataTargetPO suPO = new ObDataTargetPO();
            suPO.setTenantOtherName(tenantOtherName);
            suPO.setTenantId(tenantCode);
            suPO.setTaskId(taskId);
            List alreadyExistTaskData = this.obDataTargetDAO.selectByTaskId(suPO);
            for (int i = 1; i < ofRows; ++i) {
                ArrayList<DataTypePo> typeList = new ArrayList<DataTypePo>();
                dataId = TaskInfoUtil.get16UUID();
                Row row = sheetAt.getRow(i);
                if (null == row.getCell(0)) {
                    ImportTaskDataErrorInfoBO errorInfoBO = new ImportTaskDataErrorInfoBO();
                    errorInfoBO.setActivity(this.cellSwitchOfString(row.getCell(1)));
                    errorInfoBO.setManagerAccount(this.cellSwitchOfString(row.getCell(2)));
                    errorInfoBO.setCity(this.cellSwitchOfString(row.getCell(3)));
                    errorInfoBO.setMeal(this.cellSwitchOfString(row.getCell(4)));
                    errorInfoBO.setBrand(this.cellSwitchOfString(row.getCell(5)));
                    errorInfoBO.setIdNumber(this.cellSwitchOfString(row.getCell(6)));
                    errorInfoBO.setLeavel(this.cellSwitchOfString(row.getCell(7)));
                    errorInfoBO.setThreeMouthFlow(this.cellSwitchOfString(row.getCell(8)));
                    errorInfoBO.setErrorReason("\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    errList.add(errorInfoBO);
                    ++badNUm;
                    continue;
                }
                String s = row.getCell(0).toString();
                String phone = new BigDecimal(s).toPlainString();
                log.info("\u53f7\u7801={}", (Object)phone);
                boolean b = this.isPhone(phone);
                Boolean aBoolean = this.checkPhone(phone, networkNumberSegmentPOS);
                if (!b || !isExport.booleanValue() && !aBoolean.booleanValue()) {
                    ImportTaskDataErrorInfoBO errorInfoBO = new ImportTaskDataErrorInfoBO();
                    errorInfoBO.setPhone(phone);
                    errorInfoBO.setActivity(this.cellSwitchOfString(row.getCell(1)));
                    errorInfoBO.setManagerAccount(this.cellSwitchOfString(row.getCell(2)));
                    errorInfoBO.setCity(this.cellSwitchOfString(row.getCell(3)));
                    errorInfoBO.setMeal(this.cellSwitchOfString(row.getCell(4)));
                    errorInfoBO.setBrand(this.cellSwitchOfString(row.getCell(5)));
                    errorInfoBO.setIdNumber(this.cellSwitchOfString(row.getCell(6)));
                    errorInfoBO.setLeavel(this.cellSwitchOfString(row.getCell(7)));
                    errorInfoBO.setThreeMouthFlow(this.cellSwitchOfString(row.getCell(8)));
                    if (!b) {
                        errorInfoBO.setErrorReason("\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
                    }
                    if (!isExport.booleanValue() && !aBoolean.booleanValue()) {
                        errorInfoBO.setErrorReason("\u4e0d\u53ef\u5bfc\u5165\u672c\u7f51\u53f7\u7801");
                    }
                    errList.add(errorInfoBO);
                    ++badNUm;
                    continue;
                }
                RspList rspList = this.specialPhoneInterService.exposeQrySpecialPhone(phone);
                log.info("\u67e5\u8be2\u662f\u5426\u662f\u9ed1\u540d\u5355\u51fa\u53c2={}", (Object)rspList);
                if (rspList != null && rspList.getCount() > 0L) {
                    ImportTaskDataErrorInfoBO errorInfoBO = new ImportTaskDataErrorInfoBO();
                    errorInfoBO.setPhone(phone);
                    errorInfoBO.setActivity(this.cellSwitchOfString(row.getCell(1)));
                    errorInfoBO.setManagerAccount(this.cellSwitchOfString(row.getCell(2)));
                    errorInfoBO.setCity(this.cellSwitchOfString(row.getCell(3)));
                    errorInfoBO.setMeal(this.cellSwitchOfString(row.getCell(4)));
                    errorInfoBO.setBrand(this.cellSwitchOfString(row.getCell(5)));
                    errorInfoBO.setIdNumber(this.cellSwitchOfString(row.getCell(6)));
                    errorInfoBO.setLeavel(this.cellSwitchOfString(row.getCell(7)));
                    errorInfoBO.setThreeMouthFlow(this.cellSwitchOfString(row.getCell(8)));
                    errorInfoBO.setErrorReason("\u8be5\u53f7\u7801\u5df2\u88ab\u52a0\u5165\u9ed1\u540d\u5355");
                    errList.add(errorInfoBO);
                    ++badNUm;
                    continue;
                }
                boolean isExist = successPhone.stream().anyMatch(e -> e.equals(phone));
                if (isExist) {
                    ImportTaskDataErrorInfoBO errorInfoBO = new ImportTaskDataErrorInfoBO();
                    errorInfoBO.setPhone(phone);
                    errorInfoBO.setActivity(this.cellSwitchOfString(row.getCell(1)));
                    errorInfoBO.setManagerAccount(this.cellSwitchOfString(row.getCell(2)));
                    errorInfoBO.setCity(this.cellSwitchOfString(row.getCell(3)));
                    errorInfoBO.setMeal(this.cellSwitchOfString(row.getCell(4)));
                    errorInfoBO.setBrand(this.cellSwitchOfString(row.getCell(5)));
                    errorInfoBO.setIdNumber(this.cellSwitchOfString(row.getCell(6)));
                    errorInfoBO.setLeavel(this.cellSwitchOfString(row.getCell(7)));
                    errorInfoBO.setThreeMouthFlow(this.cellSwitchOfString(row.getCell(8)));
                    errorInfoBO.setErrorReason("\u8be5\u53f7\u7801\u5728\u6279\u6b21\u91cd\u590d\u4e0d\u4e88\u5bfc\u5165");
                    errList.add(errorInfoBO);
                    ++badNUm;
                    continue;
                }
                boolean isEx = false;
                if (alreadyExistTaskData != null && alreadyExistTaskData.size() > 0) {
                    isEx = alreadyExistTaskData.stream().anyMatch(ObDataTargetPO2 -> ObDataTargetPO2.getMobileNo().equals(phone));
                }
                if (isEx) {
                    ImportTaskDataErrorInfoBO errorInfoBO = new ImportTaskDataErrorInfoBO();
                    errorInfoBO.setPhone(phone);
                    errorInfoBO.setActivity(this.cellSwitchOfString(row.getCell(1)));
                    errorInfoBO.setManagerAccount(this.cellSwitchOfString(row.getCell(2)));
                    errorInfoBO.setCity(this.cellSwitchOfString(row.getCell(3)));
                    errorInfoBO.setMeal(this.cellSwitchOfString(row.getCell(4)));
                    errorInfoBO.setBrand(this.cellSwitchOfString(row.getCell(5)));
                    errorInfoBO.setIdNumber(this.cellSwitchOfString(row.getCell(6)));
                    errorInfoBO.setLeavel(this.cellSwitchOfString(row.getCell(7)));
                    errorInfoBO.setThreeMouthFlow(this.cellSwitchOfString(row.getCell(8)));
                    errorInfoBO.setErrorReason("\u8be5\u53f7\u7801\u5df2\u5728\u4efb\u52a1\u6570\u636e\u4e2d\u5b58\u5728\uff0c\u4e0d\u4e88\u5bfc\u5165");
                    errList.add(errorInfoBO);
                    ++badNUm;
                    continue;
                }
                TaskDataTargetBO targetBO = new TaskDataTargetBO();
                String encryptMobileNo = phone.replaceAll("(\\w{3})\\w*(\\w{4})", "$1****$2");
                targetBO.setEncryptMobileNo(encryptMobileNo);
                targetBO.setMobileNo(phone);
                targetBO.setActivityCode(this.cellSwitchOfString(row.getCell(1)));
                targetBO.setCustom1(this.cellSwitchOfString(row.getCell(2)));
                targetBO.setCity(this.cellSwitchOfString(row.getCell(3)));
                targetBO.setDataStatus(DATA_STATUS_WAITING);
                targetBO.setImportTime(new Date());
                targetBO.setTaskId(taskId);
                targetBO.setForecast(foreCast);
                targetBO.setDataSource("import");
                targetBO.setVersion(TaskConstant.DATA_VERSION_0);
                targetBO.setTenantId(tenantCode);
                targetBO.setBatch(batchId);
                targetBO.setIsBind(isBind);
                targetBO.setDataId(dataId);
                targetBO.setChannelCode(fileMD5String);
                try {
                    Rsp rsp2 = this.addTaskDataTarget(targetBO);
                    if (!rsp2.getRspCode().equals("0000")) {
                        ++badNUm;
                    }
                    for (int k = 3; k < row.getPhysicalNumberOfCells(); ++k) {
                        DataTypePo dataTypePo = new DataTypePo();
                        dataTypePo.setName(heads.getCell(k).toString());
                        dataTypePo.setValue(row.getCell(k).toString());
                        typeList.add(dataTypePo);
                    }
                    String jsonString = JSON.toJSONString(typeList);
                    ObDataCustomerPO ob = new ObDataCustomerPO();
                    ob.setTenantId(tenantCode);
                    ob.setDataId(dataId);
                    ob.setAttribute(jsonString);
                    ob.setTenantOtherName(tenantOtherName);
                    int in = this.ObDataCustomerPOMapper.insertSelective(ob);
                    if (in <= 0) continue;
                    log.info("\u5bfc\u5165\u5173\u8054\u5c5e\u6027\u8868\u6210\u529f");
                    successPhone.add(phone);
                    continue;
                }
                catch (Exception e2) {
                    ++badNUm;
                    e2.printStackTrace();
                    throw new RuntimeException();
                }
            }
            ErrInfoRspBO errInfoRspBO = new ErrInfoRspBO();
            if (null != errList && errList.size() > 0 && (rsp = this.exportTaskErrorData(errList)).getRspCode().equals("0000") && rsp.getData() != null && null != (data = (ErrInfoRspBO)rsp.getData())) {
                errInfoRspBO.setFileName(data.getFileName());
                errInfoRspBO.setFilePath(data.getFilePath());
            }
            return BaseRspUtils.createSuccessRsp((Object)errInfoRspBO, (String)("\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff0c\u6210\u529f\u5bfc\u5165" + (sum - badNUm) + "\u6761\u6570\u636e, \u5931\u8d25" + badNUm + "\u6761\uff0c\u603b\u6570" + sum + "\u6761"));
        }
        catch (Exception e3) {
            log.error("\u5bfc\u5165\u5931\u8d25\uff1a{}", (Object)e3.getMessage());
            e3.printStackTrace();
            throw new RuntimeException();
        }
    }

    public String cellSwitchOfString(Cell cell) {
        if (null == cell) {
            return null;
        }
        cell.setCellType(CellType.STRING);
        return cell.toString();
    }

    private Boolean checkPhone(String phone, List<ObNetworkNumberSegmentPO> networkNumberSegmentPOS) {
        Boolean flag = false;
        String subPhone = phone.substring(phone.indexOf("1"), phone.indexOf("1") + TaskConstant.SUBSTRING_INDEX);
        long count = networkNumberSegmentPOS.stream().filter(po -> subPhone.equals(po.getMsisdnSeg())).count();
        if (0L == count) {
            flag = true;
        }
        return flag;
    }

    private Boolean checkPower(String userId, String tenantId) {
        Boolean flag = false;
        Integer count = this.bladeTenantInterService.getTenantPower(tenantId, "task:data:import");
        if (count > 0) {
            flag = true;
        } else {
            List roleNames = this.bladeUserInterService.getUserRoleInfo(userId);
            if (null != roleNames && roleNames.size() > 0) {
                for (String role : roleNames) {
                    if (StringUtils.isEmpty((Object)role) || !role.equals("system:admin")) continue;
                    flag = true;
                    break;
                }
            }
        }
        return flag;
    }

    public static void main(String[] args) {
    }
}

