/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.task.relation.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.ocs.bo.AddTacticsBO;
import com.tydic.nicc.ocs.bo.QryTacticsBO;
import com.tydic.nicc.ocs.bo.QryTacticsReqBO;
import com.tydic.nicc.ocs.bo.TaskRelationBO;
import com.tydic.nicc.ocs.bo.TaskTacticsBO;
import com.tydic.nicc.ocs.bo.UpdateTacticsReqBO;
import com.tydic.nicc.ocs.bo.UpdateTacticsRspBO;
import com.tydic.nicc.ocs.config.CodeConfig;
import com.tydic.nicc.ocs.constant.TaskConstant;
import com.tydic.nicc.ocs.mapper.ObCallRateConfigDAO;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.ObTaskTacticsDAO;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskTacticsPO;
import com.tydic.nicc.ocs.service.IsvTaskProxyService;
import com.tydic.nicc.ocs.service.TaskTacticsService;
import com.tydic.nicc.ocs.utils.RegularUtils;
import com.tydic.nicc.ocs.utils.TaskInfoUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.StringUtils;

@DubboService
public class TaskTacticsServiceImpl
implements TaskTacticsService {
    private static final Logger log = LoggerFactory.getLogger(TaskTacticsServiceImpl.class);
    private static final Integer STATUS_0 = 0;
    private static final Integer STATUS_1 = 1;
    private static final String SUCCESS_MESSAGE = "SUCCESS";
    private static final String DELETE_FLAG_0 = "0";
    private static final String DELETE_FLAG_1 = "1";
    @Resource
    private ObTaskTacticsDAO obTaskTacticsDAO;
    @Resource
    private ObTaskInfoDAO obTaskInfoDAO;
    @Resource
    private ObCallRateConfigDAO obCallRateConfigDAO;
    @Autowired
    private CodeConfig codeConfig;
    @Value(value="${defaultFormatBegin:yyyy-MM-dd 10:00:00}")
    private String defaultFormatBegin;
    @Value(value="${defaultFormatEnd:yyyy-MM-dd 20:59:59}")
    private String defaultFormatEnd;
    @Value(value="${defaultRollFormatEnd:yyyy-MM-dd 20:00:00}")
    private String defaultRollFormatEnd;
    @Resource
    private IsvTaskProxyService isvTaskProxyService;
    private static final String DEFAULT_PARAM = "0";

    @Transactional(rollbackFor={RuntimeException.class})
    public Rsp addTactics(AddTacticsBO addTacticsBO) {
        ObTaskTacticsPO po;
        log.info("\u8fdb\u5165\u65b0\u589e\u4efb\u52a1\u7b56\u7565\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)addTacticsBO));
        TaskRelationBO taskRelationBO = new TaskRelationBO();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Rsp rsp = this.checkParam(addTacticsBO);
        if (!"0000".equals(rsp.getRspCode())) {
            return rsp;
        }
        ObTaskTacticsPO obTaskTacticsPO = new ObTaskTacticsPO();
        obTaskTacticsPO.setTaskId(addTacticsBO.getTaskId());
        List obTaskTacticsPOS = this.obTaskTacticsDAO.selectByTaskId(obTaskTacticsPO);
        log.info("\u6839\u636e\u4efb\u52a1ID\u67e5\u8be2\u7b56\u7565Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskTacticsPOS));
        ArrayList<ObTaskTacticsPO> taskTacticsPOS = new ArrayList<ObTaskTacticsPO>();
        Integer sort = obTaskTacticsPOS == null && obTaskTacticsPOS.size() == 0 ? Integer.valueOf(1) : Integer.valueOf(obTaskTacticsPOS.size() + 1);
        for (String week : addTacticsBO.getWeeks()) {
            if (obTaskTacticsPOS != null && obTaskTacticsPOS.size() > 0) {
                for (ObTaskTacticsPO tacticsPO : obTaskTacticsPOS) {
                    if (!tacticsPO.getWeek().equals(week) || !tacticsPO.getStartTime().equals(addTacticsBO.getStartTime()) || !tacticsPO.getEndTime().equals(addTacticsBO.getEndTime())) continue;
                    log.info("\u5f53\u524d\u7b56\u7565\u4fe1\u606f\u5df2\u5b58\u5728");
                    taskRelationBO.setStatus(STATUS_0);
                    taskRelationBO.setMessage("\u5f53\u524d\u4efb\u52a1\u4fe1\u606f\u5df2\u5b58\u5728\uff01");
                    return BaseRspUtils.createErrorRsp((String)"\u5f53\u524d\u4efb\u52a1\u4fe1\u606f\u5df2\u5b58\u5728");
                }
            }
            ObTaskTacticsPO taskTacticsPO = new ObTaskTacticsPO();
            String tactics = TaskInfoUtil.get16UUID();
            taskTacticsPO.setTacticsId(StringUtils.isEmpty((Object)addTacticsBO.getTacticsId()) ? tactics : addTacticsBO.getTacticsId());
            taskTacticsPO.setTaskId(addTacticsBO.getTaskId());
            taskTacticsPO.setMinStartSeats(Integer.valueOf(Integer.parseInt(addTacticsBO.getMinStartSeats())));
            taskTacticsPO.setPredictionDivisor(Integer.valueOf(Integer.parseInt(addTacticsBO.getPredictionDivisor())));
            taskTacticsPO.setStartTime(addTacticsBO.getStartTime());
            taskTacticsPO.setEndTime(addTacticsBO.getEndTime());
            taskTacticsPO.setDeleteFlag("0");
            taskTacticsPO.setWeek(week);
            taskTacticsPO.setCreateTime(format.format(new Date()));
            taskTacticsPO.setRemark(sort);
            taskTacticsPO.setMaxQueue(Integer.valueOf(Integer.parseInt(addTacticsBO.getMinStartSeats())));
            taskTacticsPOS.add(taskTacticsPO);
            Integer n = sort;
            Integer n2 = sort = Integer.valueOf(sort + 1);
        }
        log.info("\u65b0\u589e\u4efb\u52a1\u7b56\u7565Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(taskTacticsPOS));
        int insertNum = 0;
        if (!taskTacticsPOS.isEmpty()) {
            insertNum = this.obTaskTacticsDAO.inserts(taskTacticsPOS);
            po = new ObTaskTacticsPO();
            po.setMaxQueue(Integer.valueOf(Integer.parseInt(addTacticsBO.getMinStartSeats())));
            po.setMinStartSeats(Integer.valueOf(Integer.parseInt(addTacticsBO.getMinStartSeats())));
            po.setPredictionDivisor(Integer.valueOf(Integer.parseInt(addTacticsBO.getPredictionDivisor())));
            po.setTaskId(addTacticsBO.getTaskId());
            this.obTaskTacticsDAO.updateObTaskTacticsPOByTaskId(po);
        }
        po = new ObTaskTacticsPO();
        po.setMinStartSeats(Integer.valueOf(Integer.parseInt(addTacticsBO.getMinStartSeats())));
        po.setPredictionDivisor(Integer.valueOf(Integer.parseInt(addTacticsBO.getPredictionDivisor())));
        po.setTaskId(addTacticsBO.getTaskId());
        log.info("\u4fee\u6539\u9884\u6d4b\u56e0\u5b50Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)po));
        try {
            this.obTaskTacticsDAO.updateObTaskTacticsPOByTaskId(po);
            this.isvTaskProxyService.createIsvTask(addTacticsBO.getTaskId(), addTacticsBO.getTenantCode());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            if (e.getMessage().equals("invalid time")) {
                return BaseRspUtils.createErrorRsp((String)"\u65e0\u6548\u7684\u7b56\u7565\u65f6\u95f4");
            }
            return BaseRspUtils.createErrorRsp((String)("\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + e.getMessage()));
        }
        taskRelationBO.setStatus(STATUS_0);
        taskRelationBO.setMessage(SUCCESS_MESSAGE);
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public Rsp addLocalTactics(AddTacticsBO addTacticsBO) {
        log.info("\u8fdb\u5165\u65b0\u589e\u4efb\u52a1\u7b56\u7565\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)addTacticsBO));
        TaskRelationBO taskRelationBO = new TaskRelationBO();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Rsp rsp = this.checkParam(addTacticsBO);
        if (!"0000".equals(rsp.getRspCode())) {
            return rsp;
        }
        ObTaskTacticsPO obTaskTacticsPO = new ObTaskTacticsPO();
        obTaskTacticsPO.setTaskId(addTacticsBO.getTaskId());
        List obTaskTacticsPOS = this.obTaskTacticsDAO.selectByTaskId(obTaskTacticsPO);
        log.info("\u6839\u636e\u4efb\u52a1ID\u67e5\u8be2\u7b56\u7565Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskTacticsPOS));
        ArrayList<ObTaskTacticsPO> taskTacticsPOS = new ArrayList<ObTaskTacticsPO>();
        Integer sort = obTaskTacticsPOS == null && obTaskTacticsPOS.size() == 0 ? Integer.valueOf(1) : Integer.valueOf(obTaskTacticsPOS.size() + 1);
        for (String week : addTacticsBO.getWeeks()) {
            if (obTaskTacticsPOS != null && obTaskTacticsPOS.size() > 0) {
                for (ObTaskTacticsPO tacticsPO : obTaskTacticsPOS) {
                    if (!tacticsPO.getWeek().equals(week) || !tacticsPO.getStartTime().equals(addTacticsBO.getStartTime()) || !tacticsPO.getEndTime().equals(addTacticsBO.getEndTime())) continue;
                    log.info("\u5f53\u524d\u7b56\u7565\u4fe1\u606f\u5df2\u5b58\u5728");
                    taskRelationBO.setStatus(STATUS_0);
                    taskRelationBO.setMessage("\u5f53\u524d\u4efb\u52a1\u4fe1\u606f\u5df2\u5b58\u5728\uff01");
                    return BaseRspUtils.createErrorRsp((String)"\u5f53\u524d\u4efb\u52a1\u4fe1\u606f\u5df2\u5b58\u5728");
                }
            }
            ObTaskTacticsPO taskTacticsPO = new ObTaskTacticsPO();
            String tactics = TaskInfoUtil.get16UUID();
            taskTacticsPO.setTacticsId(StringUtils.isEmpty((Object)addTacticsBO.getTacticsId()) ? tactics : addTacticsBO.getTacticsId());
            taskTacticsPO.setTaskId(addTacticsBO.getTaskId());
            taskTacticsPO.setMinStartSeats(Integer.valueOf(Integer.parseInt(addTacticsBO.getMinStartSeats())));
            taskTacticsPO.setPredictionDivisor(Integer.valueOf(Integer.parseInt(addTacticsBO.getPredictionDivisor())));
            taskTacticsPO.setStartTime(addTacticsBO.getStartTime());
            taskTacticsPO.setEndTime(addTacticsBO.getEndTime());
            taskTacticsPO.setDeleteFlag("0");
            taskTacticsPO.setWeek(week);
            taskTacticsPO.setCreateTime(format.format(new Date()));
            taskTacticsPO.setRemark(sort);
            taskTacticsPO.setMaxQueue(Integer.valueOf(Integer.parseInt(addTacticsBO.getMinStartSeats())));
            taskTacticsPOS.add(taskTacticsPO);
            Integer n = sort;
            Integer n2 = sort = Integer.valueOf(sort + 1);
        }
        log.info("\u65b0\u589e\u4efb\u52a1\u7b56\u7565Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(taskTacticsPOS));
        int insertNum = 0;
        if (!taskTacticsPOS.isEmpty()) {
            insertNum = this.obTaskTacticsDAO.inserts(taskTacticsPOS);
        }
        if (insertNum == 0) {
            log.error("\u65b0\u589e\u5931\u8d25");
            return BaseRspUtils.createErrorRsp((String)"\u65b0\u589e\u5931\u8d25");
        }
        taskRelationBO.setStatus(STATUS_0);
        taskRelationBO.setMessage(SUCCESS_MESSAGE);
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public RspList<QryTacticsBO> qryTactics(QryTacticsReqBO reqBO) {
        PageInfo pageInfo;
        log.info("\u8fdb\u5165\u67e5\u8be2\u4efb\u52a1\u7b56\u7565\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ArrayList<QryTacticsBO> rspBOS = new ArrayList<QryTacticsBO>();
        try {
            if (reqBO == null) {
                log.error("\u5165\u53c2\u9519\u8bef");
                return BaseRspUtils.createErrorRspList((String)"\u5165\u53c2\u9519\u8bef");
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                log.error("\u4efb\u52a1ID\u4e3a\u7a7a");
                return BaseRspUtils.createErrorRspList((String)"\u4efb\u52a1ID\u4e3a\u7a7a");
            }
            ObTaskTacticsPO obTaskTacticsPO = new ObTaskTacticsPO();
            obTaskTacticsPO.setTaskId(reqBO.getTaskId());
            PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
            List obTaskTacticsPOS = this.obTaskTacticsDAO.selectByTaskId(obTaskTacticsPO);
            pageInfo = new PageInfo(obTaskTacticsPOS);
            log.info("\u67e5\u8be2\u4efb\u52a1\u7b56\u7565Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskTacticsPOS));
            if (!obTaskTacticsPOS.isEmpty()) {
                for (ObTaskTacticsPO tacticsPO : obTaskTacticsPOS) {
                    QryTacticsBO bo = new QryTacticsBO();
                    BeanUtils.copyProperties((Object)tacticsPO, (Object)bo);
                    bo.setMinStartSeats(tacticsPO.getMaxQueue());
                    rspBOS.add(bo);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25:{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)pageInfo.getTotal());
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public UpdateTacticsRspBO updateTactics(UpdateTacticsReqBO reqBO) {
        log.info("\u8fdb\u5165\u5220\u9664\u4efb\u52a1\u7b56\u7565\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        UpdateTacticsRspBO rspBO = new UpdateTacticsRspBO();
        try {
            block20: {
                ObTaskTacticsPO taskTacticsPO;
                if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                if (StringUtils.isEmpty((Object)reqBO.getTacticsId())) {
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u7b56\u7565ID\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                if (reqBO.getFlag() == null) {
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u63a5\u53e3\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                if (!StringUtils.isEmpty((Object)reqBO.getMinStartSeats()) && !StringUtils.isEmpty((Object)reqBO.getPredictionDivisor())) {
                    if (StringUtils.isEmpty((Object)reqBO.getMinStartSeats())) {
                        reqBO.setMinStartSeats("0");
                    }
                    if (StringUtils.isEmpty((Object)reqBO.getPredictionDivisor())) {
                        reqBO.setPredictionDivisor("0");
                    }
                    if (!this.isNumeric(reqBO.getMinStartSeats())) {
                        rspBO.setRspCode("8888");
                        rspBO.setRspDesc("\u6700\u5927\u6392\u961f\u6570\u53ea\u80fd\u4e3a\u6570\u5b57\uff01");
                        return rspBO;
                    }
                    if (!this.isNumeric(reqBO.getPredictionDivisor())) {
                        rspBO.setRspCode("8888");
                        rspBO.setRspDesc("\u5fae\u8c03\u53c2\u6570\u53ea\u80fd\u4e3a\u6570\u5b57\uff01");
                        return rspBO;
                    }
                    if (!RegularUtils.within100(reqBO.getMinStartSeats())) {
                        rspBO.setRspCode("8888");
                        rspBO.setRspDesc("\u6700\u5927\u6392\u961f\u6570\u8303\u56f4\u4e3a 0 -- 100\uff01");
                        return rspBO;
                    }
                    if (!RegularUtils.withinIn(reqBO.getPredictionDivisor())) {
                        rspBO.setRspCode("8888");
                        rspBO.setRspDesc("\u5fae\u8c03\u53c2\u6570\u8303\u56f4\u4e3a -100 -- 100\uff01");
                        return rspBO;
                    }
                }
                if ((taskTacticsPO = this.obTaskTacticsDAO.selectByPrimaryKey(reqBO.getTacticsId())) == null) {
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u5165\u53c2\u9519\u8bef");
                    return rspBO;
                }
                ObTaskTacticsPO obTaskTacticsPO = new ObTaskTacticsPO();
                obTaskTacticsPO.setTaskId(reqBO.getTaskId());
                obTaskTacticsPO.setTacticsId(reqBO.getTacticsId());
                if (reqBO.getFlag() == TaskConstant.TACTICS_FLAG_0) {
                    obTaskTacticsPO.setDeleteFlag(DELETE_FLAG_1);
                } else {
                    if (reqBO.getWeeks() == null || reqBO.getWeeks().size() == 0) {
                        rspBO.setRspCode("8888");
                        rspBO.setRspDesc("\u8bf7\u9009\u62e9\u7b56\u7565\u65f6\u95f4\uff01");
                        return rspBO;
                    }
                    obTaskTacticsPO.setMinStartSeats(Integer.valueOf(Integer.parseInt(reqBO.getMinStartSeats())));
                    obTaskTacticsPO.setPredictionDivisor(Integer.valueOf(Integer.parseInt(reqBO.getPredictionDivisor())));
                    obTaskTacticsPO.setWeek((String)reqBO.getWeeks().get(0));
                    obTaskTacticsPO.setStartTime(reqBO.getStartTime());
                    obTaskTacticsPO.setEndTime(reqBO.getEndTime());
                    obTaskTacticsPO.setMaxQueue(Integer.valueOf(Integer.parseInt(reqBO.getMinStartSeats())));
                }
                log.info("\u4fee\u6539\u4efb\u52a1\u7b56\u7565Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskTacticsPO));
                int updNum = this.obTaskTacticsDAO.updateByPrimaryKeySelective(obTaskTacticsPO);
                if (updNum == 0) {
                    log.error("\u4fee\u6539\u5931\u8d25");
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff01");
                    return rspBO;
                }
                if (reqBO.getFlag() == TaskConstant.TACTICS_FLAG_1) {
                    try {
                        this.isvTaskProxyService.modifyIsvTask(reqBO.getTaskId(), reqBO.getTenantCode());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (!e.getMessage().equals("invalid time")) break block20;
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        throw new RuntimeException("\u65e0\u6548\u7684\u65f6\u95f4\u6bb5");
                    }
                }
            }
            rspBO.setRspCode("0000");
            rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            rspBO.setRspCode("8888");
            rspBO.setRspDesc(e.getMessage());
            e.printStackTrace();
        }
        return rspBO;
    }

    public List<TaskTacticsBO> qryTacticsByTaskID(String taskID, String tenantID) {
        ObTaskTacticsPO taskTactics = new ObTaskTacticsPO();
        taskTactics.setTaskId(taskID);
        List tacticsList = this.obTaskTacticsDAO.selectByTaskId(taskTactics);
        ArrayList<TaskTacticsBO> res = new ArrayList<TaskTacticsBO>();
        if (null == tacticsList) {
            return res;
        }
        for (ObTaskTacticsPO tactics : tacticsList) {
            TaskTacticsBO tacticsBO = new TaskTacticsBO();
            BeanUtils.copyProperties((Object)tactics, (Object)tacticsBO);
            res.add(tacticsBO);
        }
        return res;
    }

    public String[] qryAppoint(String appointFormat) {
        String[] appoints = new String[2];
        String formatBegin = this.codeConfig.getCodeStrValue(appointFormat, CodeConfig.CODE_NAME.APPOINT_FORMAT_BEGIN);
        String formatEnd = this.codeConfig.getCodeStrValue(appointFormat, CodeConfig.CODE_NAME.APPOINT_FORMAT_END);
        String rollEndTime = this.codeConfig.getCodeStrValue(appointFormat, CodeConfig.CODE_NAME.APPOINT_FORMAT_ROLL_END);
        if (StringUtils.isEmpty((Object)formatBegin) || StringUtils.isEmpty((Object)formatEnd) || StringUtils.isEmpty((Object)rollEndTime)) {
            formatBegin = this.defaultFormatBegin;
            formatEnd = this.defaultFormatEnd;
            rollEndTime = this.defaultRollFormatEnd;
        }
        Date date = new Date();
        Calendar current = Calendar.getInstance();
        SimpleDateFormat beginFormat = new SimpleDateFormat(formatBegin);
        SimpleDateFormat endFormat = new SimpleDateFormat(formatEnd);
        SimpleDateFormat rollEndRormat = new SimpleDateFormat(rollEndTime);
        appoints[0] = beginFormat.format(date);
        appoints[1] = endFormat.format(date);
        rollEndRormat.format(date);
        return appoints;
    }

    public boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[-0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    private Boolean checkParam(Integer param1, Integer param2, Integer param3) {
        if (param1 < param2 || param1 > param3) {
            return false;
        }
        return true;
    }

    private Rsp checkParam(AddTacticsBO addTacticsBO) {
        if (StringUtils.isEmpty((Object)addTacticsBO.getTaskId())) {
            return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ObTaskInfoPO obTaskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(addTacticsBO.getTaskId());
        if (StringUtils.isEmpty((Object)addTacticsBO.getMinStartSeats())) {
            addTacticsBO.setMinStartSeats("0");
        }
        if (!this.isNumeric(addTacticsBO.getMinStartSeats())) {
            return BaseRspUtils.createErrorRsp((String)"\u6700\u5927\u6392\u961f\u6570\u53ea\u80fd\u4e3a\u6570\u5b57\uff01");
        }
        if (StringUtils.isEmpty((Object)addTacticsBO.getPredictionDivisor())) {
            addTacticsBO.setPredictionDivisor("0");
        }
        if (!this.isNumeric(addTacticsBO.getPredictionDivisor())) {
            return BaseRspUtils.createErrorRsp((String)"\u5fae\u8c03\u53c2\u6570\u53ea\u80fd\u4e3a\u6570\u5b57\uff01");
        }
        if (!RegularUtils.within100(addTacticsBO.getMinStartSeats())) {
            return BaseRspUtils.createErrorRsp((String)"\u6700\u5927\u6392\u961f\u6570\u8303\u56f4\u4e3a 0 -- 100\uff01");
        }
        if (!RegularUtils.withinIn(addTacticsBO.getPredictionDivisor())) {
            return BaseRspUtils.createErrorRsp((String)"\u5fae\u8c03\u53c2\u6570\u8303\u56f4\u4e3a -100 -- 100\uff01");
        }
        if (addTacticsBO.getWeeks().isEmpty()) {
            return BaseRspUtils.createErrorRsp((String)"Week\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addTacticsBO.getStartTime() == null) {
            return BaseRspUtils.createErrorRsp((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addTacticsBO.getEndTime() == null) {
            return BaseRspUtils.createErrorRsp((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public static void main(String[] args) {
        SimpleDateFormat endFormat = new SimpleDateFormat("yyyy-MM-dd 20:59:59");
        System.out.println(endFormat.getCalendar().getTime());
    }
}

